$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 5;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            window.goodCount = 0;
            window.totalCount = 0;
            window.clickCount = 0;

            __.initItems();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = '/zosia_nurek.png';
            var kid2Path = '/stas_nurek.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 12, 506);
            __.kid2 = initKid(__, 'kid2', kid2Path, 95, 495);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initItems = function(layer) {
            
            __.items = {};
            __.itemsData = [];
            __.itemsData.push({x: 187, y:357});
            __.itemsData.push({x: 1, y:303});
            __.itemsData.push({x: 371, y:375});
            __.itemsData.push({x: 575, y:377});
            // __.itemsData.push({x: 843, y:118}); // 5
            // __.itemsData.push({x: 559, y:198});
            __.itemsData.push({x: 375, y:187});
            __.itemsData.push({x: 194, y:179});
            __.itemsData.push({x: 24, y:106});
            // __.itemsData.push({x: 711, y:19}); // 10
            __.itemsData.push({x: 560, y:22});
            __.itemsData.push({x: 365, y:22 });
            __.itemsData.push({x: 182, y:26});

            for (index in __.itemsData) {
                var data = __.itemsData[index];
                var nr = parseInt(index) + 1;
                var id = 'item_' + '_' + nr;
                __.items[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'items/item_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: false,
                    bringToFront: true,
                    nr: nr
                });
                __.items[id].init();

                __.items[id].click = function(layer) {
                }

                __.items[id].dragstop = function(layer) {
                    cl(this.id +'    x: ' + layer.x + ', y:' + layer.y);
                }
            }

            __.times = {};
            __.timesData = [];
            __.timesData.push({x: 399, y:549, gx: 210, gy:489});
            __.timesData.push({x: 175, y:580, gx: 22, gy:442});
            __.timesData.push({x: 283, y:580, gx: 399, gy:493});
            __.timesData.push({x: 916, y:274 , gx: 595, gy:521});
            // __.timesData.push({x: 801, y:346, gx: 883, gy:239}); // 5
            // __.timesData.push({x: 913, y:347, gx: 595, gy:335});
            __.timesData.push({x: 801, y:275 , gx: 397, gy:305});
            __.timesData.push({x: 286, y:550, gx: 229, gy:315});
            __.timesData.push({x: 176, y:549, gx: 45, gy:249});
            // __.timesData.push({x: 396, y:580, gx: 215, gy:303}); // 10
            __.timesData.push({x: 853, y:239, gx: 575, gy:155});
            __.timesData.push({x: 802, y:310, gx: 392, gy:142});
            __.timesData.push({x: 913, y:311, gx: 203, gy:138});

            for (index in __.timesData) {
                var data = __.timesData[index];
                var nr = parseInt(index) + 1;
                var id = 'time_' + '_' + nr;
                __.times[id] = new Material({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'times/t_' + nr + '.png',
                    coordX: data.x,
                    coordY: data.y,
                    draggable: true,
                    bringToFront: true,
                    data: data,
                    nr: nr
                });
                __.times[id].init();

                __.times[id].click = function(layer) {
                }

                __.times[id].dragstop = function(layer) {
                    // console.log(this.id +'    gx: ' + layer.x + ', gy:' + layer.y);

                    for (id in __.items) {
                        var item = __.items[id];

                        if (item.isOn(layer, 20) && item.nr === this.nr) {

                            window.goodCount++;

                            if (window.goodCount >= __.itemsData.length) {
                                play('koniec-stas', __.kid2, 'index.html');
                            } else {
                                play('poprawnie-stas', __.kid2);
                            }

                            // id check

                            this.animateToPosition(layer, this.data.gx, this.data.gy, 1000);
                            this.set('draggable', false);
                            return;
                        } 
                    }
                    this.backToOryginalPosition(layer);
                    play('blad-zosia', __.kid1);
                }
            }
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);