$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 1;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            __.initItems();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = __.gameId + __.gameNr + '/kid1.png';
            var kid2Path = __.gameId + __.gameNr + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 426);
            __.kid2 = initKid(__, 'kid2', kid2Path, 880, 306);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initItems = function ()
        {
            __.items = {};
            var countKra = 3;
            var countOnKra = 5;

            __.itemsOnPlaceCount = 0;
            __.totalItemsCount = countKra * countOnKra;

            __.goodPositions = new Object();
            __.startPositions = new Object();

            for (kra = 1; kra <= countKra; kra++) {
                __.goodPositions[kra] = new Object;
                __.startPositions[kra] = new Object;
                for (nr = 1; nr <= countOnKra; nr++) {
                    __.goodPositions[kra][nr] = new Array();
                    __.startPositions[kra][nr] = new Array();
                }
            }
            __.goodPositions[1][1]['x'] = 326;
            __.goodPositions[1][1]['y'] = 88;
            __.goodPositions[1][2]['x'] = 419;
            __.goodPositions[1][2]['y'] = 116;
            __.goodPositions[1][3]['x'] = 558;
            __.goodPositions[1][3]['y'] = 141;
            __.goodPositions[1][4]['x'] = 324;
            __.goodPositions[1][4]['y'] = 164;
            __.goodPositions[1][5]['x'] = 500;
            __.goodPositions[1][5]['y'] = 211;
            __.goodPositions[2][1]['x'] = 325;
            __.goodPositions[2][1]['y'] = 263;
            __.goodPositions[2][2]['x'] = 405;
            __.goodPositions[2][2]['y'] = 262;
            __.goodPositions[2][3]['x'] = 482;
            __.goodPositions[2][3]['y'] = 264;
            __.goodPositions[2][4]['x'] = 326;
            __.goodPositions[2][4]['y'] = 338;
            __.goodPositions[2][5]['x'] = 388;
            __.goodPositions[2][5]['y'] = 337;
            __.goodPositions[3][1]['x'] = 324;
            __.goodPositions[3][1]['y'] = 414;
            __.goodPositions[3][2]['x'] = 390;
            __.goodPositions[3][2]['y'] = 414;
            __.goodPositions[3][3]['x'] = 536;
            __.goodPositions[3][3]['y'] = 414;
            __.goodPositions[3][4]['x'] = 326;
            __.goodPositions[3][4]['y'] = 453;
            __.goodPositions[3][5]['x'] = 470;
            __.goodPositions[3][5]['y'] = 458;

            __.startPositions[1][1]['x'] = 6;
            __.startPositions[1][1]['y'] = 111;
            __.startPositions[1][2]['x'] = 836;
            __.startPositions[1][2]['y'] = 99;
            __.startPositions[1][3]['x'] = 777;
            __.startPositions[1][3]['y'] = 369;
            __.startPositions[1][4]['x'] = 171;
            __.startPositions[1][4]['y'] = 467;
            __.startPositions[1][5]['x'] = 163;
            __.startPositions[1][5]['y'] = 436;
            __.startPositions[2][1]['x'] = 4;
            __.startPositions[2][1]['y'] = 354;
            __.startPositions[2][2]['x'] = 813;
            __.startPositions[2][2]['y'] = 200;
            __.startPositions[2][3]['x'] = 144;
            __.startPositions[2][3]['y'] = 286;
            __.startPositions[2][4]['x'] = 753;
            __.startPositions[2][4]['y'] = 292;
            __.startPositions[2][5]['x'] = 688;
            __.startPositions[2][5]['y'] = 112;
            __.startPositions[3][1]['x'] = 741;
            __.startPositions[3][1]['y'] = 193;
            __.startPositions[3][2]['x'] = 96;
            __.startPositions[3][2]['y'] = 217;
            __.startPositions[3][3]['x'] = 193;
            __.startPositions[3][3]['y'] = 96;
            __.startPositions[3][4]['x'] = 9;
            __.startPositions[3][4]['y'] = 253;
            __.startPositions[3][5]['x'] = 489;
            __.startPositions[3][5]['y'] = 20;

            for (kra = 1; kra <= countKra; kra++) {
                for (nr = 1; nr <= countOnKra; nr++) {

                    var iid = 'ice_' + kra + '_' + nr;
                    __.items[iid] = new Material({
                        canvas: __.canvas,
                        id: iid,
                        imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/Etap1Kra' + kra + '_' + nr + '.png',
                        coordX: __.startPositions[kra][nr]['x'],
                        coordY: __.startPositions[kra][nr]['y'],
                        draggable: true,
                        bringToFront: true,
                        goodPosition: __.goodPositions[kra][nr]
                    });
                    __.items[iid].init();

                    __.items[iid].error = function (layer) {
                        play('blad-stas', __.kid2);
                        this.backToOryginalPosition(layer);
                    };
                    __.items[iid].good = function (layer) {
                        
                        play('poprawnie-zosia', __.kid1);

                        __.canvas.setLayer(layer.name, {
                            draggable: false
                        });
                        __.itemsOnPlaceCount++;

                        if (__.itemsOnPlaceCount === __.totalItemsCount) {
                            play('koniec-stas', __.kid2, 'game2.html');
                        }
                    };
                }
            }
        };

    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);