$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 4;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            __.initDogs();
            __.initWeights();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid2Path = 'A1/kid2.png';
            __.kid2 = initKid(__, 'kid2', kid2Path, 880, 266);

            var Kids = new Object();
            Kids.kid2 = __.kid2;
            window.kids = Kids;

        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initWeights = function()
        {
            __.txtPositions = [];
            __.txtPositions.push({x: 610, y :240, value: '350 kg'});
            __.txtPositions.push({x: 610, y :340, value: '180 kg'});
            __.txtPositions.push({x: 610, y :440, value: '130 kg'});
            __.txtPositions.push({x: 610, y :550, value: '240 kg'});

            __.txts = {};
            window.dogsInBagsCcount = {};
            for(i=0; i < __.txtPositions.length; i++) {
                window.dogsInBagsCcount[i+1] = 0;
                __.drawTxt(i, __.txtPositions[i]);
            }
        };

        this.drawTxt = function (nr, position)
        {
            var id = 'txt_' + nr;
            __.txts[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#356583',
                strokeStyle: '#2c5078',
                fontStyle: 'bold',
                fontSize: '18pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: position.value,
                coordX: position.x, coordY: position.y,
                align: 'center',
                draggable: false,
                bringToFront: true,
                game: __
            });
            __.txts[id].init();
        };

        this.initDogs = function ()
        {
            __.dogs = {};
            __.dogsCount = 26;


            __.startPositions = [];
            __.startPositions.push({x: 147, y :346});
            __.startPositions.push({x: 13, y :122}); 
            __.startPositions.push({x: 5, y :189}); 
            __.startPositions.push({x: 9, y :247}); 
            __.startPositions.push({x: 5, y :312});
            __.startPositions.push({x: 11, y :373});
            __.startPositions.push({x: 4, y :419});
            __.startPositions.push({x: 3, y :471});
            __.startPositions.push({x: 0, y :520});
            __.startPositions.push({x: 53, y :178});
            __.startPositions.push({x: 63, y :235});
            __.startPositions.push({x: 57, y :292});
            __.startPositions.push({x: 58, y :345});
            __.startPositions.push({x: 51, y :394});
            __.startPositions.push({x: 54, y :448});
            __.startPositions.push({x: 54, y :496});
            __.startPositions.push({x: 97, y :183});
            __.startPositions.push({x: 100, y :240});
            __.startPositions.push({x: 99, y :294});
            __.startPositions.push({x: 94, y :345});
            __.startPositions.push({x: 92, y :397});
            __.startPositions.push({x: 94, y :453});
            __.startPositions.push({x: 97, y :507});
            __.startPositions.push({x: 136, y :458});
            // __.startPositions.push({x: 126, y :163});
            // __.startPositions.push({x: 140, y :236});

            
            for (var i = 1; i <= __.dogsCount; i++) {
                var id = 'dog_' + i;
                __.dogs[i] = new Item({
                    canvas: __.canvas,
                    id: id,
                    opacity: 1,
                    imgUrl: getImgDir(__) + 'dog.png',
                    coordX: __.startPositions[i-1] ? __.startPositions[i-1]['x']  : 100,
                    coordY: __.startPositions[i-1] ? __.startPositions[i-1]['y']  : 100,
                    draggable: true,
                    bringToFront: true,
                    controller: __
                });
                __.dogs[i].init();

                __.dogs[i].error = function (layer) {
                };
                __.dogs[i].good = function (layer) {
                };

                __.dogs[i].dragstop = function (layer) {

                    if (layer.x <= 200) {
                        this.backToOryginalPosition(layer);
                        return;
                    }

                    var bagInfo = this.controller.selectBag(layer);
                    var bag = bagInfo.bag;

                    if (window.dogsInBagsCcount[bagInfo.nr] < bag.dogsCount) {
                        window.dogsInBagsCcount[bagInfo.nr]++;

                        if (window.dogsInBagsCcount[bagInfo.nr] === bag.dogsCount) {
                            // play('pelneSanie-stas', __.kid2);
                        }
                        if (bag) {

                            var bagsCanFree = 0;
                            var bags = __.getBags();
                            for(i=0; i < bags.length; i++) {
                                bagsCanFree += bags[i]['dogsCount'];
                            }

                            var bagsCanInUse = 0;
                            for(i=1; i <= Object.keys(window.dogsInBagsCcount).length; i++) {
                                bagsCanInUse += window.dogsInBagsCcount[i];
                            }

                            this.set('draggable', false);
                            this.controller.animateDogToBag(this, bagInfo);

                            if (bagsCanInUse === bagsCanFree) {

                                play('koniec-stas', __.kid2, 'game5.html');
                                return;
                            }

                        } else {
                            play('blad-stas', __.kid2);
                            this.backToOryginalPosition(layer);
                        }
                    } else {
                        play('blad-stas', __.kid2);
                        this.backToOryginalPosition(layer);
                    }
                };  
            };
        };

        this.animateDogToBag = function (dog, bagInfo)
        {
            var dogsInBag = window.dogsInBagsCcount[bagInfo.nr];
            var startingX = 600;
            if (bagInfo.nr == 3) {
                startingX -= 20;
            }
            if (bagInfo.nr == 4) {
                startingX -= 20;
            }
            if (bagInfo.nr == 1) {
                startingX -= 10;
            }

            dog.animateToPosition(dog, startingX - dogsInBag * 40, bagInfo.bag.normal);
        };

        this.selectBag = function (layer)
        {
            var bags = __.getBags();
            for(bi = 1; bi <= bags.length; bi++) {
                var bag = bags[bi-1];
                if (layer.y >= bag.min && layer.y <= bag.max) {
                    return {nr: bi, bag: bag};
                }
            }
            return false;
        };

        this.getBags = function ()
        {
            var groups = [];
            groups.push({min: 217, max: 280, normal: 240, dogsCount: 9});
            groups.push({min: 281, max: 367, normal: 330, dogsCount: 5});
            groups.push({min: 368, max: 467, normal: 450, dogsCount: 4});
            groups.push({min: 467, max: 610, normal: 550, dogsCount: 6});
            return groups;
        };
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);