$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 'entry';

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.initBlock = false;
            __.initLogo();
            __.initGameIcons();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'kid1.png';
            var kid2Path = 'kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 7, 426);
            __.kid2 = initKid(__, 'kid2', kid2Path, 880, 266);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };

        this.initLogo = function()
        {
            __.canvas.drawImage({
                layer: true,
                name: 'title',
                source: '../../img/A/entry/logo.png',
                x: 250, y: 40,
                sWidth: 437,
                sHeight: 98,
                sx: 111, sy: 111,
                fromCenter: false
            });

            __.canvas.animateLayer('title', {
                rotate: '+=2'
            }, 'slow');
            __.animateLogo();


            __.canvas.drawImage({
                layer: true,
                name: 'titleSafari',
                source: '../../img/A/entry/TytulKrainaLodu.png',
                x: 300, y: 300,
                sWidth: 523,
                sHeight: 125,
                sx: 111, sy: 111,
                fromCenter: false
            });
        };



        __.initGameIcons = function() {
            for (gid = 1; gid <= 5; gid++) {
                var gb = new Button({
                    canvas: __.canvas,
                    id: 'gbut' + gid,
                    imgUrl: '../../img/A/entry/Etap' + gid + 'male.png',
                    coordX: 70 + (gid * 150),
                    coordY: 150,
                    width: 129,
                    height: 132
                });
                gb.init();
                swing = rand(3) * 10;

                gb.click = function(gb) {
                    cl('sa');
                    var gameId = gb.name.replace('gbut', '');
                    window.redirect("game" + gameId + '.html');
                };
                gb.mouseover = function(gb) {
                    __.canvas.animateLayer(gb.name, {
                        rotate: '+=' + swing
                    }, 340, 'swing');
                    __.canvas.css('cursor', 'pointer');
                };
                gb.mouseout = function(gb) {
                    __.canvas.animateLayer(gb.name, {
                        rotate: '-=' + swing * 1.5
                    }, 'slow', 'swing');
                    __.canvas.animateLayer(gb.name, {
                        rotate: '+=' + swing * 0.5
                    }, 'slow', 'swing');
                };
            }
        };

        __.animateLogo = function() {

            var stop = 3;
            rot = '-=' + stop;

            if (false === __.logoFlag) {
                rot = '+=' + stop;
                __.logoFlag = true;
            } else {
                __.logoFlag = false;
            }
            __.canvas.animateLayer('title', {
                rotate: rot
            }, 'slow');

            setTimeout(function() {
                __.animateLogo();
            }, 700);
        };

    };

    $.fn.Game = function()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function(index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);


