$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 1;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            __.drawedPints = [];
            __.initPints();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = __.gameId + '/kid1.png';
            var kid2Path = __.gameId + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 12, 406);
            __.kid2 = initKid(__, 'kid2', kid2Path, 7, 136);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.clickOnBg = function(layer) {
            // cl('x:' + layer.eventX + ', y:' + layer.eventY);
            var apro = 20;

            var clicked = 0;
            for (nr = 0; nr <= __.points.length - 1; nr++) {
                if (__.points[nr].used) {
                    clicked++;
                }
            }

            for (nr = 0; nr <= __.points.length - 1; nr++) {
                var point = __.points[nr];
                if (!point.used) {
                    var goodX = layer.eventX >= point.x - apro && layer.eventX <= point.x + apro;
                    var goodY = layer.eventY >= point.y - apro && layer.eventY <= point.y + apro;
                    if (goodX && goodY) {
                        __.points[nr].used = true;
                        clicked++;
                        __.drawPint('point_' + nr, point.x, point.y);

                        if (clicked === __.points.length) {
                            play('koniec-stas', __.kid2, 'game2.html');
                            return;
                        }
                        play('poprawnie-stas', __.kid2);
                        return;
                    }
                }
            }
            play('blad-stas', __.kid2);
        }

        this.drawPint = function(id, x, y) {
            __.drawedPints[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/mark.png',
                coordX: x-15,
                coordY: y-15,
                draggable: false,
                bringToFront: true,
                step : 1
            });
            __.drawedPints[id].init();
        }

        this.initPints = function ()
        {
            __.points = [];
            __.points.push({x:883, y:148.5, used:false});
            __.points.push({x:856, y:165.5, used:false});
            __.points.push({x:804, y:193.5, used:false});
            __.points.push({x:703, y:191.5, used:false});
            __.points.push({x:643, y:171.5, used:false});
            __.points.push({x:737, y:241.5, used:false});
            __.points.push({x:691, y:267.5, used:false});
            __.points.push({x:794, y:265.5, used:false});
            __.points.push({x:827, y:247.5, used:false});
            __.points.push({x:692, y:395.5, used:false});
        };

    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);