$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 3;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            // window.clickBlock = false;
            // window.isAnimateOn = true;

            // __.animals = [];
            __.initCalBgs();
            __.initGames(1);

            // __.initGameTwo();
            setTimeout(function () {
                __.initPolygons();
            }, 500);
            
            

            
            // __.initAnimals();
            // __.initButton();
            // __.initPictures();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.clickOnBg = function(layer) {
            // cl('x:' + layer.eventX + ', y:' + layer.eventY);
        }

        this.initKids = function ()
        {
            var kid1Path = __.gameId + '/kid1.png';
            var kid2Path = __.gameId + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 862, 235);
            __.kid2 = initKid(__, 'kid2', kid2Path, 17, 388);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initCalBgs = function() {
            
            var x = 160;
            var y = 140;

            __.calsBgs = [];
            __.cals = [];
            for (var i=0; i <= 1; i++) {
                var bg = __.drawCalBg(i, x + (i*380), y)
                __.drawCal(i, x + (i*380), y, bg)
            };
        }

        __.initGames = function(gi) {
            if (!window.initBlock) {
                var selectedKid = (gi % 2 != 0) ? __.kid1 : __.kid2;
                play('Zadanie1-polecenie'+gi, selectedKid);
                window.gameNowPlay = gi;

            } else {
                setTimeout(function () {
                    __.initGames(gi);
                }, 1000);
            }
        };

        __.initPolygons = function()
        {
            __.fields = [];

            __.coords = [];
            __.coords.push({w: 44, h: 52, x: 429, y: 297, gameId: 1}); // 21
            // __.coords.push({w: 44, h: 52, x: 206, y: 348, gameId: 1}); // 23
            __.coords.push({w: 44, h: 52, x: 295, y: 348, gameId: 2}); // 25
            __.coords.push({w: 44, h: 52, x: 676, y: 191, gameId: 3}); // 1
            __.coords.push({w: 44, h: 52, x: 676, y: 295, gameId: 4}); // 15

            for (i = 0; i < __.coords.length; i++) {
                var coord = __.coords[i];
                __.drawRectangle(i, coord);
            }
        }

        __.drawRectangle = function(id, coord)
        {
            var id = 'poly_' + id;
            __.fields[id] = new Rectangle({
                canvas: __.canvas,
                id: id,
                coordX: coord.x,
                coordY: coord.y,
                width: coord.w,
                height: coord.h,
                fillStyle: '#69b45e',
                strokeStyle: '#000',
                // x: 100, y: 100,
                radius: 36,
                sides: 4,
                opacity: 0.5,
                draggable: false,
                bringToFront: true,
                opacity: 0,
                gameNr: coord.gameId,
                controller: __
                // visible: false
            });
            __.fields[id].init();
            __.fields[id].click = function(layer) {

                if ($(this)[0].gameNr === window.gameNowPlay) {
                    play('Zadanie1-poprawnie-stas', __.kid2);
                    $(this)[0].show(400, 0.5);

                    var ___ = $(this)[0].controller;

                    if (window.gameNowPlay === ___.coords.length) {

                        for (cal in ___.cals) {
                            ___.cals[cal].hide(300);
                        }

                        for (cal in ___.calsBgs) {
                            ___.calsBgs[cal].hide(300);
                        }

                        for (field in ___.fields) {
                            ___.fields[field].hide(300);
                        }

                        ___.initGameTwo();
                    }

                    setTimeout(function () {
                        __.initGames(window.gameNowPlay+1);
                    }, 2000);

                }
            };
        };

        __.drawCalBg = function (i, x, y)
        {
            var id = 'calbg_' + i;
            __.calsBgs[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + 'calbg_' + i + '.png',
                coordX: x,
                coordY: y,
                draggable: false,
                bringToFront: true
            });
            __.calsBgs[id].init();
            return __.calsBgs[id];
        };

        __.drawCal = function (i, x, y, bg)
        {
            if (i === 0) {
                y += 6;
            }

            var id = 'cal_' + i;
            __.cals[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + 'cal_' + i + '.png',
                coordX: x+7,
                coordY: y+10,
                draggable: false,
                bringToFront: true,
                bg: bg
            });
            __.cals[id].click = function(layer) {
                play('Zadanie2-blad-stas', __.kid2);
            }
            __.cals[id].init();
        }

        __.initGameTwo = function()
        {
            play('Zadanie2-polecenie-zosia', __.kid1);
            var id = 'game2board';
            __.board = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + 'Etap3-Zadanie22.png',
                coordX: 180,
                coordY: 40,
                draggable: false,
                bringToFront: true
            });
            __.board.init();

            setTimeout(function () {
                __.initTextFields();
            }, 800);
        };

        __.initTextFields = function()
        {
            __.txts = [];
            __.fields = [];

            __.coords = [];
            __.coords.push({w: 118, h: 45, x: 206, y: 538, gameId: 1}); // 23
            __.coords.push({w: 118, h: 45, x: 325, y: 538, gameId: 2}); // 25
            __.coords.push({w: 118, h: 45, x: 443   , y: 538, gameId: 3}); // 1

            for (i = 0; i < __.coords.length; i++) {
                var coord = __.coords[i];
                __.drawRectangle('_b_'+i, coord);
                __.fields['poly__b_'+i].show(100, 0.1);

                __.fields['poly__b_'+i].click = function(layer)
                {
                }
            }

            __.lookFor(0);
        };

        __.hideUnusedFields = function()
        {
            for (i = 0; i < __.coords.length; i++) {
                __.fields['poly__b_'+i].show(10, 0.1);
            }
        }

        
        __.lookFor = function(nr)
        {
            __.hideUnusedFields();
            __.fields['poly__b_'+nr].show(200, 0.4);

            var answer = __.getRightAnswers(nr);
            window.lookForKey = 0;
            window.selNr = nr;
            window.selectNr = nr;

            $('body').keyup(function(k) {
                var good1 = k.which <= 106 && k.which >= 96;
                var good2 = k.which <= 57 && k.which >= 48;
                if (good1 || good2) {

                    var x = k.which;
                    var numberSelected = 0;
                    if (x > 95) {  
                        numberSelected = x - 96;
                    } else {
                        numberSelected = x - 48;
                    }

                    var lookingFor = answer[window.lookForKey];
                    if (numberSelected == lookingFor) {

                        window.lookForKey += 1;
                        var nr = window.selectNr;

                        var x = __.fields['poly__b_'+nr].coordX + 20 + (window.lookForKey * 15);

                        __.drawTxt(nr+''+numberSelected+window.lookForKey, numberSelected+'', {x:x, y: 555});
                        
                        if (answer[answer.length-1] === numberSelected) {
                            play('Zadanie2-poprawnie-zosia', __.kid1);
                        }
                        

                        if (window.lookForKey >= answer.length) {
                            if (nr === 2) {
                                 play('Zadanie2-koniec-zosia', __.kid1, 'game4.html');
                            } else {
                                __.lookFor(nr+1);
                            }
                        }
                    }
                }
            });
        };

        this.drawTxt = function (nr, txt, position)
        {
            var id = 'txt_' + nr;
            __.txts[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#356583',
                strokeStyle: '#2c5078',
                fontStyle: 'bold',
                fontSize: '18pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: txt,
                coordX: position.x, coordY: position.y,
                align: 'center',
                draggable: false,
                bringToFront: true,
                game: __
            });
            __.txts[id].init();
        };

        __.getRightAnswers = function(nr)
        {
            var answers = {
                0: [1, 0, 9],
                1: [1, 5],
                2: [3]
            };
            return answers[nr];
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);