$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 4;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            window.goodCount = 0;

            __.initCoords();
            __.initBoards();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = __.gameId + '/kid1.png';
            var kid2Path = __.gameId + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 868, 219);
            // __.kid2 = initKid(__, 'kid2', kid2Path, 360, 470);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            // Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.clickOnBg = function(layer) {
            // cl('x:' + layer.eventX + ', y:' + layer.eventY);
        }

        __.initCoords = function() {
            __.coords = [];
            __.coords.push({x:645, y:70 });
            __.coords.push({x:534, y:67});
            __.coords.push({x:639, y:40 });
            __.coords.push({x:705, y:245 });
            __.coords.push({x:705, y:289 });
            __.coords.push({x:715, y:333 });
            __.coords.push({x:725, y:375 });
            __.coords.push({x:745, y:419 });

            __.good = [];
            __.good.push({x:75, y:457 });
            __.good.push({x:73, y:235});
            __.good.push({x:378, y:186}); // 
            __.good.push({x:742, y:185}); // 3
            __.good.push({x:376, y:325});
            __.good.push({x:699, y:546});
            __.good.push({x:410, y:524});
            __.good.push({x:127, y:613});


        }

        __.initBoards = function()
        {
            
            __.boards = [];
            for (var i = 0; i < __.coords.length; i++) {

                if (i === 0){
                    continue;
                }
                var id = 'board_' + i;

                __.boards[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    i: i,
                    imgUrl: getImgDir(__) + 'Etap4-PLANSZA'+(i+1)+'.png',
                    coordX: __.coords[i].x,
                    coordY: __.coords[i].y,
                    draggable: true,
                    bringToFront: true,
                    opacity: 1
                });
                __.boards[id].init();
                __.boards[id].dragstop = function(layer) {
                    var apro = 40;
                    var good = __.good[$(this)[0].i];

                    var goodX = layer.eventX >= good.x - apro && layer.eventX <= good.x + apro;
                    var goodY = layer.eventY >= good.y - apro && layer.eventY <= good.y + apro;
                    if (goodX && goodY) {
                        window.goodCount++;
                        __.canvas.setLayer(layer.name, {
                            draggable: false
                        });

                        if (window.goodCount === 7) {
                            play('koniec-zosia', __.kid1, 'game5.html');
                        } else {
                            play('poprawnie-zosia', __.kid1);
                        }
                    } else {
                        play('blad-zosia', __.kid1);
                        $(this)[0].backToOryginalPosition(layer);
                    }

                    // cl('x:' + layer.eventX + ', y:' + layer.eventY);
                    // cl(layer.eventX);
                    // cl($(this)[0].isOn({x: layer.eventX, y: layer.eventY}, 30));
                }
            };
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);