function initButtons(__) {

    var vidButton = new Item({
        canvas: __.canvas,
        id: 'vidButton',
        imgUrl: '../../img/buttons/IkonaUcho.png',
        coordX: 10,
        coordY: 20,
        element: 'mainVideo',
        opacity: (isVideoOn()) ? 1 : 0.5,
        noLimit: true
    });
    vidButton.init();
    vidButton.click = function(layer) {
        window.isVideoOnFlag = !isVideoOn();
        if (isVideoOn()) {
            $(this)[0].show(200, 0.7);
            $(this)[0].show(200, 1);
        } else {
            $('.videoFrame').hide();
            $(this)[0].show(200, 0.5);
        }
    }
    
    __.exitButton = new Item({
        canvas: __.canvas,
        id: 'exitButton',
        imgUrl: '../../img/buttons/IkonaZamknij.png',
        coordX: 950,
        coordY: 20,
        element: 'help',
        noLimit: true
    });
    __.exitButton.init();
    __.exitButton.click = function () {
        if (__.gameNr == 'entry') {
            window.redirect("../../../index.html");
            return;
        }
        window.redirect("index.html");
    };

    __.reloadButton = new Item({
        canvas: __.canvas,
        id: 'reloadButton',
        imgUrl: '../../img/buttons/IkonaJeszczeRaz.png',
        coordX: 870,
        coordY: 20,
        element: 'help',
        noLimit: true
    });
    __.reloadButton.init();
    __.reloadButton.click = function () {
        if (__.gameNr == 'entry') {
            window.redirect("index.html");
        }
        window.redirect("game" + __.gameNr + ".html");
    };
}

function initHelp(__)
{
    __.helpButton = new Turner({
        canvas: __.canvas,
        id: 'helpButton',
        imgUrl: '../../img/buttons/help.png',
        coordX: 90,
        coordY: 20,
        width: 63,
        height: 64,
        element: 'help'
    });
    __.helpButton.init();

    __.canvas.drawImage({
        layer: true,
        name: 'help',
        source: '../../img/buttons/PomocKartka.png',
        x: -750, y: 1040,
        sWidth: 573,
        sHeight: 586,
        sx: 111, sy: 111,
        fromCenter: false,
        visible: false
    });
    __.canvas.animateLayer('help', {
        opacity: 0
    }, 1, 'swing');

    __.canvas.drawImage({
        layer: true,
        name: 'unia',
        source: '../../img/buttons/unia.jpg',
        x: -730, y: 1530,
        sWidth: 520,
        sHeight: 73,
        sx: 111, sy: 111,
        fromCenter: false,
        bringToFront: true,
        visible: false
    });


    __.helpClose = new Button({
        canvas: __.canvas,
        id: 'helpClose',
        imgUrl: '../../img/buttons/IkonaZamknij.png',
        coordX: -260,
        coordY: 1066,
        width: 63,
        height: 64,
        element: 'helpClose',
        visible: false
    });
    __.helpClose.init();

    swing = rand(2) * 10;
    var animType = 'linear';
    var animSpeed = 100;

    __.helpClose.click = function (helpClose) {

        __.helpButton.stage = false;
        __.helpButton.turnOff();

    };
    __.helpClose.mouseover = function (helpClose) {
        __.canvas.animateLayer(helpClose.name, {
            rotate: '+=' + swing,
            bringToFront: true
        }, 340, animType);
        __.canvas.css('cursor', 'pointer');
    };
    __.helpClose.mouseout = function (helpClose) {
        __.canvas.animateLayer(helpClose.name, {
            rotate: '-=' + swing * 1.5,
            bringToFront: true
        }, 'slow', animType);
        __.canvas.animateLayer(helpClose.name, {
            rotate: '+=' + swing * 0.5,
            bringToFront: true
        }, 'slow', animType);
    };
}

function initKid(__, id, path, x, y)
{
    var kid = new Kid({
        canvas: __.canvas,
        id: id,
        imgUrl: '../../img/kids/' + path,
        coordX: x,
        coordY: y
    });
    kid.init();
    return kid;
}