$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 2;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.countGoods = 0;
            __.initBags();
            __.initAnserws();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'A1/kid1.png';
            var kid2Path = 'A1/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 880, 266);
            __.kid2 = initKid(__, 'kid2', kid2Path, 7, 426);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initBags = function ()
        {
            __.bags = {};
            __.bagsCount = 5;

            __.startPositions = new Object();
            for (nr = 1; nr <= __.bagsCount; nr++) {
                __.startPositions[nr] = new Array();
            }
            __.startPositions[1]['x'] = 352;
            __.startPositions[1]['y'] = 212;
            __.startPositions[2]['x'] = 492;
            __.startPositions[2]['y'] = 142;
            __.startPositions[3]['x'] = 642;
            __.startPositions[3]['y'] = 212;
            __.startPositions[4]['x'] = 502;
            __.startPositions[4]['y'] = 272;
            __.startPositions[5]['x'] = 582;
            __.startPositions[5]['y'] = 372;

            for (nr = 1; nr <= __.bagsCount; nr++) {
                var id = 'bag_' + nr;
                __.bags[id] = new Bag({
                    canvas: __.canvas,
                    id: id,
                    opacity: 1,
                    imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/Etap2figura' + nr + 'Napis.png',
                    coordX: __.startPositions[nr]['x'],
                    coordY: __.startPositions[nr]['y'],
                    draggable: false,
                    bringToFront: true
                });
                __.bags[id].init();

                __.canvas.animateLayer('bag_' + nr, {
                    opacity: 0.3
                }, 100, 'swing');

                __.bags[id].error = function (layer) {
                };
                __.bags[id].good = function (layer) {
                };
            }
        };

        this.initAnserws = function ()
        {
            var answers = [];
            answers.push({value: 182, isInUse: 1, x: 100, y: 200});
            answers.push({value: 240, isInUse: 2, x: 333, y: 59}); 
            answers.push({value: 174, isInUse: 3, x: 624, y: 49}); 
            answers.push({value: 180, isInUse: 4, x: 31, y: 127}); 
            answers.push({value: 282, isInUse: 5, x: 907, y: 125}); 

            answers.push({value: 184, isInUse: false, x: 469, y: 49}); 
            answers.push({value: 175, isInUse: false, x: 178, y: 109}); 
            answers.push({value: 280, isInUse: false, x: 781, y: 150}); 
            answers.push({value: 150, isInUse: false, x: 18, y: 263}); 
            answers.push({value: 360, isInUse: false, x: 213, y: 177});

            __.answers = {};

            for (nr = 0; nr < answers.length; nr++) {
                var answer = answers[nr];
                __.drawTxt(nr+1, answer);
            }
        };

        this.drawTxt = function (nr, answer)
        {
            var id = 'txt_' + nr;
            __.answers[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#fff',
                strokeStyle: '#47629a',
                fontStyle: 'bold',
                fontSize: '34pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: answer.value,
                coordX: answer.x, coordY: answer.y,
                align: 'center',
                draggable: true,
                bringToFront: true,
                isInUse: answer.isInUse,
                game: __
            });
            __.answers[id].init();

            __.answers[id].animateToPositionCallback = function(layer)
            {
                this.swing();
            };

            __.answers[id].mouseover = function (layer) {
                __.canvas.css('cursor', 'pointer');
            };

            __.answers[id].dragstop = function (layer) {
                var __ = this;

                if (__.isInUse) {
                    if (__.game.bags['bag_' + nr].isOn(layer, 20)) {
                        __.hide();
                        __.game.bags['bag_' + nr].hide();
                        play('poprawnie-stas', window.kids.kid2);
                        window.countGoods++;

                        if (window.countGoods === Object.keys(__.game.bags).length) {
                            play('koniec-zosia', __.game.kid1, 'game3.html');
                        }
                        return;
                    }
                }
                play('blad-zosia', window.kids.kid1);
                __.backToOryginalPosition(layer);
            };

        };
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);