$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 3;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            __.initBoy();
            __.initRoadMap();
            __.initControlls();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'A1/kid1.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 880, 266);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initControlls = function()
        {
            __.controllers = {};
            __.controllersConfig = [];
            __.controllersConfig.push({name: 'up', x: 60, y: 530});
            __.controllersConfig.push({name: 'down', x: 62, y: 580});
            __.controllersConfig.push({name: 'left', x: 10, y: 580});
            __.controllersConfig.push({name: 'right', x: 110, y: 580});

            for(i=1; i <= __.controllersConfig.length; i++) {
                var config = __.controllersConfig[i-1];
                __.drawController(config);
            }


            $('body').keyup(function(k) {
                switch(k.which) {
                    case 37:
                        __.controllers['controll_left'].click();
                    break;
                    case 38:
                        __.controllers['controll_up'].click();
                    break;
                    case 39:
                        __.controllers['controll_right'].click();
                    break;
                    case 40:
                        __.controllers['controll_down'].click();
                    break;
                }    
            });
        };

        __.drawController = function(config)
        {
            var id = 'controll_' + config.name;
            __.controllers[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/' + config.name + '.png',
                coordX: config.x,
                coordY: config.y,
                draggable: false,
                bringToFront: true,
                config: config
            });
            __.controllers[id].init();

            __.controllers[id].click = function() {
                if (window.initBlock) {
                    return;
                }
                var currentStep = __.roadMap[__.currentRoadPart];



                if (this.config.name === currentStep.dir) {
                    __.stepsInRaodPart++;

                    cl(__.currentRoadPart, __.stepsInRaodPart);
                    if (__.currentRoadPart === 1 && __.stepsInRaodPart === 1) {
                        play('wskazowka02zosia', __.kid1);
                    } else if (__.currentRoadPart === 2 && __.stepsInRaodPart === 1) {
                        play('wskazowka03zosia', __.kid1);
                    } else if (__.currentRoadPart === 3 && __.stepsInRaodPart === 1) {
                        play('wskazowka04zosia', __.kid1);
                    } else if (__.currentRoadPart === 5 && __.stepsInRaodPart === 5) {
                        play('wskazowka06zosia', __.kid1);
                    } else if (__.stepsInRaodPart === currentStep.length) {
                        __.currentRoadPart++;
                        __.stepsInRaodPart = 0;


                        cl(__.currentRoadPart , __.stepsInRaodPart);

                        if (1) {

                        }

                        if (__.roadMap[__.currentRoadPart] && __.roadMap[__.currentRoadPart]['hint']) {
                            play(__.roadMap[__.currentRoadPart]['hint'], window.kids.kid1);
                        }

                        if (__.roadMap.length <= __.currentRoadPart) {
                            play('koniec-zosia', window.kids.kid1, 'game4.html');
                        } else {
                            currentStep = __.roadMap[__.currentRoadPart];         
                        }
                    } else {
                        play('poprawnie-zosia', window.kids.kid1);
                    }
                    __.boy.move(this.config.name, 1);
                } else {
                    play('blad-zosia', window.kids.kid1);
                }
            };
        };

        __.initRoadMap = function()
        {
            __.currentRoadPart = 0;
            __.stepsInRaodPart = 0;
            __.roadMap = [];

            __.roadMap.push({ dir: 'up', length: 6 });
            __.roadMap.push({ dir: 'right', length: 4, hint: false });
            __.roadMap.push({ dir: 'down', length: 3, hint: false });
            __.roadMap.push({ dir: 'left', length: 2, hint: false });
            __.roadMap.push({ dir: 'down', length: 3, hint: false });
            __.roadMap.push({ dir: 'right', length: 6, hint: 'wskazowka05zosia' });
        };

        this.initBoy = function ()
        {
            var id = 'boy';
            __.boy = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/' + __.gameNr + '/boy.png',
                coordX: 180,
                coordY: 500,
                draggable: true,
                bringToFront: true,
                step : 1
            });
            __.boy.init();
            __.boy.error = function()
            {
                
            }
        };
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);