$(document).ready(function () {
    $('#game').Game();
});

gameId = 'A';
gameNr = 5;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            window.nowPlace = 0;
            __.initNums();
            __.initBoy();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 200);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = 'A1/kid1.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 880, 266);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.initNums = function ()
        {
            __.stages = [4, 8, 12, 13, 17, 18, 14, 10, 6, 7];

            var coords = [];
            coords.push({x: 349, y:18, x2: 446, y2:116, equation: "3x7"});
            coords.push({x: 488, y:30, x2: 618, y2:130, equation: "5x5"});
            coords.push({x: 652, y:58, x2: 767, y2:157, equation: "9x7"});
            coords.push({x: 789, y:72, x2: 911, y2:167, equation: "9x6"});

            coords.push({x: 308, y:133, x2: 408, y2:240, equation: "5x4"});
            coords.push({x: 443, y:140, x2: 564, y2:252, equation: "3x9"});
            coords.push({x: 586, y:165, x2: 702, y2:291, equation: "74-22"});
            coords.push({x: 737, y:180, x2: 850, y2:310, equation: "8x7"});

            coords.push({x: 270, y:256, x2: 356, y2:373, equation: "2x12"});
            coords.push({x: 387, y:273, x2: 487, y2:384, equation: "5x7"});
            coords.push({x: 515, y:294, x2: 595, y2:400, equation: "6x8"});
            coords.push({x: 646, y:317, x2: 767, y2:419, equation: "8x9"});

            coords.push({x: 221, y:378, x2: 324, y2:484, equation: "7x4"});
            coords.push({x: 358, y:385, x2: 462, y2:500, equation: "26+6"});
            coords.push({x: 472, y:412, x2: 580, y2:506, equation: "4x11"});
            coords.push({x: 617, y:415, x2: 720, y2:509, equation: "7x7"});

            coords.push({x: 204, y:503, x2: 340, y2:622, equation: "7x5"});
            coords.push({x: 365, y:509, x2: 461, y2:624, equation: "6x6"});
            coords.push({x: 476, y:528, x2: 575, y2:633, equation: "8x5"});
            coords.push({x: 601, y:521, x2: 704, y2:636, equation: "3x7"});

            for (var i = 0; i <= coords.length - 1; i++) {
                coords[i].result = solveEquation(coords[i].equation);
                coords[i].nr = i;
            };

            __.coords = coords;
             __.txts = [];

            for (var i = __.coords.length - 1; i >= 0; i--) {
                var coord = __.coords[i];

                coord.x += (coord.x2 - coord.x) / 3;
                coord.y += (coord.y2 - coord.y) / 3;

                __.drawTxt(i, coord.equation, coord);

            };
        }

        this.drawTxt = function (nr, text, position)
        {
            var id = 'txt_' + nr;
            __.txts[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#356583',
                strokeStyle: '#2c5078',
                fontStyle: 'bold',
                fontSize: '16pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: text,
                coordX: position.x, coordY: position.y,
                align: 'center',
                draggable: false,
                bringToFront: true,
                game: __
            });
            __.txts[id].init();
            __.txts[id].click = function(layer) {
                __.movie(layer);
            }
        };

        __.clickOnBg = function(layer) {
            __.movie(layer);
        }

        __.movie = function(layer)
        {
            clickedPlace = __.getStageByClick(layer);
            if (clickedPlace) {
                if (clickedPlace.nr == __.stages[window.nowPlace]) {
                    window.nowPlace++;

                    
                    play('poprawnie-zosia', __.kid1);
                    __.boy.animateToPosition(false, clickedPlace.x, clickedPlace.y-30);

                    if (__.stages[window.nowPlace] === undefined) {
                        play('koniec-zosia', __.kid1, 'index.html');
                    }

                } else {
                    // Error (wrong field)    
                    play('blad-zosia', __.kid1);
                }
            } else {
                // ERROR (not in playing ground...)
                play('blad-zosia', __.kid1);
            }
        }

        __.getStageByClick = function(layer) {
            for (var i = __.coords.length - 1; i >= 0; i--) {
                var coord = __.coords[i];

                var xIsGood = layer.eventX >= coord.x - 20 && layer.eventX <= coord.x2;
                var yIsGood = layer.eventY >= coord.y && layer.eventY <= coord.y2;

                if (xIsGood && yIsGood) {
                    return coord;
                }
            }
            return false;
        }     

        this.initBoy = function ()
        {
            var id = 'boy';
            __.boy = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: '../../img/' + __.gameId + '/3/boy.png',
                coordX: 180,
                coordY: 130,
                draggable: true,
                bringToFront: true,
                step : 1
            });
            __.boy.init();
        };
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);