$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 2;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            window.clickBlock = false;
            window.isAnimateOn = true;

            __.animals = [];
            __.initCoords();
            __.initAnimals();
            __.initButton();
            __.initPictures();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = __.gameId + '/kid1.png';
            var kid2Path = __.gameId + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 490, 480);
            __.kid2 = initKid(__, 'kid2', kid2Path, 360, 470);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.clickOnBg = function(layer) {
            // cl('x:' + layer.eventX + ', y:' + layer.eventY);
        }

        this.initAnimals = function ()
        {
            __.groups = [];
            __.groups.push({name: 'ssak', good: true, animalsCount: 8});
            __.groups.push({name: 'ptaki', good: false, animalsCount: 3});
            __.groups.push({name: 'owady', good: false, animalsCount: 5});
            __.groups.push({name: 'gady', good: false, animalsCount: 1});

            for (gi = 0; gi < __.groups.length; gi++) {
                var group = __.groups[gi];
                for (i = 0; i < group.animalsCount; i++) {
                    var id = gi + '' + i;
                    if (__.coords[id]) {
                        var coord = __.coords[id];

                        __.drawAnimal('animal_' + id, coord, group, i);
                    }
                }
            }

            __.runAnimations();
        }

        __.runAnimations = function(iteration)
        {
            var iteration = (typeof iteration !== 'undefined') ? iteration : 1;
            window.clickBlock = false;
            if (window.isAnimateOn) {
                if (iteration % 5 === 0) {
                    __.showOneFromGroup('ssak');
                    __.hideAllFromGroup('ptaki');
                    __.hideAllFromGroup('owady');
                    __.hideAllFromGroup('gady');
                } else {
                    __.showOneFromGroup('owady');
                    __.shuffleSomeAnimals();
                }
            }

            setTimeout(function () {
                __.runAnimations(iteration+1);
            }, 3000);
        }

        __.shuffleSomeAnimals = function()
        {
            var changePerTour = 4;
            for (index in __.animals) {
                var animal = __.animals[index];
                if (changePerTour >= 0) {
                    if (rand(5) > 3) {

                        if (animal.visible) {
                            // if (rand(5) > 3) {
                                animal.hide(200);
                            // }
                        } else {
                            changePerTour++;
                            animal.show(200);
                        }
                        
                        changePerTour--;
                    }
                }
            }
        }
        __.showAllFromGroup = function(groupName) {
             for (index in __.animals) {
                var animal = __.animals[index];
                if (!animal.visible && animal.group.name === groupName) {
                    animal.show(200);
                }
            }
        }
        __.showOneFromGroup = function(groupName) {
             for (index in __.animals) {
                var animal = __.animals[index];
                if (!animal.visible && animal.group.name === groupName) {
                    animal.show(200);
                    return;
                }
            }
        }
        __.hideAllFromGroup = function(groupName) {
             for (index in __.animals) {
                var animal = __.animals[index];
                if (animal.visible && animal.group.name === groupName) {
                    animal.hide(200);
                }
            }
        }

        __.drawAnimal = function(id, coord, group, i)
        {
            __.animals[id] = new Item({
                canvas: __.canvas,
                id: id,
                imgUrl: getImgDir(__) + group.name + '_' + i + '.png',
                coordX: coord.x,
                coordY: coord.y,
                draggable: false,
                bringToFront: true,
                group : group
            });
            __.animals[id].init();
        }

        __.initCoords = function() {
            __.coords = {};
            __.coords['00'] = ({x:78, y:582.5});
            __.coords['01'] = ({x:163, y:398.5});
            __.coords['02'] = ({x:831, y:360.5});
            __.coords['03'] = ({x:201, y:472.5});
            __.coords['04'] = ({x:295, y:394.5});
            __.coords['05'] = ({x:658, y:331});
            __.coords['06'] = ({x:179, y:273.5});
            __.coords['07'] = ({x:41, y:286.5});
            
            __.coords['10'] = ({x:10, y:112.5});
            __.coords['11'] = ({x:659, y:195.5});
            __.coords['12'] = ({x:438, y:177.5});
            
            __.coords['20'] = ({x:679, y:483.5});
            __.coords['21'] = ({x:619, y:436.5});
            __.coords['22'] = ({x:530, y:395.5});
            __.coords['23'] = ({x:929, y:402.5});
            __.coords['24'] = ({x:960, y:333.5});

            __.coords['30'] = ({x:667, y:561.5});
        }

        __.initPictures = function()
        {
            __.pictures = [];
            for (var i = 1; i <= 6; i++) {
                var id = 'pic_' + i;

                __.pictures[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    imgUrl: getImgDir(__) + 'pic.png',
                    coordX: 150 + i * 80,
                    coordY: 30,
                    draggable: false,
                    bringToFront: true,
                    opacity: 0.4
                });
                __.pictures[id].init();
            };
            setTimeout(function () {
                __.flash = new Item({
                    canvas: __.canvas,
                    id: 'flash',
                    imgUrl: getImgDir(__) + 'flash.png',
                    coordX: 0,
                    coordY: 0,
                    draggable: false,
                    bringToFront: true,
                    opacity: 0,
                    visible: false
                });
                __.flash.init();
            }, 500);
        }

        __.initButton = function()
        {
            __.button = new Item({
                canvas: __.canvas,
                id: 'button',
                imgUrl: getImgDir(__) + 'button.png',
                coordX: 910,
                coordY: 227,
                draggable: false,
                bringToFront: true
            });
            __.button.init();

            __.button.click = function(layer) {

                if (window.clickBlock) {
                    return false;
                }
                window.clickBlock = false;

                for (index in __.animals) {
                    var animal = __.animals[index];
                    if (animal.group.name === 'ssak') {
                        if (!animal.visible) {
                            // play('blad-stas', __.kid2);
                            // return false;
                        }
                    } else {
                        if (animal.visible) {
                            play('blad-stas', __.kid2);
                            return false;
                        }
                    }
                }

                if (!__.markPic()) {
                    play('koniec-stas', __.kid2, 'game3.html');
                } else {
                    play('poprawnie-stas', __.kid2);
                }
            }
        }

        __.markPic = function() {
            for (pic in __.pictures) {
                var pic = __.pictures[pic];
                if (pic.opacity != 1) {
                    pic.show(400);
                    __.flash.show(100);
                    setTimeout(function () {
                        __.flash.hide(200);
                    }, 200);
                    
                    if (pic.id === 'pic_6') {
                        return false;
                    }
                    return true;
                }
            }
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);