$(document).ready(function () {
    $('#game').Game();
});

gameId = 'B';
gameNr = 5;

(function ($, f) {

    if (!$)
        return f;

    var Game = function ()
    {
        var __ = this;
        __.canvas = false;

        this.init = function (el)
        {
            window.bootstrap();

            if (typeof el === 'undefined')
                return f;

            __.canvas = el;
            __.cWidth = parseInt(__.canvas.css('width'));
            __.cHeight = parseInt(__.canvas.css('height'));

            __.gameId = window.gameId;
            __.gameNr = window.gameNr;

            initBackground(__);
            loadAudioForGame(__);
            loadBgAudio(__);
            __.initKids();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            // window.initBlock = false;

            window.goodCount = 0;
            window.totalCount = 0;
            window.clickCount = 0;

            window.clicked = new Array();
            window.toClick = new Array();

            __.initLetter();
            __.initBgs();

            /*~~~~~~~~~~~~~~~~~~~~~~~*/

            setTimeout(function () {
                initButtons(__);
                initHelp(__);
            }, 300);

            if(window.enableInitSounds) {
                playInitAudio(__);
            }
        };

        this.initKids = function ()
        {
            var kid1Path = __.gameId + '/kid1.png';
            var kid2Path = __.gameId + '/kid2.png';
            __.kid1 = initKid(__, 'kid1', kid1Path, 38, 319);
            __.kid2 = initKid(__, 'kid2', kid2Path, 858, 209);

            var Kids = new Object();
            Kids.kid1 = __.kid1;
            Kids.kid2 = __.kid2;
            window.kids = Kids;
        };
        /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

        this.clickOnBg = function(layer) {
            // cl('x:' + layer.eventX + ', y:' + layer.eventY);
            var x = layer.eventX;
            var y = layer.eventY;
            var goodX = x >= 265 && x <= 757;
            var goodY = y >= 20 && y <= 516;
            if (goodX && goodY) {
                play('blad-zosia', __.kid1);
            }
            // cl(goodX , goodY, layer.eventX, layer.eventY);
        }


        __.initBgs= function() {

            __.bgs = [];
            __.let = [];
            __.colors = [];
            var red = '#e10d0d';
            var yellow = '#e4e511';
            var lightGreen = '#a7ff7a ';
            var lightPurple = '#cdaeff';
            var purple = '#9828f9';
            var orange = '#f68234';
            var green = '#1cf214';
            var lightRed = '#ff4d00 ';
            var pink = '#ff58ce';
            var yellow = '#e4e511';
            var blue = '#1376ff';


            __.colors.push({name: orange, 
                y1: 1, y2: 9, 
                x1: 1, x2: 1
            });
            __.colors.push({name: pink, 
                x1: 6, x2: 6, 
                y1: 3, y2: 8
            });
            __.colors.push({name: red, 
                x1: 2, x2: 7, 
                y1: 1, y2: 1
            });
            __.colors.push({name: yellow, 
                y1: 3, y2: 8,
                x1: 2, x2: 2
            });
            __.colors.push({name: lightPurple, // szalwia 
                y1: 2, y2: 8,
                x1: 7, x2: 7
            });
            __.colors.push({name: blue,  
                y1: 9, y2: 9,
                x1: 2, x2: 8
            });
            __.colors.push({name: lightGreen,  
                y1: 4, y2: 8,
                x1: 3, x2: 3
            });
            __.colors.push({name: purple,  
                y1: 2, y2: 2,
                x1: 2, x2: 7
            });
            __.colors.push({name: lightRed,  
                y1: 3, y2: 6,
                x1: 4, x2: 4
            });
            __.colors.push({name: green,  
                y1: 1, y2: 8,
                x1: 8, x2: 8
            });

            for (color in __.colors) {
                var color = __.colors[color];
                window.totalCount += color.x2 - color.x1 + color.y2 - color.y1 + 1;

                window.toClick[color.name] = __.getCountFromColor(color);
                window.clicked[color.name] = 0;
               
            }

            for(i=0; i < 8; i++) {
                for(j=0; j < 9; j++) {

                    var w = 54;
                    var h = 54;

                    var x = 270;
                    var y = 65;
                    y += i * h;
                    x += j * w;
                    var color = __.getColor(i, j);
                    var letter = __.letters[i*9+j];
                    __.drawLetter(i+""+j, letter, x, y);
                    if (color) {
                        __.drawRectangle(i+""+j, x, y, w, h, color);
                    }
                }                
            }
        }

        __.drawLetter = function(id, letter, x, y)
        {
            x += 10;
            y += 4;
            if (letter == 'I') {
                x += 6;
            } else if (letter == 'W') {
                x -= 4;
            } else if (letter == 'Ł') {
                x += 3;
            }

            var id = 'txt_' + id;
            __.let[id] = new Txt({
                canvas: __.canvas,
                id: id,
                fillStyle: '#47629a',
                strokeStyle: '#bac2ff',
                fontStyle: '',
                fontSize: '30pt',
                fontFamily: 'Trebuchet MS, sans-serif',
                text: letter,
                coordX: x, coordY: y,
                align: 'center',
                draggable: false,
                bringToFront: true
            });
            __.let[id].init();
            __.let[id].click = function(layer) {
                play('blad-zosia', __.kid1);
            }
        };

        __.getColor = function(x, y)
        {
            x++;y++;
            for (color in __.colors) {
                var color = __.colors[color];
                var goodX = color.x1 <= x && color.x2 >= x;
                var goodY = color.y1 <= y && color.y2 >= y;
                if (goodX && goodY) {
                    return color;
                }
            }
        }

        __.drawRectangle = function(id, x, y, w, h, color)
        {
            var id = 'poly_' + id;
            __.bgs[id] = new Rectangle({
                canvas: __.canvas,
                id: id,
                coordX: x,
                coordY: y,
                width: w,
                height: h,
                fillStyle: color.name,
                colorObj: color,
                strokeStyle: '#000',
                // x: 100, y: 100,
                radius: 36,
                sides: 4,
                opacity: 0.5,
                draggable: false,
                bringToFront: true,
                fromCenter: false,
                opacity: 0,
                visible: false,
                clicked: false,
                clr: color,
                controller: __
                // visible: false
            });
            __.bgs[id].init();
            __.bgs[id].click = function(layer) {

                if (!$(this)[0].clicked && $(this)[0].opacity != 1) {
                    $(this)[0].clicked = 1;
                    $(this)[0].show(100, 0.6);
                    window.clickCount++;

                    window.clicked[this.clr.name]++;

                    // console.log(window.clicked[this.clr.name] , window.toClick[this.clr.name]);

                    if (window.clicked[this.clr.name] === window.toClick[this.clr.name]) {
                        play('poprawnie-slowo-stas', __.kid2);
                    }

                    __.getCountFromColor(this.clr);
// console.log(window.totalCount , window.clickCount);
                    
                    // cl(window.totalCount , window.clickCount);
                    if (window.totalCount-1 == window.clickCount) {
                        play('poprawnie-slowo-stas', __.kid2, 'index.html');
                    } else {
                        // play('poprawnie-litera-stas', __.kid2);
                    }
                } else {
                    play('blad-zosia', __.kid1);
                }
            }
            __.bgs[id].mouseover = function(layer) {

            }
        };


        __.initLetter = function()
        {
            // __.letters = 
            // 'SASKRZYPWR' +
            // 'ZBCTCHABER' + 
            // 'AKONICZYNA' +
            // 'ŁQKDFGJAQJ' +
            // 'WWUQRDESTA' +
            // 'IFKISCJIPS' +
            // 'ABLPBABKAK' +
            // 'TIILUMBCZI' +
            // 'GOKEWYKADE' +
            // 'RZEŻUCHAQR';

            __.letters = 
            'KONICZYNA' +
            'KBSKRZYPJ' + 
            'UAXRDESTA' +
            'KBWYKAIPS' +
            'LKAFYUKLK' +
            'IACHABERI' +
            'KSZAŁWIAE' +
            'RZEŻUCHAR';
        }

        __.initBoards = function()
        {
            
            __.boards = [];
            for (var i = 0; i < __.coords.length; i++) {
                var id = 'board_' + i;

                __.boards[id] = new Item({
                    canvas: __.canvas,
                    id: id,
                    i: i,
                    imgUrl: getImgDir(__) + 'Etap4-PLANSZA'+(i+1)+'.png',
                    coordX: __.coords[i].x,
                    coordY: __.coords[i].y,
                    draggable: false,
                    bringToFront: true,
                    opacity: 1
                });
                __.boards[id].init();

            };
        }

        __.getCountFromColor = function(color)
        {
            // console.log(color);
            var ry = color.y2 - color.y1;
            var rx = color.x2 - color.x1;
            if (ry !== 0 || color.name === '#e10d0d' ||  color.name === '#1376ff') {
                ry++;
            }
            return ry + rx;
        }
    };

    $.fn.Game = function ()
    {
        var instance = (new Game).init();
        var len = this.length;
        return this.each(function (index) {
            var me = $(this);
            var instance = (new Game).init(me);
            me.data('Game' + (len > 1 ? '-' + (index + 1) : ''), instance);
        });

    };
})(window.jQuery, false);