function getBgSoundVolume() {
    return 0.05;
};

function isVideoOn()
{
    return window.isVideoOnFlag;
}

function loadAudioForGame(__)
{

    var audioDirs = getAudioDirs();
    for(i in audioDirs[__.gameId][__.gameNr]) {
        var path  = audioDirs[__.gameId][__.gameNr][i];
        
        var name = path.split('/');
        name = name[name.length-1];

        var clearName = name.split('.');
        clearName = clearName[0];
        
        createAudio('../../media/' + __.gameId + '/audio/' + __.gameNr + '/' + name, clearName, '', '');

        createVideo('../../media/' + window.gameId + '/video/' + __.gameNr + '/' + clearName + '.mp4', 'v_' + clearName, '');
    }


    setTimeout(function () {
            window.audioIsLoaded = 1;
    }, 3000);

}
function loadBgAudio(__)
{
    createAudio('../../media/' + __.gameId + '/audio/bg_loop.mp3', 'bgAudio', 'autoplay', 'loop');
    $('#bgAudio')[0].volume = getBgSoundVolume();
}

function createVideo(path, id, autoplay)
{
    var display = (isVideoOn()) ? 'block' : 'none';
//        cl(path);
        $("#videoHolder").append(
                '<div class="videoFrame" style="display: '+display+';"><video style="display: block;" class="video" id="' + id + '" width="240" height="180" preload="auto" ' + autoplay + '>' +
                '<source src="' + path + '" type="video/mp4"></source>' +
                '</video></div>');
        // $(".videoFrame").show();
    
}

function createAudio(path, id, autoplay, loop)
{
    if (!window.mediaOn) {
        return false;
    }
   cl('Render audio:' + path);
    $("body").append(
            '<audio class="audio disnone" id="' + id + '" width="300" height="180" preload ' + autoplay + ' ' + loop + ' >' +
            '<source src="' + path + '" type="video/mp4"></source>' +
            '</audio>');

    $('#' + id)[0].volume = 0.5;
}

function play(id, kid, redirectTarget) {

    if (!window.mediaOn) {
        return false;
    }

    if ($('#' + id).length === 0) {
        setTimeout(function () {
            play(id);
        }, 1000);
        return;
    }

    $.each($('.audio'), function (index, value) {
        if ($(value).attr('id') !== 'bgAudio') {
            pause($(value).attr('id'));
        }
    });


    if (id.indexOf('_kid') > -1) {
        var tmp = id.split('_kid');
        var kidId = 'kid' + tmp[1];
    }

    if (typeof kid !== 'undefined' || kidId) {
        if (kidId) {
            var kid = window.kids[kidId];
        }
        
        var time = $('#' + id)[0].duration;
        if (isVideoOn()) {
            time = $('#v_' + id)[0].duration;
        }
        kid.talkFor(time);
    }
    if (typeof redirectTarget !== 'undefined') {
        var redirectAfterMilisecounds = time * 1000 + 500;
        redirect(redirectTarget, redirectAfterMilisecounds);
    }

    $('#' + id)[0].play();
    if (isVideoOn()) {
        $('.videoFrame').show();
        var frame = $('#v_' + id).parents()[0];
        window.newZindex++;
        $(frame).css('zIndex', window.newZindex);
        $('#v_' + id)[0].play();
    } else {
        $('.videoFrame').hide();
    }
}

function pause(id) {
    if ($('#' + id)[0].currentTime) {
        $('#' + id)[0].currentTime = 0;
    }
    $('#' + id)[0].pause();
}

function playInitAudio(__)
{
    if (!window.audioIsLoaded) {
        setTimeout(function () {
            playInitAudio(__);
        }, 1000);
        return;
    }
    // cl(window.audioIsLoaded);
// return;
    var audioList = getInitAudioCollection();

    if (audioList.length > 0) {
        startInitAudioRoll(0, audioList);
    }
}

function getInitAudioCollection()
{
    var audios = [];
    $.each($('.audio'), function (index, value) {
        var isInitAudio = $(value).attr('id').indexOf('init_') > -1;
        if (isInitAudio) {
            audios.push($(this));
        }
    });
    return audios;
}

function startInitAudioRoll(nr, list)
{
    //  TODO gets video length if needed from element.attr('id') with .mp4 format...
    var audioLength = list[nr][0].duration;
    if (isVideoOn())  {
        var audioLength = $('#v_' + list[nr].attr('id'))[0].duration;
    }
    play(list[nr].attr('id'));
    
    nr++;
    if (list[nr]) {
        setTimeout(function () {
                startInitAudioRoll(nr, list);
        }, audioLength * 1000 + 1000);
    } else {
        setTimeout(function () {
            window.initBlock = false;
        }, audioLength * 1000);
    }
}

function getAudioDirs()
{
    var audioPaths = [];
    
    audioPaths['A'] = [];
    audioPaths['B'] = [];

    var keys = ['A', 'B'];
    var Nrs = ['entry', 1, 2, 3, 4, 5];

    for (key in keys) {
        var key = keys[key];
        audioPaths[key] = [];
        for (i in Nrs) {
            var nr = Nrs[i];
            audioPaths[key][nr] = [];
        }
    }
    
    audioPaths['A']['1'].push('../../media/A/audio/1/blad-stas.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_0_kid2.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_1_kid1.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_2_kid1.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_3_kid2.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_4_kid1.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/init_5_kid2.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/koniec-stas.mp3');
    audioPaths['A']['1'].push('../../media/A/audio/1/poprawnie-zosia.mp3');
    audioPaths['A']['entry'].push('../../media/A/audio/entry/init_0_kid2.mp3');
    audioPaths['A']['entry'].push('../../media/A/audio/entry/init_1_kid1.mp3');
    audioPaths['A']['entry'].push('../../media/A/audio/entry/init_2_kid2.mp3');
    audioPaths['A']['entry'].push('../../media/A/audio/entry/init_3_kid1.mp3');
    audioPaths['A']['entry'].push('../../media/A/audio/entry/init_4_kid2.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/blad-zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/init_0_kid1.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/init_1_kid1.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/koniec-zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/poprawnie-zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/wskazowka02zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/wskazowka03zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/wskazowka04zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/wskazowka05zosia.mp3');
    audioPaths['A']['3'].push('../../media/A/audio/3/wskazowka06zosia.mp3');
    audioPaths['A']['4'].push('../../media/A/audio/4/blad-stas.mp3');
    audioPaths['A']['4'].push('../../media/A/audio/4/init_0_kid2.mp3');
    audioPaths['A']['4'].push('../../media/A/audio/4/koniec-stas.mp3');
    audioPaths['A']['4'].push('../../media/A/audio/4/pelneSanie-stas.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/blad-zosia.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/init_0_kid2.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/init_1_kid1.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/init_2_kid2.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/init_3_kid1.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/koniec-zosia.mp3');
    audioPaths['A']['2'].push('../../media/A/audio/2/poprawnie-stas.mp3');
    audioPaths['A']['5'].push('../../media/A/audio/5/blad-zosia.mp3');
    audioPaths['A']['5'].push('../../media/A/audio/5/init_0_kid1.mp3');
    audioPaths['A']['5'].push('../../media/A/audio/5/koniec-zosia.mp3');
    audioPaths['A']['5'].push('../../media/A/audio/5/poprawnie-zosia.mp3');
    audioPaths['B']['entry'].push('../../media/B/audio/entry/init_0_kid2.mp3');
    audioPaths['B']['entry'].push('../../media/B/audio/entry/init_1_kid1.mp3');
    audioPaths['B']['entry'].push('../../media/B/audio/entry/init_2_kid2.mp3');
    audioPaths['B']['entry'].push('../../media/B/audio/entry/init_3_kid1.mp3');
    audioPaths['B']['entry'].push('../../media/B/audio/entry/init_4_kid2.mp3');
    audioPaths['B']['1'].push('../../media/B/audio/1/blad-stas.mp3');
    audioPaths['B']['1'].push('../../media/B/audio/1/init_0_kid2.mp3');
    audioPaths['B']['1'].push('../../media/B/audio/1/init_1_kid1.mp3');
    audioPaths['B']['1'].push('../../media/B/audio/1/koniec-stas.mp3');
    audioPaths['B']['1'].push('../../media/B/audio/1/poprawnie-stas.mp3');
    audioPaths['B']['2'].push('../../media/B/audio/2/blad-stas.mp3');
    audioPaths['B']['2'].push('../../media/B/audio/2/init_0_kid2.mp3');
    audioPaths['B']['2'].push('../../media/B/audio/2/koniec-stas.mp3');
    audioPaths['B']['2'].push('../../media/B/audio/2/poprawnie-stas.mp3');
    audioPaths['B']['4'].push('../../media/B/audio/4/blad-zosia.mp3');
    audioPaths['B']['4'].push('../../media/B/audio/4/init_0_kid1.mp3');
    audioPaths['B']['4'].push('../../media/B/audio/4/koniec-zosia.mp3');
    audioPaths['B']['4'].push('../../media/B/audio/4/poprawnie-zosia.mp3');
    audioPaths['B']['5'].push('../../media/B/audio/5/blad-zosia.mp3');
    audioPaths['B']['5'].push('../../media/B/audio/5/init_0_kid2.mp3');
    audioPaths['B']['5'].push('../../media/B/audio/5/init_1_kid1.mp3');
    audioPaths['B']['5'].push('../../media/B/audio/5/poprawnie-litera-stas.mp3');
    audioPaths['B']['5'].push('../../media/B/audio/5/poprawnie-slowo-stas.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-blad-stas.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-koniec-zosia.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-polecenie1.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-polecenie2.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-polecenie3.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-polecenie4.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie1-poprawnie-stas.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie2-blad-stas.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie2-koniec-zosia.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie2-polecenie-zosia.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/Zadanie2-poprawnie-zosia.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/init_0_kid2.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/init_1_kid1.mp3');
    audioPaths['B']['3'].push('../../media/B/audio/3/init_2_kid2.mp3');
    
    return audioPaths;
};