var Form = function () {

    //zmienne formularza
    this.name;
    this.surname;
    this.age;
    this.work;
    this.gender = "empty";
    this.wyksztalcenie;

    //zmienne do wykresu
    this.stenValueData;
    this.stenValuePeople;
    this.stenValueThings;
    this.stenValueIdea;

    //zmienne do słownego podsumowania wykresu
    this.stenTextData;
    this.stenTextPeople;
    this.stenTextThings;
    this.stenTextIdea;

    this.stenTextDataDesc;
    this.stenTextPeopleDesc;
    this.stenTextThingsDesc;
    this.stenTextIdeaDesc;

    /**
     * Dane wygenerowane z formularza pytania.php
     */
    this._questions = [{"question": "1. Dzia\u0142a\u0107 wed\u0142ug okre\u015blonych zasad, standard\u00f3w, norm i przepis\u00f3w\r\n"}, {"question": "2. Doradza\u0107 i pomaga\u0107 innym w rozwi\u0105zaniu ich trudnych problem\u00f3w\r\n"}, {"question": "3. Interesowa\u0107 si\u0119 budow\u0105 i funkcjonowaniem r\u00f3\u017cnych maszyn i urz\u0105dze\u0144\r\n"}, {"question": "4. Wymy\u015bla\u0107 co\u015b i wdra\u017ca\u0107 to do praktyki\r\n"}, {"question": "5. Diagnozowa\u0107 i rozwi\u0105zywa\u0107 r\u00f3\u017cne problemy\r\n"}, {"question": "6. Ocenia\u0107 zachowania i mo\u017cliwo\u015bci innych ludzi\r\n"}, {"question": "7. Dogl\u0105da\u0107, nadzorowa\u0107 i regulowa\u0107 r\u00f3\u017cne maszyny i urz\u0105dzenia\r\n"}, {"question": "8. Bada\u0107 otaczaj\u0105cy \u015bwiat i poznawa\u0107 rz\u0105dz\u0105ce nim prawid\u0142owo\u015bci\r\n"}, {"question": "9. Zestawia\u0107 i porz\u0105dkowa\u0107 informacje z r\u00f3\u017cnych \u017ar\u00f3de\u0142\r\n"}, {"question": "10. Wywiera\u0107 wp\u0142yw na innych (ich przekonania, postawy i zachowania)\r\n"}, {"question": "11. Obrabia\u0107 przedmioty i materia\u0142y z u\u017cyciem specjalistycznych przyrz\u0105d\u00f3w i narz\u0119dzi\r\n"}, {"question": "12. Zajmowa\u0107 si\u0119 dzia\u0142alno\u015bci\u0105 naukow\u0105\r\n"}, {"question": "13. Analizowa\u0107 dost\u0119pne informacje i wnioskowa\u0107 na ich podstawie\r\n"}, {"question": "14. Reprezentowa\u0107 interesy innych, negocjowa\u0107\r\n"}, {"question": "15. Kierowa\u0107 lub prowadzi\u0107 r\u00f3\u017cne pojazdy mechaniczne \r\n"}, {"question": "16. Przelewa\u0107 na papier swoje my\u015bli, opinie i przemy\u015blenia\r\n"}, {"question": "17. Łączy\u0107 i scala\u0107 r\u00f3\u017cne informacje w celu stworzenia z nich sp\u00f3jnej ca\u0142o\u015bci\r\n"}, {"question": "18. Instruowa\u0107, szkoli\u0107, uczy\u0107 lub trenowa\u0107 innych\r\n"}, {"question": "19. Obs\u0142ugiwa\u0107 r\u00f3\u017cne maszyny i urz\u0105dzenia\r\n"}, {"question": "20. Tworzy\u0107 nowe teorie lub weryfikowa\u0107 dost\u0119pn\u0105 wiedz\u0119 na dany temat\r\n"}, {"question": "21. Tworzy\u0107 zestawienia informacji pochodz\u0105cych z r\u00f3\u017cnych \u017ar\u00f3de\u0142\r\n"}, {"question": "22. Wydawa\u0107 innym polecenia, kierowa\u0107 ich dzia\u0142aniami\r\n"}, {"question": "23. Kontrolowa\u0107 maszyny i urz\u0105dzenia, obserwowa\u0107 wska\u017aniki maszyn i urz\u0105dze\u0144\r\n"}, {"question": "24. Wdra\u017ca\u0107 i realizowa\u0107 w\u0142asne wizje artystyczne\r\n"}, {"question": "25. Przeprowadza\u0107 obliczenia i operacje liczbowe\r\n"}, {"question": "26. Nadzorowa\u0107 i kontrolowa\u0107 wykonywanie zada\u0144 przez innych\r\n"}, {"question": "27. Manipulowa\u0107 narz\u0119dziami oraz przyrz\u0105dami pomiarowymi\r\n"}, {"question": "28. Inicjowa\u0107 r\u00f3\u017cne oryginalne pomys\u0142y i dzia\u0142ania\r\n"}, {"question": "29. Sporz\u0105dza\u0107 analizy i sprawozdania finansowe, prowadzi\u0107 rachunkowo\u015b\u0107\r\n"}, {"question": "30. Dostarcza\u0107 innym rozrywki, zabawia\u0107 ich\r\n"}, {"question": "31. Podawa\u0107, uk\u0142ada\u0107, przemieszcza\u0107 r\u00f3\u017cne przedmioty i materia\u0142y\r\n"}, {"question": "32. Wykorzystywa\u0107 bogat\u0105 wyobra\u017ani\u0119 i intuicj\u0119\r\n"}, {"question": "33. Por\u00f3wnywa\u0107 dost\u0119pne informacje pochodz\u0105ce z r\u00f3\u017cnych \u017ar\u00f3de\u0142\r\n"}, {"question": "34. Przekonywa\u0107 innych\r\n"}, {"question": "35. Wykorzystywa\u0107 r\u0119czne narz\u0119dzia w celu obrobienia przedmiot\u00f3w i materia\u0142\u00f3w\r\n"}, {"question": "36. Rozwi\u0105zywa\u0107 problemy w spos\u00f3b tw\u00f3rczy i nietypowy\r\n"}, {"question": "37. Podejmowa\u0107 decyzje oraz dokonywa\u0107 ocen w oparciu o zebrane informacje"}, {"question": "38. Obs\u0142ugiwa\u0107 innych, \u015bwiadczy\u0107 r\u00f3\u017cne us\u0142ugi na ich rzecz"}, {"question": "39. Instalowa\u0107 i montowa\u0107 r\u00f3\u017cne urz\u0105dzenia za pomoc\u0105 precyzyjnych narz\u0119dzi"}, {"question": "40. My\u015ble\u0107 abstrakcyjnie"}];

    this._position = 0;
    this._answers = "";

    /*
     * Dane wygenerowane z tabeli punktacji wartosci.php
     */
    this._stenPeople = {1: 20.65, 2: 24.38, 3: 28.12, 4: 31.85, 5: 35.59, 6: 39.32, 7: 43.06, 8: 46.79, 9: 50.00};
    this._stenData = {1: 19.81, 2: 23.42, 3: 27.02, 4: 30.63, 5: 34.24, 6: 37.85, 7: 41.46, 8: 45.07, 9: 48.67, 10: 50.00};
    this._stenIdea = {1: 21.28, 2: 24.94, 3: 28.60, 4: 32.26, 5: 35.93, 6: 39.59, 7: 43.25, 8: 46.91, 9: 50.00};
    this._stenThings = {1: 7.73, 2: 12.69, 3: 17.65, 4: 22.61, 5: 27.57, 6: 32.53, 7: 37.49, 8: 42.45, 9: 47.41, 10: 50.00};

    /**
     * Zmianna do testowania wykresu, 
     * po przełączeniu generuje losowe wartości punktowe
     * dla wymiarów 
     */
    this._testValues = false;

    this.getQuestions = function () {
        return this._questions;
    };

    this.appendAnswer = function (answer) {
        this._answers += answer;
        this._position++;
    };

    this.getNextQuestion = function () {
        return this._questions[this._position];
    };

    this.setUserData = function (name, surname, age) {
        this.name = name;
        this.surname = surname;
        this.age = age;
    };

    this.isNotLastQuestion = function () {
        if (this._position < 39) {
            return true;
        } else {
            return false;
        }
    };

    /**
     * 
     * Metoda wywoływana po zakończeniu wprowadzaniu odpowiedzi.
     * Konieczna do wygenerowania wykresu ze stenami.
     */
    this.generateStenValues = function (answers) {
        var pointsData = 0;
        var pointsPeople = 0;
        var pointsThings = 0;
        var pointsIdea = 0;

        this._answers = answers;

        if (this._testValues) {
            this._answers = [1, 2, 3, 4, 5, 1, 2, 3, 4, 5,
                1, 2, 3, 4, 5, 1, 2, 3, 4, 5,
                1, 2, 3, 4, 5, 1, 2, 3, 4, 5,
                1, 2, 3, 4, 5, 1, 2, 3, 4, 5];

            this._answers = this._shuffleArray(this._answers);
        }

        //podsumowanie ankiety
        for (var i = 0; i < 40; ) {
            pointsData += parseInt(this._answers[i++]);
            pointsPeople += parseInt(this._answers[i++]);
            pointsThings += parseInt(this._answers[i++]);
            pointsIdea += parseInt(this._answers[i++]);
        }

        log("points data " + pointsData + " people " + pointsPeople + " things " + pointsThings + " idee " + pointsIdea);

        log("data");
        this.stenValueData = this._getStenValue(pointsData, this._stenData);

        log("people");
        this.stenValuePeople = this._getStenValue(pointsPeople, this._stenPeople);

        log("things");
        this.stenValueThings = this._getStenValue(pointsThings, this._stenThings);

        log("idea");
        this.stenValueIdea = this._getStenValue(pointsIdea, this._stenIdea);

        log("sten data " + this.stenValueData + " people " + this.stenValuePeople + " things " +
                this.stenValueThings + " idee " + this.stenValueIdea);

        this.stenTextData = this._getStenText("DANE", this.stenValueData);
        this.stenTextPeople = this._getStenText("LUDZIE", this.stenValuePeople);
        this.stenTextThings = this._getStenText("RZECZY", this.stenValueThings);
        this.stenTextIdea = this._getStenText("IDEE", this.stenValueIdea);


        this.stenTextDataDesc = this._getStenDescs("dane", this.stenTextData);
        this.stenTextPeopleDesc = this._getStenDescs("ludzie", this.stenTextPeople);
        this.stenTextThingsDesc = this._getStenDescs("rzeczy", this.stenTextThings);
        this.stenTextIdeaDesc = this._getStenDescs("idee", this.stenTextIdea);
    };

    this.getParamForStens = function () {
        var items = [this.stenValueData, this.stenValueIdea,
            this.stenValuePeople, this.stenValueThings
        ];
        items = items.sort(function (a, b) {
            return b - a;
        });

        if (items[0] === items[1]) {
        } else {
            return this._searchStenName(items[0], 1);
        }

        if (items[1] === items[2]) {
            return "all";
        } else {
            return this._searchStenName(items[0], 2);
        }

        return "all";
    };

    this.getImportantStens = function () {
        var stens = [];
        if (this.stenValueData >= 8) {
            stens.push('work_d');
        }
        if (this.stenValuePeople >= 8) {
            stens.push('work_l');
        }
        if (this.stenValueThings >= 8) {
            stens.push('work_r');
        }
        if (this.stenValueIdea >= 8) {
            stens.push('work_i');
        }
        return stens;
    }

    this.getOtherStens = function (stens) {
        log("stens " + stens)
        var names = ['work_i', 'work_d', 'work_l', 'work_r'];
        log("names " + names);
        var other = [];
        for (index in names) {
            var name = names[index];
            if (stens.indexOf(name) != -1) {
                //found
            } else {
                other.push(name);
            }
        }

        return other;
    };

    this._searchStenName = function (value, howMuch) {
        var name = "";
        var smtAppend = false;

        if (value === this.stenValueData) {
            name += "work_d";
            smtAppend = true;
            if (howMuch === 1)
                return name;
        }
        if (value === this.stenValueIdea) {
            if (smtAppend)
                name += ",";
            name += "work_i";
            if (howMuch === 1)
                return name;
            if (howMuch === 2 && smtAppend)
                return name;
            smtAppend = true;
        }
        if (value === this.stenValuePeople) {
            if (smtAppend)
                name += ",";
            name += "work_l";

            if (howMuch === 1)
                return name;
            if (howMuch === 2 && smtAppend)
                return name;
            smtAppend = true;
        }
        if (value === this.stenValueThings) {
            if (smtAppend)
                name += ",";
            name += "work_r";
            if (howMuch === 1)
                return name;
            if (howMuch === 2 && smtAppend)
                return name;
            smtAppend = true;
        }
    };

    this._getStenText = function (name, value) {
        var status = "";
        if (value < 4) {
            status = "niski";
        }
        if (value >= 4 && value < 8) {
            status = "średni";
        }
        if (value >= 8) {
            status = "wysoki";
        }

        return "W wymiarze pracy " + name + " uzyskałeś wynik " + status;
    };

    this._getStenDescs = function (name, stenText) {
        for (index in this._stenValuesDesc) {
            var item = this._stenValuesDesc[index];
            if (item.name == name) {
                if (stenText.indexOf("niski") > 0) {
                    return item.niski;
                } else if (stenText.indexOf("redni") > 0) {
                    return item.sredni;
                } else if (stenText.indexOf("wysoki") > 0) {
                    return item.wysoki;
                }
            }
        }
    }

    /**
     *  Tasuje tablice, powinna byc static ;]
     */
    this._shuffleArray = function (array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    };

    this._getStenValue = function (points, stenValues) {
        var ret = 1;
        var lastKey = 1;
        for (key in stenValues) {
            lastKey = key;
            //log("compare " + points + " tab " + stenValues[key]);
            if (points >= stenValues[key]) {
                ret++;
            } else {
                break;
            }
        }

        if (ret > lastKey) {
            ret = lastKey;
        }

        log("return " + ret);
        return ret;
    };

    this._stenValuesDesc = [
        {
            "name": "dane",
            "wysoki": "Jako osoba wydajesz się preferować aktywność proceduralną, czyli działania według określonych zasad, standardów, norm i przepisów. Dominującym przedmiotem pracy są dla Ciebie informacje, symbole, słowa, kody, cyfry, litery oraz myśli. Preferujesz zadania i czynności związane z syntetyzowaniem informacji, koordynowaniem informacji, analizowaniem informacji, zbieraniem informacji, obliczaniem danych, zestawianiem informacji, porównywaniem informacji.",
            "sredni": "Jako osoba wydajesz się w przeciętnym stopniu, w zależności od sytuacji, preferować aktywność proceduralną, czyli działania według określonych zasad, standardów, norm i przepisów.",
            "niski": "Jako osoba w małym stopniu zdajesz się preferować aktywność proceduralną, czyli działania według określonych zasad, standardów, norm i przepisów. Dominującym przedmiotem pracy nie są dla Ciebie informacje, symbole, słowa, kody, cyfry, litery oraz myśli."
        },
        {
            "name": "idee",
            "wysoki": "Jako osoba wydajesz się preferować aktywność twórczą, czyli działania wymagające inicjatywy, ambicji, chęci odkrywania i tworzenia czegoś nowego, wdrażania idei/pomysłów do praktyki. Dominującym przedmiotem pracy są dla Ciebie pomysły, koncepcje, teorie, wiedza, nowe sposoby myślenia lub robienia czegoś. Preferujesz zadania i czynności związane z tworzeniem, odkrywaniem, integrowaniem: wiedzy, teorii, nowych sposobów myślenia lub robienia czegoś, badaniem otaczającego świata, zajmowaniem się działalnością naukową, zajmowaniem się różnymi formami działalności artystycznej, tworzeniem w różnych obszarach dzieł sztuki, tworzeniem nowych teorii lub weryfikowaniem dostępnej wiedzy na dany temat, inicjowaniem różnych pomysłów i działań, rozwiązywaniem problemów w sposób twórczy i nietypowy.",
            "sredni": "Jako osoba wydajesz się w przeciętnym stopniu, w zależności od sytuacji, preferować aktywność twórczą, czyli działania wymagające inicjatywy, ambicji, chęci odkrywania i tworzenia czegoś nowego, wdrażania idei/pomysłów do praktyki. ",
            "niski": "Jako osoba w małym stopniu zdajesz się preferować aktywność twórczą, czyli działania wymagające inicjatywy, ambicji, chęci odkrywania i tworzenia czegoś nowego, wdrażania idei/pomysłów do praktyki.  Dominującym przedmiotem pracy nie są dla Ciebie pomysły, koncepcje, teorie, wiedza, nowe sposoby myślenia lub robienia czegoś."

        },
        {
            "name": "rzeczy",
            "wysoki": "Jako osoba wydajesz się preferować aktywność fizyczną, czyli działania wymagające wykorzystania oraz posługiwania się narzędziami, urządzeniami, maszynami. Działania te zwykle wymagają siły fizycznej. Dominującym przedmiotem pracy są dla Ciebie materiały, surowce, urządzenia, narzędzia, produkty, istoty żywe (zwierzęta i rośliny). Preferujesz zadania i czynności związane z instalowaniem oraz ustawianiem maszyn i urządzeń, wykonywaniem precyzyjnych operacji z użyciem specjalistycznych przyrządów i narzędzi, kierowaniem i prowadzeniem pojazdów, obsługiwaniem maszyn i urządzeń, manipulowaniem narzędziami oraz przyrządami pomiarowymi, doglądaniem (dozorowaniem) maszyn i urządzeń, przesyłaniem, podawaniem, odbieraniem towarów, przenoszeniem towarów.",
            "sredni": "Jako osoba wydajesz się w przeciętnym stopniu, w zależności od sytuacji, preferować aktywność fizyczną, czyli działania wymagające wykorzystania oraz posługiwania się narzędziami, urządzeniami, maszynami.",
            "niski": "Jako osoba w małym stopniu zdajesz się preferować aktywność fizyczną, czyli działania wymagające wykorzystania oraz posługiwania się narzędziami, urządzeniami, maszynami. Dominującym przedmiotem pracy nie są dla Ciebie materiały, surowce, urządzenia, narzędzia, produkty, istoty żywe (zwierzęta i rośliny)."
        },
        {
            "name": "ludzie",
            "wysoki": "Jako osoba wydajesz się preferować aktywność społeczną, czyli działania zorientowane na pomaganie i świadczenie pomocy innym ludziom, kierowanie i wywieranie wpływu. Dominującym przedmiotem pracy są dla Ciebie inni ludzie. Preferujesz zadania i czynności związane z doradzaniem, negocjowaniem, instruowaniem, kierowaniem i nadzorowaniem, dostarczaniem rozrywki, organizowaniem zabaw, przekonywaniem, udzielaniem informacji, obsługiwaniem ludzi.",
            "sredni": "Jako osoba wydajesz się w przeciętnym stopniu, w zależności od sytuacji, preferować aktywność społeczną, czyli działania zorientowane na pomaganie i świadczenie pomocy innym ludziom, kierowanie i wywieranie wpływu.",
            "niski": "Jako osoba w małym stopniu zdajesz się preferować aktywność społeczną, czyli działania zorientowane na pomaganie i świadczenie pomocy innym ludziom, kierowanie i wywieranie wpływu. Dominującym przedmiotem pracy nie są dla Ciebie inni ludzie."
        }
    ];

};