$(function(){
	try
    {
        ion.sound({
            sounds: [
                { name: "przer4_rozpoczecie_gry", preload: false}, //
                { name: "tylowka_zakonczneie_gry"}, //
                { name: "pr002_rozsypanie_figury"}, //
                { name: "pkl001_przeciaganie_klocka"},
                { name: "pk002_prawidlowy_klocek"}, //
                { name: "nk003_zdarzenie_losowe"}, //
                { name: "bl003_blad"}, //
                { name: "bl004_przegrana"}, //
                { name: "przer1_zdarzenie_losowe"}, //
                { name: "bl002_przeciaganie_klocka"}
            ],
            path: "../../../../../sound/gra/",
            preload: true,
            multiplay: true,
            volume: 0.9,

            scope: this, // optional scope
            ready_callback: function()
            {
                
            }
        });
    }
    catch(err)
    {
        console.log(err);
    }
    
	
	if ($("#dzwiek").attr("status") == "1")
		ion.sound.play('przer4_rozpoczecie_gry');

	var kolejnosc = 0;
	var ilosc_dobrych_klockow = 20;
	var podejscie = 1;
	var ilosc_klockow_by_zakonczyc = 2;
	var bledy = 0;
	var dobrych_w_drugim_podejsciu = 4;
	var wysokosc_w_dol = 260;
	var wysokosc_w_gore = 100;

	$.fn.random = function()
	{
		var ret = $();

		if(this.length > 0)
			ret = ret.add(this[Math.floor((Math.random() * this.length))]);

		return ret;
	};
	
	function enableCursorDragging(element)
	{
		element.addClass("grabbing");
	}
	
	function disableCursorDragging(element)
	{
		element.removeClass("grabbing");
	}
	
	function enableDraggable(element)
	{
		element.draggable("enable");
		element.attr("draggable", "1");
		element.attr("grabable", "1");
	}
	
	function disableDraggable(element)
	{
		disableCursorDragging(element);
		element.attr("draggable", "0");
		element.attr("grabable", "0");
	}
	
	function rand_range(min, max)
	{
		return Math.floor((Math.random() * max) + min);
	}

	$(function(){
		$('.klocek[podejscie="1"]').draggable({
			revert: "invalid",
			start: function( event, ui ) {
				
				$(ui.helper).css("z-index", "1000");
				enableCursorDragging(ui.helper);
			}
		});
		alertify.alert($('#tekst_przed_rozpoczeciem_gry').html());
	});
	
	function wyswietlBlad()
	{
		scrollDoBannera();
		
		bledy++;
		
		$("#gra_opis").addClass("blad");
		$("#gra_opis").removeClass("poprawny");
		$("#gra_opis .gra_tresc").hide();
		$("#gra_opis #blad"+bledy).show({
			effect: "fade",
			duration: 500,
		});		
	}
	
	function wyswietlBladPrzejscie2()
	{
		scrollDoBannera();
		
		$("#gra_opis").addClass("blad");
		$("#gra_opis").removeClass("poprawny");
		$("#gra_opis .gra_tresc").hide();
		$("#gra_opis #blad_podejscie2").show({
			effect: "fade",
			duration: 500,
		});		
	}
	
	function wyswietlPoprawnyRuch1()
	{		
		if (bledy<3)
		{
			$("#gra_opis").addClass("poprawny");
			$("#gra_opis").removeClass("blad");
			$("#gra_opis .gra_tresc").hide();
			
			$('.tresci_komunikatow').hide();		
			$("#gra_opis #poprawny_podejscie1 .tresci_komunikatow").random().show();
			
			$("#gra_opis #poprawny_podejscie1").delay(800).show({
				effect: "fade",
				duration: 500,
			});		
			poprawny_podejscie2_klocek1
		}
	}	
	
	function wyswietlPoprawnyRuch2()
	{
		scrollDoBannera();
		
		$("#gra_opis").addClass("poprawny");
		$("#gra_opis").removeClass("blad");
		$("#gra_opis .gra_tresc").hide();
			
		$('.tresci_komunikatow').hide();		
		$("#gra_opis #poprawny_podejscie2 .tresci_komunikatow").random().show();
			
		$("#gra_opis #poprawny_podejscie2").delay(800).show({
			effect: "fade",
			duration: 500,
		});		
		
		if ($("#dzwiek").attr("status") == "1")
			ion.sound.play("pk002_prawidlowy_klocek"); 
	}
	
	function komunikatWygrales()
	{
		scrollDoBannera();
	
		$("#gra_opis").removeClass("blad");
		$("#gra_opis").removeClass("poprawny");
		$("#gra_opis .gra_tresc").hide();
		$("#gra_opis #poprawny_wygrales").show({
			effect: "fade",
			duration: 500,
		});		
		if ($("#dzwiek").attr("status") == "1")
			ion.sound.play("tylowka_zakonczneie_gry"); 
	}
		
	function komunikatPrzegranej()
	{		
		$("#gra_opis").removeClass("blad");
		$("#gra_opis").removeClass("poprawny");
		
		$('.tresci_komunikatow').hide();		
		$("#gra_opis #loser .tresci_komunikatow").random().show();
		
		$("#gra_opis .gra_tresc").hide();
		$("#gra_opis #loser").show({
			effect: "fade",
			duration: 500,
		});	
		
		if ($("#dzwiek").attr("status") == "1")
			ion.sound.play("bl004_przegrana"); 
	}
	
	function shake(dom, random, complete)
	{
		if (random)
		{
			dom.effect({
				effect: "shake",
				duration: 600+rand_range(-200, 200),
				distance: 15+rand_range(-15, 15),
				times: 3+rand_range(-1, 1),
				complete: complete
			});
		}
		else
		{
			dom.effect({
				effect: "shake",
				duration: 600,
				distance: 15,
				times: 3,
				complete: complete
			});
		}
	}
	
	function scrollDoBannera(complete)
	{
		var body = $("html, body");
		body.delay(1000).animate(
			{
				scrollTop: wysokosc_w_gore
			}, 
			'500', 
			'swing',
			complete
		);
	}
	
	function przywroc_dobre()
	{
		for(var i = 0; i < 2; i++)
		{								
			if (kolejnosc>0)
			{
				klocek_powracany = $('.klocek[podejscie="1"][kolejnosc="'+kolejnosc--+'"]');
				klocek_powracany.attr("kolejnosc", 0);
				klocek_powracany.css("z-index", "1000");
				$("#"+klocek_powracany.attr("wewnatrz")).attr("zawiera", 0);
				klocek_powracany.attr("wewnatrz", "0");
				klocek_powracany.attr("czy_wewnatrz", "0");									
				
				ilosc_dobrych_klockow++;
				
				shake(klocek_powracany, true, function()
				{
					$(this).animate({
						left: $(this).attr("orig-left"),
						top: $(this).attr("orig-top")
					},
					1200+rand_range(-400, 400), 
					"easeOutBack", function()
					{
						$(this).draggable( "enable" );
						$(this).attr("draggable", "1");
						$(this).css("z-index", "1000");
					});
				});
			}
		}
	}
	
	function przegraj()
	{	
		do
		{	
			var klocki = $('.klocek[podejscie="1"][exploded="0"]');
			if (klocki.size()>0)
			{
				var klocek = klocki.delay(100).random();
				
				klocek.attr("exploded", "1");
				klocek.effect({
					effect: "fade",
					duration: 500+rand_range(-200, 200),
				});
			}
			else
			{
				break;
			}
		}
		while(true);
		
		$("#kontener_p1").delay(2000).animate(
			{
				height: 0
			},
			1200, 
			"swing",
			function()
			{
				
			}
		);
		
		$("html, body").animate(
			{
				scrollTop: wysokosc_w_gore
			}, 
			'1500', 
			'swing',
			function()
			{
				komunikatPrzegranej();
			
				do
				{	
					var siatklocki = $('#siatka_p1 .siatklocek[param1="0"]');
					if (siatklocki.size()>0)
					{
						var siatklocek = siatklocki.delay(100).random();
						
						siatklocek.attr("param1", "1");
						siatklocek.css("display", "none");
						siatklocek.css("visibility", "visible");
						siatklocek.show({
							effect: "fade",
							duration: 500+rand_range(-200, 200),
						});
					}
					else
					{
						break;
					}
				}
				while(true);
			}
		);
	}
		
	function bledne_rozegranie(przeciagany)
	{
		if (przeciagany.attr("bledny") && przeciagany.attr("exploded")=="0")
		{						
			przeciagany.attr("exploded", "1");
		
			wyswietlBlad();
			
			if ($("#dzwiek").attr("status") == "1")
				ion.sound.play("bl003_blad"); // blad
		
			shake(przeciagany, false, 0);
			
			przeciagany.effect({
				effect: "explode",
				duration: 600,
				pieces: 16,
				complete: function(){
				
					if (bledy>=3)
					{
						przegraj();
					}
					else
					{
						przywroc_dobre();
					}
				}
			});
		}
	}
	
	function dropEvent(event, ui)
	{
		var przeciagany			= $(ui.draggable);
		var przeciagany_id 		= $(ui.draggable).attr("id");
		var przeciagany_rodzaj 	= $(ui.draggable).attr("rodzaj");
		var przeciagany_rozmiar	= $(ui.draggable).attr("rozmiar");
		var przeciagany_bledny 	= $(ui.draggable).attr("bledny");
		
		disableDraggable(przeciagany);
		przeciagany.draggable( "disable" );
		
		if (przeciagany_bledny)
		{
			przeciagany.addClass( "rodzaj_bledny", 10, "easeOutSine" );
		}
		
		if (ilosc_dobrych_klockow > ilosc_klockow_by_zakonczyc)
		{
			var body = $("html, body");
			body.animate(
				{
					scrollTop: wysokosc_w_dol
				}, 
				'500', 
				'swing',
				function (){
					bledne_rozegranie(przeciagany);
				}
			);
		}
					

		if (!przeciagany_bledny)
		{
			var odbiorca = $('#siatka_p1 .siatklocek[zawiera="0"][rozmiar="'+przeciagany_rozmiar+'"]').random();
			
			if (odbiorca)
			{						
				odbiorca.attr("zawiera", przeciagany_id);	
				przeciagany.attr("wewnatrz", odbiorca.attr("id"));
				przeciagany.attr("czy_wewnatrz", "1");
								
				wyswietlPoprawnyRuch1();
				
				var left = (
					($("#gcg").width()/2) - ($("#siatka_p1").width()/2) + 
					odbiorca.position().left
				);
					
				var top = (
					odbiorca.position().top + 
					$("#pasek").height() +
					$("#kontener_p1").height()
				);
				
				if ($("#dzwiek").attr("status") == "1")
					ion.sound.play("pk002_prawidlowy_klocek"); 
				
				przeciagany.attr("kolejnosc", ++kolejnosc);				
				
				przeciagany.animate(
					{
						left: left,
						top: top
					},
					1500, 
					"easeOutBack", 
					function(){
					
						$(this).css("z-index", "0");
						ilosc_dobrych_klockow--;
						
						if (ilosc_dobrych_klockow <= ilosc_klockow_by_zakonczyc)
						{
							do
							{	
								var klocki = $('.klocek[podejscie="1"][exploded="0"][czy_wewnatrz="1"]');
								if (klocki.size()>0)
								{
									klocek = klocki.delay(80).random();
								
									klocek.toggleClass( "rodzaj_bledny", 10, "easeOutSine" );
								
									shake(klocek, true, 0);
									
									klocek.attr("exploded", "1");
																															
									klocek.effect({
										effect: "explode",
										duration: 600+rand_range(-200, 800),
										pieces: 16,
										complete: function(){
										}
									});
								}
								else
								{
									break;
								}
							}
							while(true);
							
							do
							{	
								var klocki = $('.klocek[podejscie="1"][exploded="0"]');
								if (klocki.size()>0)
								{
									var klocek = klocki.delay(100).random();
									
									klocek.attr("exploded", "1");
									klocek.effect({
										effect: "fade",
										duration: 500+rand_range(-200, 200),
									});
								}
								else
								{
									break;
								}
							}
							while(true);
					
							if ($("#dzwiek").attr("status") == "1")
								ion.sound.play("pr002_rozsypanie_figury");
							
							$("html, body").delay(2000).animate(
								{
									scrollTop: wysokosc_w_gore
								}, 
								'1500', 
								'swing',
								function()
								{
									if (podejscie == 1)
									{
										podejscie = 2;
										ion.sound.play('przer1_zdarzenie_losowe');
									
										$("#gra_opis").delay(800).effect({
											effect:"drop", 
											direction: "left",
											duration: 1200,
											complete: function()
											{
												$(".podejscie_1").hide();
												$("#gra_opis .gra_tresc").hide();
												$("#gra_opis").removeClass("blad");
												$("#gra_opis").removeClass("poprawny");
												$(".podejscie_2").show();
												
												$("#gra_opis").show({
													effect:"drop", 
													direction: "right",
													duration: 1200,
													complete: function()
													{
														
													}
												});
											}
										});
										
										var height = $("#kontener_p1").height() - $("#kontener_p2").attr("orig-height");
										if (height>0)
										{
											height = "-="+height;
										}
										else
										{
											height = "+="+height;
										}
										
										$("#siatka_p1").hide();
										$("#siatka_p2").show();
										
										$("#kontener_p1").delay(800).animate(
											{
												height: height
											},
											1200+rand_range(-400, 400), 
											"easeOutBack", 
											function(){
											
												$("#kontener_p1").hide();
												$('.klocek[podejscie="2"]').hide();
												$("#kontener_p2").show();
												do
												{	
													var klocki = $('.klocek[podejscie="2"][param1="1"]');
													if (klocki.size()>0)
													{
														var klocek = klocki.delay(100).random();
														
														klocek.attr("param1", "0");
														klocek.effect({
															effect: "fade",
															duration: 500+rand_range(-200, 200),
														});
													}
													else
													{
														break;
													}
												}
												while(true);
												
												podejscie2();
											}
										);
									}									
								}
							);
						}
					}
				);
			}
		}
	}
	
	$('#drophandler').droppable({
		accept: '[podejscie="1"][rodzaj]',
		drop: function( event, ui ) {
			dropEvent(event, ui);
		}
    });
	
	function podejscie2()
	{
		$('.klocek[podejscie="2"]').draggable({
			revert: "invalid",
			start: function( event, ui ) {				
				$(ui.helper).css("z-index", "1000");
				enableCursorDragging(ui.helper);
			}
		});
		
		$('#drophandler').droppable({
			accept: '[podejscie="2"][rodzaj]',
			drop: function( event, ui ) {
				dropEventPodejscie2(event, ui);
			}
		});
	}
	
	function dropEventPodejscie2(event, ui)
	{
		var przeciagany			= $(ui.draggable);
		var przeciagany_id 		= $(ui.draggable).attr("id");
		var przeciagany_rodzaj 	= $(ui.draggable).attr("rodzaj");
		var przeciagany_rozmiar	= $(ui.draggable).attr("rozmiar");
		var przeciagany_bledny 	= $(ui.draggable).attr("bledny");
		
		disableDraggable(przeciagany);
		przeciagany.draggable( "disable" );
		
		if (przeciagany_bledny)
		{
			przeciagany.addClass( "rodzaj_bledny", 10, "easeOutSine" );	
		}
		
		var body = $("html, body");
		body.animate(
			{
				scrollTop: wysokosc_w_gore
			}, 
			'500', 
			'swing',
			function()
			{
				if (przeciagany_bledny && przeciagany.attr("exploded")=="0")
				{						
					przeciagany.attr("exploded", "1");
					
					wyswietlBladPrzejscie2();
					
					if ($("#dzwiek").attr("status") == "1")
						ion.sound.play("bl003_blad"); // blad
				
					shake(przeciagany, false, 0);
					
					przeciagany.effect({
						effect: "explode",
						duration: 600,
						pieces: 16,
						complete: function()
						{
							$(this).css("z-index", "0");
						}
					});
				}
			}
		);
		
		if (!przeciagany_bledny)
		{
			var odbiorca = $('#siatka_p2 .siatklocek[zawiera="0"][rozmiar="'+przeciagany_rozmiar+'"]').random();
			
			if (odbiorca.attr("zawiera") == "0")
			{			
				wyswietlPoprawnyRuch2();
			
				odbiorca.attr("zawiera", przeciagany_id);	
				przeciagany.attr("wewnatrz", odbiorca.attr("id"));
				przeciagany.attr("czy_wewnatrz", "1");
				
				var left = (
					($("#gcg").width()/2) - ($("#siatka_p2").width()/2) + 
					odbiorca.position().left
				);
					
				var top = (
					odbiorca.position().top + 
					$("#pasek").height() +
					$("#kontener_p2").height()
				);		
				
				if ($("#dzwiek").attr("status") == "1")
					ion.sound.play("pk002_prawidlowy_klocek"); 

				przeciagany.animate(
					{
						left: left,
						top: top
					},
					1000, 
					"easeOutBack", 
					function(){											
					
						$(this).css("z-index", "0");
						
						dobrych_w_drugim_podejsciu--;
						
						klocki_do_pokazania = $('.ukryty.klocek[odkryty="0"][rodzaj="'+przeciagany_rodzaj+'"]');
						
						klocki_do_pokazania.each(function()
						{
							var rozmiar = $(this).attr("rozmiar");
						
							var odbiorca = $('#siatka_p2 .siatklocek[zawiera="0"][rozmiar="'+rozmiar+'"]').random();
							
							if (odbiorca.attr("zawiera") == "0")
							{
								$(this).css("top", odbiorca.position().top);
								$(this).css("left", odbiorca.position().left);
								$(this).show({
									effect: "fade",
									duration: 500+rand_range(-200, 200),
								});
								$(this).attr("odkryty", 1);
								$(this).css("z-index", "0");
								odbiorca.attr("zawiera", $(this).attr("id"));
								$(this).attr("wewnatrz", odbiorca.attr("id"));
								$(this).attr("czy_wewnatrz", "1");
							}
						});	

						if(dobrych_w_drugim_podejsciu <= 0)
						{									
							disableDraggable($(".klocek"));
							
							var body = $("html, body");
							body.delay(200).animate(
								{
									scrollTop: 100
								}, 
								'500', 
								'swing',
								function()
								{
									do
									{	
										var klocki = $('#kontener_p2 .klocek[czy_wewnatrz="0"][exploded="0"]');
										if (klocki.size()>0)
										{
											var klocek = klocki.delay(40).random();
											
											klocek.attr("czy_wewnatrz", "1");
											klocek.effect({
												effect: "fade",
												duration: 500+rand_range(-200, 200),
											});
										}
										else
										{
											break;
										}
									}
									while(true);
								
									komunikatWygrales();
								}
							);
						}
					}
				);
			}
		}
	}
	
	var body = $("html, body");
	body.delay(1000).animate(
		{
			scrollTop: wysokosc_w_gore
		}, 
		'500', 
		'swing',
		function() {}
	);
});		