module.exports = {
    models: {},
    sequelize: {},
    getGroups: function (user_id, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(groups) {
            endTime = new Date().getTime();
            response.send({groups: groups});
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        sequelize.query('SELECT id, leader_id, group_name, description FROM groups WHERE ' +
            'leader_id = ?', models.Group, {raw: false}, [user_id])
            .success(function(ownGroups){
                sequelize.query('SELECT id, leader_id, group_name, description FROM groups WHERE ' +
                    'id IN (SELECT group_id FROM groups_users WHERE user_id = ?)' +
                    ' AND ' +
                    'id NOT IN (SELECT id FROM groups WHERE leader_id = ?)', models.Group, {raw: false}, [user_id, user_id])
                    .success(function(notOwnGroups) {
                        var groups = ownGroups.concat(notOwnGroups);
                        sendResponse(groups);
                    })
                    .error(function(error) {
                        sendErrorResponse("Error on finding notOwnGroups: "+error);
                    });
            })
            .error(function(error){
                sendErrorResponse("Error on finding ownGroups: "+error);
            });
    },

    createGroup: function (user_id, group_name, description, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        function escapePolishLetters(string) {
            return string.replace("ą", "a")
                .replace("Ą", "A")
                .replace("ę", "e")
                .replace("Ę", "E")
                .replace("ś", "s")
                .replace("Ś", "S")
                .replace("ż", "z")
                .replace("Ż", "Z")
                .replace("ć", "c")
                .replace("Ć", "C")
                .replace("ź", "z")
                .replace("Ź", "Z")
                .replace("ń", "n")
                .replace("Ń", "N")
                .replace("ó", "o")
                .replace("Ó", "O")
                .replace("ł", "l")
                .replace("Ł", "L");
        }

        if(!(group_name) || group_name.length < 1) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.create({group_name: group_name, description: description, join_code: 0, leader_id: user_id, enabled: true})
                .success(function(group){
                    group.join_code = user_id.toString() +
                        escapePolishLetters(group_name.slice(group_name.length-1)).toUpperCase() +
                        Math.random().toString().slice(2, 2 + (6 - user_id.toString().length)) +
                        escapePolishLetters(group_name.slice(0,1)).toUpperCase() +
                        group.id.toString();
                    group.save()
                        .success(function(){
                            models.GroupUser.create({group_id: group.id, user_id: user_id})
                                .success(function(groupuser) {
                                    sendResponse({group_id: group.id, join_code: group.join_code});
                                })
                                .error(function(error) {
                                    sendErrorResponse('Error during assigning leader to group: ' + error);
                                });
                        })
                        .error(function(error){
                            sendErrorResponse('Error during saving group: ' + error);
                        });
                })
                .error(function(error){
                    sendErrorResponse('Error during creating group: ' + error);
                });
        }
    },

    joinGroup: function (user_id, join_code, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(join_code == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.find({where: {join_code: join_code}})
                .success(function(group) {
                    if(group && group.id) {
                        if(group.enabled == false) {
                            sendErrorResponse('This group is closed for new members.');
                        } else {
                            models.GroupUser.find({where: {user_id: user_id, group_id: group.id}})
                                .success(function(groupuser) {
                                    if(groupuser == null) {
                                        models.GroupUser.create({group_id: group.id, user_id: user_id})
                                            .success(function(groupuser) {
                                                sendResponse({success: true});
                                            })
                                            .error(function(error) {
                                                sendErrorResponse('Error on joining to group.');
                                            });
                                    } else {
                                        sendErrorResponse('This user is already in this group.');
                                    }
                                })
                                .error(function(error) {
                                    sendErrorResponse('Error on checking is user already in group.');
                                });
                        }
                    } else{
                        sendErrorResponse('No group with this join_code.');
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error during finding group: ' + error);
                });
        }
    },

    leaveGroup: function (user_id, group_id, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(group_id == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.GroupUser.find({where: {user_id: user_id, group_id: group_id}})
                .success(function(groupuser) {
                    if(groupuser == null) {
                        sendErrorResponse('This user is not in this group.');
                    } else {
                        models.Group.find(group_id)
                            .success(function(group) {
                                if(group && group.id) {
                                    if(group.leader_id == user_id) {
                                        models.GroupUser.findAll({where: {group_id: group_id}})
                                            .success(function(groupsusers) {
                                                if(groupsusers.length > 1) {
                                                    sendErrorResponse('You cannot leave this group - you are a leader and group is not empty.');
                                                } else {
                                                    groupuser.destroy()
                                                        .success(function() {
                                                            group.destroy()
                                                                .success(function() {
                                                                    sendResponse({success: true})
                                                                })
                                                                .error(function(error) {
                                                                    sendErrorResponse('Error during deleting group: ' + error);
                                                                });
                                                        })
                                                        .error(function(error) {
                                                            sendErrorResponse('Error during deleting user membership: ' + error);
                                                        });
                                                }
                                            })
                                            .error(function(error) {

                                            });
                                    } else {
                                        groupuser.destroy()
                                            .success(function() {
                                                sendResponse({success: true})
                                            })
                                            .error(function(error) {
                                                sendErrorResponse('Error during deleting user membership: ' + error);
                                            });
                                    }
                                } else {
                                    models.GroupUser.findAll({where: {group_id: group_id}})
                                        .success(function(groupsusers) {
                                            var deleted = 0;
                                            groupsusers.forEach(function(groupuser) {
                                                groupuser.destroy()
                                                    .success(function() {
                                                        endIteration();
                                                    })
                                                    .error(function(error) {
                                                        endIteration();
                                                    });
                                            });

                                            function endIteration() {
                                                deleted++;
                                                if(deleted >= groupsusers.length) {
                                                    sendErrorResponse('This group does not exist #1. Membership deleted.');
                                                }
                                            }
                                        })
                                        .error(function(error) {
                                            sendErrorResponse('This group does not exist #2.');
                                        });
                                }
                            })
                            .error(function(error) {
                                sendErrorResponse('Error on finding group: ' + error);
                            });
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error on checking is user already in group: ' + error);
                });
        }
    },

    excludeSomeoneFromGroup: function (user_id, user_to_exclude_id, group_id, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(group_id == null || user_to_exclude_id == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.find(group_id)
                .success(function(group) {
                    if(group && group.id) {
                        if(group.leader_id == user_id) {
                            models.GroupUser.find({where: {user_id: user_to_exclude_id, group_id: group_id}})
                                .success(function(groupuser) {
                                    if(groupuser && groupuser.group_id) {
                                        groupuser.destroy()
                                            .success(function() {
                                                sendResponse({success: true});
                                            })
                                            .error(function(error) {
                                                sendErrorResponse('Error during deleting membership of user to exclude: ' + error);
                                            });
                                    } else {
                                        sendErrorResponse('This user is not member of this group.');
                                    }
                                })
                                .error(function(error) {
                                    sendErrorResponse('Error during finding membership of user to exclude: ' + error);
                                });
                        } else {
                            sendErrorResponse('You are not a leader of this group.');
                        }
                    } else {
                        sendErrorResponse('Group doest not exist.');
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error during finding group: ' + error);
                });
        }
    },

    toggleGroupAvailability: function (user_id, group_id, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(group_id == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.find(group_id)
                .success(function(group) {
                    if(group && group.id) {
                        if(group.leader_id == user_id) {
                            group.enabled = !group.enabled;
                            group.save()
                                .success(function() {
                                    sendResponse({success: true, enabled: group.enabled});
                                })
                                .error(function(error) {
                                    sendErrorResponse('Error during saving group: ' + error);
                                });
                        } else {
                            sendErrorResponse('You are not leader of this group.');
                        }
                    } else {
                        sendErrorResponse('Group doest not exist.');
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error during finding group: ' + error);
                });
        }
    },

    getGroupInfo: function (user_id, join_code, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(join_code == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.find({where: {join_code: join_code}})
                .success(function(group) {
                    if(group && group.id) {
                        sendResponse({group_id: group.id, group_name: group.group_name, description: group.description, leader_id: group.leader_id, enabled: group.enabled});
                    } else {
                        sendErrorResponse('Group doest not exist.');
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error during finding group: ' + error);
                });
        }
    },

    includeSomeoneToGroup: function (user_id, user_to_include_id, group_id, response)
    {
        var models = this.models,
            sequelize = this.sequelize,
            beginTime = new Date().getTime(),
            endTime;

        function sendResponse(res) {
            response.send(res);
        }

        function sendErrorResponse(error) {
            endTime = new Date().getTime();
            response.send({error: error});
        }

        if(user_to_include_id == null || group_id == null) {
            sendErrorResponse('Incomplete data.');
        } else {
            models.Group.find(group_id)
                .success(function(group) {
                    if(group && group.id) {
                        if(group.leader_id == user_id) {
                            models.GroupUser.find({where: {user_id: user_to_include_id, group_id: group_id}})
                                .success(function(groupuser) {
                                    if(groupuser && groupuser.group_id) {
                                        sendErrorResponse('This user is already member of this group.');
                                    } else {
                                        models.GroupUser.create({group_id: group_id, user_id: user_to_include_id})
                                            .success(function(groupuser) {
                                                sendResponse({success: true});
                                            })
                                            .error(function(error) {
                                                sendErrorResponse('Error during creating membership of user to include: ' + error);
                                            });
                                    }
                                })
                                .error(function(error) {
                                    sendErrorResponse('Error during checking membership of user to include: ' + error);
                                });
                        } else {
                            sendErrorResponse('You are not leader of this group.');
                        }
                    } else {
                        sendErrorResponse('Group doest not exist.');
                    }
                })
                .error(function(error) {
                    sendErrorResponse('Error during finding group: ' + error);
                });
        }
    }
};