module.exports = {
    mysql: {},
    saveTask: function (data, socket) {
        var task_id,
            mysql = this.mysql,
            queryString = 'SELECT id FROM tasks WHERE '+
                'user_id = (SELECT id FROM users WHERE username = ?) AND '+
                'book_id = (SELECT id FROM books WHERE product_code = ?) AND '+
                'task_in_book_id = ?';

        function emitError(error) {
            socket.emit('savedTask', { data: error });
        }

        function emitSuccess(success) {
            socket.emit('savedTask', { data: success });
        }

        this.mysql.query(queryString, [data.username, data.productcode, data.task_id], function(error, rows, fields){
            if(error) {
                emitError('ERROR: ' + error);
            } else {
                if(rows.length > 0) {
                    task_id = rows[0].id;

                    queryString = 'UPDATE tasks SET state = ?, state_timestamp = NOW() WHERE id = ?';
                    mysql.query(queryString, [data.task_inner, task_id], function(error, rows, fields){
                        if(error)
                        {
                            emitError('ERROR: ' + error);
                        } else {
                            emitSuccess('Successfully updated task!');
                        }
                    });
                } else {
                    queryString = "INSERT INTO tasks (user_id, book_id, task_in_book_id, state, state_timestamp) VALUES" +
                        "((SELECT id FROM users WHERE username = ?), " +
                        "(SELECT id FROM books WHERE product_code = ?), " +
                        "?, " +
                        "?, " +
                        "NOW())";
                    mysql.query(queryString, [data.username, data.productcode, data.task_id, data.task_inner], function(error, rows, fields){
                        if(error)
                        {
                            emitError('ERROR: ' + error);
                        } else {
                            emitSuccess('Successfully saved task!');
                        }
                    });
                }
            }
        });
    }
};