module.exports = {
    models: {},
    sequelize: {},

    beginLog: function(data, response, next)
    {
        var models = this.models,
            parameters = JSON.parse(require('fs').readFileSync(__dirname + '/parameters.json')),
            maxLogNumber = parameters.maxLogsNumber;

            models.Log.findAndCountAll()
            .success(function(logs) {
                if(logs.count >= maxLogNumber) {
                    logs.rows[0].destroy()
                        .success(function() {
                            createLog();
                        })
                        .error(function(error) {
                            console.log('Error during creating logs (begin): ' + error);
                            createLog();
                        })
                } else {
                    createLog();
                }
            })
            .error(function(error) {
                console.log('Error during creating logs (begin): ' + error);
                createLog();
            });

        function createLog() {
            models.Log.create({user_id: data.user_id, method: data.method, request_json: JSON.stringify(data), requested_at: new Date()})
                .success(function(log) {
                    next(log.id, data, response);
                })
                .error(function(error) {
                    console.log('Error during creating logs (begin): ' + error);
                });
        }
    },

    endLog: function(log_id, data, errors)
    {
        var errorsString = '';

        if(errors && errors.length && errors.length > 0) {
            errors.forEach(function(error) {
                errorsString += error + "\n";
            });
        }

        this.models.Log.find(log_id)
            .success(function(log) {
                log.response_json = JSON.stringify(data);
                log.errors = errorsString;
                log.save()
                    .success(function(){
                    })
                    .error(function(error){
                        console.log('Error during creating logs(end): ' + error);
                    });
            })
            .error(function(error) {
                console.log('Error during creating logs(end): ' + error);
            });
    }
};