/**
 * Created by qjon on 08.01.14.
 */
var express = require('express'),
    app = express(),
    http = require('http'),
    ChatRoomManager = require('./models/ChatRoomManager'),
    fs = require('fs'),
    parameters = JSON.parse(fs.readFileSync(__dirname + '/parameters.json')),
    server = http.createServer(app),
    database = require('./database/index'),
    output = require('./models/MyConsole'),
    io = require('socket.io').listen(server),
    colors = require('colors'),
    clients = {},
    clientsByUserId = {},
    clientsLength = 0;

app.use(express.bodyParser());

app.use(function(err, req, res, next){
    sendError(10000, err, res);
});

app.get('/client', function(req, res) {
    res.sendfile(__dirname + '/client/index.html');
});
app.get('/client/app.js', function(req, res) {
    res.sendfile(__dirname + '/client/app.js');
});

ChatRoomManager.database = database;
ChatRoomManager.output = output;

function sendError(errorCode, errorMessageForDatabase, response) {
    var errorMessage = "";
    try {
        errorMessage = errors[errorCode.toString()];
    } catch(e) {
        try {
            errorMessage = errors["default"];
        } catch (e) {
            errorMessage = "General default error message. Missing file with errors.";
        }
    }
    response.errors.push(errorCode + ":"  + errorMessageForDatabase);
    response.send({error: {code: errorCode, message: errorMessage}});
}

io.sockets.on('connection', function (socket) {
    output.success('User connected.');
    var ChatRoom;

    socket.on('connect', function(data){
        ChatRoom = ChatRoomManager.addChatRoom(data['room']);
        ChatRoom.addClient(socket, data['user']);
        socket.join(ChatRoom.id);
        clients[socket.id] = {
            socket: socket,
            ChatRoom: ChatRoom
        }

        io.sockets.in(ChatRoom.id).emit('usersList', ChatRoom.getUsers());

        database.Message.findAll({
            where: {
                group_id: ChatRoom.id
            }
            ,order: 'create_at ASC'
            ,limit: parameters.historyLimit
        }).success(function(rows){
                var history = [];
                rows.forEach(function(Message){
                    history.push({
                        username: Message.get('username')
                        ,message: Message.get('message')
                        ,create_at: Message.get('create_at')
                    })
                })
                socket.emit('historyList', history);
            })
                .error(function(){
                output.error('History not get from databse');
            })
        ;
    });

    socket.on('disconnect', function () {
        if(clients[socket.id] != null)
        {
            clients[socket.id].ChatRoom.removeClient(clients[socket.id].socket);
            delete clients[socket.id];
        }
        output.info('User disconnected.');
    });

    socket.on('sendMsg', function(data) {
        var Message = ChatRoom.addMsg(data['message'], socket.id);
        database.Message.create(Message)
            .success(function(messageData) {
                output.info('Add message ' + Message);

                io.sockets.in(ChatRoom.id).emit('newMessage', Message);
            })
            .error(function(error) {
                output.error('Message not add' + Message);
            })
        ;
    });

});

server.listen(parameters.port, function () {
    output.info('socket.io and server listening at port ' + parameters.port);
    clients = {};
});