﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */

function InitializeStandardTree()
{
	var tree_frame = player.findFrame("tree");
	if (tree_frame && tree_frame.initialize) {
		tree_frame.initialize();
	};
};
//-------------------------------------------------------------------------
function trim(str)
{
	if (typeof(str) != "undefined") {
		return str.replace(/^\s*|\s*$/g, "");
	} else {
		return "";
	};
};
//-------------------------------------------------------------------------
function intToLetter(number)
{
	var result = "";	
	var sLetters = "abcdefghijklmnopqrstuvwxyz".split("");
	var bLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".split("");
	if (number < 10) result = number; else
	if (number < 36) result = sLetters[number-10]; else
	if (number < 62) result = bLetters[number-36];
	
	return result;
};
//-------------------------------------------------------------------------
function letterToInt(letter)
{
	var result = "";	
	var sLetters = "abcdefghijklmnopqrstuvwxyz";
	var bLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	if (parseInt(letter) < 10) result = parseInt(letter); else
	if (sLetters.indexOf(letter) > -1) result = 10 + sLetters.indexOf(letter); else
	if (bLetters.indexOf(letter) > -1) result = 36 + bLetters.indexOf(letter);
	
	return result;
};
//-------------------------------------------------------------------------
function pad (str, max) {
  return str.length < max ? pad("0" + str, max) : str;
};
//-------------------------------------------------------------------------
function isNumeric(v){
    return (v-0)==v&&v.length>0;
};
//-------------------------------------------------------------------------
function compressSuspendData(data) {
	try {
		var result = '';
		if (typeof(data) == 'undefined' || data == '') return result;
		
		var expectedChunksLength = 5;
		var separators = new Array('', 'skip', ',', '', ',');
		
		var chunks = data.split('|');
		if (chunks.length < expectedChunksLength) {
			delete separators;
			return data; //result;
		};
		
		for (var i=0; i<chunks.length; i++) {
			var subChunk = chunks[i];
			var separator = separators[i];
			if (separator == 'skip' || i >= expectedChunksLength) { //pg2-second condition- do not compress another parts, first- perform some tests and/or- write some code
				if (result == '') result = subChunk; else result += '|' + subChunk;
				continue;
			};
			
			var subResult = '';
			var elements = subChunk.split(separator);
			
			var count = 0;
			var element = elements[0];
			var currentElement = '';
			var hasChanged = false;
			for (var j=0; j<elements.length; j++) {
				currentElement = elements[j];
				if (currentElement != element) {
					if (i==4 && element=='' && hasChanged && j<elements.length-1) count++;
					if (subResult == '') {
						if (count > 1) subResult = count + 'x' + element; else subResult = (i==4?'1x':'') + element;
					} else {
						if (count > 1) subResult += ',' + count + 'x' + element; else subResult += ',' + (i==4?'1x':'') + element;
					};
					hasChanged = true;
					element = currentElement;
					count = 1;
					if (j == elements.length-1) {
						if (subResult == '') subResult = '1x' + element; else subResult += ',' + '1x' + element;
					};
				} else {
					count++;
					if (j == elements.length-1) {
						if (subResult == '') {
							if (count > 1) {
								if (element == '' && hasChanged == false) {
									subResult = (count-1) + 'x' + element;
								} else {
									subResult = count + 'x' + element;
								};
							} else {
								subResult = (i==4?'1x':'') + element;
							};
						} else {
							if (count > 1) {
								subResult += ',' + count + 'x' + element;
							} else {
								subResult += ',' + (i==4?'1x':'') + element;
							};
						};
					};
				};
			};
			
			if (result == '') result = subResult; else result += '|' + subResult;
		};
		delete separators;
		if (result.length > data.length) result = data;
		return result;
	} catch(e) {
		return data;
	};
};
//-------------------------------------------------------------------------
function decompressSuspendData(data) {
	try {
		var result = '';
		if (typeof(data) == 'undefined' || data == '') return result;
		
		var expectedChunksLength = 5;
		var separators = new Array('', 'skip', ',', '', ',');
		
		var chunks = data.split('|');
		if (chunks.length < expectedChunksLength) {
			delete separators;
			return data; //result;
		};
		if (chunks[0].indexOf(',') == -1 && chunks[0].indexOf('x') == -1) {
			delete separators;
			return data;
		};
		
		for (var i=0; i<chunks.length; i++) {
			var subChunk = chunks[i];					
			var separator = separators[i];
			if (separator == 'skip' || i >= expectedChunksLength) { //pg2-second condition- do not decompress another parts, first- perform some tests and/or- write some code
				if (result == '') result = subChunk; else result += '|' + subChunk;
				continue;
			};
			var subResult = '';
			if (separator == ',' && i == 4) {
				var elements = subChunk.split(',');
				var prevValue = '';
				for (var j=0; j<elements.length; j++) {
					var element = elements[j];
					var list = element.split('x');
					var number = parseInt(list[0]);
					var value = list[1];
					if (value == '') value = separator;
					
					/* for (var k=0; k<number; k++) {
						if (k==0 && subResult != '' && prevValue != separator) { //pg2-lean_test
							subResult += separator;
							prevValue = separator;
						};
						if (value == separator) {
							subResult += value;
						} else {
							if (number != 1 && k <= number-1) {
								//subResult += ((k>0 || prevValue!=',')?separator:'') + value; //pg2-lean_test -replaced with below one
								subResult += (k>0?separator:'') + value;
							} else {
								subResult += (((k>0 || prevValue!=',') && (j>0))?separator:'') + value;
							}
						};
						prevValue = value;
					}; */
					
					for (var k=0; k<number; k++) {
						if (value == separator) {
							subResult += value;
						} else {
							if (number != 1 && k < number-1) {
								subResult += ((k>0 || prevValue!=',')?separator:'') + value;
							} else {
								subResult += (((k>0 || prevValue!=',') && (j>0))?separator:'') + value;
							}
						};
						prevValue = value;
					};
					
				};
			} else {
				var elements = subChunk.split(',');
				for (var j=0; j<elements.length; j++) {
					var element = elements[j];
					if (element.indexOf('x') > -1) {
						var list = element.split('x');
						var number = parseInt(list[0]);
						var value = list[1];
						for (var k=0; k<number; k++) {
							if (value == '') {
								subResult += separator;
							} else {
								if (subResult == '') subResult = value; else subResult += separator + value;
							};
						};
					} else {
						if (subResult == '') {
							subResult = element;
						} else {
							subResult += separator + element;
						};
					};
				};
			};
			if (result == '') result = subResult; else result += '|' + subResult;
		};
		delete separators;
		return result;
	} catch(e) {
		return data;
	};
};
//-------------------------------------------------------------------------
