﻿/*
 * Copyright (C) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */
 
componentCrossword = function( name )
{
	this.__componentText = __componentText;
	this.__componentText(name);
	
	this.interactions = true;
	this.interactionsType = "fill-in";	
	
	this.wordsLegnthArr = new Array();
	
	this.arrSteps   = new Array();
	this.oldHeight  = null;
	this.timerID    = null;
    this.designMode = 0; 
};

componentCrossword.prototype = new __componentText;
componentCrossword.prototype.type = "componentCrossword";

componentCrossword.prototype.onCreate = function( obj ){

	this.captureMouseEvents();
};

componentCrossword.prototype.onPaint = function(  )
{
    var unEscaped = unescape(this.content);
    var splitContent = unEscaped.split("#@#");
	var words = splitContent[0].split("!#!");
	this.wordsLegnth = words.length-1;
	if (splitContent.length == 2) var quest = splitContent[1].split("!#!");
    
	if (PageInterface.GetValue("state") == psDesigning) this.designMode = 1;
	
	var  t = '';
	t += "<table cellspacing='0' width='100%' dir='"+this.dir+"'><tr><td>";
	t += "<table align='"+this.crossWordAlign+"' border='0' cellspacing='0'>";
	
	for(var i=0; i < words.length-1; i++){
		var word = words[i].split("");
		this.wordsLegnthArr[i] = word.length;
		
		if (this.numbersNextToWordInCrossword){
			//t += "<tr><td align='center' width='20px'>"+parseInt(i+1)+"</td>";
			t += "<tr>";
			t += this.setCrossword(i, word, i);
		}else{
			t += "<tr>";
			t += this.setCrossword(i, word, -1);
		}
        t += "</tr>";
	}
	
	t += "</table></td></tr>";

	if ((this.fontBold) && (splitContent.length == 2)){
        t += "<tr height=\""+this.spaceBetweenCrosswordAndQuestion+"px\"><td></td></tr>";
        
        for(var i=0; i < quest.length-1; i++){
			t += "<tr><td><font size='"+this.font.size+"px' face='" + this.font.family + "'>"+parseInt(i+1)+") "+quest[i]+"</font></td></tr>";
		}
	}
    
	t += "</td></tr></table>";

	this.setHTML(t);	
	
	this.onRepaint();
};

componentCrossword.prototype.onRepaint = function(  )
{

	if (PageInterface.GetValue("allowCAI") && this.showCorrectAnswerIndicator)
	{
        var unEscaped = unescape(this.content);
        var splitContent = unEscaped.split("#@#");
		var words = splitContent[0].split("!#!");
		if (splitContent.length == 2) var quest = splitContent[1].split("!#!");
			
			
		for(var i=0; i < words.length-1; i++){
			if (this.numbersNextToWordInCrossword){
				this.setColoredCrossword(i, words[i]);
			}else{
				this.setColoredCrossword(i, words[i]);
			}
		}
        
		if ((this.fontBold) && (splitContent.length == 2)){
			for(var i=0; i < quest.length-1; i++){
			}
		}
	}
};

componentCrossword.prototype.setColoredCrossword = function(ind, content){

	var word = content.split("");
	var numbered = 0;
    
	for (var j=0; j < word.length; j++){
		if (word[j] != ''){
			if (document.getElementById(this.id+'_'+ind+','+j)){
				
                if (this.caseSensitive){
                    var correct = word[j];
                    var user = document.getElementById(this.id+'_'+ind+','+j).value;
                }else{      
                    var correct = word[j].toLowerCase();
                    var user = document.getElementById(this.id+'_'+ind+','+j).value.toLowerCase();
                }
				var objInput = document.getElementById(this.id+'_'+ind+','+j);
				
				if (correct == user || (correct == '_' && user == '')){
					objInput.style.background = this.cellFillCorrect;
				}else{
					objInput.style.background = this.cellFillIncorrect;
				};
			}
		}
	}
};

componentCrossword.prototype.setCrossword = function(ind, content, number){

	var table = '';
	var isNumbered = false;
	
	for (var j=0; j < content.length; j++){
		var styleContent = '';

		if (j == parseInt(this.answerColl-1)){
			//var color = this.markedColor;
			styleContent += 'border: #000000 2px solid; background-color: '+this.markedColor+'; text-align: center;';
			styleContent += this.styleMarkedCells;
		}else{
			styleContent += 'border: #000000 1px solid; background-color: '+this.inputBgColor+'; text-align: center;';
			styleContent += this.styleRegularCells;			
		};
		
        if (content[j] != ''){
			if (!isNumbered && number != -1 && content[j] != '&' && content[j] != '_'){
				table += "<td align='center' width='20px'><b>"+parseInt(number+1)+"</b></td>";	
				isNumbered = true;
			}else{
				table += "<td ></td>";
			};
			
			if (content[j] == '&'){
				if (!isNumbered && number != -1 && typeof(content[j+1]) != 'undefined' && content[j+1] != '_' && content[j+1] != '&'){
					table += "<td align='center' width='20px'><b>"+parseInt(number+1)+"</b></td>";
					isNumbered = true;
				}else{
					table += "<td></td>"
				}
			}else if (content[j] == '_'){ 
				table += "<td><input style='"+styleContent+"' id=\""+this.id+'_'+ind+','+j+"\" type='text' maxlength='1' value='' size='1'></td>";
			}else if (this.designMode == 1){ 
				table += "<td><input style='"+styleContent+"' id=\""+this.id+'_'+ind+','+j+"\" type='text' maxlength='1' value='"+content[j]+"' size='1'></td>"
			}else{
				table += "<td><input style='"+styleContent+"' id=\""+this.id+'_'+ind+','+j+"\" type='text' maxlength='1' value='' size='1' onKeyUp='owner.eventKeyUp(this.id)'></td>"
			}
		}else{
			table += "<td align='center' width='20px'></td>"
		}
	}

	return table;
};

componentCrossword.prototype.checkUserChar = function(userChar)
{
    var temp = this.allowedChars;
    var userCharLower = userChar.toLowerCase();
	
    if ((temp.indexOf(userCharLower) != -1) && (userChar != '')){
        return true;
    }else{
        return false;
    }
};

componentCrossword.prototype.setFocusOnThisId = function( objID, lastObjID )
{
	if(document.getElementById(this.id+'_'+objID)){
		document.getElementById(this.id+'_'+objID).focus();
		return;
	}else{
		var temp = objID.split(",");	
		var indI = ++temp[0];
		var indJ = -1;
		do{
			indJ++;
			var nextIndex = indI+','+indJ;
		}while(!document.getElementById(this.id+'_'+nextIndex) && indJ < 30)
		
		if (document.getElementById(this.id+'_'+nextIndex)) document.getElementById(this.id+'_'+nextIndex).focus();
			else document.getElementById(this.id+'_'+lastObjID).blur();
	}
}

componentCrossword.prototype.eventKeyUp = function( objID )
{
	objID = objID.replace(this.id+'_', '')
	var temp = objID.split(",");	
	var id = temp[1].split("");	
	
    var user = document.getElementById(this.id+'_'+objID).value;	
	
	switch (id.length){
	case 2 : 
			var index1 = id[0];
			var index2 = id[1];
			var q = parseInt(index2)+1;
			var nextIndex = temp[0] + ',' + index1 + q; 	
            
            if (this.checkUserChar(user))
				this.setFocusOnThisId(nextIndex, objID);
            
			break;				
	default :  
			var index1 = id[0];
			var q = parseInt(index1)+1;
			var nextIndex = temp[0] + ','+ q; 	
			
            if (this.checkUserChar(user))
				this.setFocusOnThisId(nextIndex, objID);	
            
			break;	
	};
};

componentCrossword.prototype.checkAnswer = function()
{
	return this.parseCheckAnswer();
}

componentCrossword.prototype.parseCheckAnswer = function()
{
	var userAnswer = this.getAnswer();
	
	if (this.caseSensitive){
		return (this.correctAnswer == userAnswer);
	}else{      
		return (this.correctAnswer.toLowerCase() == userAnswer.toLowerCase());
	}	
}

componentCrossword.prototype.getAnswer = function()
{
	var userAnswer = '';
	
	for(var i=0; i < this.wordsLegnthArr.length; i++){
		for (var j=0; j < this.wordsLegnthArr[i]; j++){
            if (document.getElementById(this.id+'_'+i+','+j)){
				if (document.getElementById(this.id+'_'+i+','+j).value != '')
					userAnswer += document.getElementById(this.id+'_'+i+','+j).value;
				else userAnswer += ' ';
            };
		};
	};
	
	return userAnswer;
};

componentCrossword.prototype.setAnswer = function(valStr, showCorrect)
{
	if ((typeof(valStr) == 'undefined' || valStr == '') && !showCorrect) return;
	if (valStr == '' && (typeof(showCorrect) == 'undefined' || showCorrect == '')) showCorrect = true;
	
	if (valStr != '' && !showCorrect){
	//user
		var userArr = valStr.split('');
		var index = 0;
		for(var i=0; i < this.wordsLegnthArr.length; i++){
			for (var j=0; j < this.wordsLegnthArr[i]; j++){
	            if (document.getElementById(this.id+'_'+i+','+j)){
					if (typeof(userArr[index]) != 'undefined') 
						document.getElementById(this.id+'_'+i+','+j).value = userArr[index];
					else	document.getElementById(this.id+'_'+i+','+j).value = '';
					index++;
	            };
			};
		};
	}else{
	//correct
		var userArr = this.correctAnswer.split('');
		var index = 0;
		for(var i=0; i < this.wordsLegnthArr.length; i++){
			for (var j=0; j < this.wordsLegnthArr[i]; j++){
	            if (document.getElementById(this.id+'_'+i+','+j)){
					if (typeof(userArr[index]) != 'undefined') document.getElementById(this.id+'_'+i+','+j).value = userArr[index];
					index++;
	            };
			};
		};
	}
};

componentCrossword.prototype.onLock = function() 
{
	for(var i=0; i < this.wordsLegnthArr.length; i++){
		for (var j=0; j < this.wordsLegnthArr[i]; j++){
            if (document.getElementById(this.id+'_'+i+','+j)){
				document.getElementById(this.id+'_'+i+','+j).readOnly = true;
            };
		};
	}
};

componentCrossword.prototype.onUnLock = function() 
{
	for(var i=0; i < this.wordsLegnthArr.length; i++){
		for (var j=0; j < this.wordsLegnthArr[i]; j++){
            if (document.getElementById(this.id+'_'+i+','+j)){
				document.getElementById(this.id+'_'+i+','+j).readOnly = false;
            };
		};
	}
};

componentCrossword.prototype.onFree = function(){

	if (this.timerID != null) 
		window.clearTimeout(this.timerID);
}

componentCrossword.prototype.interactionsCorrectResponsesCount = function()
{
	var answerCount = 1;
	return answerCount;
};

componentCrossword.prototype.interactionsCorrectResponsesAsText = function()
{
	var answerCount = 1;
	return answerCount;
};

componentCrossword.prototype.interactionsCorrectResponses = function()
{
	return this.correctAnswer;
};

componentCrossword.prototype.interactionsStudentResponseAsText = function()
{
	return this.getAnswer();
}

componentCrossword.prototype.interactionsStudentResponse = function()
{
	return this.getAnswer();
};

componentCrossword.prototype.componentCrosswordBaseUnselectable = componentCrossword.prototype.unselectable;
componentCrossword.prototype.unselectable = function()
{
	this.componentCrosswordBaseUnselectable();
	for(var i=0; i < this.wordsLegnthArr.length; i++){
		for (var j=0; j < this.wordsLegnthArr[i]; j++){
            if (document.getElementById(this.id+'_'+i+','+j)){
				document.getElementById(this.id+'_'+i+','+j).unselectable = "";
            };
		};
	}
};
