var t_id;

function WalkNode(){
	this.nextNode = [None,None,None,None];
	this.correct = [false,false,false,false];
	this.label['Wrong','Wrong','Wrong','Wrong'];
}

var _div_game;
var _div_panel;
var _button_up;
var _button_down;
var _button_left;
var _button_right;
var _button_look;
var _button_wait;
var _guide;
var _next_text;
var _tips;
var _boy;
var _buddy;
var _girl;
var _biker;
var _bush;
var _lights;
var _sign;
var _state;
var _anim_on;
var _instructions = [];
var _next_sound;

function createRoad(){
	var container = document.createElement('div');
	container.setAttribute('id', t_id);
	
		_div_game = document.createElement('div');
		_div_game.setAttribute('class', 'game');
		
			_lights = document.createElement('div');
			_lights.setAttribute('class','lights_red');
			_div_game.appendChild(_lights);
			
			_buddy = document.createElement('div');
			_buddy.setAttribute('class','buddy');
			_div_game.appendChild(_buddy);
			
			_girl = document.createElement('div');
			_girl.setAttribute('class','girl');
			
			_girl.addEventListener('animationend', function() {
				girlAnimEnd(this);
			}, false);

			_girl.addEventListener('webkitAnimationEnd', function() {
				girlAnimEnd(this);
			}, false);
			
			_div_game.appendChild(_girl);
		
			_biker = document.createElement('div');
			_biker.setAttribute('class','biker_0');
			_div_game.appendChild(_biker);
			
			_sign = document.createElement('div');
			_sign.setAttribute('class','sign');
			_div_game.appendChild(_sign);
			
			_bush = document.createElement('div');
			_bush.setAttribute('class','bush_0');
			_div_game.appendChild(_bush);
			
			_boy = document.createElement('div');
			_boy.setAttribute('class', 'boy_0');
			
			_boy.addEventListener('animationend', function() {
				animEndListener(this);
			}, false);

			_boy.addEventListener('webkitAnimationEnd', function() {
				animEndListener(this);
			}, false);
			
			_boy.addEventListener('animationstart', function() {
				animStartListener(this);
			}, false);

			_boy.addEventListener('webkitAnimationStart', function() {
				animStartListener(this);
			}, false);
			
			_div_game.appendChild(_boy);
							
		container.appendChild(_div_game);
	
		_div_panel = document.createElement('div');
		_div_panel.setAttribute('class', 'panel');
		_div_panel.setAttribute('style','background-image: url(./resources/road_resources/panel.png); position:absolute; background-size: 100% 100%; top: 75%; height: 25%; width: 100%; border: 0px;');
		
			_button_up = document.createElement('div');
			_button_up.setAttribute('onclick', 'clickListener(this)');
			_button_up.onclick = function() {
				clickUp(this);
			};
			_div_panel.appendChild(_button_up);
			
			_button_down = document.createElement('div');
			_button_down.setAttribute('onclick', 'clickListener(this)');
			_button_down.onclick = function() {
				clickDown(this);
			};
			_div_panel.appendChild(_button_down);
			
			_button_left = document.createElement('div');
			_button_left.setAttribute('onclick', 'clickListener(this)');
			_button_left.onclick = function() {
				clickLeft(this);
			};
			_div_panel.appendChild(_button_left);
			
			_button_right = document.createElement('div');
			_button_right.setAttribute('onclick', 'clickListener(this)');
			_button_right.onclick = function() {
				clickRight(this);
			};
			_div_panel.appendChild(_button_right);
			
			_button_look = document.createElement('div');
			_button_look.setAttribute('class','button_look');
			_button_look.setAttribute('onclick', 'clickListener(this)');
			_button_look.onclick = function() {
				clickLook(this);
			};
			_div_panel.appendChild(_button_look);
			
			_button_wait = document.createElement('div');
			_button_wait.setAttribute('class','button_wait');
			_button_wait.setAttribute('onclick', 'clickListener(this)');
			_button_wait.onclick = function() {
				clickWait(this);
			};
			_div_panel.appendChild(_button_wait);
			
			_guide = document.createElement('div');
			_guide.setAttribute('style','background-image: url(./resources/road_resources/guide.png); position:absolute; background-size: 100% 100%; left: 82%; top: -40%; height: 140%; width: 20%; border: 0px;');
			_div_panel.appendChild(_guide);
		
			_tips = document.createElement('div');
			_tips.setAttribute('class','tips');
			_div_panel.appendChild(_tips);
			
		container.appendChild(_div_panel);
		
	document.body.appendChild(container);
	
	_instructions.push(new Audio("./resources/road_resources/sounds/1.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/2.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/3.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/4.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/5.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/6.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/7.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/8.mp3"));
	_instructions.push(new Audio("./resources/road_resources/sounds/9.mp3"));
	
	_state = 0;
	_tips.innerHTML = "Twoim zadaniem jest bezpieczne przejście.";
	deactivateButton('left');
	deactivateButton('up');
	activateButton('right');
	activateButton('down');
	playSound(0);
	_anim_on = false;
}

function playSound(index)
{
	_instructions[index].play();
}

function deactivateButton(side)
{
	switch(side)
	{
		case 'right':
			_button_right.setAttribute('class','arrow_right_off');
		break;
		
		case 'left':
			_button_left.setAttribute('class','arrow_left_off');
		break;
		
		case 'up':
			_button_up.setAttribute('class','arrow_up_off');
		break;
	
		case 'down':
			_button_down.setAttribute('class','arrow_down_off');
		break;
		
		case 'wait':
			_button_wait.setAttribute('class','button_wait_off');
		break;
		
		case 'look':
			_button_look.setAttribute('class','button_look_off');
		break;		
	}
}

function activateButton(side)
{
	switch(side)
	{
		case 'right':
			_button_right.setAttribute('class','arrow_right');
		break;
		
		case 'left':
			_button_left.setAttribute('class','arrow_left');
		break;
		
		case 'up':
			_button_up.setAttribute('class','arrow_up');
		break;
	
		case 'down':
			_button_down.setAttribute('class','arrow_down');
		break;
		
		case 'wait':
			_button_wait.setAttribute('class','button_wait');
		break;
		
		case 'look':
			_button_look.setAttribute('class','button_look');
		break;
	}
}

function clickLeft(element){

}

function clickRight(element){
	if(!_anim_on)
	{
		switch(_state)
		{
			case 0:
				_boy.setAttribute('class', 'boy_1');
				_state = 1;
				activateButton('right');
				deactivateButton('left');
				deactivateButton('up');
				activateButton('down');
				_next_text = "Przeprowadź kolegów bezpiecznie na drugą stronę ulicy.";
				_next_sound = 1;
			break;
			
			case 3:	
				_boy.setAttribute('class', 'boy_3');
				_buddy.setAttribute('class', 'buddy_2');
				_girl.setAttribute('class', 'girl_2');			
				_state = 4;
				activateButton('right');
				activateButton('left');
				activateButton('up');
				deactivateButton('down');
				_next_text = "Przejdź prawidłowo przez ulicę w miejscu oznaczonym sygnalizatorem świetlnym.";
				_next_sound = null;
			break;
			
			case 4:	
				_tips.innerHTML = "Stój! Czerwone!";
			break;
			
			case 5:	
				_tips.innerHTML = "Pamiętaj by się rozejrzeć!";
				playSound(2);
			break;
			
			case 6:	
				_boy.setAttribute('class', 'boy_4');	
				_state = 7;
				activateButton('right');
				activateButton('left');
				activateButton('up');
				deactivateButton('down');
			break;
			
			case 8:	
				_tips.innerHTML = "Uważaj na jadący rower!";
				playSound(5);
			break;
			
			case 9:	
				_tips.innerHTML = "Pamiętaj by się rozejrzeć!";
				playSound(2);
			break;
			
			case 10:	
				_boy.setAttribute('class', 'boy_6');
				_state = 11;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
				_next_text = "Przejdź bezpiecznie przez przejazd kolejowy, zastosuj się do znaku drogowego.";
				playSound(7);
				_next_sound = 8;
			break;
			
			case 11:	
				_tips.innerHTML = "Pamiętaj by się rozejrzeć!";
				playSound(2);
			break;
			
			case 12:	
				_boy.setAttribute('class', 'boy_7');
				_state = 13;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
			break;
		}
	}
}

function clickUp(element){
}

function clickDown(element){
	if(!_anim_on)
	{
		switch(_state)
		{
			case 0:
				_tips.innerHTML = "Idź do przejścia!";
			break;
			
			case 1:
				_tips.innerHTML = "Pamiętaj by się rozejrzeć!";
				playSound(2);
			break;
			
			case 2:
				_boy.setAttribute('class', 'boy_2');
				_buddy.setAttribute('class', 'buddy_1');
				_girl.setAttribute('class', 'girl_1');
				_boy.setAttribute('class', 'boy_2');
				_state = 3;
				activateButton('right');
				activateButton('left');
				activateButton('up');
				deactivateButton('down');
				_next_text = "Przejdź prawidłowo przez ulicę w miejscu oznaczonym sygnalizatorem świetlnym.";
				_next_sound = 3;
			break;	
		}
	}
}

function clickWait(element){
	if(!_anim_on)
	{
		switch(_state)
		{
			case 4:	
				_lights.setAttribute('class','lights_green');
				_state = 5;
				activateButton('right');
				activateButton('left');
				activateButton('up');
				deactivateButton('down');
				_tips.innerHTML = "Zielone! Rozejrzyj się zanim wejdziesz na jezdnię!";
				_next_sound = null;
			break;
			
			case 8:	
				_biker.setAttribute('class','biker_2');
				_state = 9;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
				_tips.innerHTML = "Pamiętaj by się rozejrzeć!";
				_next_sound = null;
			break;
		}
	}
}

function clickLook(element){
	if(!_anim_on)
	{
		switch(_state)
		{
			case 1:
				_boy.setAttribute('class', 'boy_1w');
				_state = 2;
				deactivateButton('right');
				deactivateButton('left');
				deactivateButton('up');
				activateButton('down');
				_next_text = "Teraz możesz iść.";
				_next_sound = null;
			break;
			
			case 5:
				_boy.setAttribute('class', 'boy_3w');
				_state = 6;
				activateButton('right');
				activateButton('left');
				activateButton('up');
				deactivateButton('down');
				_next_text = "Teraz możesz iść.";
				_next_sound = null;
			break;
			
			case 7:	
				_boy.setAttribute('class', 'boy_5');
				_div_game.setAttribute('class', 'game_2');
				_lights.setAttribute('class','lights_away');
				_sign.setAttribute('class','sign_away');
				_biker.setAttribute('class','biker_1');
				_bush.setAttribute('class','bush_1');
				_state = 8;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
				_next_text = "Rowerzysta ma pierwszeństwo!";
				_next_sound = null;
			break;
			
			case 9:	
				_boy.setAttribute('class', 'boy_5w');
				_state = 10;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
				_next_text = "Możesz iść!";
				_next_sound = null;
			break;
			
			case 11:	
				_boy.setAttribute('class', 'boy_6w');
				_state = 12;
				activateButton('right');
				activateButton('left');
				deactivateButton('up');
				deactivateButton('down');
				_next_text = "Nic nie jedzie, droga wolna!";
				_next_sound = null;
			break;
		}
	}
}

function animEndListener()
{
	_anim_on = false;
	activateButton('right');
	activateButton('left');
	activateButton('up');
	activateButton('down');
	activateButton('wait');
	activateButton('look');
	_tips.innerHTML = _next_text;
	if(_next_sound) playSound(_next_sound);
	
	if(_state==7)
	{
		_boy.setAttribute('class', 'boy_5');
		_div_game.setAttribute('class', 'game_2');
		_lights.setAttribute('class','lights_away');
		_sign.setAttribute('class','sign_away');
		_biker.setAttribute('class','biker_1');
		_bush.setAttribute('class','bush_1');
		_state = 8;
		activateButton('right');
		activateButton('left');
		deactivateButton('up');
		deactivateButton('down');
		_next_text = "Pomyśl kto ma pierwszeństwo.";
		playSound(4);
		_next_sound = 6;
	}
	else if(_state==13)
	{
		_boy.setAttribute('class', 'boy_8');
		_div_game.setAttribute('class', 'game_3');
		_lights.setAttribute('class','lights_away_2');
		_sign.setAttribute('class','sign_away_2');
		_state = 14;
		activateButton('right');
		activateButton('left');
		deactivateButton('up');
		deactivateButton('down');
		_next_text = "Brawo! Dotarłes bezpiecznie do domu. Pamiętaj czego się nauczyłeś!";
	}
}

function animStartListener()
{
	_anim_on = true;
	deactivateButton('right');
	deactivateButton('left');
	deactivateButton('up');
	deactivateButton('down');
	deactivateButton('wait');
	deactivateButton('look');
	_tips.innerHTML = '';
}

function girlAnimEnd()
{
	if(_girl.getAttribute('class')=='girl_2')
		_girl.setAttribute('class', 'girl_3');	
}

function startRoad(){
	 var frame = document.createElement('iframe');
	 var div = document.createElement('div');
	 
	 div.setAttribute('style','position: absolute; top: 50%; margin-top: -215px; left: 50%; margin-left: -384px');
	 
	 frame.width = '768px';
	 frame.height = '430px';
	 frame.setAttribute('align','middle');
	 frame.setAttribute('scrolling', 'no');
	 frame.setAttribute('marginwidth', '0');
	 frame.setAttribute('marginheight', '0');
	 frame.setAttribute('style','border-style: solid; border-width 8px; border-color: white;');
	 frame.src = 'src/road.html';
	 
	 div.appendChild(frame);
	 document.body.appendChild(div);	 
}
