var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var ReturnState = (function (_super) {
        __extends(ReturnState, _super);
        function ReturnState() {
            _super.call(this);
            this.cloudList = [];
            this.movingElementsArray = [];
            this.isHelpShown = false;
            this.firstRun = true;
        }
        ReturnState.prototype.create = function () {
            _super.prototype.create.call(this);
            this.game.world.sort();
            var bg = this.game.add.image(0, 0, "_bg1");
            this.movingElementsArray.push(bg);
            var town_bg = this.game.add.image(0, 177, "rakieta");
            this.movingElementsArray.push(town_bg);
            this.player = this.game.add.sprite(261, 761, "_gracz");
            var przewodnik = this.game.add.image(0, 911, "_town_bg2");
            this.movingElementsArray.push(przewodnik);
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showWin();
        };
        ReturnState.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");
            this.load.image("_bg1", "Graphics/game/intro/ZIP_g_I_11_bg1.jpg");
            this.load.image("rakieta", "Graphics/game/intro/ZIP_g_I_11_bg1_rakieta.png");
            this.load.image("_town_bg2", "Graphics/game/intro/ZIP_g_I_11_bg1_przod.png");
            this.load.spritesheet("_gracz", "Graphics/game/intro/ZIP_g_I_11_gracz.png", 228 / 2, 210, 2);
            this.applause = new Audio("./Sounds/ZIP_g_I_11_7.mp3");
        };
        ReturnState.prototype.cloudsMover = function () {
            for (var i = 0; i < this.cloudList.length; i++) {
                var tween = this.game.add.tween(this.cloudList[i]);
                var currentposition = this.cloudList[i].x;
                var destination = currentposition - 4500;
                tween.to({ x: destination }, 5500, Phaser.Easing.Linear.None, true, 0, -1);
                tween.start();
            }
        };
        ReturnState.prototype.showWin = function () {
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Udało Ci się wylądować na Ziemi. Gratulacje!");
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 4, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.game.state.start("TitleScreenState");
						location.reload();
                    }
                    catch (e) {
                    }
                }, this);
            }, this);
            tw.start();
            try {
                //this.applause.currentTime = 0;
                this.applause.play();
            }
            catch (e) {
            }
        };
        return ReturnState;
    })(BasicModule.BasicState);
    MainGame.ReturnState = ReturnState;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=ReturnState.js.map