﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentDictionaryTree = function(name)
{
	this.componentSimplePopup = componentSimplePopup;
	this.componentSimplePopup(name);

	this.selected = -1;
	this.filter = "";
	this.scrollable = true;
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;

	this.cssTextOut = "";
	this.cssTextOver = "";
	this.closeButtonOffsetTop = 0;
	this.closeButtonOffsetRight = 0;
	this.headerTextOffsetTop = 0;
	this.headerTextOffsetLeft = 0;
	this.headerTextOffsetRight = 0;
	this.textAreaOffsetTop = 0;
	this.textAreaOffsetDown = 0;
	this.textAreaOffsetLeft = 0;
	this.textAreaOffsetRight = 0;
};

componentDictionaryTree.prototype = new componentSimplePopup;
componentDictionaryTree.prototype.type = "componentDictionaryTree";

componentDictionaryTree.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL; else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [ this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();	 
	this.setCompleteArrayInfo(this.completeInfoStyleImages);

	this.captureMouseEvents();
};

componentDictionaryTree.prototype.onCreate = function(obj)
{
	if (dictionary.items.length > 0) {
		this.selected = 0;
	};

	var ff = this.getProperty(this.treeCSSStyle, "fontFamily", "Arial");
	var fs = this.getProperty(this.treeCSSStyle, "fontSize", "2");
	var fc = this.getProperty(this.treeCSSStyle, "fontColor", "#000000");
	var fw = this.getProperty(this.treeCSSStyle, "fontWeight", "bold");
	var td = this.getProperty(this.treeCSSStyle, "textDecoration", "none");
	this.cssTextOut = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';

	var ff = this.getProperty(this.treeCSSStyleHover, "fontFamily", "Arial");
	var fs = this.getProperty(this.treeCSSStyleHover, "fontSize", "2");
	var fc = this.getProperty(this.treeCSSStyleHover, "fontColor", "#000000");
	var fw = this.getProperty(this.treeCSSStyleHover, "fontWeight", "bold");
	var td = this.getProperty(this.treeCSSStyleHover, "textDecoration", "none");
	this.cssTextOver = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';
};

componentDictionaryTree.prototype.componentDictionaryTreeOnBaseOnPaint = componentDictionaryTree.prototype.onPaint;
componentDictionaryTree.prototype.onPaint = function(obj)
{
	this.generateOutline();
	this.doClick(null);
	this.componentDictionaryTreeOnBaseOnPaint();
	this.setScroll();
};

componentDictionaryTree.prototype.getProperty = function(propStr, propName, propDef)
{
	var result = propDef;
	var propArr = propStr.split(";");
	for (var i=0; i<propArr.length; i++) {
		var pArr = propArr[i].split(":");
		if (trim(pArr[0]) == propName) {
			result = trim(pArr[1]);
			break;
		};
	};
	return result;
};

componentDictionaryTree.prototype.getItemOffsettop = function()
{
	var obj = document.getElementById(this.id+"a"+this.selected);
	var curtop = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		};
	} else
	if (obj.y) {
		curtop += obj.y;
	};
	return curtop-this.y;
}

componentDictionaryTree.prototype.onAfterLoad = function()
{
	this.setScroll();
};

componentDictionaryTree.prototype.setScroll = function()
{
	this.getTextHeight();
	this.setHTMLObiects();
	this.moveDivToItem();

	if (this.buttonsActive) this.moveSliderToItem();
};

componentDictionaryTree.prototype.moveDivToItem = function()
{
	var dictionaryTreeDIV = document.getElementById(this.id + "_tableDiv");
	if (dictionaryTreeDIV) dictionaryTreeDIV.scrollTop = 0;
};

componentDictionaryTree.prototype.moveSliderToItem = function()
{
	var	tableDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");
	var scrollPos = 0;
	var offsettop = 0;

	if (this.selected != 0){
		offsettop = this.getItemOffsettop();
	};
	tableDiv.scrollTop = offsettop;

	var maxScrollHeight = tableDiv.scrollHeight - this.h + this.headerHeight + 2*this.contentPadding + 2*this.textSpacing + this.footerHeight + this.checkboxesFieldH;
	maxScrollHeight = (maxScrollHeight == 0)?1:maxScrollHeight;
	var percScrollPos = (tableDiv.scrollTop/maxScrollHeight);

	scrollPos = this.sliderLowOffset + this.trackHeight*percScrollPos - this.getImageHeight('sliderOut')*percScrollPos;
	trackDiv.style.top = scrollPos;
};

componentDictionaryTree.prototype.reinit = function(obj)
{
	this.generateOutline();
	this.runPNGFix();
	this.selected = this.getFirstItemID();
	if (this.selected != -1) this.doClick(null);
	this.setScroll();
};

componentDictionaryTree.prototype.getFirstItemID = function()
{
	var i = 0;
	while (!document.getElementById(this.id + "a" + i)) i++;
	return i;
};

componentDictionaryTree.prototype.generateOutline = function()
{
	var outline = '<table>';
	if (dictionary.items.length == 0) {
			outline += '<tr><td valign="top" style="padding-top: 3px">';
			outline += '<img id="' + this.id + 'img' + i + '" src="' + this.resourcesURL + this.treeIMG + '" width="' + this.treeIMGWidth + '" height="' + this.treeIMGHeight + '" border="0"/>';
			outline += '</td><td>';
			outline += '<a id="' + this.id + 'a' + i + '" href="javascript:void(0);" onmouseover="pc.'+this.id+'.doOver(this);" onmouseout="pc.'+this.id+'.doOut(this);" style="' + this.cssTextOut + '" >'+this.noticeInfo+'</a></br>';
			outline += '</td></tr>';
	} else {
		for (var i=0; i<dictionary.items.length; i++) {
			if (!dictionary.items[i].visible) continue;
			outline += '<tr><td valign="top" style="padding-top: 3px">';
			outline += '<img id="' + this.id + 'img' + i + '" src="' + this.resourcesURL + this.treeIMG + '" width="' + this.treeIMGWidth + '" height="' + this.treeIMGHeight + '" border="0"/>';
			outline += '</td><td>';
			outline += '<a id="' + this.id + 'a' + i + '" href="javascript:void(0);" onmouseover="pc.'+this.id+'.doOver(this);" onmouseout="pc.'+this.id+'.doOut(this);" style="' + this.cssTextOut + '" title="' + unescape(dictionary.items[i].key) + '" onclick="pc.'+this.id+'.doClick(this);">' + unescape(dictionary.items[i].key) + "</a></br>";
			outline += '</td></tr>';
		};
	};
	outline += '</table>';
	var content = this.findContentObj();
	content.innerHTML = outline;
	//this.setHTML(outline);
};

componentDictionaryTree.prototype.doOver = function(obj)
{
	var no = obj.id.replace(this.id + "a", "");
	if (this.selected != no){
		var img = document.getElementById(this.id + "img" + no);
		this.setImageSrc(this.resourcesURL + this.treeIMGOver, img);
	};
	obj.style.cssText = this.cssTextOver;
};

componentDictionaryTree.prototype.doOut = function(obj)
{
	var no = obj.id.replace(this.id + "a", "");
	var img = document.getElementById(this.id + "img" + no);
	if (no != this.selected) {
		this.setImageSrc(this.resourcesURL + this.treeIMG, img);
	};
	obj.style.cssText = this.cssTextOut;
};

componentDictionaryTree.prototype.doClick = function(obj)
{
	var fVis = -1;
	for (var i=0; i<dictionary.items.length; i++) {
		if (!dictionary.items[i].visible) continue;
		if (fVis == -1) fVis = i;
		var img = document.getElementById(this.id + "img" + i);
		this.setImageSrc(this.resourcesURL + this.treeIMG, img);
	};
	if (obj == null) {
		obj = document.getElementById(this.id + "a" + fVis);
	};
	if (obj == null) {
		var dict_content_comp = page.getElementsType("componentDictionaryContent");
		for (var i=0; i<dict_content_comp.length; i++) {
			var comp = dict_content_comp[i];
			comp.reFillComponent(null);
		};
		var dict_links_comp = page.getElementsType("componentDictionaryLinks");
		for (var i=0; i<dict_links_comp.length; i++) {
			var comp = dict_links_comp[i];
			comp.generateOutline(null);
		};
	} else {
		var no = obj.id.replace(this.id + "a", "");
		var img = document.getElementById(this.id + "img" + no);
		this.setImageSrc(this.resourcesURL + this.treeIMGSelected, img);
		this.selected = no;
		var dict_content_comp = page.getElementsType("componentDictionaryContent");
		for (var i=0; i<dict_content_comp.length; i++) {
			var comp = dict_content_comp[i];
			comp.reFillComponent(dictionary.items[this.selected]);
		};
		var dict_links_comp = page.getElementsType("componentDictionaryLinks");
		for (var i=0; i<dict_links_comp.length; i++) {
			var comp = dict_links_comp[i];
			comp.generateOutline(dictionary.items[this.selected]);
		};
	};
};

componentDictionaryTree.prototype.setFilter = function(value)
{
	dictionary.setFilter(value);
};

componentDictionaryTree.prototype.setKey = function(value)
{
	for (var i=0; i<dictionary.items.length; i++) {
		if (!dictionary.items[i].visible || dictionary.items[i].key != value) continue;
		var obj = document.getElementById(this.id + "a" + i);
		this.doClick(obj);
		this.obj.scrollTop = obj.offsetParent.offsetTop;
		break;
	}
};

componentDictionaryTree = function(name)
{
	this.componentSimplePopup = componentSimplePopup;
	this.componentSimplePopup(name);

	this.selected = -1;
	this.filter = "";
	this.scrollable = true;
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;

	this.cssTextOut = "";
	this.cssTextOver = "";
	this.closeButtonOffsetTop = 0;
	this.closeButtonOffsetRight = 0;
	this.headerTextOffsetTop = 0;
	this.headerTextOffsetLeft = 0;
	this.headerTextOffsetRight = 0;
	this.textAreaOffsetTop = 0;
	this.textAreaOffsetDown = 0;
	this.textAreaOffsetLeft = 0;
	this.textAreaOffsetRight = 0;
};

componentDictionaryTree.prototype = new componentSimplePopup;
componentDictionaryTree.prototype.type = "componentDictionaryTree";

componentDictionaryTree.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [ this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();	 
	this.setCompleteArrayInfo(this.completeInfoStyleImages);

	this.captureMouseEvents();
};

componentDictionaryTree.prototype.onCreate = function(obj)
{
	if (dictionary.items.length > 0) {
		this.selected = 0;
	};

	var ff = this.getProperty(this.treeCSSStyle, "fontFamily", "Arial");
	var fs = this.getProperty(this.treeCSSStyle, "fontSize", "2");
	var fc = this.getProperty(this.treeCSSStyle, "fontColor", "#000000");
	var fw = this.getProperty(this.treeCSSStyle, "fontWeight", "bold");
	var td = this.getProperty(this.treeCSSStyle, "textDecoration", "none");
	this.cssTextOut = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';

	var ff = this.getProperty(this.treeCSSStyleHover, "fontFamily", "Arial");
	var fs = this.getProperty(this.treeCSSStyleHover, "fontSize", "2");
	var fc = this.getProperty(this.treeCSSStyleHover, "fontColor", "#000000");
	var fw = this.getProperty(this.treeCSSStyleHover, "fontWeight", "bold");
	var td = this.getProperty(this.treeCSSStyleHover, "textDecoration", "none");
	this.cssTextOver = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';
};

componentDictionaryTree.prototype.componentDictionaryTreeOnBaseOnPaint = componentDictionaryTree.prototype.onPaint;
componentDictionaryTree.prototype.onPaint = function(obj)
{
	this.generateOutline();
	this.doClick(null);
	this.componentDictionaryTreeOnBaseOnPaint();
	this.setScroll();
};

componentDictionaryTree.prototype.getProperty = function(propStr, propName, propDef)
{
	var result = propDef;
	var propArr = propStr.split(";");
	for (var i=0; i<propArr.length; i++) {
		var pArr = propArr[i].split(":");
		if (trim(pArr[0]) == propName) {
			result = trim(pArr[1]);
			break;
		};
	};
	return result;
};

componentDictionaryTree.prototype.getItemOffsettop = function()
{
	var obj = document.getElementById(this.id+"a"+this.selected);
	var curtop = 0;
	if (obj.offsetParent) {
		while (obj.offsetParent) {
			curtop += obj.offsetTop
			obj = obj.offsetParent;
		};
	} else
	if (obj.y) {
		curtop += obj.y;
	};
	return curtop-this.y;
};

componentDictionaryTree.prototype.onAfterLoad = function()
{
	this.setScroll();
};

componentDictionaryTree.prototype.setScroll = function()
{
	this.getTextHeight();
	this.setHTMLObiects();
	this.moveDivToItem();
	if (this.buttonsActive) this.moveSliderToItem();
};

componentDictionaryTree.prototype.moveDivToItem = function()
{
	var dictionaryTreeDIV = document.getElementById(this.id + "_tableDiv");
	if (dictionaryTreeDIV) dictionaryTreeDIV.scrollTop = 0;
};

componentDictionaryTree.prototype.moveSliderToItem = function()
{
	var	tableDiv = document.getElementById(this.id + "_tableDiv");
	var	trackDiv = document.getElementById(this.id + "_trackDiv");
	var scrollPos = 0;
	var offsettop = 0;

	if (this.selected != 0){
		offsettop = this.getItemOffsettop();
	};
	tableDiv.scrollTop = offsettop;

	var maxScrollHeight = tableDiv.scrollHeight - this.h + this.headerHeight + 2*this.contentPadding + 2*this.textSpacing + this.footerHeight + this.checkboxesFieldH;
	maxScrollHeight = (maxScrollHeight == 0)?1:maxScrollHeight;
	var percScrollPos = (tableDiv.scrollTop/maxScrollHeight);

	scrollPos = this.sliderLowOffset + this.trackHeight*percScrollPos - this.getImageHeight('sliderOut')*percScrollPos;
	trackDiv.style.top = scrollPos;
};

componentDictionaryTree.prototype.reinit = function(obj)
{
	this.generateOutline();
	this.runPNGFix();
	this.selected = this.getFirstItemID();
	if (this.selected != -1) this.doClick(null);
	this.setScroll();
};

componentDictionaryTree.prototype.getFirstItemID = function()
{
	var i = 0;
	while (!document.getElementById(this.id + "a" + i)) i++;
	return i;
};

componentDictionaryTree.prototype.generateOutline = function()
{
	var outline = '<table>';
	if (dictionary.items.length == 0) {
		outline += '<tr><td valign="top" style="padding-top: 3px">';
		outline += '<img id="' + this.id + 'img' + i + '" src="' + this.resourcesURL + this.treeIMG + '" width="' + this.treeIMGWidth + '" height="' + this.treeIMGHeight + '" border="0"/>';
		outline += '</td><td>';
		outline += '<a id="' + this.id + 'a' + i + '" href="javascript:void(0);" onmouseover="pc.'+this.id+'.doOver(this);" onmouseout="pc.'+this.id+'.doOut(this);" style="' + 
					this.cssTextOut + '" >'+this.noticeInfo+'</a></br>';
		outline += '</td></tr>';
	} else {
		for (var i=0; i<dictionary.items.length; i++) {
			if (!dictionary.items[i].visible) continue;
			outline += '<tr><td valign="top" style="padding-top: 3px">';
			outline += '<img id="' + this.id + 'img' + i + '" src="' + this.resourcesURL + this.treeIMG + '" width="' + this.treeIMGWidth + '" height="' + this.treeIMGHeight + '" border="0"/>';
			outline += '</td><td>';
			outline += '<a id="' + this.id + 'a' + i + '" href="javascript:void(0);" onmouseover="pc.'+this.id+'.doOver(this);" onmouseout="pc.'+this.id+'.doOut(this);" style="' +
						this.cssTextOut + '" title="' + unescape(dictionary.items[i].key) + '" onclick="pc.'+this.id+'.doClick(this);">' + unescape(dictionary.items[i].key) + "</a></br>";
			outline += '</td></tr>';
		};
	};
	outline += '</table>';
	var content = this.findContentObj();
	content.innerHTML = outline;
	//this.setHTML(outline);
};

componentDictionaryTree.prototype.doOver = function(obj)
{
	var no = obj.id.replace(this.id + "a", "");

	if (this.selected != no) {
		var img = document.getElementById(this.id + "img" + no);
		this.setImageSrc(this.resourcesURL + this.treeIMGOver, img);
	};
	obj.style.cssText = this.cssTextOver;
};

componentDictionaryTree.prototype.doOut = function(obj)
{
	var no = obj.id.replace(this.id + "a", "");
	var img = document.getElementById(this.id + "img" + no);
	if (no != this.selected) {
		this.setImageSrc(this.resourcesURL + this.treeIMG, img);
	};
	obj.style.cssText = this.cssTextOut;
};

componentDictionaryTree.prototype.doClick = function(obj)
{
	var fVis = -1;
	for (var i=0; i<dictionary.items.length; i++) {
		if (!dictionary.items[i].visible) continue;
		if (fVis == -1) fVis = i;
		var img = document.getElementById(this.id + "img" + i);
		this.setImageSrc(this.resourcesURL + this.treeIMG, img);
	};
	if (obj == null) {
		obj = document.getElementById(this.id + "a" + fVis);
	};
	if (obj == null) {
		var dict_content_comp = page.getElementsType("componentDictionaryContent");
		for (var i=0; i<dict_content_comp.length; i++) {
			var comp = dict_content_comp[i];
			comp.reFillComponent(null);
		};
		var dict_links_comp = page.getElementsType("componentDictionaryLinks");
		for (var i=0; i<dict_links_comp.length; i++) {
			var comp = dict_links_comp[i];
			comp.generateOutline(null);
		};
	} else {
		var no = obj.id.replace(this.id + "a", "");
		var img = document.getElementById(this.id + "img" + no);
		this.setImageSrc(this.resourcesURL + this.treeIMGSelected, img);
		this.selected = no;
		var dict_content_comp = page.getElementsType("componentDictionaryContent");
		for (var i=0; i<dict_content_comp.length; i++) {
			var comp = dict_content_comp[i];
			comp.reFillComponent(dictionary.items[this.selected]);
		};
		var dict_links_comp = page.getElementsType("componentDictionaryLinks");
		for (var i=0; i<dict_links_comp.length; i++) {
			var comp = dict_links_comp[i];
			comp.generateOutline(dictionary.items[this.selected]);
		};
	};
};

componentDictionaryTree.prototype.setFilter = function(value)
{
	dictionary.setFilter(value);
};

componentDictionaryTree.prototype.setKey = function(value)
{
	for (var i=0; i<dictionary.items.length; i++) {
		if (!dictionary.items[i].visible || dictionary.items[i].key != value) continue;
		var obj = document.getElementById(this.id + "a" + i);
		this.doClick(obj);
		this.obj.scrollTop = obj.offsetParent.offsetTop;
		break;
	};
};
