﻿module MainGame {
    export class IntroState extends BasicModule.BasicState {
        game: Phaser.Game;
        //titleScreenImage: Phaser.Sprite;
        cloudList: Array<any> = [];
        player: any;
        button_play: any;
        movingElementsArray: Array<any> = [];

        cloud: Phaser.Image;
        cloudText: Phaser.Text;
        isHelpShown: boolean = false;
        guide: Phaser.Group;
        instruction: any;
        applause: any;
        firstRun: boolean = true;

        constructor() {
            super();
        }

        create() {
            super.create();

            // this.game.add.image(452, 158, "box");
            // var spons = this.game.add.image(0, this.game.height * 0.83, "sponsors");
            // var guide = this.game.add.image(1366, 347, "introGuide");
            // var play = this.game.add.button(488, 630, "play", this.playDown, this, 1, 0, 2, 1);
            this.game.world.sort();

            var bg = this.game.add.image(0, 0, "_bg1");
            this.movingElementsArray.push(bg);

            //for (var i = 1; i < 4; i++) {
            //    var cloud = this.game.add.image((Math.random()*1)*4000, 0 + (30 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);
            //    var cloud = this.game.add.image((Math.random() * 10) * 4000 , 0 + (40 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);
            //    var cloud = this.game.add.image((Math.random() * 10) * 1900, 0 + (15 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);

            //}
            
           // this.cloudsMover()

            var town_bg = this.game.add.image(0, 177, "rakieta");
            this.movingElementsArray.push(town_bg);
            var town_fg = this.game.add.image(2130,279, "_town_fg");
            this.movingElementsArray.push(town_fg);
            this.player = this.game.add.sprite(261, 761, "_gracz");
            var przewodnik = this.game.add.image(0, 911, "_town_bg2");
            this.movingElementsArray.push(przewodnik);
           

            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "Wybierz ubrania właściwe na deszcz i zimno.", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
            // this.createOutfitHelp();
            //this.buttonPressed(this);
            this.guide.y = this.game.world.height;
            this.showHelp();
        }

        preload() {
            super.preload();
            
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");

            this.load.image("_bg1", "Graphics/game/intro/ZIP_g_I_12_bg1.jpg");
            //this.load.image("_cloud1", "Graphics/game/intro/ZIP_g_I_4_c1.png");
            //this.load.image("_cloud2", "Graphics/game/intro/ZIP_g_I_4_c2.png");
            //this.load.image("_cloud3", "Graphics/game/intro/ZIP_g_I_4_c3.png");
            
            this.load.image("rakieta", "Graphics/game/intro/ZIP_g_I_12_bg1_rakieta.png");
            this.load.image("_town_bg2", "Graphics/game/intro/ZIP_g_I_12_bg1_przod.png");
            this.load.image("_town_fg", "Graphics/game/intro/ZIP_g_I_12_bg1_brama.png");
           // this.load.image("_przewodnik_bg", "Graphics/game/intro/ZIP_g_I_7_bg_tv.png");
            //this.load.image("_button", "Graphics/game/intro/ZIP_g_I_4_button.png");
            this.load.spritesheet("_button", "Graphics/game/intro/ZIP_g_I_4_button.png", 250, 62, 2);
            //this.load.spritesheet("_gracz2", "Graphics/game/intro/ZIP_g_I_6_gracz.png", 342 / 3, 210, 3);
            this.load.spritesheet("_gracz", "Graphics/game/intro/ZIP_g_I_8_gracz.png", 228 / 2, 210, 2);

            this.instruction = new Audio("./Sounds/ZIP_g_I_12_1.mp3");
            this.applause = new Audio("./Sounds/ZIP_g_I_12_2.mp3");
        }
        cloudsMover()
        {
            
            for (var i = 0; i < this.cloudList.length; i++) {
                
                var tween = this.game.add.tween(this.cloudList[i]);
                var currentposition = this.cloudList[i].x;
                var destination = currentposition - 4500 ;
                tween.to({ x: destination }, 5500,Phaser.Easing.Linear.None, true, 0, -1);
                tween.start();
            }

        }
        buttonPressed(play, pointer)
        {
           // console.log("asd");
            this.button_play.visible = false;
            this.button_play.intractable = false;
            for (var i = 0; i < this.movingElementsArray.length; i++) {
                var tween = this.game.add.tween(this.movingElementsArray[i]);
                var currentposition = this.movingElementsArray[i].x;
                var destination = currentposition - 1000;
                tween.to({ x: destination }, 6000);
                tween.start();
            }
            var pltween = this.game.add.tween(this.player)
            pltween.to({ x: 1300}, 6000);
            pltween.start();
            pltween.onComplete.addOnce(this.playDown, this);

                
        }
        playDown() 
        {
            this.showWin()
            //this.game.state.start("Fill");
        }
        changeHelp() {
            this.showHelp();
            //this.helpBtn.inputEnabled = true;
            this.cloudText.y = this.cloud.height * 0.4;
            // //this.tipsBtn = this.game.add.button(this.cloud.width / 2, this.cloud.height * 0.7, "tips", this.showOutfits, this, 0, 0, 1, 0);
            // //this.tipsBtn.anchor.setTo(0.5, 0.5);
            // this.cloud.addChild(//this.tipsBtn);
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
        }
        showWin() {
            
            //if (this.tableOutfits.length == 0) this.tableOutfits = [1, 2];
            //if (this.tipsBtn != undefined)
            //this.tipsBtn.visible = false;
            //this.ggCount++;
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Przed wyjściem z parku musisz kupić bilet.");
            //if (this.halp != undefined)
            //    this.halp.visible = false;
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 4, function () {
                    try {
                        this.applause.pause();
                        // this.applause.currentTime = 0;
                        //console.log("ZMAINA LEVELU");
                        //ZMIANA PLANSZY
                        this.game.state.start("Fill");
                        // this.game.state.start(IntermissionState);
                        // this.reload(); 
                        //this.replay();
                    } catch (e) { }
                }, this);
            }, this);
            tw.start();


            try {
                // this.applause.currentTime = 0;
                this.applause.play();
            } catch (e) { }
        }
        showHelp() {

            var tw = null;
            this.cloudText.setText("Witaj z powrotem na Ziemi. By dojść do szkoły musisz wyjść z parku.");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;

            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    // this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        //this.helpBtn.inputEnabled = false;
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.changeHelp, this);
                    }
                } catch (e) { }
            } else {
                try {
                    this.instruction.pause();
                    // this.instruction.currentTime = 0;
                } catch (e) { }
            }

            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
            //this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
        }

    }
}