var Game;
(function (Game) {
    var Dressup = (function () {
        function Dressup() {
            this.game = new Phaser.Game(1920, 1080, Phaser.CANVAS, 'content', { create: this.start, preload: this.preload });
        }
        Dressup.prototype.start = function () {
            this.game.state.add("TitleScreenState", TitleScreen.TitleScreenState, true);
            this.game.state.add("MainGameState", MainGame.MainGameState, false);
            this.game.state.add("IntroState", MainGame.IntroState, false);
            this.game.state.add("IntermissionState", MainGame.IntermissionState, false);
            this.game.state.add("Fill", MainGame.Fill, false);
            this.game.state.add("Fill2", MainGame.Fill2, false);
            this.game.stage.disableVisibilityChange = true;
            this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            this.game.scale.pageAlignHorizontally = true;
            this.game.scale.pageAlignVertically = true;
            this.game.scale.windowConstraints.bottom = true;
            this.game.scale.refresh();
        };
        Dressup.prototype.preload = function () {
        };
        return Dressup;
    })();
    Game.Dressup = Dressup;
})(Game || (Game = {}));
window.onload = function () {
    var game = new Game.Dressup();
};
//# sourceMappingURL=app.js.map