﻿module MainGame {
    export class Fill5 extends BasicModule.BasicState {
        connectElementCount: number;
        GameData: any;
        HorizontalPlacementArray: Array<number> = [];
        VerticalPlacementArray: Array<number> = [];
        tst2: any;
        text: Phaser.Text;
        item: any;
        box: any;
        public keyboard: any;
        isGrid: Boolean = false;
        StartingPosX: number = 0;
        StartingPosY: number = 0;
        Columns: number = 0;
        Rows: number = 0;
        Spacing: number = 0;
        initializationKeys: string = "";
        maxCharacters: number = 0;
        FillList: Array<any> = [];
        fontSize;
        FFonetimer = true;


        public inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };

        constructor() {
            super();
        }

        preload() {
            console.log("preload");
            super.preload();
            // this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            // this.loadSpritesheet();
            this.game.load.start();

        }
        public killKeyborad() {
            if (this.keyboard != undefined) {

                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        }
        create() {
            super.create();
            //}
            console.log("create");

            this.loadInit();
            // this.keyboardInit();
            // this.createAdditionalElements();
            this.createStaticElements();
            this.createControllElement();
            // 
               
            this.createActiveElments();




        }
        loadInit() {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
            // //EU.Log("isGrid?" + this.isGrid);
        }
        loadGraphics() {

            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        }
        loadSpritesheet() {
            for (var i = 0; i < this.GameData.Spritesheet.length; i++)
                this.game.load.spritesheet(this.GameData.Spritesheet[i].key, this.GameData.Spritesheet[i].src, this.GameData.Spritesheet[i].size.x, this.GameData.Spritesheet[i].size.y, this.GameData.Spritesheet[i].size.no);
        }

        createControllElement() {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;

                for (var i = 0; i < this.GameData.StaticElements.length; i++) {

                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                        //el.anchor.set(0.5, 0.5);
                        el.scale.setTo(0.8, 0.8);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                        //this.addChild(el);
                    }
                    if (this.GameData.StaticElements[i].HasText) {

                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        //this.addChild(el_text);
                    
                        // this.createActiveTextElment(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].id);
                       
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                        //this.addChild(el_text);
                    }
                }
            } else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                    // el.anchor.set(0.5);
                    //this.addChild(el);
                }
            }
        }
        createAdditionalElements() {
            for (var i = 0; i < this.GameData.AditionalElements.length; i++) {
                var el = this.game.add.image(this.GameData.AditionalElements[i].pos.x, this.GameData.AditionalElements[i].pos.y, this.GameData.AditionalElements[i].key);
                // el.anchor.set(0.5);
                //this.addChild(el);
            }
        }

        createStaticElements() {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.GameData.Controlls[0].Size + "pt Arial";
            for (var i = 0; i < this.GameData.Controlls.length; i++) {

                //var currWidth = this.StartingPosX;
                // if (this.GameData.StaticElements[i].HasImage) {
                var el = this.game.add.image(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[i].pos.y, this.GameData.Controlls[i].key);
                if (!this.GameData.Controlls[i].HasText) {
                    el.tint = 0x000000;
                    el.alpha = 0.6;
                }
                //el.anchor.set(0.5, 0.5);
                // el.scale.setTo(0.5, 0.5);
                //currWidth += el.width;
                // currHeight += el.height;
                // this.HorizontalPlacementArray.push(this.GameData.Controlls[i].pos.x+el.width);
                // this.VerticalPlacementArray.push(this.GameData.Controlls[i].pos.y+el.height/2);
                //this.addChild(el);
                // }
                //if (this.GameData.StaticElements[i].HasText) {

                //    var el_text = this.game.add.text(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[i].pos.y, this.GameData.Controlls[i].prefix, this.inputBoxStyle);
                //    el_text.anchor.set(0, 0.5);
                //this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                //this.addChild(el_text);
                    
                // this.createActiveTextElment(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].id);
                       
                // el_text = this.game.add.text(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[]i.pos.y,, this.GameData.Controlls[i].sufix, this.inputBoxStyle);
                // el_text.anchor.set(0, 0.5);
                // currWidth += el_text.width;
                // this.VerticalPlacementArray.push(currHeight + (100 * i));
                //this.addChild(el_text);

            }
            // }
           
           
        }

        createActiveElments() {

            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);

            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();

            //var currHeight = this.StartingPosY;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {

                //this.box = this.game.add.sprite(this.HorizontalPlacementArray[i], this.VerticalPlacementArray[i], bmd);
                //else
                this.box = this.game.add.sprite(this.GameData.TaskList[i].pos.x, this.GameData.TaskList[i].pos.y, bmd);

                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                //this.box.height = 100;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                // this.box.width = this.item.width + 50;
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
                //this.addChild(this.item);
                this.box.text = this.item;
                this.item.answer = this.GameData.TaskList[i].Answer;
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                //this.addChild(this.box);
                this.FillList.push(this.item);
            }


        }

        keyboardInit() {
            // super.nextTask();
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                //EU.Log(this.keyboard);
                this.keyboard.initialize(this.initializationKeys, "key", "key");
            }
            else {
                this.keyboard.initialize("qwertyuiop" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^&", "key", "key");
            }
            //}
                
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
            ////this.addChild(this.keyboard);          
            // lis.add(this.checkComplition);
        }
        showKeyboard(button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            ////EU.Log(button.width);
            // this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
            // //EU.Log(this.keyboard.input.text);
            // //EU.Log("test");
            //  console.log;
            // this.ShowKeyboard = true;
        }
        public checkComplition() {


            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                console.log(this.FillList[i].text + " == " + this.GameData.TaskList[i].Answer.toUpperCase());
                if (this.FillList[i].text.toUpperCase() == this.GameData.TaskList[i].Answer.toUpperCase()) {
                    // TotalAnswers++;
                    GoodAnswers++;
                }
                else {
                    if (this.FillList[i].text.toUpperCase() != "?")
                        //TotalAnswers++;
                        BadAnswers++;
                }

            }
            if (TotalAnswers == GoodAnswers) {
                this.game.state.start("Fill6");
                //console.log("All Good!");
                //EU.setGameCompletion(this.parent, 1);
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                //EU.Log(complition + " + " + tmpCheck + " = " + (tmpCheck + complition));
                if (tmpCheck + complition != 1) {
                    //EU.Log("zaznacz wszystkie ocje");
                }
                else {
                    //EU.setGameCompletion(this.parent, 0);
                }

            }
            this.killKeyborad()
        }
        update() {
            
            //   this.tst2.text.slice(-1);
        }
        init(json) {
            //super.init(json);
            //ladowanie danych wejsciowych
            // //EU.Log(json);
            this.GameData = {
                "Title": "",
                "Sound": "ZIP_spr_I_8_7.mp3",
                "MaxCharacters": 10,
                "AcceptedCharacters": "",
                "isGrid": true,
                "StartingPos": { "x": 400, "y": 400 },
                "Columns": 5,
                "Rows": 2,
                "Spacing": 1,
                "CustomFontSize": 32,

                "Graphics":
                [
                    //    { "src": "Graphics/game/ZIP_g_I_7_image.png", "key": "ZIP_g_I_7_image" },
                    { "src": "Graphics/game/ZIP_g_I_7_ramka.png", "key": "ZIP_g_I_7_ramka" },
                    { "src": "Graphics/game/0.png", "key": "00" },
                    { "src": "Graphics/game/1.png", "key": "01" },
                    { "src": "Graphics/game/2.png", "key": "02" },
                    { "src": "Graphics/game/3.png", "key": "03" },
                    { "src": "Graphics/game/4.png", "key": "04" },
                    { "src": "Graphics/game/5.png", "key": "05" },
                    { "src": "Graphics/game/7.png", "key": "07" },
                    { "src": "Graphics/game/8.png", "key": "08" },
                    { "src": "Graphics/game/6.png", "key": "06" },
                    { "src": "Graphics/game/ZIP_g_I_10_slonce.png", "key": "0" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta1.png", "key": "1" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta2.png", "key": "2" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta3.png", "key": "3" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta4.png", "key": "4" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta5.png", "key": "5" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta6.png", "key": "6" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta7.png", "key": "7" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta8.png", "key": "8" },


                ],
                "Spritesheet":
                [
                    //   { "src": "Graphics/game/ZIP_g_I_6_next.png", "key": "ZIP_g_I_6_next", "size": { "x": 120, "y": 120, "no": 2 } },
                ],
                "Controlls":
                [
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "0", "pos": { "x": 0, "y": 156 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "1", "pos": { "x": 336, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "2", "pos": { "x": 457, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "3", "pos": { "x": 636, "y": 395 } },
                    { "HasText": true, "HasImage": true, "Size": "40", "id": 999, "key": "4", "pos": { "x": 803, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "5", "pos": { "x": 941, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "6", "pos": { "x": 1187, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "7", "pos": { "x": 1508, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "8", "pos": { "x": 1721, "y": 395 } },
                ],
                "AditionalElements":
                [

                    { "key": "ZIP_g_I_7_ramka", "pos": { "x": 150, "y": 65 } },
                    //    { "key": "ZIP_g_I_7_image", "pos": { "x": 200, "y": 120 } },
                ],
                "StaticElements":
                [
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 1, "key": "04", "pos": { "x": 1150, "y": 780 } },
                    //{ "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 2, "key": "02", "pos": { "x": 500, "y": 490 } },
                    //{ "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 3, "key": "03", "pos": { "x": 500, "y": 570 } },
                    //{ "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 4, "key": "04", "pos": { "x": 500, "y": 700 } },
                    // { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 5, "key": "05", "pos": { "x": 500, "y": 790 } },
                ],
                "TaskList":
                [
                    { "pos": { "x": 1000, "y": 800 }, "Answer": "Mars", "id": 1 },
                    //{ "pos": { "x": 1400, "y": 530 }, "Answer": "p", "id": 2 },
                    //{ "pos": { "x": 1400, "y": 630 }, "Answer": "p", "id": 3 },
                    //{ "pos": { "x": 1400, "y": 730 }, "Answer": "p", "id": 4 },
                    //{ "pos": { "x": 1400, "y": 850 }, "Answer": "p", "id": 4 },
                ]
            };
            
            //this.elementArr.push({ "Title": "1. Wpisz odpowiednia literkę 'w' lub 'f' w wyrazach.", "Sound": "MW_kp_I_1_0.mp3","maxcharacters": "1", });
            //  this.connectElementCount = 8;
            
            //1. Wpisz odpowiednia literkę 'w' lub 'f' w wyrazach.
            //dzwięk: MW_kp_I_1_0.mp3

            //foka f
            //flaga f
            //waga w
            //futro f
            //kowal w
            //kawa w
            //worek w
            //kilof f
        }

    }

}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    JSON = {
//              completeText: "caly tekst do wyswietlenia",
//              searched: [["znak lub wyraz", (true/false || true szuka znaku lub wyrazu oddzielonego spacjami, kropka, myslnikiem lub cudzyslowiem; false szuka podciągu)], [], []]    
//           }
 