var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var Fill8 = (function (_super) {
        __extends(Fill8, _super);
        function Fill8() {
            _super.call(this);
            this.HorizontalPlacementArray = [];
            this.VerticalPlacementArray = [];
            this.isGrid = false;
            this.StartingPosX = 0;
            this.StartingPosY = 0;
            this.Columns = 0;
            this.Rows = 0;
            this.Spacing = 0;
            this.initializationKeys = "";
            this.maxCharacters = 0;
            this.FillList = [];
            this.FFonetimer = true;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
        }
        Fill8.prototype.preload = function () {
            console.log("preload");
            _super.prototype.preload.call(this);
            this.loadGraphics();
            this.game.load.start();
			this.instruction = new Audio("./Sounds/ZIP_g_I_10_13.mp3");
        };
        Fill8.prototype.killKeyborad = function () {
            if (this.keyboard != undefined) {
                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        };
        Fill8.prototype.create = function () {
            _super.prototype.create.call(this);
            console.log("create");
            this.loadInit();
            this.createStaticElements();
            this.createControllElement();
            this.createActiveElments();
			this.instruction.play();
        };
        Fill8.prototype.loadInit = function () {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
        };
        Fill8.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        Fill8.prototype.loadSpritesheet = function () {
            for (var i = 0; i < this.GameData.Spritesheet.length; i++)
                this.game.load.spritesheet(this.GameData.Spritesheet[i].key, this.GameData.Spritesheet[i].src, this.GameData.Spritesheet[i].size.x, this.GameData.Spritesheet[i].size.y, this.GameData.Spritesheet[i].size.no);
        };
        Fill8.prototype.createControllElement = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                        el.scale.setTo(0.8, 0.8);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                    }
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                }
            }
        };
        Fill8.prototype.createAdditionalElements = function () {
            for (var i = 0; i < this.GameData.AditionalElements.length; i++) {
                var el = this.game.add.image(this.GameData.AditionalElements[i].pos.x, this.GameData.AditionalElements[i].pos.y, this.GameData.AditionalElements[i].key);
            }
        };
        Fill8.prototype.createStaticElements = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.GameData.Controlls[0].Size + "pt Arial";
            for (var i = 0; i < this.GameData.Controlls.length; i++) {
                var el = this.game.add.image(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[i].pos.y, this.GameData.Controlls[i].key);
                if (!this.GameData.Controlls[i].HasText) {
                    el.tint = 0x000000;
                    el.alpha = 0.6;
                }
            }
        };
        Fill8.prototype.createActiveElments = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                this.box = this.game.add.sprite(this.GameData.TaskList[i].pos.x, this.GameData.TaskList[i].pos.y, bmd);
                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
                this.box.text = this.item;
                this.item.answer = this.GameData.TaskList[i].Answer;
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                this.FillList.push(this.item);
            }
        };
        Fill8.prototype.keyboardInit = function () {
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                this.keyboard.initialize(this.initializationKeys, "key", "key");
            }
            else {
                this.keyboard.initialize("QWERTYUIOP" + this.keyboard.arrSeparator + "ASDFGHJKL" + this.keyboard.arrSeparator + "ZXCVBNM&", "key", "key");
            }
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
        };
        Fill8.prototype.showKeyboard = function (button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
        };
        Fill8.prototype.checkComplition = function () {
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                console.log(this.FillList[i].text + " == " + this.GameData.TaskList[i].Answer.toUpperCase());
                if (this.FillList[i].text.toUpperCase() == this.GameData.TaskList[i].Answer.toUpperCase()) {
                    GoodAnswers++;
                }
                else {
                    if (this.FillList[i].text.toUpperCase() != "?")
                        BadAnswers++;
                }
            }
            if (TotalAnswers == GoodAnswers) {
				this.instruction.pause();
				this.instruction.currentTime = 0;
                this.game.state.start("Fill10");
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                if (tmpCheck + complition != 1) {
                }
                else {
                }
            }
            this.killKeyborad();
        };
        Fill8.prototype.update = function () {
        };
        Fill8.prototype.init = function (json) {
            this.GameData = {
                "Title": "",
                "Sound": "ZIP_spr_I_8_7.mp3",
                "MaxCharacters": 10,
                "AcceptedCharacters": "",
                "isGrid": true,
                "StartingPos": { "x": 400, "y": 400 },
                "Columns": 5,
                "Rows": 2,
                "Spacing": 1,
                "CustomFontSize": 32,
                "Graphics": [
                    { "src": "Graphics/game/0.png", "key": "00" },
                    { "src": "Graphics/game/1.png", "key": "01" },
                    { "src": "Graphics/game/2.png", "key": "02" },
                    { "src": "Graphics/game/3.png", "key": "03" },
                    { "src": "Graphics/game/4.png", "key": "04" },
                    { "src": "Graphics/game/5.png", "key": "05" },
                    { "src": "Graphics/game/7.png", "key": "07" },
                    { "src": "Graphics/game/8.png", "key": "08" },
                    { "src": "Graphics/game/6.png", "key": "06" },
                    { "src": "Graphics/game/ZIP_g_I_10_slonce.png", "key": "0" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta1.png", "key": "1" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta2.png", "key": "2" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta3.png", "key": "3" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta4.png", "key": "4" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta5.png", "key": "5" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta6.png", "key": "6" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta7.png", "key": "7" },
                    { "src": "Graphics/game/ZIP_g_I_10_planeta8.png", "key": "8" },
                ],
                "Spritesheet": [
                ],
                "Controlls": [
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "0", "pos": { "x": 0, "y": 156 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "1", "pos": { "x": 336, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "2", "pos": { "x": 457, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "3", "pos": { "x": 636, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "4", "pos": { "x": 803, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "5", "pos": { "x": 941, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "6", "pos": { "x": 1187, "y": 395 } },
                    { "HasText": true, "HasImage": true, "Size": "40", "id": 999, "key": "7", "pos": { "x": 1508, "y": 395 } },
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "8", "pos": { "x": 1721, "y": 395 } },
                ],
                "AditionalElements": [
                    { "key": "ZIP_g_I_7_ramka", "pos": { "x": 150, "y": 65 } },
                ],
                "StaticElements": [
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 1, "key": "07", "pos": { "x": 1150, "y": 780 } },
                ],
                "TaskList": [
                    { "pos": { "x": 1000, "y": 800 }, "Answer": "Uran", "id": 1 },
                ]
            };
        };
        return Fill8;
    })(BasicModule.BasicState);
    MainGame.Fill8 = Fill8;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=Fill8.js.map