var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var IntroState = (function (_super) {
        __extends(IntroState, _super);
        function IntroState() {
            _super.call(this);
            this.cloudList = [];
            this.movingElementsArray = [];
            this.isHelpShown = false;
            this.firstRun = true;
        }
        IntroState.prototype.create = function () {
            _super.prototype.create.call(this);
            this.game.world.sort();
            var bg = this.game.add.image(0, 0, "_bg1");
            this.movingElementsArray.push(bg);
            var town_bg = this.game.add.image(1834, 182, "_town_bg");
            this.movingElementsArray.push(town_bg);
            this.player = this.game.add.sprite(350, 740, "_gracz");
            var town_fg = this.game.add.image(50, 900, "_town_fg");
            this.movingElementsArray.push(town_fg);
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showHelp();
        };
        IntroState.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");
            this.load.image("_bg1", "Graphics/game/intro/ZIP_g_I_10_bg1.jpg");
            this.load.image("_town_bg", "Graphics/game/intro/ZIP_g_I_10_bg1_rakieta.png");
            this.load.image("_town_fg", "Graphics/game/intro/ZIP_g_I_10_bg1_przod.png");
            this.load.image("_button", "Graphics/game/intro/ZIP_g_I_4_button.png");
            this.load.spritesheet("_button", "Graphics/game/intro/ZIP_g_I_4_button.png", 250, 62, 2);
            this.load.spritesheet("_gracz", "Graphics/game/intro/ZIP_g_I_8_gracz.png", 228 / 2, 210, 2);
            this.instruction = new Audio("./Sounds/ZIP_g_I_10_1.mp3");
            this.applause = new Audio("./Sounds/ZIP_g_I_10_2.mp3");
        };
        IntroState.prototype.cloudsMover = function () {
            for (var i = 0; i < this.cloudList.length; i++) {
                var tween = this.game.add.tween(this.cloudList[i]);
                var currentposition = this.cloudList[i].x;
                var destination = currentposition - 4500;
                tween.to({ x: destination }, 5500, Phaser.Easing.Linear.None, true, 0, -1);
                tween.start();
            }
        };
        IntroState.prototype.buttonPressed = function (play, pointer) {
            this.button_play.visible = false;
            this.button_play.intractable = false;
            for (var i = 0; i < this.movingElementsArray.length; i++) {
                var tween = this.game.add.tween(this.movingElementsArray[i]);
                var currentposition = this.movingElementsArray[i].x;
                var destination = currentposition - 1000;
                tween.to({ x: destination }, 6000);
                tween.start();
            }
            var pltween = this.game.add.tween(this.player);
            pltween.to({ x: 1100 }, 6000);
            pltween.start();
            pltween.onComplete.addOnce(this.playDown, this);
        };
        IntroState.prototype.playDown = function () {
            this.showWin();
        };
        IntroState.prototype.changeHelp = function () {
            this.showHelp();
            this.cloudText.y = this.cloud.height * 0.4;
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
        };
        IntroState.prototype.showWin = function () {
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Jednak aby rozpocząć wyprawę, musisz prawidłowo odczytać godzinę z zegara.");
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 4, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.game.state.start("Fill");
                    }
                    catch (e) {
                    }
                }, this);
            }, this);
            tw.start();
            try {
                this.applause.currentTime = 0;
                this.applause.play();
            }
            catch (e) {
            }
        };
        IntroState.prototype.showHelp = function () {
            var tw = null;
            this.cloudText.setText("Niespodzianka! Zabieramy Cię w podróż w kosmos.");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;
            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    //this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.changeHelp, this);
                    }
                }
                catch (e) {
                }
            }
            else {
                try {
                    this.instruction.pause();
                    //this.instruction.currentTime = 0;
                }
                catch (e) {
                }
            }
            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        };
        return IntroState;
    })(BasicModule.BasicState);
    MainGame.IntroState = IntroState;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=IntroState.js.map