var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var IntermissionState = (function (_super) {
        __extends(IntermissionState, _super);
        function IntermissionState() {
            _super.call(this);
            this.cloudList = [];
            this.movingElementsArray = [];
            this.isHelpShown = false;
            this.firstRun = true;
        }
        IntermissionState.prototype.create = function () {
            _super.prototype.create.call(this);
            this.game.world.sort();
            var bg = this.game.add.image(0, 0, "_bg1");
            this.movingElementsArray.push(bg);
            this.cloudsMover();
            this.player = this.game.add.sprite(100, 760, "_gracz");
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
            var town_fg = this.game.add.image(1774, 630, "_town_fg");
            this.movingElementsArray.push(town_fg);
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showHelp();
        };
        IntermissionState.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");
            this.load.image("_bg1", "Graphics/game/intro/ZIP_g_I_10_bg2.jpg");
            this.load.image("_town_fg", "Graphics/game/intro/ZIP_g_I_10_bg2_planeta.png");
            this.load.image("_gracz", "Graphics/game/intro/ZIP_g_I_10_bg2_rakieta.png");
            this.instruction = new Audio("./Sounds/ZIP_g_I_10_5.mp3");
        };
        IntermissionState.prototype.cloudsMover = function () {
            for (var i = 0; i < this.cloudList.length; i++) {
                var tween = this.game.add.tween(this.cloudList[i]);
                var currentposition = this.cloudList[i].x;
                var destination = currentposition - 4500;
                tween.to({ x: destination }, 5500, Phaser.Easing.Linear.None, true, 0, -1);
                tween.start();
            }
        };
        IntermissionState.prototype.buttonPressed = function (play, pointer) {
            this.button_play.visible = false;
            this.button_play.intractable = false;
            for (var i = 0; i < this.movingElementsArray.length; i++) {
                var tween = this.game.add.tween(this.movingElementsArray[i]);
                var currentposition = this.movingElementsArray[i].x;
                var destination = currentposition - 400;
                tween.to({ x: destination }, 6500);
                tween.start();
            }
            var pltween = this.game.add.tween(this.player);
            pltween.to({ x: 1200, y: 400 }, 9000, Phaser.Easing.Quadratic.InOut);
            pltween.start();
            pltween.onComplete.addOnce(this.playDown, this);
        };
        IntermissionState.prototype.playDown = function () {
            this.game.state.start("Fill2");
        };
        IntermissionState.prototype.changeHelp = function () {
            this.showHelp();
            this.cloudText.y = this.cloud.height * 0.4;
        };
        IntermissionState.prototype.showHelp = function () {
            var tw = null;
            this.cloudText.setText("Posłuchaj informacji o mijanych ciałach niebieskich i podaj ich nazwy.");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;
            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    //this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 8, this.changeHelp, this);
                    }
                }
                catch (e) {
                }
            }
            else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                }
                catch (e) {
                }
            }
            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        };
        return IntermissionState;
    })(BasicModule.BasicState);
    MainGame.IntermissionState = IntermissionState;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=IntermissionState.js.map