﻿module TitleScreen {
    export class TitleScreenState extends BasicModule.BasicState {
        game: Phaser.Game;
        titleScreenImage: Phaser.Sprite;

        constructor() {
            super();
        }

        create() {
            super.create();

            this.game.add.image(452, 158, "box");
            var spons = this.game.add.image(0, this.game.height * 0.83, "sponsors");
            var guide = this.game.add.image(1366, 347, "introGuide");
            var play = this.game.add.button(488, 630, "play", this.playDown, this, 1, 0, 2, 1);
            this.game.world.sort();
        }

        preload() {
            super.preload();
            this.load.spritesheet("play", "Graphics/gui/play_btn.png", 200, 200, 3);
            this.load.image("box", "Graphics/gui/intro_box.png");
            this.load.image("sponsors", "Graphics/gui/sponsors.png");
            this.load.image("introGuide", "Graphics/gui/guide2.png");
        }

        playDown(play, pointer) {
            this.game.state.start("IntroState", false, false);
            
            
            //this.game.state.start("IntermissionState", false, false);
            //this.game.state.start("Fill7", true, false, 0);
            //this.game.state.start("MainGameState", true, false, 0);
        }
    }
}