var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var Fill2 = (function (_super) {
        __extends(Fill2, _super);
        function Fill2() {
            _super.call(this);
            this.HorizontalPlacementArray = [];
            this.VerticalPlacementArray = [];
            this.isGrid = false;
            this.StartingPosX = 0;
            this.StartingPosY = 0;
            this.Columns = 0;
            this.Rows = 0;
            this.Spacing = 0;
            this.initializationKeys = "";
            this.maxCharacters = 0;
            this.FillList = [];
			this.isHelpShown = false;
			this.firstRun = true;
            this.FFonetimer = true;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
        }
        Fill2.prototype.preload = function () {
            console.log("preload");
            _super.prototype.preload.call(this);
            this.loadGraphics();
            this.game.load.start();
			this.instruction = new Audio("./Sounds/ZIP_g_I_7_10.mp3");
			this.instruction_s = new Audio("./Sounds/ZIP_g_I_7_9.mp3");
            this.applause = new Audio("./Sounds/brawo.mp3");
        };
        Fill2.prototype.killKeyborad = function () {
            if (this.keyboard != undefined) {
                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        };
        Fill2.prototype.create = function () {
            _super.prototype.create.call(this);
            console.log("create");
            this.loadInit();
            this.createAdditionalElements();
            this.createStaticElements();
            this.createControllElement();
            this.createActiveElments();
			this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud_2");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showHelp();
        };
		Fill2.prototype.changeHelp = function () {
            this.showHelp();
            this.cloudText.y = this.cloud.height * 0.4;
        };
		Fill2.prototype.showWin = function () {
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Brawo!");
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 2, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.game.state.start("Fill3");
                    }
                    catch (e) {
                    }
                }, this);
            }, this);
            tw.start();
            try {
                //this.applause.currentTime = 0;
                this.applause.play();
            }
            catch (e) {
            }
        };
		Fill2.prototype.showHelp = function () {
            var tw = null;
            this.cloudText.setText("Jak należy zachować się, kiedy jesteśmy przeziębieni?");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;
            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    //this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.showHelp_s, this);
                    }
                }
                catch (e) {
                }
            }
            else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                }
                catch (e) {
                }
            }
            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        };
		Fill2.prototype.showHelp_s = function () {
            this.cloudText.setText("Zaznacz, które zdania są prawdziwe, a które błędne.");
			this.instruction_s.play();
            if (this.firstRun) {
                var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.changeHelp, this);
            }
        };
        Fill2.prototype.loadInit = function () {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
        };
        Fill2.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        Fill2.prototype.loadSpritesheet = function () {
            for (var i = 0; i < this.GameData.Spritesheet.length; i++)
                this.game.load.spritesheet(this.GameData.Spritesheet[i].key, this.GameData.Spritesheet[i].src, this.GameData.Spritesheet[i].size.x, this.GameData.Spritesheet[i].size.y, this.GameData.Spritesheet[i].size.no);
        };
        Fill2.prototype.createControllElement = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                        el.scale.setTo(0.8, 0.8);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                    }
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                }
            }
        };
        Fill2.prototype.createAdditionalElements = function () {
            for (var i = 0; i < this.GameData.AditionalElements.length; i++) {
                var el = this.game.add.image(this.GameData.AditionalElements[i].pos.x, this.GameData.AditionalElements[i].pos.y, this.GameData.AditionalElements[i].key);
            }
        };
        Fill2.prototype.createStaticElements = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.GameData.Controlls[0].Size + "pt Arial";
            for (var i = 0; i < this.GameData.Controlls.length; i++) {
                var currWidth = this.StartingPosX;
                if (this.GameData.StaticElements[i].HasImage) {
                    var el = this.game.add.image(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[i].pos.y, this.GameData.Controlls[i].key);
                }
            }
        };
        Fill2.prototype.createActiveElments = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                this.box = this.game.add.sprite(this.GameData.TaskList[i].pos.x, this.GameData.TaskList[i].pos.y, bmd);
                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
                this.box.text = this.item;
                this.item.answer = this.GameData.TaskList[i].Answer;
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                this.FillList.push(this.item);
            }
        };
        Fill2.prototype.keyboardInit = function () {
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                this.keyboard.initialize(this.initializationKeys, "key", "key");
            }
            else {
                this.keyboard.initialize("qwertyuiop" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^&", "key", "key");
            }
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
        };
        Fill2.prototype.showKeyboard = function (button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
        };
        Fill2.prototype.checkComplition = function () {
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                console.log(this.FillList[i].text + " == " + this.GameData.TaskList[i].Answer.toUpperCase());
                if (this.FillList[i].text.toUpperCase() == this.GameData.TaskList[i].Answer.toUpperCase()) {
                    GoodAnswers++;
                }
                else {
                    if (this.FillList[i].text.toUpperCase() != "?")
                        BadAnswers++;
                }
            }
            if (TotalAnswers == GoodAnswers) {
				this.showWin();
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                if (tmpCheck + complition != 1) {
                }
                else {
                }
            }
            this.killKeyborad();
        };
        Fill2.prototype.update = function () {
        };
        Fill2.prototype.init = function (json) {
            this.GameData = {
                "Title": "",
                "Sound": "",
                "MaxCharacters": 1,
                "AcceptedCharacters": "PF",
                "isGrid": true,
                "StartingPos": { "x": 400, "y": 400 },
                "Columns": 5,
                "Rows": 2,
                "Spacing": 1,
                "CustomFontSize": 32,
                "Graphics": [
                    { "src": "Graphics/game/ZIP_g_I_7_ramka.png", "key": "ZIP_g_I_7_ramka" },
                    { "src": "Graphics/game/00.jpg", "key": "00" },
                    { "src": "Graphics/game/01.jpg", "key": "01" },
                    { "src": "Graphics/game/02.jpg", "key": "02" },
                    { "src": "Graphics/game/03.jpg", "key": "03" },
                    { "src": "Graphics/game/04.jpg", "key": "04" },
                    { "src": "Graphics/game/05.jpg", "key": "05" },
                ],
                "Spritesheet": [
                ],
                "Controlls": [
                    { "HasText": false, "HasImage": true, "Size": "40", "id": 999, "key": "00", "pos": { "x": 500, "y": 200 } },
                ],
                "AditionalElements": [
                    { "key": "ZIP_g_I_7_ramka", "pos": { "x": 150, "y": 65 } },
                ],
                "StaticElements": [
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 1, "key": "01", "pos": { "x": 500, "y": 400 } },
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 2, "key": "02", "pos": { "x": 500, "y": 490 } },
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 3, "key": "03", "pos": { "x": 500, "y": 570 } },
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 4, "key": "04", "pos": { "x": 500, "y": 700 } },
                    { "HasText": false, "HasImage": true, "prefix": "", "sufix": "", "id": 5, "key": "05", "pos": { "x": 500, "y": 790 } },
                ],
                "TaskList": [
                    { "pos": { "x": 1400, "y": 430 }, "Answer": "p", "id": 1 },
                    { "pos": { "x": 1400, "y": 530 }, "Answer": "p", "id": 2 },
                    { "pos": { "x": 1400, "y": 630 }, "Answer": "p", "id": 3 },
                    { "pos": { "x": 1400, "y": 730 }, "Answer": "p", "id": 4 },
                    { "pos": { "x": 1400, "y": 850 }, "Answer": "p", "id": 4 },
                ]
            };
        };
        return Fill2;
    })(BasicModule.BasicState);
    MainGame.Fill2 = Fill2;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=Fill2.js.map