﻿module MainGame {
    export class IntermissionState extends BasicModule.BasicState {
        game: Phaser.Game;
        //titleScreenImage: Phaser.Sprite;
        cloudList: Array<any> = [];
        player: any;
        button_play: any;
        movingElementsArray: Array<any> = [];

        cloud: Phaser.Image;
        cloudText: Phaser.Text;
        isHelpShown: boolean = false;
        guide: Phaser.Group;
        instruction: any;
        firstRun: boolean = true;

        constructor() {
            super();
        }

        create() {
            super.create();

            // this.game.add.image(452, 158, "box");
            // var spons = this.game.add.image(0, this.game.height * 0.83, "sponsors");
            // var guide = this.game.add.image(1366, 347, "introGuide");
            // var play = this.game.add.button(488, 630, "play", this.playDown, this, 1, 0, 2, 1);
            this.game.world.sort();

            var bg = this.game.add.image(0, 0, "_bg1");
            this.movingElementsArray.push(bg);

            //for (var i = 1; i < 7; i++) {
            //    var cloud = this.game.add.image((Math.random() * 1) * 4000, 0 + (30 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);
            //    var cloud = this.game.add.image((Math.random() * 10) * 4000, 0 + (40 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);
            //    var cloud = this.game.add.image((Math.random() * 10) * 1900, 0 + (15 * (Math.random() * (i + 5))), "_cloud" + i);
            //    this.cloudList.push(cloud);

            //}

            this.cloudsMover()

            //var town_bg = this.game.add.image(0, 60, "_town_bg");
            //this.movingElementsArray.push(town_bg);
            //var town_tv = this.game.add.image(1900, 0, "_town_TV");
            //town_tv.scale.setTo(0.8, 0.8);
            //this.movingElementsArray.push(town_tv);
            this.player = this.game.add.sprite(200, 640, "_gracz");
            //var lat = this.game.add.image(-20, 548, "_town_latarnia");
            //this.movingElementsArray.push(lat);
            //var przewodnik = this.game.add.image(638, 560, "_przewodnik_bg");
            //this.movingElementsArray.push(przewodnik);
            //var lat = this.game.add.image(1604, 538, "_town_latarnia");
            //this.movingElementsArray.push(lat);
            //var lat = this.game.add.image(2450, 538, "_town_latarnia");
           // this.movingElementsArray.push(lat);
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
           // var town_fg = this.game.add.image(2362, 144, "_town_fg");

           // this.movingElementsArray.push(town_fg);


            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "Wybierz ubrania właściwe na deszcz i zimno.", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);

            // this.createOutfitHelp();

            this.guide.y = this.game.world.height;
            //this.showHelp();
        }

        preload() {
            super.preload();

            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");

            this.load.image("_bg1", "Graphics/game/intro/ZIP_g_I_7_bg2.jpg");
            //this.load.image("_cloud1", "Graphics/game/intro/ZIP_g_I_6_cloud1.png");
           // this.load.image("_cloud2", "Graphics/game/intro/ZIP_g_I_6_cloud2.png");
           // this.load.image("_cloud3", "Graphics/game/intro/ZIP_g_I_6_cloud3.png");
          //  this.load.image("_cloud4", "Graphics/game/intro/ZIP_g_I_6_cloud4.png");
          //  this.load.image("_cloud5", "Graphics/game/intro/ZIP_g_I_6_cloud5.png");
           // this.load.image("_cloud6", "Graphics/game/intro/ZIP_g_I_6_cloud6.png");

            //this.load.image("_town_bg", "Graphics/game/intro2/ZIP_g_I_6_intro2_miasto.png");
           // this.load.image("_town_TV", "Graphics/game/intro2/ZIP_g_I_6_tv.png");
            //this.load.image("_town_fg", "Graphics/game/intro2/ZIP_g_I_6_intro2_fg.png");
            //this.load.image("_town_latarnia", "Graphics/game/intro2/ZIP_g_I_6_latarnia.png");
            //this.load.image("_przewodnik_bg", "Graphics/game/intro2/ZIP_g_I_6_przewodnik_bg2.png");
            this.load.image("_button", "Graphics/game/intro/ZIP_g_I_4_button.png");
            this.load.spritesheet("_button", "Graphics/game/intro/ZIP_g_I_4_button.png", 250, 62, 2);
            this.load.spritesheet("_gracz", "Graphics/game/intro/ZIP_g_I_7_bg2_gracz.png", 312 / 2, 310, 2);

            this.instruction = new Audio("./Sounds/ZIP_g_I_6_1.mp3");
        }
        cloudsMover() {

            for (var i = 0; i < this.cloudList.length; i++) {

                var tween = this.game.add.tween(this.cloudList[i]);
                var currentposition = this.cloudList[i].x;
                var destination = currentposition - 4500;
                tween.to({ x: destination }, 5500, Phaser.Easing.Linear.None, true, 0, -1);
                tween.start();
            }

        }
        buttonPressed(play, pointer) {
            // console.log("asd");
            this.button_play.visible = false;
            this.button_play.intractable = false;
            for (var i = 0; i < this.movingElementsArray.length; i++) {
                var tween = this.game.add.tween(this.movingElementsArray[i]);
                var currentposition = this.movingElementsArray[i].x;
                var destination = currentposition - 200;
                tween.to({ x: destination }, 6500);
                tween.start();
            }
            var pltween = this.game.add.tween(this.player)
            pltween.to({ x: 1200 }, 6000);
            pltween.start();
            pltween.onComplete.addOnce(this.playDown, this);


        }
        playDown() {
            this.game.state.start("Fill2");
        }
        changeHelp() {
            this.showHelp();
            //this.helpBtn.inputEnabled = true;
            this.cloudText.y = this.cloud.height * 0.4;
            // //this.tipsBtn = this.game.add.button(this.cloud.width / 2, this.cloud.height * 0.7, "tips", this.showOutfits, this, 0, 0, 1, 0);
            // //this.tipsBtn.anchor.setTo(0.5, 0.5);
            // this.cloud.addChild(//this.tipsBtn);
            this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
        }
        showHelp() {

            var tw = null;
            this.cloudText.setText("");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;

            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        //this.helpBtn.inputEnabled = false;
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 8, this.changeHelp, this);
                    }
                } catch (e) { }
            } else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                } catch (e) { }
            }

            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
            //this.button_play = this.game.add.button(818, 811, "_button", this.buttonPressed, this, 1, 0, 1, 0);
        }

    }
}