﻿/*
 * Copyright (c) 1995-2012 by 4system Polska Sp. z o.o.
 * All Rights Reserved. v4
 */
var PAGETYPE_UNKNOWN = "Unknown";
var PAGETYPE_INFORMATION = "Information";
var PAGETYPE_EXERCISE = "Exercise";
//var PAGETYPE_HIDDEN = "Hidden";
var PAGETYPE_POLL = "Poll";
var PAGESTATUS_NOT_ATTEMPTED = "N";
var PAGESTATUS_INCOMPLETE = "I";
var PAGESTATUS_COMPLETED = "C";
var PAGESTATUS_PASSED = "P";
var PAGESTATUS_FAILED = "F";
var KEY_SEP = "¦";
var CHAR_A_CODE = 97;
var GLOBAL_MAX_POINTS = -1;

var listRandomizerInfo 		= null;	//wl - 201401 for config.temp_BSH201401
var iRandomizerAllPages		= 0;	//wl - 201401 for config.temp_BSH201401
var iRandomizerVisiblePages	= 0;	//wl - 201401 for config.temp_BSH201401

function getIdentiefier09az(index)
{
	if (index > 9) {
		return String.fromCharCode(87 + index);
	} else {
		return index;
	};
};

UELODDCalculator = function()
{
	var namesList = new Array();
};

UELODDCalculator.prototype.setNamesList = function(s)
{
	if (s == null || typeof(s) != "string" || s == "") return; //pg2
	this.namesList = new Array();
	if (s.indexOf("||") > -1) var list = s.split("||"); else var list = s.split(":");
	for (var i = 0; i < list.length; i++) {
		var items = list[i].split("|");
		for (var j = 0; j < items.length; j++) {
			var ex = false;
			for (var k = 0; k < this.namesList.length; k++) {
				if (this.namesList[k] == items[j]) {
					ex = true;
					break;
				};
			};
			if (!ex) {
				this.namesList[this.namesList.length] = items[j];
			};
		};
	};
};

UELODDCalculator.prototype.getNameCode = function(name)
{
	if (!this.namesList) return ''; //pg2-bi_matchParagraph_interactions
	for (var i = 0; i < this.namesList.length; i++) {
		if (this.namesList[i] == name) {
			return String.fromCharCode(CHAR_A_CODE + i);
		};
	};
	return "";
};

UELODDCalculator.prototype.transform = function(ss, s, all_possible)
{
	if (all_possible && all_possible != "") this.setNamesList(all_possible); else this.setNamesList(ss);
	var r = "{";
	s += "";
	if (s.length != 0) {
		if (s.indexOf("||") > -1) var sr = s.split("||"); else var sr = s.split(":");
		for (var i = 0; i < sr.length; i++) {
			if (r.length > 1) r += ",";
			r += String.fromCharCode(CHAR_A_CODE + i) + ".";
			r += this.getNameCode(sr[i]);
		};
	};
	r += "}";
	return r;
};

UELODDCalculator.prototype.transformToPermutation = function(ss, s, all_possible)
{
	if (all_possible && all_possible != "") this.setNamesList(all_possible); else
	if (ss && ss != '') this.setNamesList(ss); else return ""; //pg2-bi_matchParagraph_interactions
	
	var g = new Array();
	if (s.indexOf("||") > -1) var list = s.split("||"); else var list = s.split(":");
	for (var i = 0; i < list.length; i++) {
		g[i] = new Array();
		var items = list[i].split("|");
		if (i == 0) {
			for (var k = 0; k < items.length; k++) {
				g[i][g[i].length] = {"index":items[k],"parent":-1};
			};
		} else {
			for (var j = 0; j < g[i - 1].length; j++) {
				for (var k = 0; k < items.length; k++) {
					g[i][g[i].length] = {"index":items[k],"parent":j};
				};
			};
		};
	};
	var res = "";
	for (var i = 0; i < g[g.length - 1].length; i++) {
		var p = g.length - 1;
		var mod = "";
		if (res.length > 0) res += ";"
		res += "{";
		var item = g[g.length - 1][i];
		mod += String.fromCharCode(CHAR_A_CODE + p) + "." + this.getNameCode(item["index"]);
		p--;
		var parent = item["parent"];
		for (var j = g.length - 2; j >= 0; j--) {
			mod = String.fromCharCode(CHAR_A_CODE + p) + "." + this.getNameCode(g[j][parent]["index"]) + "," + mod;
			parent = g[j][parent]["parent"]
			p--;
		};
		res += mod + "}";
	};
	return (res);
};
/*
  *
  *
  */
UELOInteractions = function()
{
	this.gix = 0;
	this.id = "";
	this.elementId = "";
	this.correctResponses = "";
	this.studentResponse = "";
	this.all_possible = "";
	this.answerValuesString = "";
	this.correctResponsesAsText = "";
	this.studentResponseAsText = "";
	this.time = "";
	this.timestamp = null;
	this.type = "";
	this.weighting = "";
	this.status = PAGESTATUS_NOT_ATTEMPTED;
	this.result = "";
	this.maxScore = 0;
	this.score = 0;
	this.question = "";
	this.latency = null;
	this.tryNumber = 0;
	this.maxTryNumber = 0;
	this.solveVersion = 0;
    this.versions = new Array();
};

UELOInteractions.prototype.AddCorrectResponses = function(pattern)
{
	var p = this.FindCorrectResponses(pattern);
	if (p == null) {
		p = this.correctResponses[this.correctResponses.length] = pattern; 
	};
	return p;
};

UELOInteractions.prototype.FindCorrectResponses = function(pattern)
{
	for (var i = 0; i < this.correctResponses.length; i++) {
		if (this.correctResponses[i] == pattern) {
			return this.correctResponses[i];
		};
	};
	return null;
};
UELOInteractions.prototype.setValue = function(name, value)
{
	// wyjatki do poprawinie i ujednolicenia
	if (name == "answers") name = "studentResponse";
	if (name == "group") name = "id";

	if (typeof(this[name]) == "undefined") return;

	if (name == "status") {
		if (value == PAGESTATUS_PASSED) {
			this['result'] = true;
			this['score'] = this.maxScore;
		} else this['result'] = false;

	};

	if (typeof(this[name]) == "number" || typeof(this[name]) == "string" || typeof(this[name]) == "boolean") {
		this[name] = value;
	};
};

UELOInteractions.prototype.getValue = function(name)
{
	return (typeof(this[name] != "undefined")) ? this[name] : null;
};

UELOInteractions.prototype.setResult = function(value, userScore)
{
	if (value == true) {
		this.result = true;
		this.status = PAGESTATUS_PASSED;
		if (userScore) {
			this.score=userScore;
		} else {
			this.score=1;
		};
	} else {
		this.result = false;
		this.status = PAGESTATUS_FAILED;
		if (userScore) {
			this.score = userScore;
		} else {
			this.score = 0;
		};
	};
};

UELOInteractions.prototype.addVersion = function(vIndex, vText)
{
	var v = new UELOInterVersion();    
    v.versionIndex = vIndex;
    v.versionText = vText;
	this.versions[this.versions.length] = v;
	return v;
};

UELOInteractions.prototype.getVersionQuestion = function(vIndex)
{
	for (var k in this.versions) {
		if (this.versions[k].versionIndex == vIndex) {
			return this.versions[k].versionText;
		};
	};
	return this.question;
};

UELOYellowCard = function()
{
	this.id = "";
	this.cardType = "";
	this.date = "";
	this.author = "";
	this.left = "";
	this.top = "";
	this.title = "";
	this.note = "";
	this.buttonAdd = "";
	this.showUserName = false;
	this.pageName = '';
	this.pageGI = -1;
	this.personGraphic = "";
	this.clockGraphic = "";
	this.isMaximalize = false;
};

UELOYellowCard.prototype.setValue = function(name, value)
{
	// wyjatki do poprawinie i ujednolicenia
	if (name == "cardId") name = "id";
	if (typeof(this[name]) == "undefined") return;
	if (typeof(this[name]) == "number" || typeof(this[name]) == "string" || typeof(this[name]) == "boolean") {
		if (name == "isMaximalize") this[name] = (value == "true"); else this[name] = value;
	};
};
/*
  *
  *
  */
UELOPage = function()
{
	this.pageId = "";
	this.scoId = "";
	this.type = -1;
	this.access = true;
	this.pageType = PAGETYPE_UNKNOWN;
	this.status = PAGESTATUS_NOT_ATTEMPTED;
	this.title = "";
	this.chapterName = "";
	this.versionTitle = "";
	this.versionChapterName = "";
	this.globalIndex = -1;
	this.pageVisited = 0;
	//this.blockRestorePage = false; //pg2-qr -removed, 'cause below there is a duplicate
	this.correctResponses = new Array();
	this.interactions = new Array();
	this.yellowCards = new Array();
	this.visible = 1;
	this.marked = false;
	this.attempted = false;
	this.userAnswer = "";
	this.userMarkers = "";
	this.sessionTime = 0;
    this.href = "";
    this.parent = 1;
    this.ms = 0;
    this.score = 0;
    this.status = PAGESTATUS_NOT_ATTEMPTED;
    this.realParent = 1;
    this.iss = -1;
    this.haveParent = false;
    this.versions = new Array();//new UELOVersion();
    this.sessionTime = 0;
	this.blockRestorePage = false;
	this.isExamPage = false;
	this.passed = false;
	this.isQuizPageToReset = false; //pg2-bsh_test
	this.visitedCount = 0;
	this.isBookmark = false;

	this.previouslyVisible = true; //pg2-qr_test -previously available page (exercise or information one) - in drawing from some pool mode (export settings or quizRandomizer)
	this.previousStatus = '';
	
	this.lockPageScore = false; //pg2-courseReport_af
	this.forcePageReset = false;
	//...
};

UELOPage.prototype.setPageTitle = function(vIndex)
{
	this.versionTitle = this.getVersionText(vIndex, "title", this.title);
	this.versionChapterName = this.getVersionText(vIndex, "chapterName", this.chapterName);
};

UELOPage.prototype.FillYellowCards = function(params)
{
	if (typeof(params) != "undefined" && params != "") {
		var paramsArr = params.split(",");

		for (var i=0; i<paramsArr.length; i++) {
			if (paramsArr[i] != "") {
				var itemAttr = paramsArr[i].split(";");

				this.AddYellowCard("systemCard" + i/*unescape(itemAttr[0])*/, unescape(itemAttr[1]),
					unescape(itemAttr[2]), unescape(itemAttr[3]),
					unescape(itemAttr[4]), unescape(itemAttr[5]),
					unescape(itemAttr[6]), unescape(itemAttr[7]),
					'' , '', '' , '', '' , '', '' , '', '', 
					'___.yellowCard.author.gif', '___.yellowCard.time.gif' , '','', '', '', '', 'false', this.title, this.globalIndex
					);
			};
		};
	};
};

UELOPage.prototype.AddYellowCard = function(id, date, cardType, left, top, author, title, note, src, trashOver, trashOut, miniOver, miniOut, hideOver, hideOut, minimalizedMyCard, myDot, personGraphic, clockGraphic, defaultMinimalize, showMouseOver, isMaximalize, hourLang, buttonAdd, showUserName, pageName, pageGI)
{
	var yellowCard = this.FindYellowCard(id);
	if (yellowCard == null && id != "") {
		yellowCard = this.yellowCards[this.yellowCards.length] = new UELOYellowCard();
		yellowCard.id = id;
		yellowCard.date = (date && date != "") ? date : formatTime("datetime");
		yellowCard.cardType = cardType;
		yellowCard.left = left;
		yellowCard.top = top;
		yellowCard.author = author;
		yellowCard.title = title;
		yellowCard.note = escape(note);
		yellowCard.hourLang = hourLang;
		yellowCard.buttonAdd = buttonAdd;
		yellowCard.showUserName = showUserName;
		yellowCard.pageName = pageName;
		yellowCard.pageGI = pageGI;
		if (src) yellowCard.src = src;
		if (trashOver) yellowCard.trashOver = trashOver;
		if (trashOut) yellowCard.trashOut = trashOut;
		if (miniOver) yellowCard.miniOver = miniOver;
		if (miniOut) yellowCard.miniOut = miniOut;
		if (hideOver) yellowCard.hideOver = hideOver;
		if (hideOut) yellowCard.hideOut = hideOut;
		if (minimalizedMyCard) yellowCard.minimalizedMyCard = minimalizedMyCard;
		if (myDot) yellowCard.authorDot = myDot;
		if (personGraphic) yellowCard.personGraphic = personGraphic;
		if (clockGraphic) yellowCard.clockGraphic = clockGraphic;
		if (defaultMinimalize) yellowCard.defaultMinimalize = defaultMinimalize;
		if (showMouseOver) yellowCard.showMouseOver = showMouseOver;
		if (isMaximalize) yellowCard.isMaximalize = isMaximalize;
		else yellowCard.isMaximalize = false;
	};
	return yellowCard;
};

UELOPage.prototype.updateYellowCard = function(id,date,author,left,top,title,note,src,miniBckg,trashOver,trashOut,miniOver,miniOut,hideOver,hideOut,myDot,personGraphic,clockGraphic,defaultMinimalize,showMouseOver,isMaximalize)
{
	var yellowCard = this.FindYellowCard(id);
	//if (yellowCard && yellowCard.cardType == "private") {
	if (yellowCard) {
		yellowCard.date = date;
		yellowCard.author = author;
		yellowCard.left = left;
		yellowCard.top = top;
		yellowCard.title = title;
		yellowCard.note = escape(note);
		yellowCard.src = src;
		yellowCard.minimalizedMyCard = miniBckg;
		yellowCard.trashOver = trashOver;
		yellowCard.trashOut = trashOut
		yellowCard.miniOver = miniOver;
		yellowCard.miniOut = miniOut;
		yellowCard.hideOver = hideOver;
		yellowCard.hideOut = hideOut;
		yellowCard.authorDot = myDot;
		yellowCard.personGraphic = personGraphic;
		yellowCard.clockGraphic = clockGraphic;
		yellowCard.defaultMinimalize = defaultMinimalize;
		yellowCard.showMouseOver = showMouseOver;
		yellowCard.isMaximalize = isMaximalize;
		return true;
	};
	return false;
};

UELOPage.prototype.DeleteYellowCard = function(id)
{
	for (var i = 0; i < this.yellowCards.length; i++) {
		var yellowCard = this.yellowCards[i];
		if (yellowCard && yellowCard.id == id) {
			this.yellowCards[i] = null;
			return true;
		};
	};
	return false;
};

UELOPage.prototype.FindYellowCard = function(id)
{
	for (var i = 0; i < this.yellowCards.length; i++) {
		var yellowCard = this.yellowCards[i];
		if (yellowCard && yellowCard.id == id) {
			return yellowCard;
		};
	};
	return null;
};

UELOPage.prototype.setValue = function(name, value)
{
	// wyjatki do poprawinie i ujednolicenia
	if (typeof(this[name]) == "undefined") return;

	if (typeof(this[name]) == "number" || typeof(this[name]) == "string" || typeof(this[name]) == "boolean") {
		this[name] = unquotedString(value);
	};
};

UELOPage.prototype.AddInteraction = function(elementId, question, correctResponses, maxScore, tryNumber, maxTryNumber, type, answerValuesString, all_possible, elementType, reportData)
{
	/*
	if (elementType.indexOf('Light',0) > 0) {
		elementType=elementType.substring(0,elementType.indexOf('Light',0));
	}
	*/
	var interId = this.FormatInteractionId(elementId, this.globalIndex);
	var inter = this.FindInteraction(interId);
	if (inter == null) {
		var inter = this.interactions[this.interactions.length] = new UELOInteractions();
		inter.gix = this.interactions.length;
		inter.id = interId;
		inter.elementType = elementType;
		inter.elementId = elementId;
		inter.question = question || "";
		inter.maxScore = maxScore || "";
		inter.maxTryNumber = maxTryNumber || "";
		inter.correctResponses = correctResponses || "";
		inter.type = type || "";
		inter.all_possible = all_possible || "";
		inter.answerValuesString = answerValuesString || "";
		inter.reportData = reportData || "";
		inter.correctResponsesAsText = this.convertCorrectAnswerToText(inter.elementType, inter.answerValuesString, inter.correctResponses);
		return inter;
	} else {
		return inter;
	};
};

UELOPage.prototype.convertCorrectAnswerToText = function(t, s, a) {
	if (s == "") return "";
    var ans = "";
    var result = "";
    var sep = "";
    var sep = "";
    var valuesArr = s.split('||');
    
	if (t == 'single_choice' || t == 'mltp_choice') {
		ans = decIntoBin(a).toString().split('');
		for (var i = 0; i < ans.length; i++) {
			if (result != "") sep = "<br>";
			if (ans[i] == '1') result += valuesArr[i];
		};
	} else
	if (t == 'radiobutton') {
		valuesArr = s.split(':');
		ans = a.split(':');
		for (var i in ans) {
			if (ans[i] == '1') {
				result += valuesArr[i];
				break;
			};
		};
	} else
	if (t == 'DDBasket') {
		var l = {};
		for (var i in valuesArr) {
			var p = valuesArr[i].indexOf("=");
			if (p > -1) {
				var k = valuesArr[i].substr(0,p);
				l[k] = valuesArr[i].substr(p+1);
			};
		};

		ans = a.split('|');
		for (var i in ans) {
			if (result != "") result += ",";
			result += l[ans[i]];
		};
	} else {
		ans = a.toString().split('||');
		for (var i in ans) {
			if (result != "") result += "<br>";
			var s = valuesArr[parseInt(ans[i])];
			if (typeof(s) != 'undefined') result += s;
		};
	};
    return result;
};

UELOPage.prototype.FindInteraction = function(interId)
{
	for (var i = 0; i < this.interactions.length; i++) {
		var inter = this.interactions[i];
		if (inter.id == interId) {
			return inter;
		};
	};
	return null;
};

UELOPage.prototype.FormatInteractionId = function(elementId, pageGlobalIndex)
{
	return elementId + "_" + pageGlobalIndex;
};

UELOPage.prototype.addVersion = function(vIndex, vType, vText) {
	var v = new UELOPageVersion();    
    v.versionIndex = vIndex;
    v.versionText = vText;
	v.versionType = vType;
	this.versions[this.versions.length] = v;
	return v;
};

UELOPage.prototype.getVersionText = function(vIndex, vType, defaultText)
{
	for (var k in this.versions) {
		if (this.versions[k].versionIndex == vIndex && this.versions[k].versionType == vType) {
			return this.versions[k].versionText;
		};
	};
	return defaultText;
};

UELOPage.prototype.existsVersionPage = function(vIndex, vType)
{
	for (var k in this.versions) {
		if (k.versionIndex == vIndex && k.versionType == vType) {
			return true;
		};
	};
	return false;
};

UELOInterVersion = function()
{
    this.versionIndex = 0;
    this.versionText = "";
};

UELOPageVersion = function()
{
    this.versionIndex = 0;
	this.versionType = "";
    this.versionText = "";
};

UELOPage.prototype.getRawScore = function()
{
	if (this.visible == 0) return "";
	if (this.pageType != PAGETYPE_EXERCISE) return "";
	var res = 0;
	for (var j = 0; j < this.interactions.length; j++) {
		var inter = this.interactions[j];
		res += parseInt(inter.score);
	};
	return res;
};

UELOPage.prototype.getRawScoreMax = function()
{
	if (this.visible == 0) return "";
	if (this.pageType != PAGETYPE_EXERCISE) return "";
	var res=0;
	for (var j = 0; j < this.interactions.length; j++) {
		var inter = this.interactions[j];
		res += parseInt(inter.maxScore);
	};
	return res;
};

UELOPage.prototype.getRawPageTry = function()
{
	if (this.pageType == PAGETYPE_EXERCISE) {
		for (var j = 0; j < this.interactions.length; j++) {
			var inter = this.interactions[j];
			if (inter.tryNumber > 0) {
				return inter.tryNumber;
			};
		};
	};
	return 0;
};

UELOPage.prototype.getCMIScore = function()
{
	var score = this.getRawScore();
	var max = this.getRawScoreMax();
	if (score == "" || max == "") {
		return "";
	};
	return ((score*100)/max).toFixed(0);
};

UELOPage.prototype.resetPageInteractions = function() //pg2-bsh
{
	this.status = PAGESTATUS_NOT_ATTEMPTED;
	this.passed = false;
	this.solved = false;
	this.score = 0; //pg2-qr
	for (var i = 0; i < this.interactions.length; i++) {
		var inter = this.interactions[i];
		inter.studentResponse = "";
		inter.studentResponseAsText = "";
		inter.time = "";
		inter.timestamp = null;
		inter.status = PAGESTATUS_NOT_ATTEMPTED;
		inter.result = "";
		inter.score = 0;
		inter.tryNumber = 0;
	};
};
/*
  *
  *
  */
UELO = function()
{
	this.pages = new Array();
	this.notepad = new Array();
	this.keySep = KEY_SEP;
	this.scoId = "";
	this.courseName = "";
	this.courseDescription = "";
	this.username = "";
	this.password = "";
	this.organisation = "";
	this.server = "";
	this.percentCompleted = "";
	this.pagesCount = 0;
	this.exercisePagesCount = 0;
	this.pagesVisited = 0;
	this.pointsMax = 100;
	this.points = 0;
	this.passThreshold = 100;
	this.beginTime = new Date();
	this.endTime = new Date();
	this.sessionTime = 0;
	this.userVars = "";
	this.lastVisitedPage = 0;
	this.saveUelo = 0;
	this.showUserAnswers = true;
	this.initialized = false;
	this.sco_gix = -1;
    this.sco_uelo = null;
	this.sendDataInterval = 0;
	this.sendResultsToServerTime = 0;
	this.courseOryginalStatus = "";
	this.courseOryginalScore = 0;
	this.writeValuesList = new Array("organisation", "username", "password", "server", "percentCompleted", "pagesVisited", "pointsMax", "points", "passThreshold",  "beginTime", "endTime", "courseName", "courseDescription", "keySep", "userVars", "lastVisitedPage", "score", "marked", "attempted");
    this.index = 0;
    this.rootPage = null;
	this.examParentGix = -1;
	this.firstOffsetPages = 0;
	this.lastOffsetPages = 0;
	this.countShowPages = 0;
	this.isCourseMixed = false;  
	this.timerDataSender = null;  
	this.timerPostponeSender = null;

	this.previousMixedStructure = ""; //pg2-qr_test -previously visible pages structure
	this.pageInAssessmentCheckAnswerInSession = false; //pg2-qr

	this.currentUELOPage = null; //pg2-speed up
	this.resetOverride = false; //pg2-courseReport_af
	//this.lastPageGIX = -1; //pg2-knf //pg2-removed
};

/*UELO.prototype.setLastPageGIX = function() //pg2-knf //pg2-removed, moved to player
{
	try {
		if (this.pagesCount > 0) {
			this.lastPageGIX = this.pages[this.pagesCount-1].globalIndex;
		};
	} catch(e) {};
};*/


UELO.prototype.CompleteInitialization = function(gix) //pg2-speed up
{
	try {
		if (parseInt(gix) > 1) {
			if (this.currentUELOPage && this.currentUELOPage.globalIndex == parseInt(gix)) return;
			this.currentUELOPage = null;
			var uPage = this.FindPage(gix);
			this.currentUELOPage = uPage;
		};
	} catch(e) {};
};

UELO.prototype.IsHidden = function(gix)
{
	var p = this.FindPage(gix);
	return (p) ? (p.visible == 0):true;
};

UELO.prototype.RunTimerDataSender = function()
{
	this.UpdateTimerDataSender();
};

UELO.prototype.UpdateTimerDataSender = function()
{
	if (config.sendDataToServerOnEachPage) {
		this.StopTimerDataSender();
		this.timerDataSender = window.setInterval('uelo.TimerDataSend()', (60000 * 5));
	};
};

UELO.prototype.StopTimerDataSender = function()
{
	if (this.timerDataSender != null) {
		window.clearInterval(this.timerDataSender);
	};
};

UELO.prototype.TimerDataSend = function()
{
	this.sendSubDataToServer();
};

UELO.prototype.AddPage = function()
{
	var p = new UELOPage();
	this.pages[this.pagesCount++] = p; //this.pages[this.pages.length] = p; //pg2-speed up 2
	//this.pagesCount++;
	return p;
};

UELO.prototype.setRootPage = function()
{
    this.rootPage = new UELOPage();
    return this.rootPage;
};

UELO.prototype.LoadFromForm = function(textAreaName)
{
};

//String parent.UELO.getHeaderString(String Name) - daje text z naglowka 
UELO.prototype.GetHeaderString = function(name)
{
	for (var k in this) {
		var type = typeof(this[k]);
		if (type == "number" || type == "string" || type == "boolean" || type == "object") {
			return this[k];
		};
	};
	return null;
};

UELO.prototype.setHeaderString = function(name, value)
{
	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	// wyjatki do poprawinie i ujednolicenia
	if (name == "Server_for_check_Answers") name = "server";

	var f = new RegExp("^" + name + "$", "gi");
	for (var k in this) {
		if (k.match(f)) {
			for (var j = 0; j < this.writeValuesList.length; j++) {
				if (this.writeValuesList[j].toLowerCase() == k.toLowerCase()) {
					if (typeof(this[k]) == "number" || typeof(this[k]) == "string" || typeof(this[k]) == "boolean") {
						this[k] = value;
						return;
					};
					if (typeof(this[k]) == "object" && (k == "beginTime" || k == "endTime")) {
						this[k] = this.stringToDate(value);
						return;
					};
				};
			};
		};
	};
};

//String parent.UELO.getDataStringByID(int PageId;String ColumnName) - daje text z danych linia szukajac po PageId
UELO.prototype.GetDataStringByID = function(pageId, name)
{
};

//String parent.UELO.getDataStringByIdx(int RowIdx;String ColumnName) - daje text z danych linia RowIdx
UELO.prototype.GetDataStringByIdx = function(rowIdx, columnName)
{
};

//String parent.UELO.getDataStringByName(String PageName;String ColumnName) - daje text z danych linia szukajac po PageId
UELO.prototype.GetDataStringByName = function(pageName, columnName)
{
};

//int parent.UELO.getDataRowCount() - daje ilosc linii
UELO.prototype.GetDataRowCount = function()
{
};

//String parent.UELO.setDataStringByID(int PageID;String ColumnName,String value)
UELO.prototype.SetDataStringByID = function(pageID, columnName, value)
{
};

UELO.prototype.setPageTitle = function(gix, vIndex)
{
	var page = this.FindPage(gix);
	if (page) {
		page.setPageTitle(vIndex);
	};
};

UELO.prototype.setBookmark = function(gix, value)
{
	var page = this.FindPage(gix);
	if (page) {
		page.isBookmark = (value == true);
	};
};

UELO.prototype.GetPageStudentAnswer = function(gix, examMode)
{
	var result = "";
	var sep = "";
	var page = this.FindPage(gix);
	if (page) { 
		if (page.pageType == PAGETYPE_EXERCISE) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				var studentResponse = inter.studentResponse;
				//if (examMode && //pg2- it's 'undefined', so for baskets with many elements it wouldn't be executed...ever
				if (inter.id.indexOf("DDBasket") > -1) {
					studentResponse = studentResponse.replace(/,/g, "|");
				};
				result += sep + studentResponse;
				sep = "~";
			};
		} else
		if (page.userAnswer != "") {
			result += page.userAnswer;
		};
	};
	return result;
};

UELO.prototype.getPageTryNumber = function(gix)
{
	var result = -1;
	var page = this.FindPage(gix);
	if (page) {
		if (page.pageType == PAGETYPE_EXERCISE) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				/*
				var tryRemain = inter.maxTryNumber - inter.tryNumber;
				if (tryRemain>result) result = tryRemain;
				*/
				//return result = inter.tryNumber; //pg2-removed
				if (inter.tryNumber > result) result = inter.tryNumber;  //pg2-dg -check for max tryNumber (ex.component MarkSentence has no 'real' inter and tryNumber is const)
			};
		};
	};
	return result; 
};

UELO.prototype.getExerciseTryMaxNumberTitle = function(gix, value)
{
	var result = "";
	var sep = '\n';
	var page = null;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		page = this.pages[i];
		if (page.visible == 1 && page.interactions.length < 1) continue;
		result += sep;
		result += page.title+" : ";
		result += page.interactions[0].tryNumber + "/";
		result += page.interactions[0].maxTryNumber + " ";
	};	
	return result;
};

UELO.prototype.getExerciseTryNumber = function(gix, value) //pg2-qr -modyfied
{
	var res = "";
	var p = null;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		p = this.pages[i];
		//if (p.visible == 0) continue; //pg2-removed, in case of drawing pages, it could happen, that in next drawing, page's try count wasn't saved - so always check it
		try {
			if (res != '') res += ',';
			if ((p.blockRestorePage || p.interactions.length > 0) && p.pageType == PAGETYPE_EXERCISE) {
				if (isNaN(p.interactions[0].tryNumber)) res += '0'; //pg2
				else res += p.interactions[0].tryNumber + ''; //intToLetter(p.interactions[0].tryNumber); //pg2-qr -replaced, tryNumber could be value up to 99
			} else {
				res += "0";
			};
		} catch(e) {}; //pg2-sometimes there was exceptions within this block
	};
	return res;
};

UELO.prototype.convertStudentAnswerToText = function(t, s, a) {
	if (s == "") return "";
    var ans = "";
    var result = "";
    var sep = "";
    var valuesArr = s.split('||');
    
	if (t == "text_mark") {
		if (a == '') result = "<br>"; else { //pg2-in case of an empty answer, there was 'undefined'
			ans = a.toString().split(':');
			for (var i in ans) {
				result += valuesArr[parseInt(ans[i])] + "<br>";
			};
		};
	} else
	if (t == 'choice' || t == 'single_choice' || t == 'mltp_choice') { //pg2-added 'single_choice' and 'mltp_choice' - otherwise in multi-singleSCO on next visit, in DetailedReport...
		ans = decIntoBin(a).toString().split('');                      //       ...there will be 'undefined' or wrong answer (user has given correct one, but displayed will be a wrong one from list
		for (var i = 0; i < ans.length; i++) {
			if (result != "") sep = "<br>";
			if (ans[i] == '1') result += valuesArr[i];
		};
	} else
	/*if (t == 'single_choice') { //pg2-removed, 'cause it is coded from binary array to decimal; moved above...
		ans = parseInt(a);
		if (!isNaN(ans)) {
			result = valuesArr[ans-1];
		}
	} else*/
	if (t == 'radiobutton' || t == 'checkbox') { //pg2-added checkbox
		valuesArr = s.split(':');
		ans = a.split(':');
		for (var i in ans) {
			if (ans[i] == '1') {
				result += valuesArr[i];
				break;
			};
		};
	} else
	if (t == 'DDBasket') {
		var l = {};
		for (var i in valuesArr) {
			var p = valuesArr[i].indexOf("=");
			if (p > -1) {
				var k = valuesArr[i].substr(0,p);
				l[k] = valuesArr[i].substr(p+1);
			};
		};

		ans = a.split('|');
		for (var i in ans) {
			if (result != "") result += "<br>";
			result += (typeof(l[ans[i]]) == "string") ? l[ans[i]]:"";
		};
	} else {
		ans = a.toString().split('||');
		for (var i in ans) {
			if (result != "") result += "<br>";
			var s = valuesArr[parseInt(ans[i])];
			if (typeof(s) != 'undefined') result += s;
		};
	};
	if (typeof(result) == "undefined") result = ""; //pg2-if wasn't found or there is some error and it ends up as 'undefined', use an empty string
    return result;
};

UELO.prototype.SetPageStudentAnswer = function(gix, value) //pg2-qr -modyfied
{
	if (typeof(value) == "undefined" || value == null) return;
	var p = this.FindPage(gix);
	if (p) {
		//if (p.blockRestorePage) return; //pg2-pkf_draw_pages_answers-removed -this blocks displaying user's answers in reports (interactions won't be initialized from previous session's values; its reset will be invoked visiting first page of the pool
		if (p.pageType == PAGETYPE_EXERCISE) {
			//pg2-replaced with below one //var valueStr = value + ""; //pg2- if number will be passed, an exception will be invoked
			var valueStr = ""; //pg2-change
			try {
				valueStr = value.toString(); //pg2-instead of value+""
			} catch(e) {
				valueStr = "";
			};
			var valueArr = valueStr.split("~"); //pg2
			for (var j = 0; j < p.interactions.length; j++) {
				var inter = p.interactions[j];
				inter.studentResponse = (typeof(valueArr[j]) != "undefined") ? valueArr[j] : "";

				//
				inter.studentResponseAsText = this.convertStudentAnswerToText(inter.elementType, inter.answerValuesString, inter.studentResponse); 
			};
		} else p.userAnswer = value;
	};
};

UELO.prototype.GetPageMarkers = function(gix)
{
	var result = null;
	var page = this.FindPage(gix);
	if (page) {
		result = page.userMarkers;
	};
	return result;
};

UELO.prototype.SetPageMarkers = function(gix, value)
{
	if (typeof(value) == "undefined" || value == null) return;
	var page = this.FindPage(gix);
	if (page) {
		page.userMarkers = value;
	};
};

UELO.prototype.setPageParams = function(gix, command) //pg2-courseReport_af
{
	if (typeof(gix) == 'undefined' || typeof(command) == 'undefined' || command == '') return;
	var p = this.FindPage(gix);
	if (p) {
		switch (command) {
			case 'markLockPassed':
				p.lockPageScore = true;
				p.forcePageReset = true;
				if (!struct) struct = getStruct();
				if (struct) {
					var sp = struct.findItem(p.globalIndex);
					if (sp) sp["lockPageScore"] = true;
				};
				break;
			case 'markForceReset':
				p.lockPageScore = false;
				p.forcePageReset = true;
				break;
		};
	};
};

UELO.prototype.pageAttempted = function(gix)
{
	var result = false;
	var page = this.FindPage(gix);
	if (page) {
		page.attempted = true;
		result = true;
	};
	return result;
};

UELO.prototype.pageNotAttempted = function(gix)
{
	var result = false;
	var page = this.FindPage(gix);
	if (page) {
		page.attempted = false;
		result = true;
	};
	return result;
};

UELO.prototype.getPageAttempt = function(gix)
{
	var page = this.FindPage(gix);
	if (page) {
		return  page.attempted;
	};
	return false
};

UELO.prototype.markPage = function(gix)
{
	var result = false;
	var page = this.FindPage(gix);
	if (page) {
		page.marked = true;
		result = true;
	};
	return result;
};

UELO.prototype.unmarkPage = function(gix)
{
	var result = false;
	var page = this.FindPage(gix);
	if (page) {
		page.marked = false;
		result = true;
	};
	return result;
};

UELO.prototype.updateUELOFromSDMultiple = function(status, userans)
{
	if (this.sco_gix != -1) {
		this.setPageStatus(this.sco_gix, status);
		this.SetPageStudentAnswer(this.sco_gix, userans);
	};
};

UELO.prototype.updateUELOFromSD = function(statusString, userAnswers, tryNumberStr, interStatus, scoringList, mixedStructStatuses) //pg2-qr -modyfied
{
	var sep = "";
	if (statusString.indexOf(",") > -1) sep = ",";

	var arr = statusString.split(sep);
	var tryNumberArr = [];
	if (typeof(tryNumberStr) != 'undefined') {
		tryNumberArr = tryNumberStr.split(","); //pg2-qr -replaced "" with "," -remove letters, use max 2-digit numbers
	};
	//pg2-pkf_draw_pages_tryCount -old block
	// var structPage = null;
	// for (var i = 0; i < arr.length; i++) {
		// structPage = struct.findItemGixByArrIndex(i);
		// if (typeof(tryNumberArr[i]) != 'undefined') {
			// if (tryNumberArr[i] == 'NaN') tryNumberArr[i] = '0'; //pg2-PCEN
			//// this.setPageStatusFromSD(structPage, arr[i], letterToInt(tryNumberArr[i])); //pg2-qr -replaced with below one (remove letters, it could be a 2-digit number, and letters range isn't that wide)
			// this.setPageStatusFromSD(structPage, arr[i], parseInt(tryNumberArr[i])); //pg2-qr -new
		// } else {
			// this.setPageStatusFromSD(structPage, arr[i], 0);
		// };
	// };
	//...
	//pg2-pkf_draw_pages_tryCount -new5
	if (typeof(mixedStructStatuses) == 'undefined') mixedStructStatuses = '';
	if (mixedStructStatuses != '') {
		mixedStructStatuses = mixedStructStatuses.replace(new RegExp('1', "g"), '');
		mixedStructStatuses = mixedStructStatuses.replace(new RegExp('0', "g"), '');
		if (mixedStructStatuses.length == this.pages.length) statusString = mixedStructStatuses;
	};
	
	var tryNumberStrArr = tryNumberStr.split(',');
	for (var i=0; i<this.pages.length; i++) {
		var p = this.pages[i];
		
		var pStatus2Set = 'N';
		if (statusString.length > i) pStatus2Set = statusString.substring(i,i+1);
		
		var tryNumber2Set = 0;
		if (tryNumberStrArr.length > i) tryNumber2Set = tryNumberStrArr[i];
		
		if (mixedStructStatuses == '') this.setPageStatusFromSD(p.globalIndex, pStatus2Set, tryNumber2Set);
		else this.setPageStatusFromSD_Mixed(p.globalIndex, pStatus2Set, tryNumber2Set); //pg2-pkf_draw_pages_tryCount -without changing '.visible' etc
	};
	//...

	if (typeof(userAnswers) != "undefined") {
		var dataArr = userAnswers.split(";");
		for (var i = 0; i < dataArr.length; i++) {
			var dItem = dataArr[i].split("=");
			if (dItem[0].indexOf("_ua") > -1) {
				var gix = dItem[0].replace("_ua", "");
				this.SetPageStudentAnswer(gix, unescape(dItem[1]));
			};
		};
	};

	if (typeof(interStatus) != "undefined") {
		this.setInteractionsStatus(interStatus);
	};

	if (typeof(scoringList) != "undefined") {
		//pg2-???
	};
};

UELO.prototype.getLastVisitedPage = function()
{
	if (this.lastVisitedPage != 0) return this.lastVisitedPage;
	var lastPage = null;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		if (this.pages[i].status == PAGESTATUS_INCOMPLETE) {
			this.pages[i].globalIndex;
		} else
		if (this.pages[i].status == PAGESTATUS_NOT_ATTEMPTED) {
			return lastPage;
		};
		lastPage = this.pages[i].globalIndex;
	};
	return lastPage;
};

UELO.prototype.setLastVisitedPage = function(pageNo)
{
	this.lastVisitedPage = pageNo;
};

UELO.prototype.getPageIndexInStruct = function(pageGlobalIndex)
{
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		if (this.pages[i].globalIndex == pageGlobalIndex) {
			return i;
		};
	};
};

UELO.prototype.getPageAccess = function(gix)
{
	var p = this.FindPage(gix);
	return (p) ? p.access : true;
};

UELO.prototype.setPageAccess = function(gix, b)
{
	var p = this.FindPage(gix);
	if (p) {
		p.access = b;
	};
};

UELO.prototype.getPageType = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		return p.pageType;
	};
};

UELO.prototype.showUELOPageInteractions = function(pageGlobalIndex, displayValues)
{
	var result = "";
	var ueloPage = this.FindPage(pageGlobalIndex);
	if (ueloPage) {
		for (var i = 0; i < ueloPage.interactions.length; i++) {
			var inter = ueloPage.interactions[i];
			result += '\n';
			for (var j = 0; j < displayValues.length; j++) {
				result += '\n';
				result += displayValues[j]+" : " + inter[displayValues[j]];
			};
		};
	};
	return result;
};

UELO.prototype.getPagesArrWithStatus = function(sep)
{
	var resultArr = new Array();
	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		resultArr.push([page.globalIndex, page.title, page.status]);
	};
	return resultArr;
};

UELO.prototype.getPagesStatus = function(sep)
{
	var result = "";
	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		result += sep + page.status;
	};
	return result;
};

UELO.prototype.getPageStatus = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		return p.status;
	};
};

UELO.prototype.setPageStatusFromSD = function(pageGlobalIndex, newPageStatus, tryNumber)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		//if (p.blockRestorePage) return; //pg2-pkf_draw_pages_tryCount-removed -this blocks displaying user's answers in reports (interactions won't be initialized from previous session's values; its reset will be invoked visiting first page of the pool
		if (typeof(newPageStatus) == "undefined") newPageStatus = PAGESTATUS_NOT_ATTEMPTED; //pg2
		p.visible = (newPageStatus >= 'a' && newPageStatus <= 'z') ? 0:1;
		newPageStatus = newPageStatus.toUpperCase();
		p.status = newPageStatus;
		if ((p.status != PAGESTATUS_NOT_ATTEMPTED) && (p.status != PAGESTATUS_INCOMPLETE) && (p.status != 'not attempted') && (p.status != 'incomplete')) p.pageVisited = 1; //pg2
		if (p.status == PAGESTATUS_PASSED) p.passed = true;

		for (var i = 0; i < p.interactions.length; i++) {
			var inter = p.interactions[i];
			inter.tryNumber = tryNumber;
			if (inter.status == PAGESTATUS_NOT_ATTEMPTED) inter.status = newPageStatus;
			if (newPageStatus == PAGESTATUS_PASSED) {
				inter.score = inter.maxScore;
				inter.result = true;
			};
			if (newPageStatus == PAGESTATUS_FAILED) {
				inter.score = 0;
				inter.result = false;
			};
		};
	};
};

UELO.prototype.setPageStatusFromSD_Mixed = function(pageGlobalIndex, newPageStatus, tryNumber) //pg2-pkf_draw_pages_tryCount
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		if (typeof(newPageStatus) == "undefined") newPageStatus = PAGESTATUS_NOT_ATTEMPTED;
		newPageStatus = newPageStatus.toUpperCase();
		p.status = newPageStatus;
		if ((p.status != PAGESTATUS_NOT_ATTEMPTED) && (p.status != PAGESTATUS_INCOMPLETE) && (p.status != 'not attempted') && (p.status != 'incomplete')) p.pageVisited = 1; //pg2
		if (p.status == PAGESTATUS_PASSED) p.passed = true;

		for (var i = 0; i < p.interactions.length; i++) {
			var inter = p.interactions[i];
			inter.tryNumber = tryNumber;
		};
	};
};

UELO.prototype.setPageStatus = function(pageGlobalIndex, newPageStatus)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		if (typeof(newPageStatus) == "undefined") newPageStatus = PAGESTATUS_NOT_ATTEMPTED; //pg2-ewspa, in exe page at startup is visited, 'cause nps is undefined
		p.status = newPageStatus;
		if ((p.status != PAGESTATUS_NOT_ATTEMPTED) && (p.status != PAGESTATUS_INCOMPLETE) && (p.status != 'not attempted') && (p.status != 'incomplete')) p.pageVisited = 1; //pg2-multiSCO
		for (var i = 0; i < p.interactions.length; i++) {
			var inter = p.interactions[i];
			if (inter.status == PAGESTATUS_NOT_ATTEMPTED) inter.status = newPageStatus;
		};
	};
};

UELO.prototype.setPageScore = function(gix, score)
{
	var p = this.FindPage(gix);
	if (p) {
		if (isNaN(score)) return
		p.score = score;
	};
};

UELO.prototype.setPagePassed = function(pageGlobalIndex, passed)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		p.passed = passed;
	};
};

UELO.prototype.getPagePassed = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		return p.passed;
	} else {
		return false;
	};
};

UELO.prototype.getPageVisited = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		return p.pageVisited;
	};
};

UELO.prototype.setPageVisited = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		this.setLastVisitedPage(pageGlobalIndex);
		p.pageVisited = 1;
	};
	this.setPercentCompleted();
};

UELO.prototype.setPercentCompleted = function()
{
	var allPages = this.getPagesCount(null);
	var visitedPages = this.getPagesVisitedCount('VISITED');
	var pagesC = '' + ((visitedPages * 100) / allPages);
	if (pagesC.indexOf('.') > 0) pagesC = pagesC.substr(0, pagesC.indexOf('.') + 3);
	this.percentCompleted = pagesC;
};

UELO.prototype.getPagesCount = function(pageType)
{
	var exCnt = 0;
	var infCnt = 0;
	var fullCnt = 0;
	var visCnt = 0;

	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		if (this.pages[i].visible == 0) continue;
		if (this.pages[i].pageType == PAGETYPE_EXERCISE) exCnt++;
		else infCnt++;
		fullCnt++;
	};

	if (!pageType) return fullCnt; 
	if (pageType == PAGETYPE_EXERCISE) { //pg2- "==" instead of "="
		return exCnt;
	} else {
		return infCnt;
	};
};

UELO.prototype.getPointsMax = function()
{
	if (GLOBAL_MAX_POINTS > 0) return GLOBAL_MAX_POINTS;
	var retScore = 0;
	for (var i=0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.visible == 0) continue;
		if (page.pageType == PAGETYPE_EXERCISE) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				if (inter) { //pg2
					retScore += parseInt(inter.maxScore);
				};
			};
		};
	};
	return retScore;
};

UELO.prototype.getPagesCompletedAndPassedCount = function()
{
	var visPassCnt = 0;
	var p = null;

	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up
		p = this.pages[i]; 
		if (p.visible == 0) continue;
		if ((p.pageType == PAGETYPE_INFORMATION) && (p.status == PAGESTATUS_COMPLETED)) {
			visPassCnt++;
		} else
		if ((p.pageType == PAGETYPE_EXERCISE) && (p.status == PAGESTATUS_PASSED)) {
			visPassCnt++;
		};
	};
	return visPassCnt;
};

UELO.prototype.getPagesVisitedCount = function()
{
	var visCnt = 0;

	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		if (this.pages[i].visible == 0) continue;
		if (this.pages[i].pageVisited == 1) visCnt++;
	};
	return visCnt;
};

UELO.prototype.getCourseScore = function()
{
	var retScore = 0;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.visible == 0) continue;
		if (page.pageType == PAGETYPE_EXERCISE) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				if (inter.status == PAGESTATUS_PASSED) retScore += parseInt(inter.score);
			};
		};
	};
	return retScore;
};

UELO.prototype.getPercentCourseScore = function()
{
	return parseInt((this.getCourseScore()*100) / this.getPointsMax());
};

UELO.prototype.getCourseStatus = function()
{
	if (this.getPagesCount() != this.getPagesVisitedCount()) {
		return 1;
	} else {
		return 0;
	};
};

UELO.prototype.FindPage = function(pageGlobalIndex)
{
	if (this.currentUELOPage && this.currentUELOPage.globalIndex == pageGlobalIndex) return this.currentUELOPage; //pg2-speed up
	if (parseInt(pageGlobalIndex) < 2) return null; //pg2-speed up
	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		if (this.pages[i].globalIndex == pageGlobalIndex) {
			return this.pages[i];
		};	
	};
	return null;
};

UELO.prototype.AddInteractionToPage = function(pageGlobalIndex, elementId)
{
	var iterPage = this.FindPage(pageGlobalIndex);
	if (iterPage == null) return null;
	return iterPage.AddInteraction(elementId);
};

UELO.prototype.findInteraction = function(pageGlobalIndex, elementId)
{
	var iterPage = this.FindPage(pageGlobalIndex);
	if (iterPage == null) return null;
	return iterPage.FindInteraction(elementId);
};

//String parent.UELO.setDataStringByID(int PageID;String ColumnName,String value)
UELO.prototype.GetStudentAnswer = function(pageGlobalIndex, elementId)
{
	var iterPage = this.FindPage(pageGlobalIndex);
	if (iterPage == null) return null;
	var interId = iterPage.FormatInteractionId(elementId, iterPage.globalIndex);
	var iter = iterPage.FindInteraction(interId);
	if (iter == null) return null;
	return iter.studentResponse;
};

UELO.prototype.getInteractionSolveVersion = function(pageGlobalIndex, elementId)
{
	var iterPage = this.FindPage(pageGlobalIndex);
	if (iterPage == null) return null;
	var interId = iterPage.FormatInteractionId(elementId, iterPage.globalIndex);
	var iter = iterPage.FindInteraction(interId);
	if (iter == null) return null;
	return iter.solveVersion;
};

UELO.prototype.setUELOData = function()
{
	this.endTime = new Date();
	this.sessionTime = this.getActivitySessionTime();
	//this.sessionTime = this.calculateTimeToString(this.beginTime, new Date());
};

UELO.prototype.toPollWBTSString = function()
{
    var r = "";
    r += "[UniversalElearningDataObjectHeader]\n";
    r += "Organisation=" + this.organisation + "\n";
    r += "Username=" + this.username + "\n";
    r += "Password=" + this.password + "\n";
    r += "ServerForCheckAnswers=" + this.server + "\n";
    r += "PercentCompleted=" + this.percentCompleted + "\n";
    r += "PagesCount=" + this.getPagesCount(null) + "\n";
    r += "ExercisePagesCount=" + this.getPagesCount(PAGETYPE_EXERCISE) + "\n";
    r += "PagesVisited=" + this.getPagesVisitedCount() + "\n";
    r += "PointsMax=" + this.getPointsMax() + "\n";
    r += "Points=" + this.points + "\n";
    r += "PassThreshold=" + this.passThreshold + "\n";
    r += "BeginTime=" + this.dateTimeToString(this.beginTime) + "\n";
    r += "EndTime=" + this.dateTimeToString(this.endTime) + "\n";
    r += "SessionTime=" + this.getActivitySessionTime() + "\n";
//	r += "SessionTime=" + this.calculateTimeToString(this.beginTime, this.endTime) + "\n";
    r += "KeySep=" + this.keySep + "\n";
	r += "keySep=" + this.keySep + "\n"; //pg2-new, 4 new EIS without disting. in parser between small and capital letter
    r += "userVars=" + this.getUserVars() + "\n";
    r += "lastVisitedPage=" + this.getLastVisitedPage() + "\n";
    r += "\n";
    r += "[UniversalElearningDataObjectDataFormat]" + "\n";
    r += "page_identifier" + this.keySep + "globalPageIndex"+ this.keySep + "group"+ this.keySep + "answers"+ this.keySep + "maxScore" + this.keySep + "score" + this.keySep + "tryNumber" + this.keySep + "maxTryNumber" + this.keySep + "status" + this.keySep + "pageType" + this.keySep + "correctResponsesAsText" + this.keySep + "studentResponseAsText" + "\n";
    r += "\n";
    r += "[UniversalElearningDataObjectData]" + "\n";
    
    for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
        var page = this.pages[i];
        if (page.visible == 0) continue;
        if (page.pageType == PAGETYPE_POLL) {
            for (var j = 0; j < page.interactions.length; j++) {
                var inter = page.interactions[j];
                r += page.pageId + this.keySep + page.globalIndex + this.keySep + inter.id + this.keySep + inter.studentResponse + this.keySep + inter.maxScore + this.keySep + inter.score + this.keySep + inter.tryNumber + this.keySep + inter.maxTryNumber + this.keySep + inter.status + this.keySep + PAGESTATUS_PASSED + this.keySep + inter.correctResponsesAsText + this.keySep + inter.studentResponseAsText + "\n";
            };
        };
    };
    return r;
};

UELO.prototype.toWBTSString = function()
{
	var r = "";
	r += "[UniversalElearningDataObjectHeader]\n";
	r += "Organisation=" + this.organisation + "\n";
	r += "Username=" + this.username + "\n";
	r += "Password=" + this.password + "\n";
	r += "ServerForCheckAnswers=" + this.server + "\n";
	r += "PercentCompleted=" + this.percentCompleted + "\n";
	r += "PagesCount=" + this.getPagesCount(null) + "\n";
	r += "ExercisePagesCount=" + this.getPagesCount(PAGETYPE_EXERCISE) + "\n";
	r += "PagesVisited=" + this.getPagesVisitedCount() + "\n";
	r += "PointsMax=" + this.getPointsMax() + "\n";
	r += "Points=" + this.points + "\n";
	r += "PassThreshold=" + this.passThreshold + "\n";
	r += "BeginTime=" + this.dateTimeToString(this.beginTime) + "\n";
	r += "EndTime=" + this.dateTimeToString(this.endTime) + "\n";
    r += "SessionTime=" + this.getActivitySessionTime() + "\n";
//	r += "SessionTime=" + this.calculateTimeToString(this.beginTime, this.endTime) + "\n";
	r += "KeySep=" + this.keySep + "\n";
	r += "keySep=" + this.keySep + "\n"; //pg2-new, 4 new EIS without disting. in parser between small and capital letter
	r += "userVars=" + this.getUserVars() + "\n";
	r += "lastVisitedPage=" + this.getLastVisitedPage() + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectDataFormat]" + "\n";
	r += "sco_identifier" + this.keySep + "page_identifier" + this.keySep + "globalPageIndex"+ this.keySep + "chapterName" + this.keySep + "group" + this.keySep + "question" + this.keySep + "answers"+ this.keySep + "maxScore" + this.keySep + "score" + this.keySep + "tryNumber" + this.keySep + "maxTryNumber" + this.keySep + "status" + this.keySep + "pageType" + this.keySep + "correctResponsesAsText" + this.keySep + "studentResponseAsText" + this.keySep + "marked" + this.keySep + "attempted" + this.keySep + "visible" + this.keySep + "isAssessment" + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectData]" + "\n";

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.visible == 0) continue;
		if (page.pageType == PAGETYPE_EXERCISE) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				r += uelo.scoId + this.keySep + page.pageId + this.keySep + page.globalIndex + this.keySep + quotedString(page.chapterName) + this.keySep + inter.id + this.keySep + inter.question + this.keySep + inter.studentResponse + this.keySep + inter.maxScore  + this.keySep + inter.score + this.keySep + inter.tryNumber + this.keySep + inter.maxTryNumber + this.keySep + inter.status + this.keySep + "E" + this.keySep + inter.correctResponsesAsText + this.keySep + inter.studentResponseAsText + this.keySep + page.marked + this.keySep + page.attempted + this.keySep + page.visible + this.keySep + page.isAssessment + "\n";
			};
		} else
		if (page.pageType == PAGETYPE_POLL) {
			for (var j = 0; j < page.interactions.length; j++) {
				var inter = page.interactions[j];
				r += uelo.scoId + this.keySep + page.pageId + this.keySep + page.globalIndex + this.keySep + quotedString(page.chapterName) + this.keySep + inter.id + this.keySep + inter.question + this.keySep + inter.studentResponse + this.keySep + inter.maxScore  + this.keySep + inter.score + this.keySep + inter.tryNumber + this.keySep + inter.maxTryNumber + this.keySep + inter.status + this.keySep + PAGESTATUS_PASSED + this.keySep + inter.correctResponsesAsText + this.keySep + inter.studentResponseAsText + this.keySep + page.marked + this.keySep + page.attempted + this.keySep + page.visible + this.keySep + page.isAssessment + "\n";
			}
		} else {
			//var pStatus="N";
			r += uelo.scoId + this.keySep + page.pageId + this.keySep + page.globalIndex + this.keySep + quotedString(page.chapterName) + this.keySep + this.keySep + this.keySep + this.keySep+ "1" + this.keySep + "0" + this.keySep + "0" + this.keySep + "0" + this.keySep + page.status + this.keySep + PAGESTATUS_INCOMPLETE + this.keySep + "" + this.keySep + "" + this.keySep + page.marked + this.keySep + page.attempted + this.keySep + page.visible + this.keySep + page.isAssessment + "\n";
		};
			//page.add
	};
	r += "\n" + this.getYellowCardsToWBTSString();
	r += "\n" + this.getNotepadToWBTSString();
	r += "\n" + this.getMarkersToWBTSString();
	return r;
};

UELO.prototype.toFullString = function()
{
	var r = "";
	r += "[UniversalElearningDataObjectHeader]\n";
	r += "ScoId=" + this.scoId + "\n";
	r += "CourseName=" + this.courseName + "\n";
	r += "CourseDescription=" + this.courseDescription + "\n";
	r += "Organisation=" + this.organisation + "\n";
	r += "Username=" + this.username + "\n";
	r += "Password=" + this.password + "\n";
	r += "ServerForCheckAnswers=" + this.server + "\n";
	r += "PercentCompleted=" + this.percentCompleted + "\n";
	r += "PagesCount=" + this.getPagesCount(null) + "\n";
	r += "ExercisePagesCount=" + this.getPagesCount(PAGETYPE_EXERCISE) + "\n";
	r += "PagesVisited=" + this.getPagesVisitedCount() + "\n";
	r += "PointsMax=" + this.getPointsMax() + "\n";
	r += "Points=" + this.points + "\n";
	r += "PassThreshold=" + this.passThreshold + "\n";
	r += "BeginTime=" + this.dateTimeToString(this.beginTime) + "\n";
	r += "EndTime=" + this.dateTimeToString(this.endTime) + "\n";
    r += "SessionTime=" + this.getActivitySessionTime() + "\n";
//	r += "SessionTime=" + this.calculateTimeToString(this.beginTime, this.endTime) + "\n";
	r += "KeySep=" + this.keySep + "\n";
	r += "keySep=" + this.keySep + "\n"; //pg2-new, 4 new EIS without disting. in parser between small and capital letter
	r += "userVars=" + this.getUserVars() + "\n";
	r += "lastVisitedPage=" + this.getLastVisitedPage() + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectDataFormat]" + "\n";
	r += "sco_identifier" + this.keySep + "page_identifier" + this.keySep + "globalPageIndex" + this.keySep + "group" + this.keySep + "question" + this.keySep + "answers" + this.keySep + "maxScore" + this.keySep + "score" + this.keySep + "status" + this.keySep + "pageType" + this.keySep + "correctResponsesAsText" + this.keySep + "studentResponseAsText"+ this.keySep + "marked" + this.keySep + "attempted" + "\n";
	r += "\n";
	r += "[UniversalElearningDataObjectData]" + "\n";

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		r += "\n";
		r += "[UniversalElearningDataObjectDataPage]" + "\n";
		r += page.pageId + this.keySep + page.scoId+ this.keySep + page.type+ this.keySep + page.pageType+ this.keySep + page.status+ this.keySep + page.title+ this.keySep + page.globalIndex+ this.keySep + page.marked+ + this.keySep + page.attempted + "\n";
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];
			r += "    [UniversalElearningDataObjectDataPageInteraction]" + "\n";
			r += "    "+inter.id + this.keySep + inter.correctResponses + this.keySep + inter.studentResponse + this.keySep + inter.time + this.keySep + inter.type + this.keySep + inter.weighting + this.keySep + inter.status + this.keySep + inter.result + this.keySep + inter.maxScore + this.keySep + inter.score + this.keySep + inter.question + this.keySep + inter.latency + this.keySep + inter.correctResponsesAsText + this.keySep + inter.studentResponseAsText + "\n";
		};
	};
	return r;
};

// To jest metoda ktora tlumaczy z formatu UELO do normy HACP
// generalnie CUDA na KIJU ;) tam sie dzieja
var _CORRECT_RESPONSES = 1;
var _STUDENT_RESPONSE = 2;
var _EXAM_STUDENT_RESPONSE = 3;

UELO.prototype.formatResponseToHACPFormat = function(mode, inter)
{
	var s = "";
	if (mode == _CORRECT_RESPONSES) {
		s = inter.correctResponses;
	} else
	if (mode == _STUDENT_RESPONSE) {
		s = inter.studentResponse;
	} else {
		return null;
	};

	var type = inter.type.toLowerCase();
	if (typeof(s) == "string" && type == "choice") {
		var r = s;
		if (s.indexOf("||") > -1) {
			var arr = s.split("||");
		} else {
			var arr = s.split(":");
		};
		if (arr.length > 1) {
			var r = "{";
			for (var i = 0; i < arr.length; i++) {
				if (arr[i] == "1") {
					if (r.length > 1) r += ",";
					r += String.fromCharCode(97 + i);
				};
			};
			r += "}";
		};
		return r;
	} else
	if (type == "numeric") {
		// sa takie przypadki ze komponent przedstawia sie jako "numeric"
		// a dane dostaracza takie jak "choice" - aw
		if (typeof(s) == "string") {
			var arr = new Array();
			if (s.indexOf("||") > -1) var arr = s.split("||"); else
			if (s.indexOf(":") > -1) var arr = s.split(":");
			if (arr.length > 0) {
				var r = "";
				for (var i = 0; i < arr.length; i++) {
					if (arr[i] == "1") {
						return "" + i;
					};
				};
			};
			return s;
		};
		return s.toString();
	} else
	if (type == "fill-in") {
		s = s.replace(/\|\|/gi, "; ");
		return s;
	} else
	if (type == "matching") {
		var calc = new UELODDCalculator();
		var res = "";
		if (mode == _CORRECT_RESPONSES) {
			res = calc.transformToPermutation(inter.correctResponses, inter.correctResponses, inter.all_possible);
		} else
		if (mode == _STUDENT_RESPONSE) {
			res = calc.transform(inter.correctResponses, inter.studentResponse, inter.all_possible);
		};
		return res;
	};
	return s;
};

UELO.prototype.toHACPInteractionsString = function(course_id, student_id, lesson_id)
{
	var r = "";
	var d = new Date();
	r += '"course_id","student_id","lesson_id","date","time","interaction_id","objective_id","type_interaction","correct_response","student_response","result","weighting","latency"\n';
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];
			r += '"' + course_id + '"'; //course_id
			r += ',"'+ student_id +'"'; //student_id
			r += ',"0"'; //lesson_id
			r += ',"'+this.dateToString(d, "/")+'"'; // date
			r += ',"'+this.timeToString(d)+'"'; // time
			r += ',"p_' + i + '_e_' + j + '"'; // interaction_id  -> r += ',"'+inter.id+'"'; // interaction_id
			r += ',""'; // objective_id
			r += ',"'+inter.type+'"'; // type_interaction
			r += ',"'+this.formatResponseToHACPFormat(_CORRECT_RESPONSES, inter)+'"'; // correct_response
			r += ',"'+this.formatResponseToHACPFormat(_STUDENT_RESPONSE, inter)+'"'; // student_response
			r += ',"'+((inter.result == true)?"c":"w")+'"'; // result
			r += ',"1.0"'; // weighting
			r += ',"'+((inter.latency == null)?"00:00:00":inter.latency)+'"'; // latency
			r += '\n';
		};
	};
	return r;
};

UELO.prototype.formatResponseToSCORM12Format = function(mode, inter)
{
	var s = "";
	if (mode == _CORRECT_RESPONSES) {
		s = inter.correctResponses;
	} else
	if (mode == _STUDENT_RESPONSE) {
		s = inter.studentResponse;
	} else {
		return null;
	};

	var type = inter.type.toLowerCase();
	if (typeof(s) == "string" && type == "choice") {
		var isGroup = false;
		if (s.indexOf("||") > -1) var arr = s.split("||"); else
		if (s.indexOf(":") > -1) {
			isGroup = true;
			var arr = s.split(":");
		} else {
			return s;
		};
		//zakres do 18, w przeciwnym wypadku uzyc performance
		var r = "";
		if (arr.length > 18) {
			this.changelistner = "type,performance";
			for (var i = 0; i < arr.length; i++) {
				r += arr[i];
			};
		} else {
			for (var i = 0; i < arr.length; i++) {
				if (r != "") r += ",";
				//r += i + "_" + arr[i];
				if (arr[i] == 0) r += getIdentiefier09az(i);
				else r += getIdentiefier09az(i + 18);
			};
			r = ((isGroup && r.indexOf(",") > -1) ? "{" + r + "}" : r);
		};
		return r;
	} else
	if (type == "numeric") {
		// sa takie przypadki ze komponent przedstawia sie jako "numeric"
		// a dane dostaracza takie jak "choice" - aw
		if (inter.id.indexOf("DDBasket") > -1) {
			if (mode == _CORRECT_RESPONSES) {
				return "1";
			} else {
				return (inter.result) ? "1" : "0";
			};
		};

		var res = s;
		if (typeof(s) == "string") {
			var arr = new Array();
			if (s.indexOf("||") > -1) var arr = s.split("||"); else
			if (s.indexOf(":") > -1) var arr = s.split(":");
			if (arr.length > 0) {
				var r = "";
				for (var i = 0; i < arr.length; i++) {
					if (arr[i] == "1") {
						res = "" + i;
						break;
					};
				};
			};
		};
		return res;
	} else
	if (type == "fill-in") {
		s = s.replace(/\|\|/gi, ",");
		return s;
	} else
	if (type == "matching") {
		if (inter.id.indexOf("DDBasket") > -1) {
			var calc = new UELODDCalculator();
			var res = "";
			var icr = inter.correctResponses.replace(/,/gi, ":");
			if (icr.indexOf(":") == -1) icr = icr.replace(/\|/gi, ":");
			var isr = inter.studentResponse.replace(/,/gi, ":");
			if (mode == _CORRECT_RESPONSES) {
				res = calc.transformToPermutation(icr, icr, inter.all_possible);
			} else
			if (mode == _STUDENT_RESPONSE) {
				res = calc.transform(icr, isr, inter.all_possible);
			};
			return res;
		} else {
			if (typeof(s) == "string") {
				var isGroup = false;
				if (s.indexOf("||") > -1) {
					var arr = s.split("||");
				} else {
					isGroup = true;
					var arr = s.split(":");
				};
				var r = "";
				for (var i = 0; i < arr.length; i++) {
					if (r != "") r += ",";
					//r += inter.elementId + "." + arr[i];
					r += getIdentiefier09az(inter.gix) + "." + getIdentiefier09az(arr[i]);
				};
				if (r == "") {
					//r = inter.elementId + "." + s;
					r += getIdentiefier09az(inter.gix) + "." + getIdentiefier09az(s);
				};
				r = ((isGroup && r.indexOf(",") > -1) ? "{" + r + "}" : r);
				return r;
			} else
			if (typeof(s) == "number") {
				//return inter.elementId + "." + s;
				return getIdentiefier09az(inter.gix) + "." + getIdentiefier09az(s);
			};
		};
	};
	return s;
};

UELO.prototype.getSCORM12Interactions = function()
{
	var result = {};
	var counter = 0;

	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];

			if (inter.latency == null || inter.latency == "" || inter.timestamp == null || inter.timestamp == "") continue;

			var interId = "p_" + page.globalIndex + "_e_" + j;

			result[interId] = {};
			result[interId]["id"] = interId;
			result[interId]["number"] = counter;
			result[interId]["time"] = formatTime("time", inter.timestamp);
			result[interId]["type"] = inter.type;
			result[interId]["question"] = inter.question;
			result[interId]["elementId"] = inter.elementId;
			result[interId]["pageGlobalIndex"] = page.globalIndex;

			var latencyArr = ((inter.latency) ? inter.latency : "00:00:00").split(":");
			var date = formatTime("time", new Date(this.beginTime.getFullYear(), this.beginTime.getMonth(),
				this.beginTime.getDate(), latencyArr[0], latencyArr[1], latencyArr[2]));

			result[interId]["latency"] = date;
			result[interId]["result"] = (inter.correctResponses == "") ? "neutral" : ((inter.result == true) ? "correct" : "wrong");
			result[interId]["weighting"] = (inter.weighting && inter.weighting != "") ? inter.weighting : "1.0"; //inter.weighting

			this.changelistner = "";

			var studentResponse = this.formatResponseToSCORM12Format(_STUDENT_RESPONSE, inter); //pg2
			if (typeof(studentResponse) == 'string') studentResponse = studentResponse.replace(new RegExp('"', "g"), "'"); //pg2-only in case of 'string'
			result[interId]["student_response"] = studentResponse;
			
			result[interId]["correct_responses"] = new Array();
			var correctResponses = this.formatResponseToSCORM12Format(_CORRECT_RESPONSES, inter); //pg2
			if (typeof(studentResponse) == 'string') correctResponses = correctResponses.replace(new RegExp('"', "g"), "'"); //pg2-only in case of 'string'
			result[interId]["correct_responses"][0] = correctResponses;

			if (this.changelistner != "") {
				var arr = this.changelistner.split(",");
				if (arr[0] == "type") {
					result[interId]["type"] = arr[1];
				};
			};
			counter++;
		};
	};
	return result;
};

UELO.prototype.getPollInteractions = function()
{
	var result = {};
	var counter = 0;

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];

			if (inter.latency == null || inter.latency == ""
				|| inter.timestamp == null || inter.timestamp == "") continue;

			var interId = "p_" + page.globalIndex + "_e_" + j;

			result[interId] = {};
			result[interId]["id"] = interId;
			result[interId]["number"] = counter;
			result[interId]["time"] = formatTime("time", inter.timestamp);
			result[interId]["type"] = inter.type;
			result[interId]["question"] = inter.question;
			result[interId]["elementId"] = inter.elementId;
			result[interId]["pageGlobalIndex"] = page.globalIndex;

			var latencyArr = ((inter.latency) ? inter.latency : "00:00:00").split(":");
			var date = formatTime("time", new Date(this.beginTime.getFullYear(), this.beginTime.getMonth(),
				this.beginTime.getDate(), latencyArr[0], latencyArr[1], latencyArr[2]));

			result[interId]["latency"] = date;
			result[interId]["result"] = (inter.correctResponses == "") ? "neutral" : ((inter.result == true) ? "correct" : "wrong");
			result[interId]["weighting"] = (inter.weighting && inter.weighting != "") ? inter.weighting : "1.0"; //inter.weighting

			this.changelistner = "";

			//pg2-eis_raport_statistics
			var studentResponse = inter.studentResponseAsText.toString();
			var studentResponseArr = studentResponse.split('||');
			var notAllowedChars = new Array(',', ';', "'", '@', ':', '~', '#', '!', '$', '%', '^', '&', '`', '"');
			var replaceWith = '_';
			for (var l=0; l<studentResponseArr.length; l++) {
				var str = studentResponseArr[l];
				for (var k=0; k<notAllowedChars.length; k++) {
					while (str.indexOf(notAllowedChars[k]) > -1) str = str.replace(notAllowedChars[k], replaceWith); //str = str.replace(new RegExp(notAllowedChars[k], "g"), replaceWith);
				};
				studentResponseArr[l] = str;
			};
			delete notAllowedChars;
			studentResponse = '';
			for (var l=0; l<studentResponseArr.length; l++) {
				studentResponse += (studentResponse!=''?'||':'') + studentResponseArr[l];
			};
			studentResponse = studentResponse.replace(/\|\|/g, ",");
			result[interId]["student_response"] = studentResponse;
			//----

			if (this.changelistner != "") {
				var arr = this.changelistner.split(",");
				if (arr[0] == "type") {
					result[interId]["type"] = arr[1];
				};
			};
			counter++;
		};
	};
	return result;
};

UELO.prototype.interactionsCount = function()
{
	var result = 0;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];
			if (inter.latency == null || inter.latency == "" || inter.timestamp == null || inter.timestamp == "") continue;
			result++;
		};
	};
	return result;
};

UELO.prototype.interactionsExists = function()
{
	var result = false;
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.interactions.length > 0) {
			result = true;
			break;
		};
	};
	return result;
};

UELO.prototype.formatResponseToSCORM13Format = function(mode, inter)
{
//jezeli exam to wysylamy core i stud po numeric
//zablokowac w exam struct
	var s = "";
	if (mode == _CORRECT_RESPONSES) {
		s = inter.correctResponsesAsText;
	} else
	if (mode == _STUDENT_RESPONSE) {
		s = inter.studentResponseAsText;
	} else
	if (mode == _EXAM_STUDENT_RESPONSE) {
		return inter.studentResponse;
	} else {
		return null;
	};
	s = s.toString().replace(/%20/gi, "_");
	//s = unescape(s); //pg2-removed, look below
	var type = inter.type.toLowerCase();
	if (type != "choice" && type != "fill-in") { //pg2
		s = unescape(s);
	};
	if (type == "choice") {
		var sTmp = s.replace(new RegExp(' ', "g"), '[,]'); //pg2-some components returns separated with spaces ' ' -then take it as first way, otherwise, start
		if (sTmp.indexOf('[,]') > -1) {
			sTmp = unescape(sTmp); //*
			sTmp = sTmp.replace(new RegExp(':', "g"), '-'); //pg2- ":" is not allowed
			return sTmp;
		} else
		if (s.indexOf("||") > -1) {
			var arr = s.split("||");
		} else
		if (s.indexOf(":") > -1) {
			var arr = s.split(":");
		} else
		if (s.indexOf("|") > -1) {
			var arr = s.split("|");
		} else {
			//s = s.replace(new RegExp(' ', "g"), '[,]'); //pg2-instead of spaces, should be "[,]" -line required 'cause the block below will be skipped //pg2-removed- now it begins this block
			s = unescape(s);
			s = s.replace(new RegExp(':', "g"), '-');
			return s;
		};
		var r = "";
		for (var i = 0; i < arr.length; i++) {
			if (r != "") r += "[,]";
			r += unescape(arr[i]).replace(new RegExp(':', "g"), '-'); //pg2-instead of 'arr[i]'
		};
		return r;
	} else
	if (type == "fill-in") {
		s = s.replace(new RegExp('%3A', 'g'), '-'); //pg2-first we must replace escaped ":" with "-", 'cause in this string there are additional (not encoded) ":" as separators
		s = unescape(s);
		if (s.indexOf("||") > -1) {
			s = s.replace(/\|\|/gi, "[,]");
		} else
		if (s.indexOf(":") > -1) {
			s = s.replace(/:/gi, "[,]");
		} else
		if (s.indexOf("|") > -1) {
			s = s.replace(/\|/gi, "[,]");
		};
		return s;
	} else
	if (type == "matching") {
		if (s.indexOf("||") > -1) var arr = s.split("||"); else
		if (s.indexOf(":") > -1) var arr = s.split(":"); else var arr = new Array(s);
		var r = "";
		for (var k in arr) {
			if (r != "") r += "[,]";
			if (arr[k] != "") { //pg2-if user's answer was empty...
				r += inter.elementId + "[.]" + arr[k];
			};
		};
		return r;
	};
	return s;
};

UELO.prototype.getWBTExamInteractions = function()
{
	var result = {};
	var counter = 0;

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];

			if (inter.latency == null || inter.latency == "" || inter.timestamp == null || inter.timestamp == "") continue;

			var interId = "p_" + page.globalIndex + "_e_" + j;
			var learnerResponse = this.formatResponseToSCORM13Format(_EXAM_STUDENT_RESPONSE, inter);

			result[interId] = {};
			result[interId]["id"] = interId;
			result[interId]["number"] = counter;
			result[interId]["timestamp"] = formatTime("timestamp", inter.timestamp);
			result[interId]["type"] = inter.type;
			result[interId]["description"] = inter.question;

			var latencyArr = ((inter.latency) ? inter.latency : "00:00:00").split(":");
			var date = formatTime("timeinterval", new Date(this.beginTime.getFullYear(), this.beginTime.getMonth(),
				this.beginTime.getDate(), latencyArr[0], latencyArr[1], latencyArr[2]));
			result[interId]["latency"] = date;
			result[interId]["learner_response"] = learnerResponse;
			
			result[interId]["correct_response_text"] = unescape(inter.correctResponsesAsText); //pg2-upc_exam_inter //unescape, bo z 'u' kreskowanym w 2nd strone jest problem
			result[interId]["learner_response_text"] = unescape(inter.studentResponseAsText);

			counter++;
		};
	};
	return result;
};

UELO.prototype.getSCORM13Interactions = function()
{
	var result = {};
	var counter = 0;

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];

			if (inter.latency == null || inter.latency == "" || inter.timestamp == null || inter.timestamp == "") continue;

			var interId = "p_" + page.globalIndex + "_e_" + j;
			var learnerResponse = this.formatResponseToSCORM13Format(_STUDENT_RESPONSE, inter);
			if (typeof(learnerResponse) == 'string') learnerResponse = learnerResponse.replace(new RegExp('"', "g"), "'"); //pg2
			var correctResponses = this.formatResponseToSCORM13Format(_CORRECT_RESPONSES, inter);
			if (typeof(correctResponses) == 'string') correctResponses = correctResponses.replace(new RegExp('"', "g"), "'"); //pg2

			result[interId] = {};
			result[interId]["id"] = interId;
			result[interId]["number"] = counter;
			result[interId]["timestamp"] = formatTime("timestamp", inter.timestamp);
			result[interId]["type"] = inter.type;
			result[interId]["description"] = inter.question;

			var latencyArr = ((inter.latency) ? inter.latency : "00:00:00").split(":");
			var date = formatTime("timeinterval", new Date(this.beginTime.getFullYear(), this.beginTime.getMonth(),
				this.beginTime.getDate(), latencyArr[0], latencyArr[1], latencyArr[2]));

			result[interId]["latency"] = date;
			result[interId]["result"] = (inter.result == true) ? "correct" : "incorrect";
			result[interId]["weighting"] = (inter.weighting && inter.weighting != "") ? inter.weighting : "1.0"; //inter.weighting
			result[interId]["learner_response"] = learnerResponse;

			result[interId]["correct_responses"] = new Array();
			result[interId]["correct_responses"][0] = correctResponses;
			counter++;
		};
	};
	return result;
};

UELO.prototype.resetInteractions = function()
{
	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];
			inter.latency = null;
			inter.timestamp = null;
		};
	};
};

UELO.prototype.getInteractions = function(platform)
{
	switch (platform) {
		case "SCORM12": 
			return this.getSCORM12Interactions();
			break;
		case "SCORM13": 
			return this.getSCORM13Interactions();
			break;
		case "WBTEXAM": 
			return this.getWBTExamInteractions();
			break;
		case "POLL": 
			return this.getPollInteractions();
			break;
	};
};

UELO.prototype.getActivitySessionTime = function()
{
	//tools.js
	return calculateTimeIntToString(player.activityTime);
};

UELO.prototype.calculateTimeToString = function(dateStart, dateEnd)
{
	//tools.js
	return calculateTimeToString(dateStart, dateEnd);
};

UELO.prototype.timeToString = function(date)
{
	//tools.js
	return formatTime("time", date);
};

UELO.prototype.dateToString = function(date, separator)
{
	//tools.js
	return formatTime("date", date, separator);
};
UELO.prototype.dateTimeToString = function(date)
{
	//tools.js
	return formatTime("datetime", date, "-");
};

UELO.prototype.stringToDate = function(s)
{
	//tools.js
	return stringToDate(s);
};

UELO.prototype.toString = function()
{
	return "";//this.toFullString();
};

UELO.prototype.__parseFindGroup = function(a, name)
{
	var key = new RegExp("^\\[" + name + "\\]$", "i");
	for (var i = 0; i < a.length; i++) {
		if (a[i].match(key)) {
			return i;
		};
	};
	return null;
};

UELO.prototype.loadFromString = function(s)
{
	s = s.replace(new RegExp("\r", "g"), "");
	var lines = s.split("\n");
	//header
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectHeader");
	if (index == null) {
		return;
	};

	var i = index;
	while (i++ < lines.length - 1) {
		var p = lines[i].indexOf("=");
		if (p > 0) {
			var key = lines[i].slice(0, p);
			var value = lines[i].slice(p + 1);
			this.setHeaderString(key, value);
		} else {
			break;
		};
	};

	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectDataFormat");
	if (index == null) {
		return;
	};

	var keyMatrix = lines[index + 1].split(this.keySep);
	var gpi = -1; // globalPageIndex
	var eii = -1;  // elementIdIndex
	var dataPageType = -1; // pageType
	var dataPageId = -1; // pageId
	for (var j = 0; j < keyMatrix.length; j++) {
		if (keyMatrix[j].match(new RegExp("^globalPageIndex$", "gi"))) {
			gpi = j;
		}
		if (keyMatrix[j].match(new RegExp("^group$", "gi"))) {
			eii = j;
		}
		if (keyMatrix[j].match(new RegExp("^pageType$", "gi"))) {
			dataPageType = j;
		}
		if (keyMatrix[j].match(new RegExp("^page_identifier$", "gi"))) {
			dataPageId = j;
		};
	};
	if (gpi == -1 || eii == -1) {
		return;
	};
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectData");
	if (index == null) {
		return;
	};
	var i = index;
	while (i++ < lines.length - 1) {
		var data = lines[i].split(this.keySep);
		if (data.length == keyMatrix.length) {
			var o = this.findInteraction(data[gpi], data[eii]);
			var ueloPage = this.FindPage(data[gpi]);
			if (!o) { 
				//var ueloPage = this.FindPage(data[gpi]);
				if (!ueloPage) { 
					ueloPage = this.AddPage();
					ueloPage.type = 0;
					if (data[dataPageType].indexOf('E') >= 0) {
						ueloPage.pageType = PAGETYPE_EXERCISE;
					} else
					if (data[dataPageType].indexOf('P') >= 0) {
						ueloPage.pageType = PAGETYPE_POLL;
					} else {
						ueloPage.pageType = PAGETYPE_INFORMATION;
					};
					ueloPage.pageId = data[dataPageId];
					ueloPage.globalIndex = data[gpi];
					if ((ueloPage.pageType == PAGETYPE_EXERCISE) || (ueloPage.pageType == PAGETYPE_POLL)) {
						o = ueloPage.interactions[ueloPage.interactions.length] = new UELOInteractions();
					} else {
						//
					};
				};
				if (ueloPage) {
					//o = ueloPage.interactions[ueloPage.interactions.length] = new UELOInteractions();
				};
			} else {
				//alert('Wrong data!!!: '+data);
			};

			if (ueloPage) {
				for (var j = 0; j < keyMatrix.length; j++) {
					if (j != gpi && j != eii && j != dataPageType) {
						ueloPage.setValue(keyMatrix[j], data[j]);
					};
				};		
			};

			if (o) {
				for (var j = 0; j < keyMatrix.length; j++) {
					if (j != gpi) {
						o.setValue(keyMatrix[j], data[j]);
					};
				};
			};
		};
	};
	this.loadYellowCardsFromString(s);
	this.loadNotepadFromString(s);
	this.loadMarkersToWBTSString(s);
};

UELO.prototype.getChapters = function()
{
	var chapters = new Array();
	var chapterPageName = "";
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var p = this.pages[i];
		if (chapterPageName != p.chapterName) {
			if (this.courseName != p.chapterName) {
				chapters[chapters.length] = p.chapterName;
			};
			chapterPageName = p.chapterName;
		};
	};
	return chapters;
};

UELO.prototype.getPagesInChapter = function(chName)
{
	var chapterPages = new Array();
	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var p = this.pages[i];
		if (p.chapterName == chName) {
			if (this.courseName != p.chapterName) {
				chapterPages[chapterPages.length] = p.globalIndex;
			};
		};
	};
	return chapterPages;
};

UELO.prototype.getUserVars = function()
{
	return this.userVars;
};

UELO.prototype.setUserVars = function(uVars)
{
	this.userVars = uVars;
};

UELO.prototype.clearInteractions = function()
{
	this.username = "";
	this.password = "";
	this.organisation = "";
	this.server = "";
	this.percentCompleted = "";
	this.pagesVisited = 0;
	this.points = 0;
	this.beginTime = new Date();
	this.endTime = new Date();
	this.sessionTime = 0;
	this.userVars = "";
	this.lastVisitedPage = 0;

	for (var i = 0; i < this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		page.status = PAGESTATUS_NOT_ATTEMPTED;
		page.pageVisited = 0;
		page.userAnswer = "";
		for (var j = 0; j < page.interactions.length; j++) {
			var inter = page.interactions[j];
			inter.studentResponse = "";
			inter.studentResponseAsText = "";
			inter.time = "";
			inter.timestamp = null;
			inter.status = PAGESTATUS_NOT_ATTEMPTED;
			inter.result = "";
			inter.score = 0;
			inter.latency = null;
			inter.tryNumber=0;
		};
	};
};

UELO.prototype.getDate = function()
{
	return new Date();
};

UELO.prototype.getYellowCardsToWBTSString = function()
{
	var r = "";
	r += "[UniversalElearningDataObjectYellowCardsHeader]\n";
	r += "[UniversalElearningDataObjectYellowCardsDataFormat]\n";
	r += "globalPageIndex" + this.keySep + "cardId"+ this.keySep + "date" + this.keySep + "cardType" + this.keySep + "left" + this.keySep + "top" + this.keySep + "author" + this.keySep + "title" + this.keySep + "note" + this.keySep + "isMaximalize" + this.keySep + "personGraphic" + this.keySep + "clockGraphic" + this.keySep + "buttonAdd" + this.keySep + "showUserName" +this.keySep + "pageName" + this.keySep + "pageGI" + "\n";
	r += "[UniversalElearningDataObjectYellowCardsData]\n";
	var yellowCardAppear = false;

	for (var i = 0; i < this.pagesCount; i++) { //this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.yellowCards.length > 0) {
			yellowCardAppear = true;
			for (var j = 0; j < page.yellowCards.length; j++) {
				var yellowCard = page.yellowCards[j];
				if (yellowCard && yellowCard.id.indexOf('__yc__') > -1) {
					r += page.globalIndex + this.keySep;
					r += yellowCard.id + this.keySep;
					r += yellowCard.date + this.keySep;
					r += yellowCard.cardType + this.keySep;
					r += yellowCard.left + this.keySep;
					r += yellowCard.top + this.keySep;
					r += yellowCard.author + this.keySep;
					r += yellowCard.title + this.keySep;
					r += yellowCard.note + this.keySep;
					r += yellowCard.isMaximalize + this.keySep;
					r += yellowCard.personGraphic + this.keySep;
					r += yellowCard.clockGraphic + this.keySep;
					r += yellowCard.buttonAdd + this.keySep;
					r += yellowCard.showUserName + this.keySep;
					r += yellowCard.pageName + this.keySep;
					r += yellowCard.pageGI;
					r += "\n";
				};
			};
		};
	};
	if (yellowCardAppear) {
		return r;
	} else {
		return "";
	};
};

UELO.prototype.loadYellowCardsFromString = function(s)
{
	//s = s.replace(new RegExp("\r", "g"), "");
	var lines = s.split("\n");
	//header
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectYellowCardsHeader");
	if (index == null) {
		return;
	};
	//add a header functionality here if needed
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectYellowCardsDataFormat");
	if (index == null) {
		return;
	};
	//add a data format functionality here if needed
	var keyMatrix = lines[index + 1].split(this.keySep);
	var gpi = -1; // globalPageIndex
	var eii = -1;  // elementIdIndex
	for (var j = 0; j < keyMatrix.length; j++) {
		if (keyMatrix[j].match(new RegExp("^globalPageIndex$", "gi"))) {
			gpi = j;
		};
		if (keyMatrix[j].match(new RegExp("^cardId$", "gi"))) {
			eii = j;
		};		
	};
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectYellowCardsData");
	if (index == null) {
		return;
	};
	var i = index;
	while (i++ < lines.length - 1) {
		var data = lines[i].split(this.keySep);
		if (data.length == keyMatrix.length) {
			var ueloPage = this.FindPage(data[gpi]);
			if (ueloPage) {
				var yellowCard = ueloPage.yellowCards[ueloPage.yellowCards.length] = new UELOYellowCard();
				for (var j = 0; j < keyMatrix.length; j++) {
					yellowCard.setValue(keyMatrix[j], data[j]);
				};
			};
		};
	};
};

UELO.prototype.getMarkersToWBTSString = function(s)
{
	var r = "";
	r += "[UniversalElearningDataObjectMarkersHeader]\n";
	r += "[UniversalElearningDataObjectMarkersDataFormat]\n";
	r += "globalPageIndex" + this.keySep + "values\n";
	r += "[UniversalElearningDataObjectMarkersData]\n";
	var markersAppear = false;

	for (var i=0; i<this.pagesCount; i++) { // this.pages.length; i++) { //pg2-speed up 2
		var page = this.pages[i];
		if (page.userMarkers != "") {
			markersAppear = true;
			r += page.globalIndex + this.keySep;
			r += page.userMarkers;
			r += "\n";
		};
	};
	if (markersAppear) {
		return r;
	} else {
		return "";
	};
};

UELO.prototype.loadMarkersToWBTSString = function(s)
{
	var lines = s.split("\n");
	//header
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectMarkersHeader");
	if (index == null) {
		return;
	};
	//add a header functionality here if needed
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectMarkersDataFormat");
	if (index == null) {
		return;
	};
	//add a data format functionality here if needed
	var keyMatrix = lines[index + 1].split(this.keySep);
	var gpi = -1; // globalPageIndex
	var eii = -1;  // elementIdIndex
	for (var j = 0; j < keyMatrix.length; j++) {
		if (keyMatrix[j].match(new RegExp("^globalPageIndex$", "gi"))) {
			gpi = j;
		};
		if (keyMatrix[j].match(new RegExp("^values$", "gi"))) {
			eii = j;
		};	
	};
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectMarkersData");
	if (index == null) {
		return;
	};
	var i = index;
	while (i++ < lines.length - 1) {
		var data = lines[i].split(this.keySep);
		if (data.length == keyMatrix.length) {
			var page = this.FindPage(data[gpi]);
			if (page) {
				page.userMarkers = data[eii];
			};
		};
	};
};

UELONotepad = function()
{
	this.id = "";
	this.note = "";
};

UELO.prototype.fillNotepad = function(params)
{
	if (typeof(params) != "undefined" && params != "") {
		var paramsArr = params.split(",");

		for (var i=0; i<paramsArr.length; i++) {
			if (paramsArr[i] != "") {
				var itemAttr = paramsArr[i].split(";");
				this.AddNotepad("__np__" + i, unescape(itemAttr[1]));
			};
		};
	};
};

UELO.prototype.addNotepad = function(id, note)
{
	var npd = this.findNotepad(id);
	if (npd == null && id != "") {
		npd = this.notepad[this.notepad.length] = new UELONotepad();
		npd.id = id;
		npd.note = escape(note);
	};
	return npd;
};

UELO.prototype.updateNotepad = function(id,note)
{
	var npd = this.findNotepad(id);
	if (npd) {
		npd.note = escape(note);
		return true;
	};
	return false;
};

UELO.prototype.deleteNotepad = function(id)
{
	for (var i = 0; i < this.notepad.length; i++) {
		var npd = this.notepad[i];
		if (npd && npd.id == id) {
			this.notepad[i] = null;
			return true;
		};
	};
	return false;
};

UELO.prototype.findNotepad = function(id)
{
	for (var i = 0; i < this.notepad.length; i++) {
		var npd = this.notepad[i];
		if (npd && npd.id == id) {
			return npd;
		};
	};
	return null;
};

UELO.prototype.getNotepadToWBTSString = function()
{
	var r = "";
	r += "[UniversalElearningDataObjectNotepadHeader]\n";
	r += "[UniversalElearningDataObjectNotepadDataFormat]\n";
	r += "notepadId"+ this.keySep + "note" + "\n";
	r += "[UniversalElearningDataObjectNotepadData]\n";
	var noteAppear = false;

	if (this.notepad.length > 0) {
		noteAppear = true;
		for (var j = 0; j < this.notepad.length; j++) {
			var npd = this.notepad[j];
			r += npd.id + this.keySep;
			r += npd.note;
			r += "\n";
		};
	};
	if (noteAppear) {
		return r;
	} else {
		return "";
	};
};

UELO.prototype.loadNotepadFromString = function(s)
{
	//s = s.replace(new RegExp("\r", "g"), "");
	var lines = s.split("\n");
	//header
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectNotepadHeader");
	if (index == null) {
		return;
	};
	//add a header functionality here if needed
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectNotepadDataFormat");
	if (index == null) {
		return;
	};
	//add a data format functionality here if needed
	var keyMatrix = lines[index + 1].split(this.keySep);
	var gpi = -1; // globalPageIndex
	var eii = -1;  // elementIdIndex
	for (var j = 0; j < keyMatrix.length; j++) {
		if (keyMatrix[j].match(new RegExp("^globalPageIndex$", "gi"))) {
			gpi = j;
		};
		if (keyMatrix[j].match(new RegExp("^notepadId$", "gi"))) {
			eii = j;
		};		
	};
	var index = this.__parseFindGroup(lines, "UniversalElearningDataObjectNotepadData");
	if (index == null) {
		return;
	};
	var i = index;
	while (i++ < lines.length - 1) {
		var data = lines[i].split(this.keySep);
		if (data.length == keyMatrix.length) {
			var npd = this.notepad[this.notepad.length] = new UELONotepad();
			for (var j = 0; j < keyMatrix.length; j++) {
				npd.setValue(keyMatrix[j], data[j]);
			};
		};
	};
};

UELONotepad.prototype.setValue = function(name, value)
{
	// wyjatki do poprawienie i ujednolicenia
	if (name == "notepadId") name = "id";
	if (typeof(this[name]) == "undefined") return;
	if (typeof(this[name]) == "number" || typeof(this[name]) == "string" || typeof(this[name]) == "boolean") {
		this[name] = value;
	};
};

UELO.prototype.getSendDataTimeInterval = function()
{
	if (typeof(top.serverSendDataInterval) != 'undefined') {
			this.sendDataInterval = top.serverSendDataInterval;
	};	
	var date = new Date();
	var time = date.getTime();
	this.sendResultsToServerTime = time + (this.sendDataInterval*60*1000);
};

UELO.prototype.sendSubDataToServerAtOnce = function() //pg2-knf //pg2-BV
{
	if (typeof(SendDataToServer) != "undefined") {
		return SendDataToServer();
	};
	return 1;
};

UELO.prototype.postponeSendSubDataToServer = function()
{
	if (typeof(SendDataToServer) != "undefined") {
		if (this.timerPostponeSender != null) window.clearTimeout(this.timerPostponeSender);
		this.timerPostponeSender = window.setTimeout('uelo.timerPostponeSender = null; SendDataToServer();', 1);
	};
};

UELO.prototype.sendSubDataToServer = function()
{
	//if (is.safari && is.mobile) { //pg2-BI_iPad_connection
		//this.sendSubDataToServerAtOnce();
		//return;
	//};
	this.UpdateTimerDataSender();
	if (!config.sendDataToServerOnEachPage) {
		//AW:Nie wiem po co to, jak bt co pytac MK
		if (this.sendDataInterval < 1) return;
	};
	var date = new Date();
	var time = date.getTime();
	if (config.sendDataToServerOnEachPage || time > this.sendResultsToServerTime) {
		this.postponeSendSubDataToServer();
		this.sendResultsToServerTime = time + (this.sendDataInterval*60*1000);
	};
};

UELO.prototype.sendInteractions = function()
{
	var interactions = this.getInteractions("SCORM12");
	for (var k in interactions) {
		var item = interactions[k];

		lms.LMSSetValue("cmi.interactions." + item["number"] + ".id", item["id"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".time", item["time"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".type", item["type"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".latency", item["latency"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".result", item["result"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".weighting", item["weighting"]);
		lms.LMSSetValue("cmi.interactions." + item["number"] + ".student_response", item["student_response"]);
		lms.LMSSetValue("wbts.interactions." + item["number"] + ".question", item["question"]);

		var correctResponses = item["correct_responses"];
		for (var j = 0; j < correctResponses.length; j++) {
			lms.LMSSetValue("cmi.interactions." + item["number"] + ".correct_responses."
				+ j + ".pattern", correctResponses[j]);
		};
	};
};

UELO.prototype.resetInteractionsforPage = function(pageGlobalIndex)
{
	var p = this.FindPage(pageGlobalIndex);
	if (p) {
		p.resetPageInteractions();
	};
};

UELO.prototype.setScoringList = function(t) //pg2-qr -reorganized
{
	var a = t.split(',');
	for (var i in this.pages) {
		var p = this.pages[i];
		var v = a[i];
		if (typeof(v) == 'undefined' || v == '') {
			continue;
		} else
		if (v == 'X') {
			p.isAssessment = 0;
		} else
		if (parseInt(v) != NaN) {
			p.score = parseInt(v);
			p.isAssessment = 1;
		} else {
			p.score = v;
		};
	};
};

UELO.prototype.getScoringList = function() //pg2-qr -reorganized
{
	var a = new Array();
	for (var i in this.pages) {
		var p = this.pages[i];
		if (p.isAssessment == 0) {
			a[a.length] = 'X';
		} else {
			if (p.pageType == 'Information') a[a.length] = ''; //pg2-profiles_exe -otherwise it returns '0' for information page
			else a[a.length] = p.score.toString();
		};
	};
	return a.toString();
};

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
UELO.prototype.getPreviousMixedStructure = function() //pg2-qr_new
{
	if (typeof(struct) == 'undefined' || typeof(player) == 'undefined') return '';

	var res = "";
	//pg2-qr -previous course pages list visibility
	var examWasSolved = player.checkExamWasSolved(); //check if user has at least visited any page from drawed pool
	var reallyMixed = this.wasReallyMixed();
	if ((struct.isCourseMixed && examWasSolved && reallyMixed) || (struct.isCourseMixed && !examWasSolved && this.previousMixedStructure == '' && reallyMixed)) {
		try {
			for (var i in this.pages) {
				var p = this.pages[i];
				var positive = (p.visible && p.iss);
				res += (positive?'1':'0') + p.status; //pg2-added status
			};
			res = '|MIX:' + res;
		} catch(e) {
			res = '';
		};
	} else
	if (this.previousMixedStructure != '') res = '|MIX:' + this.previousMixedStructure; else res = '';
	return res;
};

UELO.prototype.resetAllPagesInPool = function(loadedPageGIX) //pg2-qr -new, perform this at first visit on page within a pool, if during current session none of these was visited
{
	for (var i in this.pages) {
		var p = this.pages[i];
		if (!p) continue; //pg2-qr_current
		if ((p.visible && p.iss) && (p.isQuizPageToReset || p.blockRestorePage)) {
			if (p.pageType == PAGETYPE_EXERCISE) {
				p.resetPageInteractions();
				if (suspendData) suspendData.setValue('_ua' + p.globalIndex, ''); //pg2-pkf_draw_pages_prevAnswer
			} else p.status = PAGESTATUS_NOT_ATTEMPTED;
		};
	};
	this.setPageStatus(loadedPageGIX, PAGESTATUS_INCOMPLETE);
};

UELO.prototype.setPreviousMixedStructure = function(t) //pg2-qr -new
{
	//pg2-qr -TODO
	this.previousMixedStructure = t;
	//if (struct.isCourseMixed == false) return;
	if (this.previousMixedStructure != '') struct.isCourseMixed = true;

	var res = '';
	if (this.previousMixedStructure == '') {
		try {
			for (var i in this.pages) {
				var p = this.pages[i];
				var positive = (p.visible && p.iss);
				res += (positive?'1':'0') + p.status; //pg2-added status
			};
			//res = '|MIX:' + res;
		} catch(e) {
			res = '';
		};
		this.previousMixedStructure = res;
	};
	if (this.previousMixedStructure == '') return;

	for (var i in this.pages) {
		var p = this.pages[i];
		if (p) { //0N,1F,1P
			try {
				var prevVisibilityStr = this.previousMixedStructure.substr(i*2, 1);
				var prevStatusStr = this.previousMixedStructure.substr((i*2)+1, 1);
				if (prevVisibilityStr == '0') {
					p.previouslyVisible = false;
					/* //pg2-removed, it has caused all problems - this page MUST be visible, otherwise navigation via tree will not succeed
					var stPage = struct.findItem(p.globalIndex); //aw
					stPage["blockRestorePage"] = true;
					stPage["visible"] = 0;
					stPage["iss"] = 0;
					stPage["isExamPage"] = 1; */
					//...
				} else {
					p.previouslyVisible = true;
				};
				p.previousStatus = prevStatusStr;
			} catch(e) {};
		};
	};
	player.reinitializeTree = true;
};

UELO.prototype.wasCourseReallyMixedAndPagesInAssessment = function() //pg2-qr
{
	var reallyMixed = false;
	var inAssessment = false;
	if (struct.isCourseMixed) { //should be mixed
		for (var i in this.pages) {
			var p = this.pages[i];
			if (p && p.visible && p.isExamPage && p.isAssessment) { // && p.status != PAGESTATUS_NOT_ATTEMPTED) {
				reallyMixed = true;
				inAssessment = true;
				break; //not neccessary go through all pages, some pages sets could overlap over each other (part in quiz could be inAssessment, ans some part- not)
			} else
			if (p && p.visible && p.isExamPage && !p.isAssessment) { // && p.status != PAGESTATUS_NOT_ATTEMPTED) {
				reallyMixed = true;
				inAssessment = false;
				break; //
			};
		};
	};
	return [reallyMixed, inAssessment];
};

UELO.prototype.wasReallyMixed = function() //pg2-qr
{
	var res = false;
	for (var i in this.pages) {
		var p = this.pages[i];
		if (p && p.isExamPage) {
			res = true;
			break;
		};
	};
	return res;
};

//--------------------------------------------------------------------------------------------------------------------------------------------------------------
UELO.prototype.setVisitedCountList = function(t)
{
	for (var i in this.pages) {
		var p = this.pages[i];
		var s = t.substr(i * 3, 3);
		var c = parseInt(s, 16);
		p.visitedCount = c;
	};
};

UELO.prototype.getVisitedCountList = function()
{
	var s = "";
	for (var i in this.pages) {
		var p = this.pages[i];
		var c = p.visitedCount.toString(16);
		c = pad(c, 3);
		if (c.length == 3) {
			s += c;
		} else {
			s += "???"
		};
	};
	return s;
};

UELO.prototype.setBookmarkList = function(t)
{
	for (var i in this.pages) {
		var p = this.pages[i];
		var s = t.substr(i * 1, 1);
		p.isBookmark = (s == "B");
	};
};

UELO.prototype.getBookmarkList = function()
{
	var s = "";
	for (var i in this.pages) {
		var p = this.pages[i];
		if (p.isBookmark) {
			s += "B";
		} else {
			s += "_"
		};
	};
	return s;
};

UELO.prototype.setInteractionsStatus = function(s)
{
	var sindex = 0;
	for (var ip in this.pages) {
		var p = this.pages[ip];
		for (var i in p.interactions) {
			var inter = p.interactions[i];
			inter.status = s.charAt(sindex++);
			switch (inter.status) {
				case PAGESTATUS_PASSED:
					inter.result = true;
					break;
				case PAGESTATUS_FAILED:
					inter.result = false;
					break;
				default:
					inter.result = "";
			};
		};
	};
};

UELO.prototype.getInteractionsStatus = function()
{
	var s = "";
	for (var ip in this.pages) {
		var p = this.pages[ip];
		for (var i in p.interactions) {
			var inter = p.interactions[i];
			s += inter.status;
		};
	};
	return s;
};

UELO.prototype.getSimpleSessionTime = function()
{
	if (config.inactivityEnabled && player) { //pg2-inactivity time -detailedReport
		return calculateTimeIntToFormattedString(player.activityTime);
	} else {
		var now = new Date();
		return this.calculateTimeToString(this.beginTime, now);
	};
};

UELO.prototype.getPagesList = function(pQuizBeginPage,pQuizEndPage) //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return null; //pg2-update to WL's changes
	
	var listGix = new Array();
	var bIsBegin = false;
	for (var i=0; i<struct.length(); i++) {
		var iGix = struct.item(i)["gix"];
		if (iGix == pQuizBeginPage) bIsBegin = true;
		if (bIsBegin) listGix.push(iGix);
		if (iGix == pQuizEndPage) break;
	};
	return listGix;
};

UELO.prototype.addQuizRandomizerRange = function(pGix,pPagesRandomCount,pQuizBeginPage,pQuizEndPage) //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return; //pg2-update to WL's changes
	
	if (this.isPageInRandomizerRange(pQuizBeginPage) || this.isPageInRandomizerRange(pQuizEndPage)) return;
	
	//pg2-BSH_WL_FIX
	var itemBeginPage = struct.findItem(pQuizBeginPage);
	var itemEndPage = struct.findItem(pQuizEndPage);
	if (!itemBeginPage || itemBeginPage == null || !itemEndPage || itemEndPage == null) return;
	var iIdxParent	= itemBeginPage["parent"];
	//...
	//var iIdxParent	= struct.findItem(pQuizBeginPage)["parent"]; //pg2-BSH_WL_FIX2 -removed, replaced with the block above
	
	var iGixParent  = struct.findPageGixByIndex(iIdxParent);
	var gixs = this.getPagesList(pQuizBeginPage,pQuizEndPage);
	
	var obj = new Array();
	obj.push(pGix);				//0
	obj.push(pPagesRandomCount);//1
	obj.push(pQuizBeginPage);	//2
	obj.push(pQuizEndPage);		//3
	obj.push(iGixParent);		//4
	obj.push(gixs);				//5
	
	if (listRandomizerInfo == null) listRandomizerInfo = new Array();
	listRandomizerInfo.push(obj);	
};

UELO.prototype.calculateMaxPagesCount = function() //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return; //pg2-update to WL's changes
	
	if (listRandomizerInfo == null) return;
	
	var sInfo = '';
	for (var i=0; i<listRandomizerInfo.length; i++) {
		var o = listRandomizerInfo[i];
		var gixs = o[5];
		iRandomizerAllPages		= iRandomizerAllPages + gixs.length;
		iRandomizerVisiblePages	= iRandomizerVisiblePages + o[1];
	};
};

UELO.prototype.getRandomizerAllPages = function() //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return 0; //pg2-update to WL's changes
	return iRandomizerAllPages;
};

UELO.prototype.getRandomizerVisiblePages = function() //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return 0; //pg2-update to WL's changes
	
	return iRandomizerVisiblePages;
};

UELO.prototype.isPageInRandomizerRange = function(pGix) //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return false; //pg2-update to WL's changes
	
	if (listRandomizerInfo == null) return false;
	for (var i=0; i<listRandomizerInfo.length;i++) {
		var o = listRandomizerInfo[i];
		var gixs = o[5];
		for (var j=0; j<gixs.length; j++) {
			if (gixs[j] == pGix){
				return true;
			};
		};
	};
	return false;
};

UELO.prototype.isPageAsRandomizerParent = function(pGix) //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return false; //pg2-update to WL's changes
	
	if (listRandomizerInfo == null) return false;
	for (var i=0; i<listRandomizerInfo.length; i++) {
		var o = listRandomizerInfo[i];		
		if (pGix == o[4]) return true;
	};
	return false;
};

UELO.prototype.getPageRandomizerParent = function(pGix) //wl - 201401 for config.temp_BSH201401
{
	if (!config.temp_BSH201401) return -1; //pg2-update to WL's changes
	
	if (listRandomizerInfo == null) return -1;
	for (var i=0; i<listRandomizerInfo.length; i++) {
		var o = listRandomizerInfo[i];
		var gixs = o[5];
		for (var j=0; j<gixs.length; j++){
			if (gixs[j]==pGix){
				return o[4];
			};
		};
	};
	return -1;
};

var uelo = new UELO();
