﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentDialogueInstruction = function( name )
{
	this.componentDialogue = componentDialogue;
	if (arguments[1]) {
		this.componentDialogue(name, arguments[1]);
	} else {
		this.componentDialogue(name);
	};

	this.arrSteps = new Array();
	this.oldHeight = null;
	this.timerID = null;
};

componentDialogueInstruction.prototype = new componentDialogue;
componentDialogueInstruction.prototype.type = "componentDialogueInstruction";

componentDialogueInstruction.prototype.onCreate = function( obj )
{
	this.captureMouseEvents();
	if (this.stepsTexts != "") this.fillArray(this.stepsTexts); else this.arrSteps = new Array();

	var stepsTexts = this.stepsTexts.split('||');
	var oneStep = stepsTexts[this.designText].split('::');
	if (this.fontBold) oneStep[1] = "<B>"+oneStep[1]+"</B>";  

	if (this.execution) {
		this.resourcesStatus = "online";
		this.resourcesURL = resourcesURL;
		if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
			this.resourcesStatus = lms.resourcesStatus();
			if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
			else this.resourcesURL = lms.resourcesURL();
		};
	    this.resourcesURL = unescape(this.resourcesURL);

		document.getElementById(this.id + "_contentCloudObj").src = this.resourcesURL + this.cloudSrc;
		document.getElementById(this.id + "_contentObj").innerHTML = oneStep[1];
	} else {
		this.text.text = oneStep[1];
	};
};

componentDialogueInstruction.prototype.onPaint = function()
{
	if (PageInterface.GetValue("state") == psDesigning) {
		var TableTD = document.getElementById(this.id + "TableTD");
		if (TableTD) TableTD.style.border = "1px solid red";
	};
	return ;
};

componentDialogueInstruction.prototype.onStep = function()
{
	if (this.timerID != null) {
		window.clearTimeout(this.timerID);
		this.timerID = null;
	};
	this.toShow = this.isInSteps(page.stepIndex);

	if (this.toShow.length !=0) {
		if (this.arrSteps[this.toShow[0]].time != 0) {
			this.timerID = setTimeout('pc.'+this.id+'.doIt();', this.arrSteps[this.toShow[0]].time);
		} else this.doIt();
	} else this.doIt();
};

componentDialogueInstruction.prototype.isInArray = function(item, itemArray)
{
	for (var k = 0; k < itemArray.length; k++) {
		if (itemArray[k].toString() == item.toString()) return true;
	};
	return false;
};

componentDialogueInstruction.prototype.isInSteps = function(step)
{
	var toShow = new Array();
	for (var i=0; i<this.arrSteps.length; i++) {
		for (var j=0; j<this.arrSteps[i].steps.length; j++) {
			if (step == this.arrSteps[i].steps[j]) {
				if (!this.isInArray(i,toShow)) toShow.push(i);
			};
		};
	};
	return toShow;
};

componentDialogueInstruction.prototype.fillArray = function(string)
{
	var arrElements	= string.split("||");
	var arrSubElements = null;
	var arrLocalSteps = null;
	for (var i=0; i < arrElements.length; i++ ) {
		arrSubElements = arrElements[i].split("::");
		arrLocalSteps = arrSubElements[0].split(",");
		var obj = 
		{ 
			steps : arrLocalSteps, 
			time  : arrSubElements[2], 
			text  : arrSubElements[1]
		};
		this.arrSteps.push(obj);
	};
};

componentDialogueInstruction.prototype.doIt = function()
{
	var toShow = this.toShow;
	if (this.execution) {
		var textObj = document.getElementById(this.id + "_contentObj");

		if (toShow.length != 0) {
			for (var i=0; i < toShow.length; i++) {
				var newText = this.arrSteps[toShow[i]].text;
				if (this.fontBold) newText = "<B>"+newText+"</B>"; 
				textObj.innerHTML = newText;
			};
			this.show();
		} else this.hide();
	} else {
		if (toShow.length != 0) {
			for (var i=0; i < toShow.length; i++) {
				var newText = this.arrSteps[toShow[i]].text;
				if (this.fontBold) newText = "<B>"+newText+"</B>"; 
				this.text.text = newText;
			};
			this.show();
		} else this.hide();
	};
};

componentDialogueInstruction.prototype.onFree = function()
{
	if (this.timerID != null) window.clearTimeout(this.timerID);
};
