var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var Fill = (function (_super) {
        __extends(Fill, _super);
        function Fill() {
            _super.call(this);
            this.HorizontalPlacementArray = [];
            this.VerticalPlacementArray = [];
            this.isGrid = false;
            this.StartingPosX = 0;
            this.StartingPosY = 0;
            this.Columns = 0;
            this.Rows = 0;
            this.Spacing = 0;
            this.initializationKeys = "";
            this.maxCharacters = 0;
            this.FillList = [];
            this.isHelpShown = false;
            this.firstRun = true;
            this.inputBoxStyle = { font: "normal 80pt Arial", fill: "black" };
        }
        Fill.prototype.preload = function () {
            console.log("preload");
            _super.prototype.preload.call(this);
            this.loadGraphics();
            this.game.load.start();
            this.instruction = new Audio("./Sounds/ZIP_g_I_7_3.mp3");
            this.applause = new Audio("./Sounds/ZIP_g_I_7_8.mp3");
        };
        Fill.prototype.killKeyborad = function () {
            if (this.keyboard != undefined) {
                this.keyboard.destroy(false, false);
                this.keyboard = undefined;
            }
        };
        Fill.prototype.create = function () {
            _super.prototype.create.call(this);
            console.log("create");
            this.loadInit();
            this.createAdditionalElements();
            this.createStaticElements();
            this.createActiveElments();
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud_2");
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.y = this.game.world.height;
            this.showHelp();
        };
        Fill.prototype.changeHelp = function () {
            this.showHelp();
            this.cloudText.y = this.cloud.height * 0.4;
        };
        Fill.prototype.showWin = function () {
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Brawo. Wszedłeś do pokoju Ani. Możesz pomóc jej w odrobieniu lekcji.");
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 4, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.game.state.start("IntermissionState");
                    }
                    catch (e) {
                    }
                }, this);
            }, this);
            tw.start();
            try {
                //this.applause.currentTime = 0;
                this.applause.play();
            }
            catch (e) {
            }
        };
        Fill.prototype.showHelp = function () {
            var tw = null;
            this.cloudText.setText("Przyjrzyj się kalendarzowi pogody i odpowiedz na pytania.");
            var point = this.game.world.height;
            this.isHelpShown = !this.isHelpShown;
            if (this.isHelpShown) {
                point -= this.guide.height;
                try {
                    //this.instruction.currentTime = 0;
                    this.instruction.play();
                    if (this.firstRun) {
                        var tmr = this.game.time.events.add(Phaser.Timer.SECOND * 4, this.changeHelp, this);
                    }
                }
                catch (e) {
                }
            }
            else {
                try {
                    this.instruction.pause();
                    this.instruction.currentTime = 0;
                }
                catch (e) {
                }
            }
            tw = this.game.add.tween(this.guide);
            tw.to({ y: point }, 800, Phaser.Easing.Cubic.Out);
            tw.start();
        };
        Fill.prototype.loadInit = function () {
            this.initializationKeys = this.GameData.AcceptedCharacters;
            this.maxCharacters = this.GameData.MaxCharacters;
            if (this.GameData.isGrid == true) {
                this.isGrid = this.GameData.isGrid;
                this.StartingPosX = this.GameData.StartingPos.x;
                this.StartingPosY = this.GameData.StartingPos.y;
                this.Columns = this.GameData.Columns;
                this.Rows = this.GameData.Rows;
                this.Spacing = this.GameData.Spacing;
            }
        };
        Fill.prototype.loadGraphics = function () {
            for (var i = 0; i < this.GameData.Graphics.length; i++)
                this.game.load.image(this.GameData.Graphics[i].key, this.GameData.Graphics[i].src);
        };
        Fill.prototype.loadSpritesheet = function () {
            for (var i = 0; i < this.GameData.Spritesheet.length; i++)
                this.game.load.spritesheet(this.GameData.Spritesheet[i].key, this.GameData.Spritesheet[i].src, this.GameData.Spritesheet[i].size.x, this.GameData.Spritesheet[i].size.y, this.GameData.Spritesheet[i].size.no);
        };
        Fill.prototype.createControllElement = function () {
            for (var i = 0; i < this.GameData.Controlls.length; i++) {
                var el = this.game.add.image(this.GameData.Controlls[i].pos.x, this.GameData.Controlls[i].pos.y, this.GameData.Controlls[i].key);
            }
        };
        Fill.prototype.createAdditionalElements = function () {
            for (var i = 0; i < this.GameData.AditionalElements.length; i++) {
                var el = this.game.add.image(this.GameData.AditionalElements[i].pos.x, this.GameData.AditionalElements[i].pos.y, this.GameData.AditionalElements[i].key);
            }
        };
        Fill.prototype.createStaticElements = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
                var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            }
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            if (this.isGrid) {
                var currHeight = this.StartingPosY;
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var currWidth = this.StartingPosX;
                    if (this.GameData.StaticElements[i].HasImage) {
                        var el = this.game.add.image(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].key);
                        el.scale.setTo(0.5, 0.5);
                        currWidth += el.width;
                        currHeight += el.height;
                        this.HorizontalPlacementArray.push(currWidth + this.Spacing);
                        this.VerticalPlacementArray.push(el.height / 2 + this.Spacing);
                    }
                    if (this.GameData.StaticElements[i].HasText) {
                        var el_text = this.game.add.text(currWidth, currHeight + (100 * i), this.GameData.StaticElements[i].prefix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        this.HorizontalPlacementArray.push(el_text.width + (LetterAmountmultipler / 2) + currWidth);
                        el_text = this.game.add.text(this.HorizontalPlacementArray[i] + LetterAmountmultipler / 2, currHeight + (100 * i), this.GameData.StaticElements[i].sufix, this.inputBoxStyle);
                        el_text.anchor.set(0, 0.5);
                        currWidth += el_text.width;
                        this.VerticalPlacementArray.push(currHeight + (100 * i));
                    }
                }
            }
            else {
                for (var i = 0; i < this.GameData.StaticElements.length; i++) {
                    var el = this.game.add.image(this.GameData.StaticElements[i].pos.x, this.GameData.StaticElements[i].pos.y, this.GameData.StaticElements[i].key);
                }
            }
        };
        Fill.prototype.createActiveElments = function () {
            if (this.GameData.CustomFontSize != -1) {
                this.fontSize = this.GameData.CustomFontSize;
            }
            else {
                this.fontSize = 50 - (this.maxCharacters);
            }
            var BoxSize = 8 / 5 * this.fontSize;
            var LetterAmountmultipler = 70 * (this.maxCharacters / 3);
            this.inputBoxStyle.font = "normal " + this.fontSize + "pt Arial";
            var bmd = this.game.add.bitmapData(LetterAmountmultipler, BoxSize);
            bmd.ctx.rect(0, 0, LetterAmountmultipler, BoxSize);
            bmd.ctx.fillStyle = '#cdcdcd';
            bmd.ctx.fill();
            var currHeight = this.StartingPosY;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                this.box = this.game.add.sprite(this.HorizontalPlacementArray[i], this.VerticalPlacementArray[i], bmd);
                this.box.anchor.set(0.5, 0.5);
                this.box.alpha = 0.5;
                this.box.width = LetterAmountmultipler;
                this.item = this.game.add.text(0, 0, "?", this.inputBoxStyle);
                this.item.anchor.set(0.5, 0.5);
                this.item.father = this.box;
                this.item.x = this.box.x;
                this.item.y = this.box.y;
                this.box.text = this.item;
                this.item.answer = this.GameData.TaskList[i].Answer;
                this.box.inputEnabled = true;
                this.box.events.onInputUp.add(this.showKeyboard, this);
                this.FillList.push(this.item);
            }
        };
        Fill.prototype.keyboardInit = function () {
            this.keyboard = new KB.Keyboard(this.game, this.initializationKeys, 500, 0, true);
            if (this.initializationKeys.length >= 2) {
                this.keyboard.initialize(this.initializationKeys, "key", "key");
            }
            else {
                this.keyboard.initialize("qwertyuiop" + this.keyboard.arrSeparator + "asdfghjkl" + this.keyboard.arrSeparator + "zxcvbnm^&", "key", "key");
            }
            this.keyboard.scale.setTo(0.5, 0.5);
            this.keyboard.alive = false;
            this.keyboard.fixedToCamera = true;
            this.keyboard.maxLetters = this.maxCharacters;
            this.game.add.existing(this.keyboard);
        };
        Fill.prototype.showKeyboard = function (button) {
            if (this.keyboard == undefined)
                this.keyboardInit();
            this.keyboard.controller = button.text;
            this.keyboard.RootController = this;
            this.keyboard.navClick(this.keyboard);
        };
        Fill.prototype.checkComplition = function () {
            var TotalAnswers = this.GameData.TaskList.length;
            var GoodAnswers = 0;
            var BadAnswers = 0;
            for (var i = 0; i < this.GameData.TaskList.length; i++) {
                if (this.FillList[i].text.toUpperCase() == this.GameData.TaskList[i].Answer.toUpperCase()) {
                    GoodAnswers++;
                }
                else {
                    if (this.FillList[i].text.toUpperCase() != "?")
                        BadAnswers++;
                }
            }
            if (TotalAnswers == GoodAnswers) {
                this.showWin();
            }
            else {
                var complition = GoodAnswers / TotalAnswers;
                var tmpCheck = BadAnswers / TotalAnswers;
                if (tmpCheck + complition != 1) {
                }
                else {
                }
            }
            this.killKeyborad();
        };
        Fill.prototype.update = function () {
        };
        Fill.prototype.init = function (json) {
            this.GameData = {
                "Title": "",
                "Sound": "",
                "MaxCharacters": 1,
                "AcceptedCharacters": "0123456789",
                "isGrid": true,
                "StartingPos": { "x": 350, "y": 550 },
                "Columns": 4,
                "Rows": 2,
                "Spacing": 20,
                "CustomFontSize": 50,
                "Graphics": [
                    { "src": "Graphics/game/ZIP_g_I_7_image.png", "key": "ZIP_g_I_7_image" },
                    { "src": "Graphics/game/ZIP_g_I_7_ramka.png", "key": "ZIP_g_I_7_ramka" },
                ],
                "Spritesheet": [
                    { "src": "Graphics/game/ZIP_g_I_6_next.png", "key": "ZIP_g_I_6_next", "size": { "x": 120, "y": 120, "no": 2 } },
                ],
                "Controlls": [
                    { "key": "ZIP_g_I_6_next", "pos": { "x": 150, "y": 65 }, "Control": "next" },
                ],
                "AditionalElements": [
                    { "key": "ZIP_g_I_7_ramka", "pos": { "x": 150, "y": 65 } },
                    { "key": "ZIP_g_I_7_image", "pos": { "x": 200, "y": 120 } },
                ],
                "StaticElements": [
                    { "HasText": true, "HasImage": false, "prefix": "Ile było pochmurnych dni z deszczem?  : ", "sufix": "", "id": 1, "key": "", "pos": { "x": 270, "y": 65 } },
                    { "HasText": true, "HasImage": false, "prefix": "Ile było dni bez opadów deszczu?          : ", "sufix": "", "id": 2, "key": "", "pos": { "x": 270, "y": 265 } },
                    { "HasText": true, "HasImage": false, "prefix": "Ile było dni wietrznych?                           : ", "sufix": "", "id": 3, "key": "", "pos": { "x": 270, "y": 465 } },
                    { "HasText": true, "HasImage": false, "prefix": "Ile było dni słonecznych?                        : ", "sufix": "", "id": 4, "key": "", "pos": { "x": 900, "y": 65 } },
                ],
                "TaskList": [
                    { "pos": { "x": 860, "y": 135 }, "Answer": "3", "id": 1 },
                    { "pos": { "x": 860, "y": 340 }, "Answer": "4", "id": 2 },
                    { "pos": { "x": 860, "y": 545 }, "Answer": "1", "id": 3 },
                    { "pos": { "x": 860, "y": 670 }, "Answer": "1", "id": 4 },
                ]
            };
        };
        return Fill;
    })(BasicModule.BasicState);
    MainGame.Fill = Fill;
})(MainGame || (MainGame = {}));
//# sourceMappingURL=Fill.js.map