﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentScrollingText = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);
};

componentScrollingText.prototype = new __componentText;
componentScrollingText.prototype.type = "componentScrollingText";

componentScrollingText.prototype.componentBaseScrollingTextOnCreate = componentScrollingText.prototype.onCreate;
componentScrollingText.prototype.onCreate = function(obj)
{
	this.componentBaseScrollingTextOnCreate(obj);

	if (this.execution) {
		var font = getProjectFont(this.allowGF == 1, this.fontFamily, this.fontSize, this.fontColor);
	} else {
		var font = getProjectFont(this.allowGF == 1, this.font.family, this.font.size, this.font.color);
	};

	if (PageInterface.GetValue("state") != psDesigning) {
		this.scrolling = this.scrolling.replace(/^(<.*>)(.*)(<\/.*>)$/,'$2');
		if (this.scrollLoop) var loop = "true";
		else var loop = this.scrollCountLoop;

		var speed = "";
		if (this.scrollSpeed != 0) speed = "scrollamount='" + this.scrollSpeed + "'";

		if (document.getElementById(this.id + "_contentObj")) {
			if (this.scrollBounce) {
				document.getElementById(this.id + "_contentObj").innerHTML = "<MARQUEE direction='" + this.scrolling + "' behavior=\"alternate\" loop='" + loop + "' " + speed + " style='font-family: " + font.family + "; font-size:" + getFontSize(font.size, 'px') + "px; color:" + font.color + ";'>" + this.text + "</MARQUEE>";
			} else {
				document.getElementById(this.id + "_contentObj").innerHTML = "<MARQUEE direction='" + this.scrolling + "' loop='" + loop + "' " + speed + " style='font-family: " + font.family + "; font-size:" + getFontSize(font.size, 'px') + "px; color:" + font.color + ";'>" + this.text + "</MARQUEE>";
			};
		} else {
			if (this.scrollBounce) {
				this.text = "<MARQUEE direction='" + this.scrolling + "' behavior=\"alternate\" loop='" + loop + "' " + speed + " style='font-family: " + font.family + "; font-size:" + getFontSize(font.size, 'px') + "px; color:" + font.color + ";'>" + this.text + "</MARQUEE>";
			} else this.text = "<MARQUEE direction='" + this.scrolling + "' loop='" + loop+"' " + speed + " style='font-family: " + font.family + "; font-size:" + getFontSize(font.size, 'px') + "px; color:" + font.color + ";'>" + this.text + "</MARQUEE>";
		};
	} else {
		var sizeDiv = '<span id="' + this.id + 'sizeDiv" style="visibility: hidden; position: absolute; font-family: ' + font.family + '; font-size:' + getFontSize(font.size, "px") + 'px;"></span>';

		if (this.execution) {
			var objImg = this.findContentObj();
			objImg.innerHTML = this.text;
		} else {
			this.text = editorText;
		};
	};
};

componentScrollingText.prototype.onPaint = function(obj)
{
	return;
};
