var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var MainGame;
(function (MainGame) {
    var PogodaGame2 = (function (_super) {
        __extends(PogodaGame2, _super);
        function PogodaGame2() {
            _super.call(this);
            this.ListaMiejsc = [[188, 178], [395, 88], [771, 151], [354, 342], [612, 393], [275, 527], [536, 658], [788, 706]];
            this.listaPogody = [];
            this.listaSpotow = [];
            this.isHelpShown = false;
            this.firstRun = true;
            this.isSafari = true;
            this.ggCount = 0;
            this.tableOutfits = [1, 2];
        }
        PogodaGame2.prototype.preload = function () {
            _super.prototype.preload.call(this);
            for (var i = 0; i < 3; i++) {
                this.game.load.spritesheet("previous" + (i + 1), "Graphics/gui/" + "previous" + (i + 1) + ".png", 53, 62, 2, 0, 0);
                this.game.load.spritesheet("next" + (i + 1), "Graphics/gui/" + "next" + (i + 1) + ".png", 53, 62, 2, 0, 0);
            }
            for (var i = 0; i < 12; i++) {
                this.game.load.image("pogoda_" + (i + 1), "Graphics/game/ZIP_g_I_6_pogoda_0" + (i + 1) + ".png");
            }
            this.game.load.image("frame", "Graphics/gui/frame.png");
            this.game.load.spritesheet("ready", "Graphics/gui/ready.png", 220, 71, 2, 0, 0);
            this.game.load.spritesheet("help", "Graphics/gui/help.png", 104, 108, 2, 0, 8);
            this.game.load.image("gameGuide", "Graphics/gui/guide.png");
            this.game.load.image("cloud", "Graphics/gui/instr_bg.png");
            this.game.load.spritesheet("tips", "Graphics/gui/tips.png", 220, 71, 2);
            this.game.load.image("tut", "Graphics/game/ZIP_g_I_6_pogoda_przyklad.png");
            this.game.load.image("empty", "Graphics/game/ZIP_g_I_6_pogoda_empty.png");
            this.game.load.image("mapa", "Graphics/game/ZIP_g_I_6_pogoda_mapa.png");
            this.instruction = new Audio("./Sounds/zip_g_I_6_5.mp3");
            this.applause = new Audio("./Sounds/zip_g_I_6_11.mp3");
            this.sndTryAgain = new Audio("./Sounds/tryagain.mp3");
        };
        PogodaGame2.prototype.create = function () {
            _super.prototype.create.call(this);
            var tut = this.game.add.image(110, 44, "mapa");
            var iteratorPogody = 0;
            for (var i = 0; i < 4; i++) {
                for (var j = 0; j < 3; j++) {
                    iteratorPogody++;
                    this.pogoda = this.game.add.sprite(1208 + (j * 146 + 50), 154 + (i * 146 + 50), "pogoda_" + iteratorPogody);
                    this.pogoda.inputEnabled = true;
                    this.pogoda.grapName = "pogoda_" + iteratorPogody;
                    this.pogoda.name = iteratorPogody;
                    this.pogoda.orginalPositionX = this.pogoda.x;
                    this.pogoda.orginalPositionY = this.pogoda.y;
                    this.pogoda.input.enableDrag(false, true);
                    this.pogoda.events.onInputUp.add(this.Up, this);
                    this.listaPogody.push(this.pogoda);
                }
            }
            for (var i = 0; i < this.ListaMiejsc.length; i++) {
                this.spot = this.game.add.sprite(this.ListaMiejsc[i][0], this.ListaMiejsc[i][1], "empty");
                this.spot.ID = i;
                this.spot.inputEnabled = true;
                this.spot.toInstert = true;
                this.spot.isEmpty = true;
                this.spot.additionaltexture = null;
                this.spot.number = -1;
                this.listaSpotow.push(this.spot);
            }
            var fr = this.game.add.image((351), 0, "frame");
            fr.y = this.game.height - fr.height;
            var txt = this.game.add.text(0, 0, "Przejaśnienia w całym kraju, 2ºC, mgły.", { font: "normal 20pt Arial" });
            txt.anchor.set(0.5, 0.5);
            txt.position.setTo(fr.width / 2.6, fr.height * 0.6);
            fr.addChild(txt);
            this.helpBtn = this.game.add.button(1778, 22, "help", this.showHelp, this, 0, 0, 1, 0);
            var arX = (339 + 300);
            var arY = 212;
            var ready = this.game.add.button(971, 24, "ready", this.isDone, this, 0, 0, 1, 0);
            fr.addChild(ready);
            this.guide = this.game.add.group();
            var gd = this.game.add.image(this.game.width * 0.7, 0, "gameGuide");
            gd.z = 100;
            this.cloud = this.game.add.image(this.game.width * 0.5, 0, "cloud");
            this.cloud.z = 100;
            gd.y = this.cloud.height * 0.8;
            this.cloudText = this.game.add.text(0, 0, "Przygotuj grafikę odpowiadającą prognozie pogody dla Polski. Skorzystaj z dostępnych ilustracji i umieść je na mapie.", { wordWrap: true, wordWrapWidth: this.cloud.width * 0.75 });
            this.cloudText.anchor.set(0.5, 0.5);
            this.cloudText.position.setTo(this.cloud.width * 0.5, this.cloud.height * 0.47);
            this.cloud.addChild(this.cloudText);
            this.guide.addChild(this.cloud);
            this.guide.addChild(gd);
            this.guide.updateZ();
            this.guide.y = this.game.world.height;
			if (this.ggCount == 0)
                this.showHelp();
        };
        PogodaGame2.prototype.Up = function (button, pointer) {
            var mover = button;
            var ToInsert = true;
            for (var i = 0; i < this.listaSpotow.length; i++) {
                if (mover.overlap(this.listaSpotow[i])) {
                    if (true) {
                        if (this.listaSpotow[i].additionaltexture == null) {
                            var spot = this.game.add.image(this.listaSpotow[i].x, this.listaSpotow[i].y, mover.grapName);
                            spot.name = mover.grapName;
                            this.listaSpotow[i].number = mover.name;
                            this.listaSpotow[i].additionaltexture = spot;
                        }
                        else {
                            this.listaSpotow[i].additionaltexture.destroy();
                            var spot = this.game.add.image(this.listaSpotow[i].x, this.listaSpotow[i].y, mover.grapName);
                            spot.name = mover.grapName;
                            this.listaSpotow[i].number = mover.name;
                            this.listaSpotow[i].additionaltexture = spot;
							console.log(this.listaSpotow);
                        }
                    }
                }
                else {
                    this.game.add.tween(button).to({ x: button.orginalPositionX, y: button.orginalPositionY }, 1000, Phaser.Easing.Back.Out, true);
                }
            }
            this.game.add.tween(mover).to({
                x: mover.orginalPositionX,
                y: mover.orginalPositionY
            }, 1000, Phaser.Easing.Back.Out, true);
        };
        PogodaGame2.prototype.isDone = function () {
            for (var i = 0; i < this.listaPogody.length; i++) {
                this.listaPogody[i].visible = false;
            }
            var win = false;
            var war1 = false;
            var war2 = false;
            var war3 = false;
            var maxpoints = this.listaSpotow.length;
            var currpoints = 0;
            for (var i = 0; i < this.listaSpotow.length; i++) {
                console.log(i + ": " + this.listaSpotow[i].number);
                if (this.listaSpotow[i].number == 2 || this.listaSpotow[i].number == 12 || this.listaSpotow[i].number == 6) {
                    currpoints++;
                    if (this.listaSpotow[i].number == 2)
                        war1 = true;
                    if (this.listaSpotow[i].number == 12)
                        war2 = true;
                    if (this.listaSpotow[i].number == 6)
                        war3 = true;
                }
            }
            if (currpoints == maxpoints)
                if (war1 && war2 && war3)
                    win = true;
            if (win) {
                this.showWin();
            }
            else {
                this.showTryAgain();
            }
        };
        PogodaGame2.prototype.showHelp = function () {
            for (var i = 0; i < this.listaPogody.length; i++) {
                this.listaPogody[i].visible = false;
            }	
            this.cloud.z = 50;
            this.guide.updateZ();
            var tw = this.game.add.tween(this.guide);
            var tw2 = this.game.add.tween(this.guide);
            tw2.onComplete.add(this.showMeWeather, this);
            this.cloudText.setText("Przygotuj grafikę odpowiadającą prognozie pogody dla Polski. Skorzystaj z dostępnych ilustracji i umieść je na mapie.");
            if (this.halp != undefined)
                this.halp.visible = true;
            try {
                //this.instruction.currentTime = 0;
                this.instruction.play();
            }
            catch (e) {
            }
            tw2.to({ y: this.game.world.height }, 800, Phaser.Easing.Cubic.Out);
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 8, function () {
                    tw2.start();
                }, this);
            }, this);
            tw.start();
        };
        PogodaGame2.prototype.showMeWeather = function () {
            for (var i = 0; i < this.listaPogody.length; i++) {
                this.listaPogody[i].visible = true;
            }
        };
        PogodaGame2.prototype.showWin = function () {
            this.tableOutfits.splice(0, 1);
            if (this.tableOutfits.length == 0)
                this.tableOutfits = [1, 2];
            this.ggCount++;
            var tw = this.game.add.tween(this.guide);
            this.cloudText.setText("Bardzo dobrze. Wykonałeś zadania.");
            if (this.halp != undefined)
                this.halp.visible = false;
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 6, function () {
                    try {
                        this.applause.pause();
                        this.applause.currentTime = 0;
                        this.game.state.start("TitleScreenState", false, false);
						location.reload();
                    }
                    catch (e) {
                    }
                }, this);
            }, this);
            tw.start();
            try {
                this.applause.currentTime = 0;
                this.applause.play();
            }
            catch (e) {
            }
        };
        PogodaGame2.prototype.showTryAgain = function () {
            var tw = this.game.add.tween(this.guide);
            var tw2 = this.game.add.tween(this.guide);
			tw2.onComplete.add(this.showMeWeather, this);
            this.cloudText.setText("SPRÓBUJ JESZCZE RAZ.");
            if (this.halp != undefined)
                this.halp.visible = true;
            try {
                this.sndTryAgain.currentTime = 0;
                this.sndTryAgain.play();
            }
            catch (e) {
            }
            tw2.to({ y: this.game.world.height }, 800, Phaser.Easing.Cubic.Out);
            tw.to({ y: this.game.world.height - this.guide.height }, 800, Phaser.Easing.Cubic.Out);
            tw.onComplete.add(function () {
                this.game.time.events.add(Phaser.Timer.SECOND * 2, function () {
                    tw2.start();
                }, this);
            }, this);
            tw.start();
        };
        PogodaGame2.prototype.changeHelp = function () {
            this.showHelp();
            this.helpBtn.inputEnabled = true;
            this.cloudText.y = this.cloud.height * 0.4;
        };
        PogodaGame2.prototype.reload = function () {
            this.firstRun = true;
            this.boy = { "cl": -1, "parts": [] };
            this.game.state.start("MainGameState", false, false);
        };
        PogodaGame2.prototype.replay = function () {
            this.firstRun = true;
            this.boy = { "cl": -1, "parts": [] };
            this.ggCount = 0;
            this.game.state.start("TitleScreenState");
        };
        return PogodaGame2;
    })(BasicModule.BasicState);
    MainGame.PogodaGame2 = PogodaGame2;
})(MainGame || (MainGame = {}));