var Game;
(function (Game) {
    var Dressup = (function () {
        function Dressup() {
            this.game = new Phaser.Game(1920, 1080, Phaser.CANVAS, 'content', { create: this.start, preload: this.preload });
        }
        Dressup.prototype.start = function () {
            this.game.state.add("TitleScreenState", TitleScreen.TitleScreenState, true);
            this.game.state.add("MainGameState", MainGame.MainGameState, false);
            this.game.state.add("IntroState", MainGame.IntroState, false);
            this.game.state.add("IntermissionState", MainGame.IntermissionState, false);
            this.game.state.add("PogodaGame1", MainGame.PogodaGame1, false);
            this.game.state.add("PogodaGame2", MainGame.PogodaGame2, false);
            this.game.state.add("PogodaGame3", MainGame.PogodaGame3, false);
            this.game.state.add("PogodaGame4", MainGame.PogodaGame4, false);
            this.game.stage.disableVisibilityChange = true;
            this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
            this.game.scale.pageAlignHorizontally = true;
            this.game.scale.pageAlignVertically = true;
            this.game.scale.windowConstraints.bottom = true;
            this.game.scale.refresh();
        };
        Dressup.prototype.preload = function () {
        };
        return Dressup;
    })();
    Game.Dressup = Dressup;
})(Game || (Game = {}));
window.onload = function () {
    var game = new Game.Dressup();
};
//# sourceMappingURL=app.js.map