﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentDictionaryLinks = function(name)
{
	this.componentSimplePopup = componentSimplePopup;
	this.componentSimplePopup(name);

	this.scrollable = true;
	this.cssTextOut = "";
	this.cssTextOver = "";

	this.headerHeight = 0;
	this.borderWidth = 0;
	this.contentPadding = 0;
	this.closeButtonOffsetTop = 0;
	this.closeButtonOffsetRight = 0;
	this.headerTextOffsetTop = 0;
	this.headerTextOffsetLeft = 0;
	this.headerTextOffsetRight = 0;
	this.textAreaOffsetTop = 0;
	this.textAreaOffsetDown = 0;
	this.textAreaOffsetLeft = 0;
	this.textAreaOffsetRight = 0;
};

componentDictionaryLinks.prototype = new componentSimplePopup;
componentDictionaryLinks.prototype.type = "componentDictionaryLinks";

componentDictionaryLinks.prototype.onBaseCreate = function(obj)
{
	this.resourcesStatus = "online";
	this.resourcesURL = resourcesURL;
	if (PageInterface.GetValue("state") != psDesigning && lms && lms.name != "lmsOffline") {
		this.resourcesStatus = lms.resourcesStatus();
		if (this.disableOnlineOfflineMix) this.resourcesURL = resourcesURL;
		else this.resourcesURL = lms.resourcesURL();
	};
	this.resourcesURL = unescape(this.resourcesURL); 

	this.imagesNameArr = [ this.arrowTopOver, this.arrowTopOut, this.arrowBottomOver, this.arrowBottomOut, this.sliderOver, this.sliderOut, this.sliderBckg ];
	this.getPreloadImagesArr();

	this.setCompleteArrayInfo(this.completeInfoStyleImages);
	this.captureMouseEvents();
};

componentDictionaryLinks.prototype.onCreate = function(obj)
{
	var ff = this.getProperty(this.linkCSSStyle, "fontFamily", "Arial");
	var fs = this.getProperty(this.linkCSSStyle, "fontSize", "2");
	var fc = this.getProperty(this.linkCSSStyle, "fontColor", "#000000");
	var fw = this.getProperty(this.linkCSSStyle, "fontWeight", "bold");
	var td = this.getProperty(this.linkCSSStyle, "textDecoration", "none");
	this.cssTextOut = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';

	var ff = this.getProperty(this.linkCSSStyleHover, "fontFamily", "Arial");
	var fs = this.getProperty(this.linkCSSStyleHover, "fontSize", "2");
	var fc = this.getProperty(this.linkCSSStyleHover, "fontColor", "#000000");
	var fw = this.getProperty(this.linkCSSStyleHover, "fontWeight", "bold");
	var td = this.getProperty(this.linkCSSStyleHover, "textDecoration", "none");
	this.cssTextOver = 'text-decoration: ' + td + '; font-family: ' + ff + '; font-size:' + getFontSize(fs, "px") + '; color: ' + fc + '; font-weight: ' + fw + ';';
};

componentDictionaryLinks.prototype.onPaint = function(obj)
{
	if (PageInterface.GetValue("state") == psDesigning) {
		this.generateOutline(dictionary.items[0]);
	} else {
		this.generateOutline();
	};
};

componentDictionaryLinks.prototype.getProperty = function(propStr, propName, propDef)
{
	var result = propDef;
	var propArr = propStr.split(";");
	for (var i=0; i<propArr.length; i++) {
		var pArr = propArr[i].split(":");
		if (trim(pArr[0]) == propName) {
			result = trim(pArr[1]);
			break;
		};
	};
	return result;
};

componentDictionaryLinks.prototype.generateOutline = function(obj)
{
	var outline = '<table style="width: 100%;">';
	outline += '<tr><td style="text-align:center; font-weight: bold;'
		+ ' font-family:' + this.fontFamily + ';'
		+ ' font-size:' + getFontSize(this.fontSize, "px") + ';'
		+ ' color: ' + this.fontColor + ';">';
	outline += this.header;
	outline += '</td></tr>';
	outline += '</table><table>';
	if (obj) {
		for (var i=0; i<obj.links.length; i++) {
			var propArr = obj.links[i].split(";");
			outline += '<tr><td>';
			outline += '<a id="' + this.id + 'a' + i + '" href="javascript:void(0);" onmouseover="pc.'+this.id+'.doOver(this);" onmouseout="pc.'+this.id+'.doOut(this);" style="' + this.cssTextOut + '" title="' + unescape(propArr[1]) + '" onclick="pc.'+this.id+'.doClick(' + propArr[0] + ');">' + unescape(propArr[1]) + "</a></br>";
			outline += '</td></tr>';
		};
	};
	outline += '</table>';
	var content = this.findContentObj();
	content.innerHTML = outline;
	//this.setHTML(outline);
	this.placeHTMLObiects();
};

componentDictionaryLinks.prototype.doOver = function(obj)
{
	obj.style.cssText = this.cssTextOver;
};

componentDictionaryLinks.prototype.doOut = function(obj)
{
	obj.style.cssText = this.cssTextOut;
};

componentDictionaryLinks.prototype.doClick = function(id)
{
	if (opener && opener.lms) {
		opener.lms.gotoPage(id);
	};
};
