﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentMainReport = function(name)
{
	this.__componentText = __componentText;
	this.__componentText(name);

	this.studentScores = 0;
	this.mailReportText = '';
};

componentMainReport.prototype = new __componentText;
componentMainReport.prototype.type = "componentMainReport";

componentMainReport.prototype.onBaseCreate = function(obj)
{
	this.captureMouseEvents();
};

componentMainReport.prototype.onCreate = function(obj)
{
	return;
};

componentMainReport.prototype.getLocalUELO = function(obj)
{
	var UELO = new Object();
	UELO.beginTime = new Date(2009, 0, 1);
	UELO.endTime = new Date(2999, 11, 31);
	UELO.courseName = "Example Course Name";
	UELO.courseDescription = "Example Course Description";
	UELO.username = "User Name";
	UELO.sessionTime = calculateTimeToString(UELO.beginTime, UELO.endTime);
	UELO.pages = new Array();
	UELO.passThreshold = 100;
	return UELO;
};

componentMainReport.prototype.onPaint = function()
{
    var UELO = page.getUELO();
    if (!UELO) {
		UELO = this.getLocalUELO()
	};

    if (UELO) {
		var isMulti = checkExportType(config.exportDetails, 'multi'); //pg2-4multiSCO
		var struct = getStruct();
		var structPage = null;
		var pageIndex = -1;

		var t = '';
		var p         = null;
		var iActions  = null;
		var font = getProjectFont(this.allowGF, this.fontFamily, this.fontSize, this.fontColor);
		///////////////// CSS STYLES

		if (this.dir == "rtl") {
			var style1		= "width: 200px; vertical-align: top; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: left; font-weight: bold; color: "+font.color+"";
			var style2		= "vertical-align: top; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: right; color: "+font.color+"";
		} else {
			var style1		= "width: 200px; vertical-align: top; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: right; font-weight: bold; color: "+font.color+"";
			var style2		= "vertical-align: top; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: left; color: "+font.color+"";
		};
		var styleBold	= "vertical-align: top; margin: 10px; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: left; font-weight: normal; color: "+font.color+"";
		var N			= "vertical-align: top; background: #F3F3F3; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: left; font-weight: bold; color: "+font.color+"";
		var N1			= "vertical-align: top; background: #F3F3F3; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: right; font-weight: bold; ; color: "+font.color+"";
		var LP			= "vertical-align: top; font-family: "+font.family+"; font-size: "+getFontSize(font.size, 'px')+"; text-align: right; font-weight: normal; padding-right: 5px; color: "+font.color+"";

		//////////////// DATES
		var startTObj = UELO.beginTime;
		var startDate = startTObj.toLocaleString();  

		var Sh = (startTObj.getHours < 10)     ? "0"+startTObj.getHours()   : startTObj.getHours();
		var Sm = (startTObj.getMinutes() < 10) ? "0"+startTObj.getMinutes() : startTObj.getMinutes();
		var Ss = (startTObj.getSeconds() < 10) ? "0"+startTObj.getSeconds() : startTObj.getSeconds();

		var endTObj = UELO.endTime;
		var endDate = endTObj.toLocaleString(); 

		var Sdate = UELO.beginTime;
		var Sd  = (Sdate.getDate() < 10)     ? "0"+Sdate.getDate()          : Sdate.getDate();
		var Smo = (Sdate.getMonth()+1 < 10)  ? "0"+eval(Sdate.getMonth()+1) : eval(Sdate.getMonth()+1);
		var Sy  = (Sdate.getFullYear() < 10) ? "0"+Sdate.getFullYear()      : Sdate.getFullYear();

		var scores    = 0;
		var maxScores = 0;
		var number    = 1;
		var foundChosenPage =  false;
		var isStronglyInfo = false;

		var player = getPlayer(); //pg2-qr -in raport there is displayed current structure, but if course has mixed structure but wasn't solved in this session, repaint previous structure
		var isCourseMixedAndNotSolvetDuringThisSession = (player && struct && struct.isCourseMixed && !player.checkExamWasSolved() && UELO.previousMixedStructure != '' && !UELO.pageInAssessmentCheckAnswerInSession);

		for (var i = 0; i < UELO.pages.length; i++) {
			p = UELO.pages[i];
			isStronglyInfo = false;
			if ((p.visible == 0 && !config.sendDataFromHiddenPages) && //pg2-lean_om -hidden exercise pages
				!isCourseMixedAndNotSolvetDuringThisSession) continue; //pg2-qr -modyfied, some previously visible, but now invisible page could be included into score calculation -from previous session
			if (p.isAssessment == 0) isStronglyInfo = true;

			if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment && !p.previouslyVisible) continue; //pg2-qr -new

			if (p.title == this.pageName || this.pageName == ''){
				foundChosenPage = true;
			};
			if (p.pageType=='Exercise' && foundChosenPage) {
				//maxScores += 1;
				if (p.pageType == 'Exercise' && !isStronglyInfo) {
					if (isMulti) {
						structPage = struct.findItem(p.globalIndex);
						pageIndex = structPage.index;
						structPageStatus = this.getSCOStatus(pageIndex);
						if (structPageStatus == "passed") {
							scores++;
						};
					} else {
						if (isCourseMixedAndNotSolvetDuringThisSession && p.isAssessment) { //pg2-qr new
							scores += (p.previousStatus == 'P'?1:0);
						} else
						if (p.status == 'P') {
							scores++;
						};
					};
					maxScores++;
				};
			};
		};
		var percent = ( ( scores*100 ) / maxScores ).toFixed( 2 );
		this.studentScores = scores;

		t += "<TABLE CELLPADDING='2' CELLSPACING='0' BORDER='0' WIDTH='100%' DIR='"+this.dir+"'>";
		t += '<TR>';
			t += '<TD COLSPAN="2"><SPAN STYLE="font-weight: bold; font-size: +'+getFontSize(font.size, "px")+'pt; font-family: Times New Roman">'+this.mainReport+'</DIV></TD>';
		t += '</TR>';
		if (this.showPrint) {
			t += '<TR>';
				t += '<TD COLSPAN="2"><input id="'+this.id+'_printButton" type="button" onClick="page.all[\''+this.id+'\'].makePrintWindow();" value="'+this.reportPrint+'"></TD>';
			t += '</TR>';
		};
		t += '<TR>';
			t += '<TD COLSPAN="2"><HR style="height: 1px"></TD>';
		t += '</TR>';
		t += "<TR>";
			t += "<TD WIDTH='200' STYLE='"+style1+"'>"+this.reportTitle+":</TD>";
			t += "<TD STYLE='"+style2+"'>"+UELO.courseName+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportTitle + ':' + UELO.courseName + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportDescription +":</TD>";
			t += "<TD STYLE='"+style2+"'>"+UELO.courseDescription+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportDescription + ':' + UELO.courseDescription + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportUserInfo +":</TD>";
			t += "<TD STYLE='"+style2+"'>"+UELO.username+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportUserInfo + ':' + UELO.username + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportStart +":</TD>";
			//t += "<TD STYLE='"+style2+"'>"+Sy+"-"+Smo+"-"+Sd+" "+Sd+"."+Sm+"."+Ss+"</TD>";
			t += "<TD STYLE='"+style2+"'>"+startDate+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportStart + ':' + startDate + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportEnd +":</TD>";
			t += "<TD STYLE='"+style2+"'> "+endDate+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportEnd + ':' + +endDate + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportDuration +":</TD>";
			//t += "<TD STYLE='"+style2+"'> "+UELO.sessionTime+"</TD>"; //pg2-replaced with the code below
			t += "<TD STYLE='"+style2+"'> " + UELO.getSimpleSessionTime() + "</TD>";
		t += "</TR>";
		//this.mailReportText += this.reportDuration + ':' + UELO.sessionTime + '<br>'; //pg2-replaced with the code below
		this.mailReportText += this.reportDuration + ':' + UELO.getSimpleSessionTime() + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportStatus+":</TD>";
			t += "<TD STYLE='"+style2+"'> "+((((percent != "NaN") ? parseFloat(percent) : 0 ) >= UELO.passThreshold) ? this.reportPassed : this.reportFailed) + "</TD>";
		t += "</TR>";
		this.mailReportText += this.reportStatus+ ':'+((((percent != "NaN") ? parseFloat(percent) : 0 ) >= UELO.passThreshold) ? this.reportPassed : this.reportFailed) + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportPoints+":</TD>";
			t += "<TD STYLE='"+style2+"'> "+((scores) ? scores : 0 )+"/"+((maxScores) ? maxScores : 0)+"</TD>";
		t += "</TR>";
		this.mailReportText += this.reportPoints+ ':'+((scores) ? scores : 0 )+"/"+((maxScores) ? maxScores : 0) + '<br>';
		t += "<TR>";
			t += "<TD STYLE='"+style1+"'>"+this.reportPercentage+":</TD>";
			t += "<TD STYLE='"+style2+"'> "+((percent != "NaN") ? percent : 0 )+"%</TD>";
		t += "</TR>";
		this.mailReportText += this.reportPercentage+':'+((percent != "NaN") ? percent : 0 ) + '<br>';

		t += "</TABLE>";
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").innerHTML = t;
		} else {
			this.text = t;
		};

		if (parseInt(percent) >= UELO.passThreshold) {
			this.invokeEvent('Passed');
		} else {
			this.invokeEvent('Failed');
		};
	} else {
		if (this.execution) {
			document.getElementById(this.id + "_contentObj").innerHTML = this.componentInfo;
		} else {
			this.text = this.componentInfo;
		};
	};
};

componentMainReport.prototype.makePrintWindow = function(obj)
{
	document.getElementById(this.id + "_printButton").style.display = 'none';
	var temp = this.obj.innerHTML;
	document.getElementById(this.id + "_printButton").style.display = 'inline';

	temp = temp.replace(/style='cursor: hand'/gm, '');

    temp = '<!doctype html><html><script type="text/javascript">function gotoPage(){return};</script><body onload="self.print();">' + temp + '</body><html>';
	var win = window.open("","_blank","toolbar=no, location=no, directories=no, status=no, menubar=yes, scrollbars=yes, resizable=yes, copyhistory=no, width=600, height=300");
    win.document.write(temp);
    win.document.close();
    win.focus();
};

componentMainReport.prototype.getSCOStatus = function(pageIndex) //pg2-4multiSCO
{
	var SCOStatus = "";
	var isExam = PageInterface.GetValue("isExam");

	if (isExam) {
		SCOStatus = lms.getValueForSco(pageIndex-2);
	} else {
		SCOStatus = this.getValueFromSCO('cmi.core.lesson_status', pageIndex-2);
	};
	if (SCOStatus == null || SCOStatus.toString() == "null") {
		SCOStatus = this.getValueFromSCO('cmi.success_status', pageIndex-2);
		if (SCOStatus == 'unknown'){
			SCOStatus = this.getValueFromSCO('cmi.completion_status', pageIndex-2);
		};
	};
	return SCOStatus;
};

componentMainReport.prototype.getValueFromSCO = function(valueParam, pageIndex) //pg2-4multiSCO
{
	var result = "";
	if (lms) {
		if (lms.name == "lmsExam") {
			result = lms.getValueForSco(pageIndex);
		} else {
			result = lms.getValueForSco(valueParam, pageIndex);
		};
		if (result == null) result = "";
	};
	//return (lms)?lms.getValueForSco(valueParam, pageIndex):"";
	return result;
};
