﻿/*
 * Copyright (C) 1995-2014 by 4system Polska Sp. z o.o.
 * All Rights Reserved.
 */

componentPrinter = function(name) {
	this.componentRollover = componentRollover;
	this.componentRollover(name);

	this.elementsContent = [];
	this.indexesArr = [];
	this.externalWindowElements = ['componentText', 'componentCountAnswers', 'componentTextarea'];  //pg2-textarea
};

componentPrinter.prototype = new componentRollover();
componentPrinter.prototype.type = "componentPrinter";

componentPrinter.prototype.componentPrinterBaseOnCreate = componentPrinter.prototype.onCreate;
componentPrinter.prototype.onCreate = function(obj)
{
	this.srcOut = this.src;
	this.srcIn = this.srcOver;

	this.componentPrinterBaseOnCreate();
};

componentPrinter.prototype.onBaseCreate = function(obj)
{
    this.resourcesURL = unescape(this.resourcesURL);
	this.captureMouseEvents();
};

componentPrinter.prototype.printNewWindowExecute = function()
{
	if (typeof(this.winHandle) == 'undefined' || this.winHandle == null) return;
	
	var winHandle = this.winHandle;
	
	if (winHandle.pc && winHandle.page) {
		winHandle.page.goToChosenStep(winHandle.page.steps.length);
		
		for (var i=0; i<winHandle.page.children.length; i++) {
			var child = winHandle.page.children[i];
			if (child.lock) child.lock();
		};
		winHandle.page.locked = true;
		
		var n_compPrinter = null;
		eval('n_compPrinter = winHandle.pc.' + this.id + ';');
		if (n_compPrinter) {
			n_compPrinter.printInExternalWindow = false;
			n_compPrinter.hideNOTPrintElements(true);
			winHandle.print();
		};
	};
};

componentPrinter.prototype.printInNewWindow = function() //pg2-coig_page_print 
{
	var url = 'wbtpages://';
	var gixStr = page.p_globalIndex + '';
	while (gixStr.length < 5) gixStr = '0' + gixStr;
	gixStr = 'p' + gixStr + '/';
	
	url += gixStr + '_page.' + PlayerInterface.GetValue("getCourseVersion") + '.html' + '?asw=1';
	if (typeof(openDialog) == 'function') {
		var winHandle = openDialog(url, page.pageWidth, page.pageHeight, false, false, false, false, false, false);
		if (typeof(winHandle) != 'undefined' && winHandle != null) {
			this.winHandle = winHandle;
			setTimeout('pc.' + this.id + '.printNewWindowExecute();', 1000);
			
		};
	};
};

componentPrinter.prototype.print = function()
{
	if (page.state != psNormal) this.printInExternalWindow = false; //pg2-coig_page_print -w podgladzie pokaz zwykle drukowanie
	if (this.printInExternalWindow) {
		//this.getTextsFromElements(); //pg2-coig_page_print -removed, not needed any more
		//this.makePrintWindow();
		this.printInNewWindow(); //pg2-coig_page_print
	} else {
		this.hideNOTPrintElements(true);
		window.print();
		setTimeout('pc.'+this.id+'.hideNOTPrintElements(false);', 3000);
	};
};

componentPrinter.prototype.hideNOTPrintElements = function(hide)
{
	var vElements = this.elementsNOTToPrint.split("||");
	var element = null;
	var action = (hide)?'none':'';

	this.obj.style.display = action;

	for (var i = 0; i < vElements.length; i++) {
		element = document.getElementById(vElements[i]);
		if (element) {
			element.style.display = action;
		};
	};
	
	for (var i=0; i<page.children.length; i++) { //pg2-coig_page_print 
		var child = page.children[i];
		if (child.type == 'componentPrinter') {
			if (hide) child.hide(); else child.show();
		};
	};
};

componentPrinter.prototype.getLinkStyle = function()
{
	var link_tag = document.getElementsByTagName("link");
	var hrefArr = new Array();

	for (i = 0; i < link_tag.length; i++ ) {
		if (link_tag[i].rel.indexOf( "stylesheet" ) != -1) {
			hrefArr.push(link_tag[i].href);
		};
	};
	return hrefArr;
};

componentPrinter.prototype.makePrintWindow = function(obj)
{
	var cssLinkArr = this.getLinkStyle();
	var temp = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">';
	temp += '<html><head>';

	for (var i=0; i < cssLinkArr.length; i++){
		temp += '<link href="'+cssLinkArr[i]+'" type="text/css" rel="stylesheet">';
	};

	temp += "<style type='text/css'> P { margin: 0px; } </style>"; //pg2- to avoid bigger lines
	temp += '</head><body onload="self.print();">' + this.getPrintContent() + '</body></html>'; //pg2- </html>

    var win = window.open("", '_blank', 'menubar=no, toolbar=no, location=no, scrollbars=yes, resizable=yes, status=yes, width=600, height=300');
    win.document.write(temp);
    win.document.close();
    win.focus();
};

componentPrinter.prototype.sortTable = function(table)
{
	var temp = 0;
	var indextemp = [];
	for (var i=0; i < table.length; i++) {
		temp = table[i];
		for (var j=i; j < table.length; j++) {
			if (table[j] <= temp) {
				  temp = table[j];
				  indextemp = j;
			};
		};
		table[indextemp] = table[i];
		table[i] = temp;
	};
	return table;
};

componentPrinter.prototype.removeHeight = function(inner)
{
	var newInner = inner.replace(/height="100%"/gi, "");
	newInner = newInner.replace(/height='100%'/gi, "");
	return newInner;
};

componentPrinter.prototype.getTextsFromElements = function(obj)
{
	var element = null;
	var content =  null;
	var elementsNOTToPrint = this.elementsNOTToPrint.split("||");
	this.elementsContent = [];
	var indexesArr = [];

	for (var i=0; i < page.children.length; i++) {
		element = page.children[i];
		if (!inArray(element.id, elementsNOTToPrint) && inArray(element.type, this.externalWindowElements)) {
			var elemType = element.type; //pg2-test

			content = element.findContentObj();  
			if (content){
				if (!this.elementsContent[element.y]){
					this.elementsContent[element.y] = new Array();
					indexesArr.push(element.y);
				};

				var str1 = ""; //pg2
				var str2 = "";

				if (elemType == 'componentTextarea') {//pg2
					try {
					/*
						var frmWidth = content.form.style.width; //get width and height of the FORM
						var frmHeight = content.form.style.height;

						str1 = content.form.innerHTML; //get only textarea code (without FORM)
						str1 = str1.replace("width: 100%", 'width: ' + frmWidth); //replace width+height (IE&MF)
						str1 = str1.replace("height: 100%", 'height: ' + frmHeight);
						str1 = str1.replace("WIDTH: 100%", 'width: ' + frmWidth);
						str1 = str1.replace("HEIGHT: 100%", 'height: ' + frmHeight);
						str1 = str1.replace("<TEXTAREA ", "<TEXTAREA disabled "); //disable it - all events, typying, etc
						str1 = str1.replace("<textarea ", "<textarea disabled ");
						var areaValue = element.getAnswer(); //get user answer manually (Firefox doesn't get it automatically)
						str1 = str1.replace("></TEXTAREA>", ">" + areaValue + "</TEXTAREA>");
						str1 = str1.replace("></textarea>", ">" + areaValue + "</textarea>");
						str2 = this.removeHeight(str1);
					*/
						str2 = element.getAnswer(); 
						while(str2.indexOf("\n")!=-1){
							str2 = str2.replace("\n", "<BR>");
						};
					} catch(e) {};
				} else { //pg2-other elements
					str1 = element.obj.innerHTML;
					str2 = this.removeHeight(str1);
				};
				//this.elementsContent[element.y].push(this.removeHeight(element.obj.innerHTML)); //pg2-remove
				this.elementsContent[element.y].push(str2); //pg2-test
			};
		};
	};
	this.indexesArr = this.sortTable(indexesArr);
};

componentPrinter.prototype.getPrintContent = function(obj)
{
	var t = "";
	var index = 0;

	for (var i=0; i < this.indexesArr.length; i++) {
		index = this.indexesArr[i];
		t += this.elementsContent[index].join("<br>");
		t += "<br>";
	};
	return t;
};

componentPrinter.prototype.onLoad = function()
{
	this.captureMouseEvents();
};

componentPrinter.prototype.componentPrinterOnBaseEventClick = componentPrinter.prototype.eventClick;
componentPrinter.prototype.eventClick = function(e) {
	this.componentPrinterOnBaseEventClick(e);
	this.print();
};
