﻿module Fiche {
    export class Fiche extends Base.BasicGroup {     
        private GameData: any;   
        private currentFiche: number;    
        private FicheImage: Phaser.Image;
        private Loader: Phaser.Loader;    
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
            this.currentFiche = 1;
        }
        init(json) {
            super.init(json);
            this.GameData = json.GameData;       
        }
        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
        }
       
        create() {
            if (this.json.isStandalone) {
                super.create();
            }  
            this.Loader = new Phaser.Loader(this.game);
            var i = this.game.add.image(50, -150, "bck");
            this.addChild(i);
            var prev = this.game.add.button(200, 800, "prevF", this.prevFiche, this, 0, 0, 1, 0);
            this.addChild(prev);
            var next = this.game.add.button(400, 800, "nextF", this.nextFiche, this, 0, 0, 1, 0);
            this.addChild(next);            
            this.FicheImage = this.game.add.image(200, 200, "prevF");
            this.addChild(this.FicheImage);
                  
        }       
        nextFiche() {
            this.currentFiche++;
            this.loadFiche();
        }
        prevFiche() {
            this.currentFiche--;
            this.loadFiche();
        }   
        loadFiche() {           
            this.Loader.image(this.currentFiche + "", "Graphics/Games/OS_G_FI_I" + "/1_" + this.currentFiche + ".jpg");
            this.Loader.onLoadComplete.addOnce(this.setFiche, this);  
            this.Loader.start();          
        }
        setFiche() {
            this.FicheImage.loadTexture(this.currentFiche, 0);             
        }
        loadGraphics() {
            this.game.load.image("bck", "Graphics/GUI/" + CardChooser.getModule() + "/" + "modul1.png");
            this.game.load.spritesheet("prevF", "Graphics/GUI/OS/prev1.png", 100, 100, 2);
            this.game.load.spritesheet("nextF", "Graphics/GUI/OS/next1.png", 100, 100, 2);       
        }


    }
}