﻿module Summation {
    export class Summation extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        Dragables: any[];
        Containers: any[];
        
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);
        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        }
        loadGraphics() {

            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        }

        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            EU.createFillElements(this);
            EU.createSelectableElements(this);
            EU.createStaticElements(this);
            this.createContainerElements();
            this.createDragableElements();
            
            
        }
        init(json) {
            super.init(json);
            this.Elements = json.GameData;
        }

       


        createDragableElements() {
            this.Dragables = [];
            for (var i = 0; i < this.Elements.DragableElements.el.length; i++) {
                var el = this.game.add.image(this.Elements.DragableElements.el[i].pos.x, this.Elements.DragableElements.el[i].pos.y, this.PREFIX + this.Elements.DragableElements.el[i].key);
                el.inputEnabled = true;
                el.input.enableDrag();
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                el.events.onInputUp.add(this.onInputUp, this);
                el.name = this.PREFIX + this.Elements.DragableElements.el[i].key + i;

                this.Dragables.push(
                    {
                        "Element": el,
                        "Value": this.Elements.DragableElements.el[i].Value,
                        "StartPos": {
                            "x": this.Elements.DragableElements.el[i].pos.x,
                            "y": this.Elements.DragableElements.el[i].pos.y,
                        }


                    });

                this.addChild(el);
            }
        }


        createContainerElements() {
            this.Containers = [];
            for (var i = 0; i < this.Elements.ContainerElements.el.length; i++) {
                var el = this.game.add.image(this.Elements.ContainerElements.el[i].pos.x, this.Elements.ContainerElements.el[i].pos.y, this.PREFIX + this.Elements.ContainerElements.el[i].key);
                this.addChild(el);
                this.Containers.push (
                    {
                        "Value": this.Elements.ContainerElements.el[i].Value,
                        "Element": el
                       
                    }); 
            }
        }
      
        //input

        private onInputOver(el: Phaser.Sprite, pointer) {
            el.alpha = 0.7;
        }

        private onInputOut(el: Phaser.Sprite, pointer) {
            el.alpha = 1.0;
        }



        private onInputUp(el: Phaser.Sprite, pointer) {
            for (var i = 0; i < this.Containers.length; i++) {

                if (this.Overlap(el, this.Containers[i].Element))
                {
                    this.checkIfEverythingIsCorrect();
                    return true;
                } 
            }

            var tw = this.game.add.tween(el);
            tw.to({
                x: this.Dragables[this.getElementIndex(el, this.Dragables)].StartPos.x,
                y: this.Dragables[this.getElementIndex(el, this.Dragables)].StartPos.y
            }, 500, Phaser.Easing.Circular.InOut);
            tw.start();
            this.checkIfEverythingIsCorrect();

            
        }

        private getElementIndex(element, array) {
            for (var i = 0; i < array.length; i++) {
                if (array[i].Element.name == element.name)
                    return i;
            }
        }

        private Overlap(a, b) {

            var bA = a.getBounds();
            var bB = b.getBounds();
            return Phaser.Rectangle.intersects(bA, bB);
        }

        private checkIfEverythingIsCorrect() {
            for (var i = 0; i < this.Containers.length; i++) {
                var points = 0;
                for (var j = 0; j < this.Dragables.length; j++) {
                    if (this.Overlap(this.Dragables[j].Element, this.Containers[i].Element)) {
                        points += this.Dragables[j].Value;
                    } 
                }
                if (this.Containers[i].Value != points) {
                    EU.Log("NotCorrect:<");
                    EU.setGameCompletion(this.parent, 0);
                    return false;
                }
            }

            if (EU.checkIfFillsAreCorrect(this) && EU.checkIfSelectablesAreCorrect(this)) {
                EU.Log("Correct!!!");
                EU.setGameCompletion(this.parent, 1);
                return true;
            }
            EU.Log("NotCorrect:<");
            EU.setGameCompletion(this.parent, 0);
            return false;
        }


    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//    JSON = {
//              completeText: "caly tekst do wyswietlenia",
//              searched: [["znak lub wyraz", (true/false || true szuka znaku lub wyrazu oddzielonego spacjami, kropka, myslnikiem lub cudzyslowiem; false szuka podciągu)], [], []]    
// 
/*          }
{
    "attrs": ["TestGroupName", {
        "GameType": GameTypes.Summation,
        "description": "7. Włóż do portfeli takie monety, aby w sumie w każdym  było 7 zł. Użyj wszystkich monet.",
        "Lector": "MW_spr_I_4_7.mp3",
        "MaxPoints": 1, "isStandalone": false, "isFirst": false, "GameData": {
            "AllMustBeUsed": false,
            "GroupsEnabled": false,
            "TaskPrefix": "Zad7",
            "Graphics":
            [
                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_moneta1.png", "key": "01" },
                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_moneta2.png", "key": "02" },
                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_moneta3.png", "key": "03" },

                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_portfel1.png", "key": "04" },
                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_portfel2.png", "key": "05" },
                { "src": "Graphics/Exams/MW_I_4/zad7/MW_spr_I_4_zad7_portfel3.png", "key": "06" },

            ],
            "StaticElements": {
                "el": [



                ],
            },

            "DragableElements": {
                "el": [

                    { "key": "01", "pos": { "x": 100, "y": 0 }, "name": "O_1_1", "Value": 1 },
                    { "key": "01", "pos": { "x": 200, "y": 0 }, "name": "O_1_2", "Value": 1 },
                    { "key": "01", "pos": { "x": 300, "y": 0 }, "name": "O_1_3", "Value": 1 },
                    { "key": "01", "pos": { "x": 400, "y": 0 }, "name": "O_1_4", "Value": 1 },

                    { "key": "02", "pos": { "x": 100, "y": 100 }, "name": "O_2_1", "Value": 2 },
                    { "key": "02", "pos": { "x": 200, "y": 100 }, "name": "O_2_2", "Value": 2 },
                    { "key": "02", "pos": { "x": 300, "y": 100 }, "name": "O_2_3", "Value": 2 },
                    { "key": "02", "pos": { "x": 400, "y": 100 }, "name": "O_2_4", "Value": 2 },
                    { "key": "02", "pos": { "x": 500, "y": 100 }, "name": "O_2_5", "Value": 2 },
                    { "key": "02", "pos": { "x": 600, "y": 100 }, "name": "O_2_6", "Value": 2 },


                    { "key": "03", "pos": { "x": 100, "y": 200 }, "name": "O_5_1", "Value": 5 },

                ],

            },
            "ContainerElements": {
                "el": [

                    { "key": "04", "pos": { "x": 100, "y": 400 }, "name": "C_1", "Value": 7 },
                    { "key": "05", "pos": { "x": 600, "y": 400 }, "name": "C_2", "Value": 7 },
                    { "key": "06", "pos": { "x": 1100, "y": 400 }, "name": "C_3", "Value": 7 },

                ],
            },
        }
    }]
},*/