﻿var game;

module Global {
    export class Main {
        public static dims = { x: 1920, y: 1080 };
        public static mainContainerDims = { x: 120, y: 200, wd: 1800, hg: 950 };
        public static AudioObject: HTMLAudioElement;
        public static currentPageNumber: number;
        public static array: Array<string>;
        public static ts: Array<Base.BasicGroup>;
        game: Phaser.Game;

        constructor() {
            this.game = new Phaser.Game(Main.dims.x, Main.dims.y, Phaser.CANVAS, 'exam', { create: this.start, preload: this.preload });
           
        }
        preload() {
            this.game.stage.disableVisibilityChange = true;
        }
        public static returnPage(index) {
            return Main.ts[index];
        }
        public static PlayMusic(musicObject: HTMLAudioElement) {
            try {
                if (this.AudioObject) {
                    this.AudioObject.pause();
                    this.AudioObject.currentTime = 0;
                }
                this.AudioObject = musicObject;
                this.AudioObject.play();
            } catch (e) {
                EU.Log("Playback Error: " + e);
            }
        }
        public static CountPoints() {
            var acquiredPoints = 0;
            var maxPoints = 0; 
            for (var i = 1; i < Main.ts.length - 1; i++) {
                EU.Log("Game: " + i + " GameCompletion = " + Main.ts[i].gameCompletion+" MaxPoints = "+Main.ts[i].maxPoints);
                acquiredPoints += Main.ts[i].gameCompletion;
                maxPoints += Main.ts[i].maxPoints;
            }
            EU.Log(acquiredPoints / maxPoints);
            return acquiredPoints / maxPoints;
        }

        public static getExamResult() {
            var acquiredPoints = 0;
            var maxPoints = 0;
            var wrongAnswers = [];
            for (var i = 1; i < Main.ts.length - 1; i++) {
                EU.Log("Game: " + i + " GameCompletion = " + Main.ts[i].gameCompletion + " MaxPoints = " + Main.ts[i].maxPoints);
                if (Main.ts[i].gameCompletion != Main.ts[i].maxPoints)
                    wrongAnswers.push(i);
                acquiredPoints += Main.ts[i].gameCompletion;
                maxPoints += Main.ts[i].maxPoints;
            }
            var result = {
                "Acquired": acquiredPoints,
                "MaxPoints": maxPoints,
                 "Score":acquiredPoints / maxPoints,
                 "WrongAnswers": wrongAnswers };
            return result;
        }
        start() {
            
            Main.ts = [];
            Main.array = [];
            Main.array.push("test");
            Main.ts.push(new Base.BeginGroup(this.game, "beginGroup", 0, 0, ""));
            if (window['data'] !== undefined && window['data'] !== null) {
                Main.ts = JD.decode(Main.ts, window['data'], this.game);
                Main.ts.push(new Base.EndGroup(this.game, "endGroup", Main.ts.length * 1920, 0, ""));
                this.game.world.setBounds(0, 0, Main.dims.x * (Main.ts.length + 2), Main.dims.y);
                var t = this.game.state.add("State1", State1.State1, false);
                this.game.state.start("State1", false, false, Main.ts);

                this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
                this.game.scale.pageAlignHorizontally = true;
                this.game.scale.pageAlignVertically = true;
                this.game.scale.windowConstraints.bottom = true;
                this.game.scale.refresh();

            } else {
                console.log("null");
                setTimeout(ctx => {
                    console.log("TIMEOUT");
                    Main.ts = JD.decode(Main.ts, window['data'], this.game);
                    Main.ts.push(new Base.EndGroup(this.game, "endGroup", Main.ts.length * 1920, 0, ""));
                    this.game.world.setBounds(0, 0, Main.dims.x * (Main.ts.length + 2), Main.dims.y);
                    var t = this.game.state.add("State1", State1.State1, false);
                    this.game.state.start("State1", false, false, Main.ts);

                    this.game.scale.scaleMode = Phaser.ScaleManager.SHOW_ALL;
                    this.game.scale.pageAlignHorizontally = true;
                    this.game.scale.pageAlignVertically = true;
                    this.game.scale.windowConstraints.bottom = true;
                    this.game.scale.refresh();
                }, 1000);
            }

        }
      

    }
}


