var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Summation;
(function (_Summation) {
    var Summation = (function (_super) {
        __extends(Summation, _super);
        function Summation(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
        }
        Summation.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.PREFIX = this.Elements.TaskPrefix;
            this.loadGraphics();
            this.game.load.start();
        };
        Summation.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.PREFIX + this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
        };
        Summation.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.createStaticElements();
            this.createContainerElements();
            this.createDragableElements();
        };
        Summation.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Summation.prototype.createStaticElements = function () {
            if (this.Elements.StaticElements)
                for (var i = 0; i < this.Elements.StaticElements.el.length; i++) {
                    var el;
                    switch (this.Elements.StaticElements.el[i].type) {
                        case "image":
                            el = this.game.add.image(0, 0, this.PREFIX + this.Elements.StaticElements.el[i].key);
                            break;
                        case "text":
                            el = this.game.add.text(0, 0, this.Elements.StaticElements.el[i].text, this.Elements.StaticElements.Options.Style);
                            break;
                        case "sound":
                            el = this.game.add.sprite(0, 0, "speaker");
                            el.inputEnabled = true;
                            el.name = this.Elements.StaticElements.el[i].sound;
                            el.events.onInputUp.add(this.soundButtonDown, this);
                            break;
                    }
                    var posX = this.Elements.StaticElements.el[i].pos.x;
                    var posY = this.Elements.StaticElements.el[i].pos.y;
                    if (this.Elements.StaticElements.Options.Just) {
                        switch (this.Elements.StaticElements.Options.Just.x) {
                            case "center":
                                posX += (Global.Main.mainContainerDims.wd - 120) / 2;
                                el.anchor.x = 0.5;
                                break;
                            case "right":
                                posX += Global.Main.mainContainerDims.wd - 120;
                                el.anchor.x = 1;
                                break;
                        }
                        switch (this.Elements.StaticElements.Options.Just.y) {
                            case "center":
                                posY += (Global.Main.mainContainerDims.hg - 65) / 2;
                                el.anchor.y = 0.5;
                                break;
                            case "bottom":
                                posY += Global.Main.mainContainerDims.hg - 65;
                                el.anchor.y = 1;
                                break;
                        }
                    }
                    el.position.set(posX, posY);
                    this.addChild(el);
                }
        };
        Summation.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        Summation.prototype.createDragableElements = function () {
            this.Dragables = [];
            for (var i = 0; i < this.Elements.DragableElements.el.length; i++) {
                var el = this.game.add.image(this.Elements.DragableElements.el[i].pos.x, this.Elements.DragableElements.el[i].pos.y, this.PREFIX + this.Elements.DragableElements.el[i].key);
                el.inputEnabled = true;
                el.input.enableDrag();
                el.events.onInputOver.add(this.onInputOver, this);
                el.events.onInputOut.add(this.onInputOut, this);
                el.events.onInputUp.add(this.onInputUp, this);
                el.name = this.PREFIX + this.Elements.DragableElements.el[i].key + i;
                this.Dragables.push({
                    "Element": el,
                    "Value": this.Elements.DragableElements.el[i].Value,
                    "StartPos": {
                        "x": this.Elements.DragableElements.el[i].pos.x,
                        "y": this.Elements.DragableElements.el[i].pos.y,
                    }
                });
                this.addChild(el);
            }
        };
        Summation.prototype.createContainerElements = function () {
            this.Containers = [];
            for (var i = 0; i < this.Elements.ContainerElements.el.length; i++) {
                var el = this.game.add.image(this.Elements.ContainerElements.el[i].pos.x, this.Elements.ContainerElements.el[i].pos.y, this.PREFIX + this.Elements.ContainerElements.el[i].key);
                this.addChild(el);
                this.Containers.push({
                    "Value": this.Elements.ContainerElements.el[i].Value,
                    "Element": el
                });
            }
        };
        Summation.prototype.onInputOver = function (el, pointer) {
            el.alpha = 0.7;
        };
        Summation.prototype.onInputOut = function (el, pointer) {
            el.alpha = 1.0;
        };
        Summation.prototype.onInputUp = function (el, pointer) {
            for (var i = 0; i < this.Containers.length; i++) {
                if (this.Overlap(el, this.Containers[i].Element)) {
                    this.checkIfEverythingIsCorrect();
                    return true;
                }
            }
            var tw = this.game.add.tween(el);
            tw.to({
                x: this.Dragables[this.getElementIndex(el, this.Dragables)].StartPos.x,
                y: this.Dragables[this.getElementIndex(el, this.Dragables)].StartPos.y
            }, 500, Phaser.Easing.Circular.InOut);
            tw.start();
            this.checkIfEverythingIsCorrect();
        };
        Summation.prototype.getElementIndex = function (element, array) {
            for (var i = 0; i < array.length; i++) {
                if (array[i].Element.name == element.name)
                    return i;
            }
        };
        Summation.prototype.Overlap = function (a, b) {
            var bA = a.getBounds();
            var bB = b.getBounds();
            return Phaser.Rectangle.intersects(bA, bB);
        };
        Summation.prototype.checkIfEverythingIsCorrect = function () {
            for (var i = 0; i < this.Containers.length; i++) {
                var points = 0;
                for (var j = 0; j < this.Dragables.length; j++) {
                    if (this.Overlap(this.Dragables[j].Element, this.Containers[i].Element)) {
                        points += this.Dragables[j].Value;
                    }
                }
                if (this.Containers[i].Value != points) {
                    EU.Log("NotCorrect:<");
                    EU.setGameCompletion(this.parent, 0);
                    return false;
                }
            }
            EU.Log("Correct!!!");
            EU.setGameCompletion(this.parent, 1);
            return true;
        };
        return Summation;
    })(Base.BasicGroup);
    _Summation.Summation = Summation;
})(Summation || (Summation = {}));
//# sourceMappingURL=Summation.js.map