var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
var Maze;
(function (_Maze) {
    var Maze = (function (_super) {
        __extends(Maze, _super);
        function Maze(game, name, x, y, json) {
            _super.call(this, game, name, x, y, json);
            this.ready = false;
        }
        Maze.prototype.init = function (json) {
            _super.prototype.init.call(this, json);
            this.Elements = json.GameData;
        };
        Maze.prototype.preload = function () {
            _super.prototype.preload.call(this);
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();
            this.map = this.Elements.Tilemap[0].layers[0].data;
            this.game.load.spritesheet('player', 'Graphics/Games/OB_G_II_3/player.png', 31, 31, 4);
        };
        Maze.prototype.loadGraphics = function () {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);
            this.cursors = this.game.input.keyboard.createCursorKeys();
        };
        Maze.prototype.create = function () {
            if (this.json.isStandalone) {
                _super.prototype.create.call(this);
            }
            this.game.physics.startSystem(Phaser.Physics.ARCADE);
            this.player = this.game.add.sprite(560, 64, 'player');
            this.player2 = this.game.add.sprite(360, 64, 'player');
            this.addChild(this.player);
            this.addChild(this.player2);
            this.wall = this.game.add.group();
            this.addChild(this.wall);
            this.game.physics.enable([this.player, this.player2], Phaser.Physics.ARCADE);
            var idx = 0;
            for (var i = 0; i < 21; i++)
                for (var j = 0; j < 21; j++) {
                    if (this.map[idx++] == 1)
                        this.wall.create(500 + (j * 32), (i * 32), 'crate');
                }
            this.wall.enableBody = true;
            this.wall.physicsBodyType = Phaser.Physics.ARCADE;
            this.ready = true;
        };
        Maze.prototype.soundButtonDown = function (button) {
            Global.Main.PlayMusic(new Audio(button.name));
        };
        Maze.prototype.update = function () {
            if (this.ready) {
                this.game.physics.arcade.collide(this.player, this.wall);
                this.game.physics.arcade.collide(this.player, this.player2);
                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;
                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                }
                if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                }
                if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                }
                if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                }
            }
        };
        return Maze;
    })(Base.BasicGroup);
    _Maze.Maze = Maze;
})(Maze || (Maze = {}));
//# sourceMappingURL=Maze.js.map