﻿module SelectImage {
    export class SelectImage extends Base.BasicGroup {
        connectElementCount: number;
        Elements: any;
        buttonArr: any[];
        item: any;
        staticImage: any;
        soundButton: any;
        shadow: any;
        floor: any;
        selectedItemsCount: number;
        NumberOfSelections: number;
        selectedImageList: Array<any> = [];
        
        textureList: Array<Phaser.Sprite> = [];
        startingPlaceX: number;
        startingPlaceY: number;
        groupCount: number = 0;
        soundBank = new Audio();
        crossObject: any;
        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);

        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            //ladowanie 
            this.loadImages();
            this.game.load.start();
        }
        loadImages() {
            for (var i = 0; i < this.Elements.TaskList.length; i++)
            {
                this.game.load.image(this.Elements.TaskList[i].Key, this.Elements.TaskList[i].Select_img);
            }
            for (var i = 0; i < this.Elements.StaticElements.length; i++)
            {
                //sprawdza czy jest klucz - czy jest obrazkiem
                if (this.Elements.StaticElements[i].Key)
                this.game.load.image(this.Elements.StaticElements[i].Key, this.Elements.StaticElements[i].Select_img);
            }
        }
        create() {
            if (this.json.isStandalone) {
                super.create();
            }
            this.groupCount = this.Elements.Init.GroupCount;
            this.insertStaticImages();
            this.insertImages();
            this.selectedItemsCount = 0;
            this.NumberOfSelections = this.Elements.Init.NoSelections;
            EU.createFillElements(this);
        }

        insertStaticImages() {
            var currentAnchorX = 0;
            var maxImageSize = 0;
            var currentAnchorY = 0;
            var currentGroup = 0;
            var soundButtonWidth = 0;
            var soundButtonHeight = 0;
            if (this.Elements.Init.HasSounds == true) {

                soundButtonWidth = this.game.cache.getImage("speaker").width / 2;
                soundButtonHeight = this.game.cache.getImage("speaker").height / 2;
            }
            //dodanie static texts
            for (var i = 0; i < this.Elements.StaticElements.length; i++) {
                if (this.Elements.StaticElements[i].isText) {
                    this.staticImage = this.game.add.text(this.Elements.StaticElements[i].PosX, this.Elements.StaticElements[i].PosY, this.Elements.StaticElements[i].Text, this.Elements.StaticElements[i].Style);
                }
                else {
                    this.staticImage = this.game.add.sprite(this.Elements.StaticElements[i].PosX, this.Elements.StaticElements[i].PosY, this.Elements.StaticElements[i].Key);
                    this.staticImage.scale.setTo(0.8, 0.8);
                }
                this.staticImage.anchor.set(0.5);
                
                this.addChild(this.staticImage);
                if (this.Elements.Init.StaticHasSounds == true && this.Elements.StaticElements[i].Sound !== "") {
                   
                    switch (this.Elements.StaticElements[i].SoundPosition)
                        {
                        case "ToLeft":
                            {
                                this.soundButton = this.game.add.sprite(this.Elements.StaticElements[i].PosX - (this.staticImage.width / 2) - soundButtonWidth - 10, this.Elements.StaticElements[i].PosY - soundButtonHeight, "speaker");
                                this.soundButton.soundBankName = this.Elements.StaticElements[i].Sound;
                                this.addChild(this.soundButton);
                                this.soundButton.inputEnabled = true;
                                this.soundButton.events.onInputUp.add(this.soundButtonDown, this);
                                break;
                            }
                        case "ToRight":
                            {
                                this.soundButton = this.game.add.sprite(this.Elements.StaticElements[i].PosX + (this.staticImage.width / 2)+10 , this.Elements.StaticElements[i].PosY - soundButtonHeight, "speaker");
                                this.soundButton.soundBankName = this.Elements.StaticElements[i].Sound;
                                this.addChild(this.soundButton);
                                this.soundButton.inputEnabled = true;
                                this.soundButton.events.onInputUp.add(this.soundButtonDown, this);
                                break;
                            }
                        default:
                            {
                                this.soundButton = this.game.add.sprite(this.Elements.StaticElements[i].PosX + (this.staticImage.width / 2) + 10, this.Elements.StaticElements[i].PosY - soundButtonHeight, "speaker");
                                this.soundButton.soundBankName = this.Elements.StaticElements[i].Sound;
                                this.addChild(this.soundButton);
                                this.soundButton.inputEnabled = true;
                                this.soundButton.events.onInputUp.add(this.soundButtonDown, this);
                                break;
                            }
                    }
                      //  this.soundButton = this.game.add.sprite(this.Elements.StaticElements[i].PosX - (this.staticImage.width / 2) - soundButtonWidth - 10, this.Elements.StaticElements[i].PosY - soundButtonHeight, "speaker");
                   
                    //this.soundButton.soundBankName = this.Elements.StaticElements[i].Sound;
                    //this.addChild(this.soundButton);
                    //this.soundButton.inputEnabled = true;
                    //this.soundButton.events.onInputUp.add(this.soundButtonDown, this);
                }
            }
        }
        insertImages() {
           
            var currentAnchorX = 0;
            var maxImageSize = 0;
            var currentAnchorY = 0;
            var currentGroup = 0;
            var soundButtonWidth = 0;
            if (this.Elements.Init.HasSounds == true) {
                
               soundButtonWidth = this.game.cache.getImage("speaker").width/2 ;
            }
                for (var i = 0; i < this.Elements.TaskList.length; i++)
                {
                    if (this.Elements.TaskList[i].Group == 0) {
                        if (maxImageSize < this.game.cache.getImage(this.Elements.TaskList[i].Key).height)
                            maxImageSize = this.game.cache.getImage(this.Elements.TaskList[i].Key).height;
                        if ((currentAnchorX + this.game.cache.getImage(this.Elements.TaskList[i].Key).width + this.Elements.Init.Spacing ) >= Global.Main.mainContainerDims.wd - (Global.Main.mainContainerDims.wd * 0.1)) {
                            currentAnchorX = 0;
                            currentAnchorY = currentAnchorY + maxImageSize;
                            maxImageSize = 0;
                        }
                    }
                    else if (this.Elements.TaskList[i].Group > 0)
                    {
                        if (maxImageSize < this.game.cache.getImage(this.Elements.TaskList[i].Key).height)
                            maxImageSize = this.game.cache.getImage(this.Elements.TaskList[i].Key).height;
                        if (currentGroup != this.Elements.TaskList[i].Group) {
                            currentAnchorX = 0;
                            currentAnchorY = currentAnchorY + maxImageSize;
                            maxImageSize = 0;
                            currentGroup = this.Elements.TaskList[i].Group;
                        }
                    }
                    currentAnchorX = currentAnchorX + this.game.cache.getImage(this.Elements.TaskList[i].Key).width + this.Elements.Init.Spacing + soundButtonWidth;
                    //dodanie miejsc
                    if (this.Elements.Init.ManualPosition == true)
                        this.shadow = this.game.add.sprite(this.Elements.TaskList[i].PosX, this.Elements.TaskList[i].PosY, this.Elements.TaskList[i].Key);
                    else
                    {
                        this.shadow = this.game.add.sprite(this.Elements.Init.StartingPlaceX + (currentAnchorX),(this.Elements.Init.StartingPlaceY + currentAnchorY), this.Elements.TaskList[i].Key);
                    }
                    this.shadow.scale.setTo(0.8, 0.8);
                    this.shadow.anchor.set(0.5);
                    this.shadow.tint = 0x000000;
                    this.shadow.alpha = 0.6;
                    this.shadow.name = this.Elements.TaskList[i].Key;
                    if (this.Elements.Init.ManualPosition == true)
                        this.item = this.game.add.sprite(this.Elements.TaskList[i].PosX, this.Elements.TaskList[i].PosY, this.Elements.TaskList[i].Key);
                    else {
                        this.item = this.game.add.sprite(this.Elements.Init.StartingPlaceX + (currentAnchorX),(this.Elements.Init.StartingPlaceY + currentAnchorY), this.Elements.TaskList[i].Key);
                    }
                        this.item.scale.setTo(0.8, 0.8);
                    this.item.anchor.set(0.5, 0.5); 
                    this.item.isCorrect = this.Elements.TaskList[i].Correct;
                    this.item.isSelected = false;
                    this.item.inputEnabled = true;
                    this.item.shadowObj = this.shadow;
                    
                    this.item.group = this.Elements.TaskList[i].Group;
                    if (this.Elements.Init.Crossable) {
                        if (this.Elements.Init.ManualPosition == true)
                            this.crossObject = this.game.add.graphics(this.Elements.TaskList[i].PosX, this.Elements.TaskList[i].PosY);
                        else {
                            this.crossObject = this.game.add.graphics(this.Elements.Init.StartingPlaceX + (currentAnchorX),(this.Elements.Init.StartingPlaceY + currentAnchorY));
                        }
                        this.crossObject.lineStyle(4, 0xb70000, 1);
                        this.crossObject.moveTo(0 - this.item.width / 2, 0 - this.item.height / 2);
                        this.crossObject.lineTo(0 + this.item.width / 2, 0 + this.item.height / 2);
                        this.crossObject.visible = false;
                        this.item.events.onInputUp.add(this.buttonCrossing, this);
                        this.item.cross = this.crossObject;
                        this.addChild(this.crossObject);
                    }
                    if (!this.Elements.Init.Crossable) { this.item.events.onInputUp.add(this.buttonDown, this) }
                    if (this.Elements.Init.HasSounds == true && this.Elements.TaskList[i].Sound !== "") {
                        if (this.Elements.Init.ManualPosition == true)
                        {
                            this.soundButton = this.game.add.sprite(this.Elements.TaskList[i].PosX + (this.item.width / 2)+5, this.Elements.TaskList[i].PosY, "speaker");
                        }
                        else {
                            this.soundButton = this.game.add.sprite(this.Elements.Init.StartingPlaceX + (currentAnchorX) + soundButtonWidth * 2,(this.Elements.Init.StartingPlaceY + currentAnchorY), "speaker");
                        }
                        this.soundButton.soundBankName = this.Elements.TaskList[i].Sound;
                        this.addChild(this.soundButton);
                        this.soundButton.inputEnabled = true;
                        this.soundButton.events.onInputUp.add(this.soundButtonDown, this);
                    }
                    this.addChild(this.shadow);
                    this.addChild(this.item);
                    if (this.Elements.Init.Crossable)
                    this.addChild(this.crossObject);
                    this.selectedImageList.push(this.item);
            }
                
        }
        soundButtonDown(button)
        {
            this.soundBank = new Audio(button.soundBankName);
            Global.Main.PlayMusic(this.soundBank);
           
           // this.soundBank = new Audio(button.soundBankName);
           
        }

        buttonCrossing(button)
        {
            if (this.groupCount != 0) {
                var tmpButonsInGroup: Array<any> = [];
                var tmpSelectedItemsInGroup: number = 0;
                for (var i = 0; i < this.selectedImageList.length; i++) {

                    if (this.selectedImageList[i].group == button.group) {
                        tmpButonsInGroup.push(this.selectedImageList[i]); // tworznie listy elementow z tej samej grupy
                        if (this.selectedImageList[i].isSelected == true)
                            tmpSelectedItemsInGroup++;
                    }
                }
                for (var i = 0; i < tmpButonsInGroup.length; i++) {
                    if (tmpSelectedItemsInGroup >= parseInt(this.Elements.Init.NoSelections)) {
                        if (button.isSelected) {
                            tmpSelectedItemsInGroup--;
                         
                            button.isSelected = false;
                            button.cross.visible = false;
                            break;
                        }
                        else {
                            for (var i = 0; i < tmpButonsInGroup.length; i++) {
                                if (tmpButonsInGroup[i].isSelected) {
                                  
                                    tmpButonsInGroup[i].isSelected = false;
                                    tmpButonsInGroup[i].cross.visible = false;
                                }
                            }
                            tmpSelectedItemsInGroup = 0;
                            tmpSelectedItemsInGroup++;
                         
                            button.isSelected = !button.isSelected;
                            button.cross.visible = true;
                            break;
                        }

                    }
                    else if (button.isSelected) {
                        tmpSelectedItemsInGroup--;
                      
                        button.isSelected = !button.isSelected;
                        button.cross.visible = false;
                        break;
                    }
                    else {
                        tmpSelectedItemsInGroup++;
                     
                        button.isSelected = !button.isSelected;
                        button.cross.visible = true; 
                        break;
                    }
                }



            }
            else {
                if ((this.selectedItemsCount >= parseInt(this.Elements.Init.NoSelections))) {
                    if (button.isSelected) {
                        this.selectedItemsCount--;
                       
                        button.isSelected = !button.isSelected;
                        button.cross.visible = false;
                        
                    }
                    else {
                        for (var i = 0; i < this.selectedImageList.length; i++) {
                            if (this.selectedImageList[i].isSelected) {
                              
                                this.selectedImageList[i].isSelected = false;
                                this.selectedImageList[i].cross.visible = false;
                            }
                        }
                        this.selectedItemsCount = 0;
                        this.selectedItemsCount++;
                       
                        button.isSelected = !button.isSelected;
                        button.cross.visible = true;
                    }

                }
                else if (button.isSelected) {
                    this.selectedItemsCount--;
                    
                    button.isSelected = !button.isSelected;
                    button.cross.visible = false;

                }
                else {
                    this.selectedItemsCount++;
                   
                    button.isSelected = !button.isSelected;
                    button.cross.visible = true;
                }
            }
            this.checkComplition();

        }
        buttonDown(button) {
         
            //podzial na grupy
            if (this.groupCount != 0) {
                var tmpButonsInGroup: Array<any> = [];
                var tmpSelectedItemsInGroup: number = 0;
                for (var i = 0; i < this.selectedImageList.length; i++) {

                    if (this.selectedImageList[i].group == button.group) {
                        tmpButonsInGroup.push(this.selectedImageList[i]); // tworznie listy elementow z tej samej grupy
                        if (this.selectedImageList[i].isSelected == true)
                            tmpSelectedItemsInGroup++;
                    }
                }
                for (var i = 0; i < tmpButonsInGroup.length; i++) {
                    if (tmpSelectedItemsInGroup >= parseInt(this.Elements.Init.NoSelections)) {
                        if (button.isSelected) {
                            tmpSelectedItemsInGroup--;
                            button.scale.setTo(0.8, 0.8);
                            button.isSelected = !button.isSelected;
                            button.shadowObj.scale.setTo(0.8, 0.8);
                            button.shadowObj.x = button.x;
                            button.shadowObj.y = button.y;
                            break;
                        }
                        else {
                            for (var i = 0; i < tmpButonsInGroup.length; i++) {
                                if (tmpButonsInGroup[i].isSelected) {
                                    tmpButonsInGroup[i].scale.setTo(0.8, 0.8);
                                    tmpButonsInGroup[i].isSelected = false;
                                    tmpButonsInGroup[i].shadowObj.scale.setTo(0.8, 0.8);
                                    tmpButonsInGroup[i].shadowObj.x = tmpButonsInGroup[i].x;
                                    tmpButonsInGroup[i].shadowObj.y = tmpButonsInGroup[i].y;
                                }
                            }
                            tmpSelectedItemsInGroup = 0;
                            tmpSelectedItemsInGroup++;
                            button.scale.setTo(1, 1);
                            button.isSelected = !button.isSelected;
                            button.shadowObj.scale.setTo(1, 1);
                            button.shadowObj.x = button.x + 8;
                            button.shadowObj.y = button.y + 10;
                            break;
                        }

                    }
                    else if (button.isSelected) {
                        tmpSelectedItemsInGroup--;
                        button.scale.setTo(0.8, 0.8);
                        button.isSelected = !button.isSelected;
                        button.shadowObj.scale.setTo(0.8, 0.8);
                        button.shadowObj.x = button.x;
                        button.shadowObj.y = button.y;
                        break;
                    }
                    else {
                        tmpSelectedItemsInGroup++;
                        button.scale.setTo(1, 1);
                        button.isSelected = !button.isSelected;
                        button.shadowObj.scale.setTo(1, 1);
                        button.shadowObj.x = button.x + 8;
                        button.shadowObj.y = button.y + 10;
                        break;
                    }
                }
            }
            else {
             if ((this.selectedItemsCount >= parseInt(this.Elements.Init.NoSelections))) {
                    if (button.isSelected) {
                        this.selectedItemsCount--;
                        button.scale.setTo(0.8, 0.8);
                        button.isSelected = !button.isSelected;
                        button.shadowObj.scale.setTo(0.8, 0.8);
                        button.shadowObj.x = button.x;
                        button.shadowObj.y = button.y;
                    }
                    else {
                        for (var i = 0; i < this.selectedImageList.length; i++) {
                            if (this.selectedImageList[i].isSelected) {
                                this.selectedImageList[i].scale.setTo(0.8, 0.8);
                                this.selectedImageList[i].isSelected = false;
                                this.selectedImageList[i].shadowObj.scale.setTo(0.8, 0.8);
                                this.selectedImageList[i].shadowObj.x = this.selectedImageList[i].x;
                                this.selectedImageList[i].shadowObj.y = this.selectedImageList[i].y;
                            }
                        }
                        this.selectedItemsCount = 0;
                        this.selectedItemsCount++;
                        button.scale.setTo(1, 1);
                        button.isSelected = !button.isSelected;
                        button.shadowObj.scale.setTo(1, 1);
                        button.shadowObj.x = button.x + 8;
                        button.shadowObj.y = button.y + 10;
                    }

                }
                else if (button.isSelected) {
                    this.selectedItemsCount--;
                    button.scale.setTo(0.8, 0.8);
                    button.isSelected = !button.isSelected;
                    button.shadowObj.scale.setTo(0.8, 0.8);
                    button.shadowObj.x = button.x;
                    button.shadowObj.y = button.y;

                }
                else {
                    this.selectedItemsCount++;
                    button.scale.setTo(1, 1);
                    button.isSelected = !button.isSelected;
                    button.shadowObj.scale.setTo(1, 1);
                    button.shadowObj.x = button.x + 8;
                    button.shadowObj.y = button.y + 10;
                }
            }
                this.checkComplition();       
        }
        checkComplition() {
               // this.gameComplition
                var localComplitionState = 0;
                var localFalseComplitionState = 0;
                var groupTrueStatements = 0;
                var groupFalseStatemests = 0;
                for (var i = 0; i < this.selectedImageList.length; i++)
                {
                    if ((this.selectedImageList[i].isSelected == true) && (this.selectedImageList[i].isCorrect == "true"))
                        localComplitionState++;
                    if ((this.selectedImageList[i].isSelected == false) && (this.selectedImageList[i].isCorrect == "false"))
                        localFalseComplitionState++;
                }
                if (this.groupCount == 0) {
                    if (localComplitionState == this.NumberOfSelections && EU.checkIfFillsAreCorrect(this)) {
                        EU.setGameCompletion(this.parent, 1);
                        EU.Log("dobrze!");

                    }
                    else
                    {
                        EU.setGameCompletion(this.parent, 0);
                        EU.Log("zle");
                    }
                }
                else (this.groupCount != 0)
                {
                    for (var i = 0; i < this.selectedImageList.length; i++)
                    {
                        if (this.selectedImageList[i].isCorrect == "true")
                            groupTrueStatements++;
                        if (this.selectedImageList[i].isCorrect == "false")
                            groupFalseStatemests++;
                    }

                    if (localComplitionState == groupTrueStatements && localFalseComplitionState == groupFalseStatemests && EU.checkIfFillsAreCorrect(this)) {
                        EU.setGameCompletion(this.parent, 1);
                        EU.Log("dobrze!");
                    }
                    else {
                        EU.setGameCompletion(this.parent, 0);
                        EU.Log("zle");
                    }
                }
            }                 
         init(json) {
             super.init(json);
            //ladowanie danych wejsciowych
            this.Elements = json.GameData;


          
           
        }

    }

}






/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////            FORMAT JSONA           ////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//"Init": {
//    "Title": "2. Kliknięciem zaznacz największą i najmniejszą planetę.",  // brak działania puki co
//    "Sound": "Graphics/Exams/OS_I_2/OS_spr_I_2_2b.mp3",					// brak działania puki co
//    "NoSelections": 1,													// Ilość poprawnych odpowiedzi ( w przypadku grup ile 
//    //maksymalnie elementów może być zaznaczone w grypie
//    "GroupCount": 3,													    // Ilość grup ( -1 jeśli ich nie ma)
//    "StartingPlaceX": 1,												    // pozycja startowa po X
//    "StartingPlaceY": 1,												    // pozycja startowa po Y
//    "Spacing": 120,														// odstęp pomiedzy elementami aktywnymi
//    "HasSounds": false,													// Dodanie możliwości odsluchania lektora dla poszczególnego elementu aktywnego
//    "Crossable": true,													    // Zmiana sposobu działania gry zamiast powiekszac, przekreśla grafikę
//    "StaticHasSounds":  true
//    "ManualPosition": true
//},

//"StaticElements": [														// Lista elementów statycznych, z którymi nie ma interakcji
//    {
//        "Select_img": "Graphics/Exams/OS_I_2/OS_spr_I_2_koszyk1.png",	    // miejsce przechowywania grafiki
//        "Key": "q1",													    // nazwa grafiki 
//        "PosX": 10,														// pozycja w pixelach po X
//        "PosY": 10														// pozycja w pixelach po Y
//        "Sound": "Graphics/Exams/OS_I_2/OS_spr_I_2_2b.mp3"

//    }],
//"TaskList": [															    // Lista elementów aktywnych, na których działamy
//    {
//        "Select_img": "Graphics/Exams/OS_I_2/OS_spr_I_2_koszyk1.png",	    // miejsce przechowywania grafiki
//        "Key": "0",														// nazwa grafiki
//        "Group": 1,														// numer grupy ( w przypadku braku gryp wartosc ma wynosic -1)
//        "PosX": 10,														// pozycja w pixelach po X
//        "PosY": 10														// pozycja w pixelach po Y
//        "Correct": "true",												// czy grafika ta jest właściwa? "true"/ "false"
//        "Sound": "Graphics/Exams/OS_I_2/OS_spr_I_2_2b.mp3"				// lokalizacja pliku z dzwiękiem, jeśli zaznaczy się "HasSound"
//    },   
//
//