﻿module Maze {

    export class Maze extends Base.BasicGroup {

        Elements: any;
        PREFIX: any;

        //map: Phaser.Tilemap;
        //cratesLayer: Phaser.TilemapLayer;

        player: Phaser.Sprite;
        player2: Phaser.Sprite;
        cursors: Phaser.CursorKeys;
        map: Array<number>;
        wall: Phaser.Group;
        tmp: Array<Phaser.Sprite>;

        ready: boolean = false;

        init(json) {
            super.init(json);
            this.Elements = json.GameData;

        }

        constructor(game, name, x, y, json) {
            super(game, name, x, y, json);

        }

        preload() {
            super.preload();
            this.game.load.onLoadComplete.addOnce(this.create, this);
            this.loadGraphics();
            this.game.load.start();

            this.map = this.Elements.Tilemap[0].layers[0].data;

            //this.game.load.tilemap('maze', null, this.Elements.Tilemap[0], Phaser.Tilemap.TILED_JSON);
            this.game.load.spritesheet('player', 'Graphics/Games/OB_G_II_3/player.png', 31, 31, 4);
        }

        loadGraphics() {
            for (var i = 0; i < this.Elements.Graphics.length; i++)
                this.game.load.image(this.Elements.Graphics[i].key, this.Elements.Graphics[i].src);

            this.cursors = this.game.input.keyboard.createCursorKeys();
        }

        create() {
            if (this.json.isStandalone) {
                super.create();

            }

            this.game.physics.startSystem(Phaser.Physics.ARCADE);

            this.player = this.game.add.sprite(560, 64, 'player');
                this.player2 = this.game.add.sprite(360, 64, 'player');

            this.addChild(this.player);
                this.addChild(this.player2);

                this.wall = this.game.add.group();
                this.addChild(this.wall);

                this.game.physics.enable([this.player, this.player2], Phaser.Physics.ARCADE);
 
 
            var idx = 0;
            for (var i = 0; i < 21; i++)
                for (var j = 0; j < 21; j++) {
                    if (this.map[idx++] == 1) this.wall.create(500 + (j * 32),(i * 32), 'crate');
                }

            this.wall.enableBody = true;
            this.wall.physicsBodyType = Phaser.Physics.ARCADE;

            this.ready = true;


        }

        soundButtonDown(button) {
            Global.Main.PlayMusic(new Audio(button.name));
        }

        /*
        createLabirynth() {
            
            this.map = this.game.add.tilemap('maze', 32, 32, 21, 21);
            this.map.addTilesetImage('crate', 'crate');
            this.cratesLayer = this.map.createLayer('Tile Layer 1');
            this.addChild(this.cratesLayer);
            
            
            this.cratesLayer.fixedToCamera = false;
            this.cratesLayer.scrollFactorX = 0;
            this.cratesLayer.scrollFactorY = 0;
            this.cratesLayer.position.set(2500, 200);
            

            this.map.setCollisionBetween(1, 100000);
        }
        */

        update() {

            if (this.ready) {

                //console.log(this.game.physics.arcade.overlap(this.player, this.wall, function () { console.log('hit'); }, null, this));
                this.game.physics.arcade.collide(this.player, this.wall);
                //this.game.physics.arcade.collide(this.player2, this.wall);
                this.game.physics.arcade.collide(this.player, this.player2);

                this.player.body.velocity.x = 0;
                this.player.body.velocity.y = 0;

                if (this.cursors.left.isDown) {
                    this.player.body.velocity.x = -200;
                }


                if (this.cursors.right.isDown) {
                    this.player.body.velocity.x = 200;
                }

                if (this.cursors.up.isDown) {
                    this.player.body.velocity.y = -200;
                }


                if (this.cursors.down.isDown) {
                    this.player.body.velocity.y = 200;
                }

            }

        }


    }

}

